/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.Iterator;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoDeclare;
import org.web3d.vrml.scripting.external.sai.SAIFieldDefinition;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DProtoDeclaration;
import org.web3d.x3d.sai.X3DProtoInstance;

public class SAIProtoDeclaration
implements X3DProtoDeclaration {
    private static final String DISPOSED_MSG = "This proto declaration has been disposed of";
    private SAINodeFactory nodeFactory;
    private VRMLProtoDeclare protoDecl;
    private BasicScene realScene;

    SAIProtoDeclaration(SAINodeFactory sAINodeFactory, VRMLProtoDeclare vRMLProtoDeclare, BasicScene basicScene) {
        this.nodeFactory = sAINodeFactory;
        this.protoDecl = vRMLProtoDeclare;
        this.realScene = basicScene;
    }

    public String getProtoName() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return this.protoDecl.getVRMLNodeName();
    }

    public int[] getNodeType() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return new int[]{27};
    }

    public X3DFieldDefinition[] getFieldDefinitions() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        X3DFieldDefinition[] x3DFieldDefinitionArray = new X3DFieldDefinition[this.protoDecl.getFieldCount()];
        Iterator iterator = this.protoDecl.getAllFields().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            x3DFieldDefinitionArray[n] = new SAIFieldDefinition((VRMLFieldDeclaration)iterator.next());
            ++n;
        }
        return x3DFieldDefinitionArray;
    }

    public X3DProtoInstance createInstance() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.protoDecl.createNewInstance(this.realScene.getRootNode(), false);
        return this.nodeFactory.getSAIProtoNode(vRMLNodeType, this);
    }

    public void dispose() throws InvalidNodeException {
        this.protoDecl = null;
        this.nodeFactory = null;
        this.realScene = null;
    }

    VRMLProtoDeclare getRealProtoDeclaration() {
        return this.protoDecl;
    }
}

