/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.ArrayList;
import java.util.List;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIFieldDefinition;
import org.web3d.vrml.scripting.external.sai.SAIFieldFactory;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.X3DField;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DMetadataObject;
import org.web3d.x3d.sai.X3DNode;
import org.xj3d.sai.X3DNodeTypeMapper;

public class SAINode
implements X3DNode {
    private VRMLNodeType realNode;
    private ExternalEventQueue theExternalEventQueue;
    private SAIFieldFactory theFieldFactory;
    private SAINodeFactory theNodeFactory;
    private X3DFieldDefinition[] fieldList;
    private X3DNodeTypeMapper typeMapper;

    public SAINode(VRMLNodeType vRMLNodeType, SAINodeFactory sAINodeFactory, SAIFieldFactory sAIFieldFactory, ExternalEventQueue externalEventQueue) {
        if (vRMLNodeType == null) {
            throw new InvalidNodeException();
        }
        this.theExternalEventQueue = externalEventQueue;
        this.realNode = vRMLNodeType;
        this.theNodeFactory = sAINodeFactory;
        this.theFieldFactory = sAIFieldFactory;
    }

    public void setMetadata(X3DMetadataObject x3DMetadataObject) {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        SAINode sAINode = (SAINode)x3DMetadataObject;
        this.realNode.setMetadataObject(this.theNodeFactory.getVRMLNode(sAINode));
    }

    public X3DMetadataObject getMetadata() {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        return (X3DMetadataObject)this.theNodeFactory.getSAINode(this.realNode.getMetadataObject());
    }

    public X3DFieldDefinition[] getFieldDefinitions() throws InvalidNodeException {
        if (this.fieldList != null) {
            return this.fieldList;
        }
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        ArrayList<SAIFieldDefinition> arrayList = new ArrayList<SAIFieldDefinition>();
        if (this.realNode instanceof VRMLProtoInstance) {
            List list = ((VRMLProtoInstance)this.realNode).getAllFields();
            for (VRMLFieldDeclaration vRMLFieldDeclaration : list) {
                arrayList.add(new SAIFieldDefinition(vRMLFieldDeclaration));
            }
            this.fieldList = new SAIFieldDefinition[arrayList.size()];
            arrayList.toArray(this.fieldList);
        } else {
            int n = this.realNode.getNumFields();
            for (int i = 0; i < n; ++i) {
                VRMLFieldDeclaration vRMLFieldDeclaration = this.realNode.getFieldDeclaration(i);
                if (vRMLFieldDeclaration == null) continue;
                arrayList.add(new SAIFieldDefinition(vRMLFieldDeclaration));
            }
            this.fieldList = new SAIFieldDefinition[arrayList.size()];
            arrayList.toArray(this.fieldList);
        }
        return this.fieldList;
    }

    public X3DField getField(String string) throws InvalidFieldException, InvalidNodeException {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        return this.theFieldFactory.getField(this.realNode, string);
    }

    public String getNodeName() throws InvalidNodeException {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        return this.realNode.getVRMLNodeName();
    }

    public int[] getNodeType() throws InvalidNodeException {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        if (this.typeMapper == null) {
            this.typeMapper = X3DNodeTypeMapper.getInstance();
        }
        return this.typeMapper.getInterfaceTypes(this.realNode.getVRMLNodeName());
    }

    VRMLNodeType getVRMLNode() {
        return this.realNode;
    }

    public boolean equals(Object object) {
        if (object instanceof SAINode) {
            SAINode sAINode = (SAINode)object;
            if (this.realNode != null) {
                return this.realNode.equals(sAINode.realNode);
            }
            return sAINode.realNode == null;
        }
        return super.equals(object);
    }

    public int hashCode() {
        if (this.realNode == null) {
            return 0;
        }
        return this.realNode.hashCode();
    }

    public void dispose() throws InvalidNodeException {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        this.realNode = null;
    }

    public boolean isRealized() {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        return this.theExternalEventQueue.isNodeRealized(this.realNode);
    }

    public void realize() {
        if (this.realNode == null) {
            throw new InvalidNodeException();
        }
        this.theExternalEventQueue.postRealizeNode(this.realNode);
    }
}

