/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.Iterator;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.VRMLExternProtoDeclare;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.sai.SAIFieldDefinition;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.X3DExternProtoDeclaration;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DProtoDeclaration;
import org.web3d.x3d.sai.X3DProtoInstance;
import org.xj3d.sai.X3DNodeTypeMapper;

public class SAIExternProtoDeclaration
implements X3DExternProtoDeclaration {
    private static final String DISPOSED_MSG = "This proto declaration has been disposed of";
    private SAINodeFactory nodeFactory;
    private VRMLExternProtoDeclare protoDecl;
    private BasicScene realScene;
    private X3DNodeTypeMapper typeMapper;

    public SAIExternProtoDeclaration(SAINodeFactory sAINodeFactory, VRMLExternProtoDeclare vRMLExternProtoDeclare, BasicScene basicScene) {
        this.nodeFactory = sAINodeFactory;
        this.protoDecl = vRMLExternProtoDeclare;
        this.realScene = basicScene;
    }

    public int getLoadState() {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return this.protoDecl.getLoadState();
    }

    public void loadNow() {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        System.out.println("External SAI ExternProto.loadNow() Not yet implemented");
    }

    public String[] getURLs() {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return this.protoDecl.getUrl();
    }

    public String getProtoName() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        return this.protoDecl.getVRMLNodeName();
    }

    public int[] getNodeType() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        if (this.typeMapper == null) {
            this.typeMapper = X3DNodeTypeMapper.getInstance();
        }
        return this.typeMapper.getInterfaceTypes(this.protoDecl.getVRMLNodeName());
    }

    public X3DFieldDefinition[] getFieldDefinitions() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        X3DFieldDefinition[] x3DFieldDefinitionArray = new X3DFieldDefinition[this.protoDecl.getFieldCount()];
        Iterator iterator = this.protoDecl.getAllFields().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            x3DFieldDefinitionArray[n++] = new SAIFieldDefinition((VRMLFieldDeclaration)iterator.next());
        }
        return x3DFieldDefinitionArray;
    }

    public X3DProtoInstance createInstance() throws InvalidNodeException {
        if (this.protoDecl == null) {
            throw new InvalidNodeException(DISPOSED_MSG);
        }
        VRMLNodeType vRMLNodeType = (VRMLNodeType)this.protoDecl.createNewInstance(this.realScene.getRootNode(), false);
        if (vRMLNodeType == null) {
            return null;
        }
        return this.nodeFactory.getSAIProtoNode(vRMLNodeType, (X3DProtoDeclaration)this);
    }

    public void dispose() throws InvalidNodeException {
        this.protoDecl = null;
        this.nodeFactory = null;
        this.realScene = null;
    }
}

