/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.web3d.util.BlockingQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBufferReclaimer;
import org.web3d.x3d.sai.X3DFieldEvent;
import org.web3d.x3d.sai.X3DFieldEventListener;

class SAIEventAdapterThreadPool {
    private static final String THREAD_NAME = "Xj3D SAI Event Messenger";
    private static final String GROUP_NAME = "Xj3D SAI Event Delivery";
    private ThreadGroup group;
    BroadcastThread[] threads;
    BlockingQueue theSourceQueue;
    BlockingQueue theRecyclingQueue;

    SAIEventAdapterThreadPool(int n) {
        this.threads = new BroadcastThread[n];
        this.theSourceQueue = new BlockingQueue();
        this.theRecyclingQueue = new BlockingQueue();
        if (this.group == null) {
            this.group = new ThreadGroup(GROUP_NAME);
        }
        while (n-- > 0) {
            this.threads[n] = this.createThread(this.theSourceQueue, this.theRecyclingQueue);
        }
    }

    BroadcastThread createThread(BlockingQueue blockingQueue, BlockingQueue blockingQueue2) {
        return (BroadcastThread)AccessController.doPrivileged(new CreateBroadcastThreadAction(blockingQueue, blockingQueue2));
    }

    void sendEvent(X3DFieldEventListener x3DFieldEventListener, X3DFieldEvent x3DFieldEvent, ExternalOutputBuffer externalOutputBuffer, int n, ExternalOutputBufferReclaimer externalOutputBufferReclaimer) {
        if (this.theRecyclingQueue == null) {
            return;
        }
        EventRecord eventRecord = (EventRecord)this.theRecyclingQueue.peekNext();
        eventRecord = eventRecord == null ? new EventRecord() : (EventRecord)this.theRecyclingQueue.getNext();
        eventRecord.load(x3DFieldEventListener, x3DFieldEvent, externalOutputBuffer, n, externalOutputBufferReclaimer);
        this.theSourceQueue.add(eventRecord);
    }

    void shutdown() {
        int n;
        for (n = 0; n < this.threads.length; ++n) {
            this.threads[n].shutdown();
        }
        this.theSourceQueue.purge();
        this.theRecyclingQueue = null;
        for (n = 0; n < this.threads.length; ++n) {
            this.theSourceQueue.add(null);
        }
    }

    class CreateBroadcastThreadAction
    implements PrivilegedAction {
        BlockingQueue theSourceQueue;
        BlockingQueue theRecyclingQueue;

        CreateBroadcastThreadAction(BlockingQueue blockingQueue, BlockingQueue blockingQueue2) {
            this.theSourceQueue = blockingQueue;
            this.theRecyclingQueue = blockingQueue2;
        }

        public Object run() {
            return new BroadcastThread(this.theSourceQueue, this.theRecyclingQueue);
        }
    }

    class BroadcastThread
    extends Thread {
        boolean shouldStop;
        BlockingQueue theSourceQueue;
        BlockingQueue theRecyclingQueue;

        BroadcastThread(BlockingQueue blockingQueue, BlockingQueue blockingQueue2) {
            super(SAIEventAdapterThreadPool.this.group, SAIEventAdapterThreadPool.THREAD_NAME);
            this.theSourceQueue = blockingQueue;
            this.theRecyclingQueue = blockingQueue2;
            this.start();
        }

        public void run() {
            while (!this.shouldStop) {
                EventRecord eventRecord = (EventRecord)this.theSourceQueue.getNext();
                if (eventRecord == null) {
                    this.theRecyclingQueue = null;
                    return;
                }
                eventRecord.receiver.readableFieldChanged(eventRecord.event);
                eventRecord.reclaimer.reclaimEventOutBuffer(eventRecord.buffer, eventRecord.tag);
                eventRecord.reset();
                this.theRecyclingQueue.add(eventRecord);
            }
            this.theRecyclingQueue = null;
        }

        void shutdown() {
            this.shouldStop = true;
        }
    }

    class EventRecord {
        X3DFieldEventListener receiver;
        X3DFieldEvent event;
        ExternalOutputBuffer buffer;
        int tag;
        ExternalOutputBufferReclaimer reclaimer;

        EventRecord() {
        }

        void load(X3DFieldEventListener x3DFieldEventListener, X3DFieldEvent x3DFieldEvent, ExternalOutputBuffer externalOutputBuffer, int n, ExternalOutputBufferReclaimer externalOutputBufferReclaimer) {
            this.receiver = x3DFieldEventListener;
            this.event = x3DFieldEvent;
            this.buffer = externalOutputBuffer;
            this.tag = n;
            this.reclaimer = externalOutputBufferReclaimer;
        }

        void reset() {
            this.receiver = null;
            this.event = null;
            this.buffer = null;
            this.reclaimer = null;
            this.tag = -1;
        }
    }
}

