/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.w3c.dom.Node;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.ScreenCaptureListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.InvalidNodeTypeException;
import org.web3d.vrml.lang.ProfileInfo;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.WriteableSceneMetaData;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.BrowserEventTask;
import org.web3d.vrml.scripting.external.sai.BrowserListenerMulticaster;
import org.web3d.vrml.scripting.external.sai.BufferedMappingSAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.CADViewAdapter;
import org.web3d.vrml.scripting.external.sai.CursorUIManagerAdapter;
import org.web3d.vrml.scripting.external.sai.ExternalErrorReporterAdapter;
import org.web3d.vrml.scripting.external.sai.MappingSAINodeFactory;
import org.web3d.vrml.scripting.external.sai.NavigationUIManagerAdapter;
import org.web3d.vrml.scripting.external.sai.NonMappingSAINodeFactory;
import org.web3d.vrml.scripting.external.sai.SAIComponentInfo;
import org.web3d.vrml.scripting.external.sai.SAIFieldFactory;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.vrml.scripting.external.sai.SAIProfileInfo;
import org.web3d.vrml.scripting.external.sai.SAIScene;
import org.web3d.vrml.scripting.external.sai.SimpleSAIFieldFactory;
import org.web3d.vrml.scripting.external.sai.StatusAdapter;
import org.web3d.vrml.scripting.sai.SAIVRMLScene;
import org.web3d.x3d.sai.BrowserEvent;
import org.web3d.x3d.sai.BrowserListener;
import org.web3d.x3d.sai.ComponentInfo;
import org.web3d.x3d.sai.InvalidBrowserException;
import org.web3d.x3d.sai.InvalidDocumentException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidURLException;
import org.web3d.x3d.sai.InvalidX3DException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DExecutionContext;
import org.web3d.x3d.sai.X3DScene;
import org.xj3d.core.eventmodel.CursorManager;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.impl.core.eventmodel.DefaultNavigationManager;
import org.xj3d.sai.Xj3DAnchorListener;
import org.xj3d.sai.Xj3DBrowser;
import org.xj3d.sai.Xj3DCADView;
import org.xj3d.sai.Xj3DCursorUIManager;
import org.xj3d.sai.Xj3DErrorReporter;
import org.xj3d.sai.Xj3DNavigationUIManager;
import org.xj3d.sai.Xj3DScreenCaptureListener;
import org.xj3d.sai.Xj3DStatusListener;

public class SAIBrowser
implements Xj3DBrowser,
BrowserCoreListener,
SensorStatusListener,
ScreenCaptureListener {
    private static final String INVALID_BROWSER_MSG = "Cannot access the Browser object. It has been disposed of.";
    private static final String NULL_CREATE_SCENE_ARGS_MSG = "Both arguments are null. 19775-2, 6.3.11 requires that one or other argument is to be non-null.";
    private static final String LINK_PROCESS_MSG = "External code generated an exception during the Xj3DAnchorListener's processLinkActivation() method. Falling back to default internal processing behaviour";
    private static final String NOT_VP_MSG = "Referenced item is not a viewpoint";
    private static final String DEFAULT_PROFILE = "Core";
    private static final String MINIMAL_X3D_SCENE = "#X3D V3.0 utf8\nPROFILE Core\n";
    private static final String browserVersion = "2_M1_DEV_2009-01-05";
    private static final String browserName = "Xj3D SAI External Browser";
    private String NODE_FACTORY_CLASS_NAME = "org.xj3d.sai.external.MappingSAINodeFactory";
    private BrowserListener browserListener;
    private StatusAdapter statusAdapter;
    private ExecutorService eventExecutor;
    private BrowserCore browserCore;
    private X3DCommonBrowser browserImpl;
    private ExternalErrorReporterAdapter errorReporter;
    private ExternalEventQueue eventQueue;
    private SAINodeFactory saiNodeFactory;
    private VRMLNodeFactory vrmlNodeFactory;
    private BufferedMappingSAIEventAdapterFactory adapterFactory;
    private RouteManager routeManager;
    private FrameStateManager stateManager;
    private CursorManager cursorManager;
    private VRMLExecutionSpace currentSpace;
    private X3DExecutionContext currentContext;
    private HashMap<String, VRMLViewpointNodeType> viewpointDefMap;
    private Map<String, Object> renderingProperties;
    private Map<String, Object> browserProperties;
    private NavigationUIManagerAdapter externalNavManager;
    private CursorUIManagerAdapter externalCursorManager;
    private CADViewAdapter externalCADView;
    private Xj3DAnchorListener anchorListener;
    private boolean sensorDescriptionActive;
    private Xj3DScreenCaptureListener captureListener;
    private int frameCapturesPendingCount;

    public SAIBrowser(BrowserCore browserCore, X3DCommonBrowser x3DCommonBrowser, RouteManager routeManager, FrameStateManager frameStateManager, ExternalEventQueue externalEventQueue, CursorManager cursorManager, ErrorReporter errorReporter) {
        if (browserCore == null) {
            throw new IllegalArgumentException("Null BrowserCore");
        }
        if (x3DCommonBrowser == null) {
            throw new IllegalArgumentException("Null CommonBrowser");
        }
        this.browserCore = browserCore;
        this.browserImpl = x3DCommonBrowser;
        this.eventQueue = externalEventQueue;
        this.routeManager = routeManager;
        this.stateManager = frameStateManager;
        this.cursorManager = cursorManager;
        this.sensorDescriptionActive = false;
        this.frameCapturesPendingCount = 0;
        this.viewpointDefMap = new HashMap();
        this.errorReporter = new ExternalErrorReporterAdapter(errorReporter);
        BrowserListenerMulticaster.setErrorReporter(this.errorReporter);
        this.eventExecutor = Executors.newSingleThreadExecutor();
        browserCore.addCoreListener(this);
        browserCore.addSensorStatusListener(this);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        HashMap hashMap2 = new HashMap();
        this.renderingProperties = Collections.unmodifiableMap(hashMap2);
        SimpleSAIFieldFactory simpleSAIFieldFactory = new SimpleSAIFieldFactory(externalEventQueue);
        this.adapterFactory = new BufferedMappingSAIEventAdapterFactory(2, browserCore.getVRMLClock());
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName("org.xj3d.sai.external.node.grouping.SAIGroup");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (bl) {
            this.saiNodeFactory = new MappingSAINodeFactory(simpleSAIFieldFactory, externalEventQueue);
            hashMap.put("ABSTRACT_NODES", Boolean.TRUE);
            hashMap.put("CONCRETE_NODES", Boolean.TRUE);
        } else {
            this.saiNodeFactory = new NonMappingSAINodeFactory(simpleSAIFieldFactory, externalEventQueue);
            hashMap.put("ABSTRACT_NODES", Boolean.FALSE);
            hashMap.put("CONCRETE_NODES", Boolean.FALSE);
        }
        this.adapterFactory.setFieldFactory(simpleSAIFieldFactory);
        simpleSAIFieldFactory.setNodeFactory(this.saiNodeFactory);
        simpleSAIFieldFactory.setSAIEventAdapterFactory(this.adapterFactory);
        hashMap.put("PROTOTYPE_CREATE", Boolean.FALSE);
        hashMap.put("DOM_IMPORT", Boolean.TRUE);
        hashMap.put("EXTERNAL_INTERACTIONS", Boolean.TRUE);
        hashMap.put("XML_ENCODING", Boolean.TRUE);
        hashMap.put("CLASSIC_VRML_ENCODING", Boolean.TRUE);
        hashMap.put("BINARY_ENCODING", Boolean.TRUE);
        this.browserProperties = Collections.unmodifiableMap(hashMap);
    }

    public void setErrorReporter(Xj3DErrorReporter xj3DErrorReporter) {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.errorReporter.setErrorReporter(xj3DErrorReporter);
    }

    public void addStatusListener(Xj3DStatusListener xj3DStatusListener) {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (this.statusAdapter == null) {
            this.statusAdapter = new StatusAdapter(this.browserCore, this.errorReporter);
        }
        this.statusAdapter.addStatusListener(xj3DStatusListener);
    }

    public void removeStatusListener(Xj3DStatusListener xj3DStatusListener) {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (this.statusAdapter == null) {
            this.statusAdapter = new StatusAdapter(this.browserCore, this.errorReporter);
        }
        this.statusAdapter.removeStatusListener(xj3DStatusListener);
    }

    public Xj3DNavigationUIManager getNavigationManager() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (this.externalNavManager == null) {
            DefaultNavigationManager defaultNavigationManager = new DefaultNavigationManager(this.browserCore);
            defaultNavigationManager.setErrorReporter(this.errorReporter);
            this.externalNavManager = new NavigationUIManagerAdapter(this.browserImpl.getViewpointManager(), defaultNavigationManager, this.browserCore);
            this.externalNavManager.setErrorReporter(this.errorReporter);
        }
        return this.externalNavManager;
    }

    public Xj3DCursorUIManager getCursorManager() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (this.externalCursorManager == null) {
            this.externalCursorManager = new CursorUIManagerAdapter(this.cursorManager, this.browserCore);
            this.externalCursorManager.setErrorReporter(this.errorReporter);
        }
        return this.externalCursorManager;
    }

    public Xj3DCADView getCADView() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (this.externalCADView == null) {
            this.externalCADView = new CADViewAdapter(this.browserCore, this.saiNodeFactory);
            this.externalCADView.setErrorReporter(this.errorReporter);
        }
        return this.externalCADView;
    }

    public void setMinimumFrameInterval(int n) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserCore.setMinimumFrameInterval(n, true);
    }

    public int getMinimumFrameInterval() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserCore.getMinimumFrameInterval();
    }

    public void setRenderingStyle(int n) throws IllegalArgumentException, InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserCore.setRenderingStyle(n);
    }

    public int getRenderingStyle() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserCore.getRenderingStyle();
    }

    public void setAnchorListener(Xj3DAnchorListener xj3DAnchorListener) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.anchorListener = xj3DAnchorListener;
    }

    public void captureFrames(int n) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (this.captureListener == null) {
            return;
        }
        this.frameCapturesPendingCount = n;
        this.browserCore.captureScreenStart(this);
    }

    public void setScreenCaptureListener(Xj3DScreenCaptureListener xj3DScreenCaptureListener) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.captureListener = xj3DScreenCaptureListener;
    }

    public void addBrowserListener(BrowserListener browserListener) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserListener = BrowserListenerMulticaster.add(this.browserListener, browserListener);
    }

    public void beginUpdate() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.eventQueue.beginUpdate();
    }

    public void endUpdate() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.eventQueue.endUpdate();
    }

    public void pauseRender() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        throw new RuntimeException("Not yet implemented");
    }

    public void removeBrowserListener(BrowserListener browserListener) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserListener = BrowserListenerMulticaster.remove(this.browserListener, browserListener);
    }

    public void startRender() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        throw new RuntimeException("Not yet implemented");
    }

    public void stopRender() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        throw new RuntimeException("Not yet implemented");
    }

    public void dispose() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.endUpdate();
        this.browserImpl = null;
        this.broadcastEvent(new BrowserEvent((Object)this, 1));
        this.adapterFactory.shutdown();
        this.statusAdapter.shutdown();
        this.statusAdapter = null;
    }

    public X3DScene createScene(org.web3d.x3d.sai.ProfileInfo profileInfo, ComponentInfo[] componentInfoArray) throws InvalidBrowserException {
        VRMLNodeFactory vRMLNodeFactory;
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (profileInfo == null && (componentInfoArray == null || componentInfoArray.length == 0)) {
            throw new IllegalArgumentException(NULL_CREATE_SCENE_ARGS_MSG);
        }
        try {
            vRMLNodeFactory = (VRMLNodeFactory)this.vrmlNodeFactory.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InvalidBrowserException("Error cloning node factory");
        }
        String string = profileInfo == null ? DEFAULT_PROFILE : profileInfo.getName();
        vRMLNodeFactory.setProfile(string);
        int n = componentInfoArray == null ? 0 : componentInfoArray.length;
        for (int i = 0; i < n; ++i) {
            vRMLNodeFactory.addComponent(componentInfoArray[i].getName(), componentInfoArray[i].getLevel());
        }
        VRMLWorldRootNodeType vRMLWorldRootNodeType = (VRMLWorldRootNodeType)vRMLNodeFactory.createVRMLNode("WorldRoot", false);
        vRMLWorldRootNodeType.setFrameStateManager(this.stateManager);
        vRMLWorldRootNodeType.setErrorReporter(this.errorReporter);
        vRMLWorldRootNodeType.setupFinished();
        int[] nArray = vRMLNodeFactory.getSpecVersion();
        WriteableSceneMetaData writeableSceneMetaData = new WriteableSceneMetaData(nArray[0] + " " + nArray[1], false, 0);
        SAIVRMLScene sAIVRMLScene = new SAIVRMLScene((SceneMetaData)writeableSceneMetaData, nArray[0], nArray[1]);
        sAIVRMLScene.setNodeFactory(vRMLNodeFactory);
        sAIVRMLScene.setWorldRootURL(this.browserImpl.getWorldURL());
        sAIVRMLScene.setRootNode((VRMLNode)vRMLWorldRootNodeType);
        vRMLWorldRootNodeType.setContainedScene((BasicScene)sAIVRMLScene);
        SAIScene sAIScene = new SAIScene((VRMLScene)sAIVRMLScene, this.routeManager, this.stateManager, this.saiNodeFactory, this.eventQueue, vRMLWorldRootNodeType, this.errorReporter);
        return sAIScene;
    }

    public X3DScene createX3DFromString(String string) throws InvalidBrowserException, InvalidX3DException {
        VRMLScene vRMLScene;
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        try {
            vRMLScene = this.browserImpl.createX3DFromString(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new InvalidX3DException(iOException.getMessage());
        }
        catch (InvalidNodeTypeException invalidNodeTypeException) {
            throw new InvalidX3DException(invalidNodeTypeException.getMessage());
        }
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        return new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.saiNodeFactory, this.eventQueue, vRMLExecutionSpace, this.errorReporter);
    }

    public X3DScene createX3DFromStream(InputStream inputStream) throws InvalidBrowserException, InvalidX3DException, IOException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLScene vRMLScene = this.browserImpl.createX3DFromStream(inputStream);
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        SAIScene sAIScene = new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.saiNodeFactory, this.eventQueue, vRMLExecutionSpace, this.errorReporter);
        return sAIScene;
    }

    public X3DScene createX3DFromURL(String[] stringArray) throws InvalidBrowserException, InvalidURLException, InvalidX3DException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLScene vRMLScene = this.browserImpl.createX3DFromURL(stringArray);
        VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
        SAIScene sAIScene = new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.saiNodeFactory, this.eventQueue, vRMLExecutionSpace, this.errorReporter);
        return sAIScene;
    }

    public ComponentInfo getComponent(String string, int n) throws InvalidBrowserException, NotSupportedException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        ComponentInfo[] componentInfoArray = this.getSupportedComponents();
        for (int i = 0; i < componentInfoArray.length; ++i) {
            if (!componentInfoArray[i].getName().equals(string)) continue;
            if (componentInfoArray[i].getLevel() >= n) {
                return new SAIComponentInfo(string, n, componentInfoArray[i].getTitle(), componentInfoArray[i].getProviderURL());
            }
            throw new NotSupportedException();
        }
        throw new NotSupportedException();
    }

    public float getCurrentSpeed() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserImpl.getCurrentSpeed();
    }

    public float getCurrentFrameRate() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserImpl.getCurrentFrameRate();
    }

    public X3DExecutionContext getExecutionContext() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        VRMLExecutionSpace vRMLExecutionSpace = this.browserCore.getWorldExecutionSpace();
        if (vRMLExecutionSpace != this.currentSpace) {
            SAIScene sAIScene = new SAIScene((VRMLScene)vRMLExecutionSpace.getContainedScene(), this.routeManager, this.stateManager, this.saiNodeFactory, this.eventQueue, this.browserCore.getWorldExecutionSpace(), this.errorReporter);
            this.currentContext = sAIScene;
        }
        return this.currentContext;
    }

    public String getName() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return browserName;
    }

    public org.web3d.x3d.sai.ProfileInfo getProfile(String string) {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        org.web3d.x3d.sai.ProfileInfo[] profileInfoArray = this.getSupportedProfiles();
        for (int i = 0; i < profileInfoArray.length; ++i) {
            if (!profileInfoArray[i].getName().equals(string)) continue;
            return profileInfoArray[i];
        }
        throw new NotSupportedException();
    }

    public ComponentInfo[] getSupportedComponents() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        org.web3d.vrml.lang.ComponentInfo[] componentInfoArray = this.getVRMLNodeFactory().getAvailableComponents();
        ComponentInfo[] componentInfoArray2 = new ComponentInfo[componentInfoArray.length];
        if (componentInfoArray2 == null) {
            return new ComponentInfo[0];
        }
        for (int i = 0; i < componentInfoArray2.length; ++i) {
            componentInfoArray2[i] = new SAIComponentInfo(componentInfoArray[i]);
        }
        return componentInfoArray2;
    }

    public org.web3d.x3d.sai.ProfileInfo[] getSupportedProfiles() {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        ProfileInfo[] profileInfoArray = this.getVRMLNodeFactory().getAvailableProfiles();
        if (profileInfoArray == null) {
            throw new RuntimeException("Null array from getAvailableProfiles");
        }
        org.web3d.x3d.sai.ProfileInfo[] profileInfoArray2 = new org.web3d.x3d.sai.ProfileInfo[profileInfoArray.length];
        for (int i = 0; i < profileInfoArray.length; ++i) {
            profileInfoArray2[i] = new SAIProfileInfo(profileInfoArray[i]);
        }
        return profileInfoArray2;
    }

    public String getVersion() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return browserVersion;
    }

    public X3DScene importDocument(Node node) {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        try {
            VRMLScene vRMLScene = this.browserImpl.importDocument(node);
            VRMLExecutionSpace vRMLExecutionSpace = (VRMLExecutionSpace)((Object)vRMLScene.getRootNode());
            return new SAIScene(vRMLScene, this.routeManager, this.stateManager, this.saiNodeFactory, this.eventQueue, vRMLExecutionSpace, this.errorReporter);
        }
        catch (Exception exception) {
            throw new InvalidDocumentException("Unable to process document.  Reason:  " + exception.getMessage());
        }
    }

    public void loadURL(String[] stringArray, Map map) throws InvalidBrowserException, InvalidURLException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.loadURL(stringArray, map);
    }

    public void replaceWorld(X3DScene x3DScene) throws IllegalArgumentException, InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (x3DScene instanceof SAIScene) {
            this.browserImpl.replaceWorld(((SAIScene)x3DScene).getRealScene());
        } else if (x3DScene == null) {
            this.browserImpl.replaceWorld(null);
        } else {
            throw new IllegalArgumentException("Incorrect scene type.");
        }
    }

    public String getDescription() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserImpl.getDescription();
    }

    public void setDescription(String string) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.setDescription(string);
    }

    public Map getRenderingProperties() throws InvalidBrowserException, InvalidOperationTimingException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.renderingProperties;
    }

    public Map getBrowserProperties() throws InvalidBrowserException, InvalidOperationTimingException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        return this.browserProperties;
    }

    public void nextViewpoint() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.nextViewpoint();
    }

    public void nextViewpoint(int n) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.nextViewpoint(n);
    }

    public void previousViewpoint() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.previousViewpoint();
    }

    public void previousViewpoint(int n) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.previousViewpoint(n);
    }

    public void firstViewpoint() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.firstViewpoint();
    }

    public void firstViewpoint(int n) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.firstViewpoint(n);
    }

    public void lastViewpoint() throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.lastViewpoint();
    }

    public void lastViewpoint(int n) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        this.browserImpl.lastViewpoint(n);
    }

    public void print(Object object) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (object != null) {
            this.errorReporter.partialReport(object.toString());
        }
    }

    public void println(Object object) throws InvalidBrowserException {
        if (this.browserImpl == null) {
            throw new InvalidBrowserException(INVALID_BROWSER_MSG);
        }
        if (object != null) {
            this.errorReporter.messageReport(object.toString());
        }
    }

    public void browserInitialized(VRMLScene vRMLScene) {
        int n;
        String string2;
        Map map = vRMLScene.getDEFNodes();
        for (String string2 : map.keySet()) {
            Object v = map.get(string2);
            if (!(v instanceof VRMLViewpointNodeType)) continue;
            this.viewpointDefMap.put(string2, (VRMLViewpointNodeType)v);
        }
        this.broadcastEvent(new BrowserEvent((Object)this, 0));
        string2 = vRMLScene.getLoadedURI();
        if (string2 != null && (n = string2.indexOf("#")) > 0) {
            String string3 = string2.substring(n + 1);
            VRMLViewpointNodeType vRMLViewpointNodeType = this.viewpointDefMap.get(string3);
            if (vRMLViewpointNodeType != null) {
                this.browserCore.changeViewpoint(vRMLViewpointNodeType);
            } else {
                this.errorReporter.messageReport("Unknown Viewpoint " + string3);
            }
        }
    }

    public void urlLoadFailed(String string) {
        this.broadcastEvent(new BrowserEvent((Object)this, 2));
    }

    public void browserShutdown() {
        this.broadcastEvent(new BrowserEvent((Object)this, 1));
        this.viewpointDefMap.clear();
    }

    public void browserDisposed() {
        if (this.browserImpl != null) {
            this.dispose();
        }
    }

    public void deviceOver(int n, String string) {
        if (string != null && this.statusAdapter != null) {
            this.sensorDescriptionActive = true;
            this.statusAdapter.sendStatusMessage(string);
        }
    }

    public void deviceNotOver(int n) {
        if (this.statusAdapter != null && this.sensorDescriptionActive) {
            this.sensorDescriptionActive = false;
            this.statusAdapter.sendStatusMessage(null);
        }
    }

    public void deviceActivated(int n) {
    }

    public void linkActivated(String[] stringArray, String[] stringArray2, String string) {
        boolean bl = true;
        if (this.anchorListener != null) {
            try {
                bl = !this.anchorListener.processLinkActivation(stringArray, stringArray2);
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(LINK_PROCESS_MSG, exception);
            }
        }
        if (!bl) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) == '#') {
                String string2 = stringArray[i].substring(1);
                VRMLBindableNodeType vRMLBindableNodeType = this.viewpointDefMap.get(string2);
                if (vRMLBindableNodeType != null) {
                    VRMLClock vRMLClock = this.browserCore.getVRMLClock();
                    vRMLBindableNodeType.setBind(true, true, vRMLClock.getTime());
                    continue;
                }
                this.errorReporter.warningReport(NOT_VP_MSG, null);
                continue;
            }
            this.browserImpl.loadURL(stringArray, null);
        }
    }

    public void screenCaptured(Buffer buffer, int n, int n2) {
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        int[] nArray = new int[n * n2];
        int n3 = n * n2 * 3;
        int n4 = 0;
        int n5 = n * 3;
        for (int i = 0; i < n2; ++i) {
            int n6 = n3 -= n5;
            for (int j = 0; j < n; ++j) {
                byte by = byteBuffer.get(n6++);
                byte by2 = byteBuffer.get(n6++);
                byte by3 = byteBuffer.get(n6++);
                nArray[n4++] = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        --this.frameCapturesPendingCount;
        if (this.frameCapturesPendingCount == 0) {
            this.browserCore.captureScreenEnd();
        }
        try {
            this.captureListener.screenCaptured(bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void initializeWorld() {
    }

    private void broadcastEvent(BrowserEvent browserEvent) {
        if (this.browserListener != null) {
            this.eventExecutor.submit(new BrowserEventTask(this.browserListener, browserEvent));
        }
    }

    private VRMLNodeFactory getVRMLNodeFactory() {
        if (this.vrmlNodeFactory == null) {
            X3DExecutionContext x3DExecutionContext = this.getExecutionContext();
            if (x3DExecutionContext == null) {
                SAIScene sAIScene = (SAIScene)this.createX3DFromString(MINIMAL_X3D_SCENE);
                this.vrmlNodeFactory = sAIScene.getVRMLNodeFactory();
            } else {
                this.vrmlNodeFactory = ((SAIScene)x3DExecutionContext).getVRMLNodeFactory();
            }
        }
        return this.vrmlNodeFactory;
    }

    private SAINodeFactory getSAINodeFactory(SAIFieldFactory sAIFieldFactory, ExternalEventQueue externalEventQueue) {
        SAINodeFactory sAINodeFactory = null;
        try {
            Class<?> clazz = Class.forName(this.NODE_FACTORY_CLASS_NAME);
            Constructor<?> constructor = clazz.getConstructor(SAIFieldFactory.class, ExternalEventQueue.class);
            Object obj = constructor.newInstance(sAIFieldFactory, externalEventQueue);
            sAINodeFactory = (SAINodeFactory)obj;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sAINodeFactory;
    }
}

