/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.web3d.browser.BrowserCore;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.scripting.external.sai.NavigationListenerMulticaster;
import org.web3d.vrml.scripting.external.sai.ViewpointWrapper;
import org.xj3d.core.eventmodel.NavigationManager;
import org.xj3d.core.eventmodel.NavigationStatusListener;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.eventmodel.ViewpointStatusListener;
import org.xj3d.sai.Xj3DNavigationUIListener;
import org.xj3d.sai.Xj3DNavigationUIManager;
import org.xj3d.sai.Xj3DViewpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NavigationUIManagerAdapter
implements Xj3DNavigationUIManager,
NavigationStatusListener,
ViewpointStatusListener {
    private static final String VP_REMOVE_ERROR_MSG = "Error sending viewpoint remove message: ";
    private static final String VP_ADD_ERROR_MSG = "Error sending viewpoint add message: ";
    private static final String VP_CHANGE_ERROR_MSG = "Error sending viewpoint list change message: ";
    private static final String VP_SELECT_ERROR_MSG = "Error sending viewpoint change selection message: ";
    private static final String NAV_LIST_ERROR_MSG = "Error sending navigation list change message: ";
    private static final String NAV_SELECT_ERROR_MSG = "Error sending navigation change selection message: ";
    private static final String DEFAULT_ERR_MSG = "Unknown error sending viewpoint event: ";
    private Xj3DNavigationUIListener navListener;
    private ViewpointManager viewpointManager;
    private NavigationManager navigationManager;
    private BrowserCore browserCore;
    private HashMap<VRMLViewpointNodeType, Xj3DViewpoint> viewpointMap;
    private ArrayList<Xj3DViewpoint> viewpointWrappers;
    private ErrorReporter errorReporter;

    NavigationUIManagerAdapter(ViewpointManager viewpointManager, NavigationManager navigationManager, BrowserCore browserCore) {
        this.viewpointManager = viewpointManager;
        this.navigationManager = navigationManager;
        this.browserCore = browserCore;
        this.viewpointMap = new HashMap();
        this.viewpointWrappers = new ArrayList();
        this.viewpointManager.addViewpointListener(this);
        this.navigationManager.addNavigationListener(this);
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
    }

    public void setNavigationState(String string) {
        List<String> list = this.navigationManager.getActiveNavigationTypes();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = list.get(i);
            if (!string2.equals(string)) continue;
            this.navigationManager.setActiveNavigationIndex(i);
            break;
        }
    }

    public String getNavigationState() {
        List<String> list = this.navigationManager.getActiveNavigationTypes();
        int n = this.navigationManager.getActiveNavgiationIndex();
        return list.get(n);
    }

    public void fitToWorld(boolean bl) {
        this.browserCore.fitToWorld(bl);
    }

    public void viewpointLookAt() {
        this.browserCore.setNavigationMode("LOOKAT");
    }

    public void recenterViewpoint() {
        this.viewpointManager.resetViewpoint();
    }

    public void straightenViewpoint() {
    }

    public void nextViewpoint() {
        this.viewpointManager.nextViewpoint();
    }

    public void previousViewpoint() {
        this.viewpointManager.previousViewpoint();
    }

    public Xj3DViewpoint[] getCurrentViewpoints() {
        Xj3DViewpoint[] xj3DViewpointArray = null;
        if (this.viewpointWrappers.size() != 0) {
            xj3DViewpointArray = (Xj3DViewpoint[])this.viewpointWrappers.toArray();
        }
        return xj3DViewpointArray;
    }

    public void selectViewpoint(Xj3DViewpoint xj3DViewpoint) {
        VRMLViewpointNodeType vRMLViewpointNodeType = ((ViewpointWrapper)xj3DViewpoint).getRealViewpoint();
        this.viewpointManager.setViewpoint(vRMLViewpointNodeType);
    }

    public void addNavigationUIListener(Xj3DNavigationUIListener xj3DNavigationUIListener) {
        this.navListener = NavigationListenerMulticaster.add(this.navListener, xj3DNavigationUIListener);
    }

    public void removeNavigationUIListener(Xj3DNavigationUIListener xj3DNavigationUIListener) {
        this.navListener = NavigationListenerMulticaster.remove(this.navListener, xj3DNavigationUIListener);
    }

    @Override
    public void availableNavigationInfoChanged(VRMLNavigationInfoNodeType[] vRMLNavigationInfoNodeTypeArray) {
    }

    @Override
    public void selectedNavigationInfoChanged(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
    }

    @Override
    public void navigationStateChanged(int n) {
        if (this.navListener == null) {
            return;
        }
        try {
            List<String> list = this.navigationManager.getActiveNavigationTypes();
            String string = list.get(n);
            this.navListener.selectedNavigationStateChanged(string);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                this.errorReporter.errorReport(NAV_SELECT_ERROR_MSG + this.navListener, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }

    @Override
    public void navigationListChanged(List<String> list) {
        if (this.navListener == null) {
            return;
        }
        try {
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            this.navListener.availableNavigationStatesChanged(stringArray);
        }
        catch (Throwable throwable) {
            if (throwable instanceof Exception) {
                this.errorReporter.errorReport(NAV_LIST_ERROR_MSG + this.navListener, (Exception)throwable);
            }
            System.out.println(DEFAULT_ERR_MSG + throwable);
            throwable.printStackTrace();
        }
    }

    @Override
    public void availableViewpointsChanged(VRMLViewpointNodeType[] vRMLViewpointNodeTypeArray) {
        this.viewpointMap.clear();
        this.viewpointWrappers.clear();
        if (vRMLViewpointNodeTypeArray != null) {
            for (int i = 0; i < vRMLViewpointNodeTypeArray.length; ++i) {
                ViewpointWrapper viewpointWrapper = new ViewpointWrapper(vRMLViewpointNodeTypeArray[i]);
                this.viewpointMap.put(vRMLViewpointNodeTypeArray[i], viewpointWrapper);
                this.viewpointWrappers.add(viewpointWrapper);
            }
        }
        if (this.navListener != null) {
            try {
                Xj3DViewpoint[] xj3DViewpointArray = null;
                if (this.viewpointWrappers.size() != 0) {
                    xj3DViewpointArray = (Xj3DViewpoint[])this.viewpointWrappers.toArray();
                }
                this.navListener.availableViewpointsChanged(xj3DViewpointArray);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(VP_CHANGE_ERROR_MSG + this.navListener, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void selectedViewpointChanged(VRMLViewpointNodeType vRMLViewpointNodeType) {
        Xj3DViewpoint xj3DViewpoint = this.viewpointMap.get(vRMLViewpointNodeType);
        if (this.navListener != null) {
            try {
                this.navListener.selectedViewpointChanged(xj3DViewpoint);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(VP_SELECT_ERROR_MSG + this.navListener, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void viewpointAdded(VRMLViewpointNodeType vRMLViewpointNodeType) {
        ViewpointWrapper viewpointWrapper = new ViewpointWrapper(vRMLViewpointNodeType);
        this.viewpointMap.put(vRMLViewpointNodeType, viewpointWrapper);
        this.viewpointWrappers.add(viewpointWrapper);
        if (this.navListener != null) {
            try {
                this.navListener.viewpointAdded((Xj3DViewpoint)viewpointWrapper);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(VP_ADD_ERROR_MSG + this.navListener, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    @Override
    public void viewpointRemoved(VRMLViewpointNodeType vRMLViewpointNodeType) {
        Xj3DViewpoint xj3DViewpoint = this.viewpointMap.remove(vRMLViewpointNodeType);
        this.viewpointWrappers.remove(xj3DViewpoint);
        if (this.navListener != null) {
            try {
                this.navListener.viewpointRemoved(xj3DViewpoint);
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(VP_REMOVE_ERROR_MSG + this.navListener, (Exception)throwable);
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }
}

