/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.lang.reflect.Constructor;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIFieldFactory;
import org.web3d.vrml.scripting.external.sai.SAINode;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.vrml.scripting.external.sai.SAIProtoInstance;
import org.web3d.x3d.sai.X3DNode;
import org.web3d.x3d.sai.X3DProtoDeclaration;
import org.web3d.x3d.sai.X3DProtoInstance;
import org.xj3d.sai.X3DNodeComponentMapper;

class MappingSAINodeFactory
implements SAINodeFactory {
    private ExternalEventQueue theEventQueue;
    private SAIFieldFactory theFieldFactory;
    private X3DNodeComponentMapper packageMapper;

    MappingSAINodeFactory(SAIFieldFactory sAIFieldFactory, ExternalEventQueue externalEventQueue) {
        this.theFieldFactory = sAIFieldFactory;
        this.theEventQueue = externalEventQueue;
        this.packageMapper = X3DNodeComponentMapper.getInstance();
    }

    public X3DNode getSAINode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType != null) {
            SAINode sAINode = null;
            if (vRMLNodeType instanceof VRMLProtoInstance) {
                return new SAIProtoInstance(vRMLNodeType, this, this.theFieldFactory, this.theEventQueue);
            }
            String string = vRMLNodeType.getVRMLNodeName();
            String string2 = this.packageMapper.getComponentName(string);
            if (string2 != null) {
                String string3 = "org.xj3d.sai.external.node." + string2 + ".SAI" + string;
                try {
                    Class<?> clazz = Class.forName(string3);
                    Constructor<?> constructor = clazz.getConstructor(VRMLNodeType.class, SAINodeFactory.class, SAIFieldFactory.class, ExternalEventQueue.class);
                    Object obj = constructor.newInstance(vRMLNodeType, this, this.theFieldFactory, this.theEventQueue);
                    sAINode = (SAINode)obj;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (sAINode == null) {
                sAINode = new SAINode(vRMLNodeType, this, this.theFieldFactory, this.theEventQueue);
            }
            return sAINode;
        }
        return null;
    }

    public VRMLNodeType getVRMLNode(X3DNode x3DNode) {
        if (x3DNode == null) {
            return null;
        }
        if (x3DNode instanceof SAINode) {
            return ((SAINode)x3DNode).getVRMLNode();
        }
        throw new RuntimeException("Incorrect node factory for Node");
    }

    public X3DProtoInstance getSAIProtoNode(VRMLNodeType vRMLNodeType, X3DProtoDeclaration x3DProtoDeclaration) {
        if (vRMLNodeType != null) {
            return new SAIProtoInstance(vRMLNodeType, this, this.theFieldFactory, x3DProtoDeclaration, this.theEventQueue);
        }
        return null;
    }
}

