/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFVec2f;

class MFVec2fWrapper
extends BaseFieldWrapper
implements MFVec2f,
ExternalEvent,
ExternalOutputBuffer {
    private boolean isSetOneValue;
    private int storedInputLength;
    private float[] storedInputValue;
    private float[] storedOutputValue;

    MFVec2fWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFVec2fWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(float[] fArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2fWrapper mFVec2fWrapper = (MFVec2fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2fWrapper == null || !mFVec2fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2fWrapper = new MFVec2fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec2fWrapper.ensureArraySize(mFVec2fWrapper.storedInputLength + 2);
            mFVec2fWrapper.storedInputValue[mFVec2fWrapper.storedInputLength++] = fArray[0];
            mFVec2fWrapper.storedInputValue[mFVec2fWrapper.storedInputLength++] = fArray[1];
            if (bl) {
                this.theEventQueue.processEvent(mFVec2fWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new float[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        float[] fArray = new float[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, fArray, 0, this.storedInputLength);
        }
        this.storedInputValue = fArray;
    }

    public void get1Value(int n, float[] fArray) {
        if (this.storedOutput) {
            fArray[0] = this.storedOutputValue[n];
            fArray[1] = this.storedOutputValue[n + 1];
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            fArray[0] = vRMLFieldData.floatArrayValue[n];
            fArray[1] = vRMLFieldData.floatArrayValue[n + 1];
        }
    }

    public void getValue(float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, fArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, vRMLFieldData.numElements * 2);
            }
        }
    }

    public void getValue(float[][] fArray) {
        if (this.storedOutput) {
            ArrayUtils.raise2(this.storedOutputValue, this.storedOutputValue.length / 2, fArray);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            ArrayUtils.raise2(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, fArray);
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2fWrapper mFVec2fWrapper = (MFVec2fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2fWrapper == null || !mFVec2fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2fWrapper = new MFVec2fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec2fWrapper.ensureArraySize(mFVec2fWrapper.storedInputLength + 2);
            System.arraycopy(mFVec2fWrapper.storedInputValue, n * 2, mFVec2fWrapper.storedInputValue, n * 2 + 2, mFVec2fWrapper.storedInputLength - n * 2);
            mFVec2fWrapper.storedInputValue[n * 2] = fArray[0];
            mFVec2fWrapper.storedInputValue[n * 2 + 1] = fArray[1];
            mFVec2fWrapper.storedInputLength += 2;
            if (bl) {
                this.theEventQueue.processEvent(mFVec2fWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements) {
            this.storedInputValue = new float[vRMLFieldData.numElements * 2];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements * 2);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        if (!this.isWritable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new float[vRMLFieldData.numElements * 2];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements * 2);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2fWrapper mFVec2fWrapper = (MFVec2fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2fWrapper == null || !mFVec2fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2fWrapper = new MFVec2fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFVec2fWrapper.storedInputLength > 0) {
                if (n * 2 + 2 < mFVec2fWrapper.storedInputLength) {
                    System.arraycopy(mFVec2fWrapper.storedInputValue, n * 2 + 2, mFVec2fWrapper.storedInputValue, n * 2, mFVec2fWrapper.storedInputLength - n * 2 - 2);
                }
                mFVec2fWrapper.storedInputLength -= 2;
                if (bl) {
                    this.theEventQueue.processEvent(mFVec2fWrapper);
                }
            } else {
                if (bl) {
                    mFVec2fWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFVec2fWrapper mFVec2fWrapper = (MFVec2fWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFVec2fWrapper == null || !mFVec2fWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFVec2fWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFVec2fWrapper = new MFVec2fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFVec2fWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFVec2fWrapper.storedInputValue[n * 2] = fArray[0];
            mFVec2fWrapper.storedInputValue[n * 2 + 1] = fArray[1];
            if (bl) {
                this.theEventQueue.processEvent(mFVec2fWrapper);
            }
        }
    }

    public void setValue(int n, float[] fArray) {
        this.checkWriteAccess();
        MFVec2fWrapper mFVec2fWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec2fWrapper = new MFVec2fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec2fWrapper.storedInput = true;
        if (mFVec2fWrapper.storedInputValue == null || mFVec2fWrapper.storedInputValue.length != n * 2) {
            mFVec2fWrapper.storedInputValue = new float[n * 2];
        }
        System.arraycopy(fArray, 0, mFVec2fWrapper.storedInputValue, 0, n * 2);
        mFVec2fWrapper.storedInputLength = n * 2;
        this.theEventQueue.processEvent(mFVec2fWrapper);
    }

    public void setValue(int n, float[][] fArray) {
        this.checkWriteAccess();
        MFVec2fWrapper mFVec2fWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFVec2fWrapper = new MFVec2fWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFVec2fWrapper.storedInput = true;
        if (mFVec2fWrapper.storedInputValue == null || mFVec2fWrapper.storedInputValue.length != n * 2) {
            mFVec2fWrapper.storedInputValue = new float[n * 2];
        }
        ArrayUtils.flatten2(fArray, n, mFVec2fWrapper.storedInputValue);
        mFVec2fWrapper.storedInputLength = n * 2;
        this.theEventQueue.processEvent(mFVec2fWrapper);
    }

    public int getSize() {
        if (this.storedOutput) {
            return this.storedOutputValue.length / 2;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

