/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFRotation;

class MFRotationWrapper
extends BaseFieldWrapper
implements MFRotation,
ExternalEvent,
ExternalOutputBuffer {
    private boolean isSetOneValue;
    private int storedInputLength;
    private float[] storedInputValue;
    private float[] storedOutputValue;

    MFRotationWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFRotationWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(float[] fArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFRotationWrapper mFRotationWrapper = (MFRotationWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFRotationWrapper == null || !mFRotationWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFRotationWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFRotationWrapper = new MFRotationWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFRotationWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFRotationWrapper.ensureArraySize(mFRotationWrapper.storedInputLength + 4);
            mFRotationWrapper.storedInputValue[mFRotationWrapper.storedInputLength++] = fArray[0];
            mFRotationWrapper.storedInputValue[mFRotationWrapper.storedInputLength++] = fArray[1];
            mFRotationWrapper.storedInputValue[mFRotationWrapper.storedInputLength++] = fArray[2];
            mFRotationWrapper.storedInputValue[mFRotationWrapper.storedInputLength++] = fArray[3];
            if (bl) {
                this.theEventQueue.processEvent(mFRotationWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new float[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputValue.length);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        float[] fArray = new float[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, fArray, 0, this.storedInputLength);
        }
        this.storedInputValue = fArray;
    }

    public void get1Value(int n, float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, n * 4, fArray, 0, 4);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, n * 4, fArray, 0, 4);
        }
    }

    public void getValue(float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, fArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, vRMLFieldData.numElements * 4);
            }
        }
    }

    public void getValue(float[][] fArray) {
        if (this.storedOutput) {
            ArrayUtils.raise4(this.storedOutputValue, this.storedOutputValue.length / 4, fArray);
        } else {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                ArrayUtils.raise4(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, fArray);
            }
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFRotationWrapper mFRotationWrapper = (MFRotationWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFRotationWrapper == null || !mFRotationWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFRotationWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFRotationWrapper = new MFRotationWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFRotationWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFRotationWrapper.ensureArraySize(this.storedInputLength + 4);
            System.arraycopy(mFRotationWrapper.storedInputValue, n * 4, mFRotationWrapper.storedInputValue, n * 4 + 4, mFRotationWrapper.storedInputLength - n * 4);
            mFRotationWrapper.storedInputValue[n * 4] = fArray[0];
            mFRotationWrapper.storedInputValue[n * 4 + 1] = fArray[1];
            mFRotationWrapper.storedInputValue[n * 4 + 2] = fArray[2];
            mFRotationWrapper.storedInputValue[n * 4 + 3] = fArray[3];
            mFRotationWrapper.storedInputLength += 4;
            if (bl) {
                this.theEventQueue.processEvent(mFRotationWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements) {
            this.storedInputValue = new float[vRMLFieldData.numElements * 4];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements * 4);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        if (!this.isWritable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements * 4) {
            this.storedOutputValue = new float[vRMLFieldData.numElements * 4];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements * 4);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFRotationWrapper mFRotationWrapper = (MFRotationWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFRotationWrapper == null || !mFRotationWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFRotationWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFRotationWrapper = new MFRotationWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFRotationWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFRotationWrapper.storedInputLength > 0) {
                if (n * 4 + 4 < mFRotationWrapper.storedInputLength) {
                    System.arraycopy(mFRotationWrapper.storedInputValue, n * 4 + 4, mFRotationWrapper.storedInputValue, n * 4, mFRotationWrapper.storedInputLength - n * 4 - 4);
                }
                mFRotationWrapper.storedInputLength -= 4;
                if (bl) {
                    this.theEventQueue.processEvent(mFRotationWrapper);
                }
            } else {
                if (bl) {
                    mFRotationWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFRotationWrapper mFRotationWrapper = (MFRotationWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFRotationWrapper == null || !mFRotationWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFRotationWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFRotationWrapper = new MFRotationWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFRotationWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            System.arraycopy(fArray, 0, mFRotationWrapper.storedInputValue, n * 4, 4);
            if (bl) {
                this.theEventQueue.processEvent(mFRotationWrapper);
            }
        }
    }

    public void setValue(int n, float[] fArray) {
        this.checkWriteAccess();
        MFRotationWrapper mFRotationWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFRotationWrapper = new MFRotationWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFRotationWrapper.storedInput = true;
        if (mFRotationWrapper.storedInputValue == null || mFRotationWrapper.storedInputValue.length != n * 4) {
            mFRotationWrapper.storedInputValue = new float[n * 4];
        }
        System.arraycopy(fArray, 0, mFRotationWrapper.storedInputValue, 0, n * 4);
        this.theEventQueue.processEvent(mFRotationWrapper);
    }

    public void setValue(int n, float[][] fArray) {
        this.checkWriteAccess();
        MFRotationWrapper mFRotationWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFRotationWrapper = new MFRotationWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFRotationWrapper.storedInput = true;
        if (mFRotationWrapper.storedInputValue == null || mFRotationWrapper.storedInputValue.length != n * 4) {
            mFRotationWrapper.storedInputValue = new float[n * 4];
        }
        ArrayUtils.flatten4(fArray, n, mFRotationWrapper.storedInputValue);
        this.theEventQueue.processEvent(mFRotationWrapper);
    }

    public int getSize() {
        if (this.storedOutput) {
            return this.storedOutputValue.length;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

