/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.x3d.sai.MFNode;
import org.web3d.x3d.sai.X3DNode;

class MFNodeWrapper
extends BaseFieldWrapper
implements MFNode,
ExternalEvent,
ExternalOutputBuffer {
    private boolean isSetOneValue;
    private SAINodeFactory nodeFactory;
    private int storedInputLength;
    private VRMLNodeType[] storedInputValue;
    private X3DNode[] storedOutputValue;

    MFNodeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAINodeFactory sAINodeFactory, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        this.nodeFactory = sAINodeFactory;
    }

    MFNodeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAINodeFactory sAINodeFactory, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAINodeFactory, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(X3DNode x3DNode) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNode);
            if (vRMLNodeType != null) {
                this.theEventQueue.postRealizeNode(vRMLNodeType);
            }
            MFNodeWrapper mFNodeWrapper = (MFNodeWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFNodeWrapper == null || !mFNodeWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFNodeWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFNodeWrapper = new MFNodeWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.nodeFactory, this.theEventAdapterFactory, true);
                    mFNodeWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFNodeWrapper.ensureArraySize(mFNodeWrapper.storedInputLength + 1);
            mFNodeWrapper.storedInputValue[mFNodeWrapper.storedInputLength++] = vRMLNodeType;
            if (bl) {
                this.theEventQueue.processEvent(mFNodeWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new X3DNode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doEvent() {
        block5: {
            try {
                this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
                if (this.storedInputValue == null) break block5;
            }
            catch (Throwable throwable) {
                if (this.storedInputValue != null) {
                    for (int i = 0; i < this.storedInputValue.length; ++i) {
                        this.storedInputValue[i] = null;
                    }
                }
                this.isSetOneValue = false;
                this.storedInput = false;
                throw throwable;
            }
            for (int i = 0; i < this.storedInputValue.length; ++i) {
                this.storedInputValue[i] = null;
            }
        }
        this.isSetOneValue = false;
        this.storedInput = false;
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, vRMLNodeTypeArray, 0, this.storedInputLength);
        }
        this.storedInputValue = vRMLNodeTypeArray;
    }

    public X3DNode get1Value(int n) {
        if (this.storedOutput) {
            return this.storedOutputValue[n];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (n < 0 || n >= vRMLFieldData.numElements) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.nodeFactory.getSAINode((VRMLNodeType)vRMLFieldData.nodeArrayValue[n]);
    }

    public void getValue(X3DNode[] x3DNodeArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, x3DNodeArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            for (int i = 0; i < vRMLFieldData.numElements; ++i) {
                x3DNodeArray[i] = this.nodeFactory.getSAINode((VRMLNodeType)vRMLFieldData.nodeArrayValue[i]);
            }
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, X3DNode x3DNode) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNode);
            if (vRMLNodeType != null) {
                this.theEventQueue.postRealizeNode(vRMLNodeType);
            }
            MFNodeWrapper mFNodeWrapper = (MFNodeWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFNodeWrapper == null || !mFNodeWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFNodeWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFNodeWrapper = new MFNodeWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.nodeFactory, this.theEventAdapterFactory, true);
                    mFNodeWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFNodeWrapper.ensureArraySize(this.storedInputLength + 1);
            System.arraycopy(mFNodeWrapper.storedInputValue, n, mFNodeWrapper.storedInputValue, n + 1, mFNodeWrapper.storedInputLength - n);
            mFNodeWrapper.storedInputValue[n] = vRMLNodeType;
            ++mFNodeWrapper.storedInputLength;
            if (bl) {
                this.theEventQueue.processEvent(mFNodeWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements) {
            this.storedInputValue = new VRMLNodeType[vRMLFieldData.numElements];
        }
        for (int i = 0; i < vRMLFieldData.numElements; ++i) {
            this.storedInputValue[i] = (VRMLNodeType)vRMLFieldData.nodeArrayValue[i];
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new X3DNode[vRMLFieldData.numElements];
        }
        for (int i = 0; i < vRMLFieldData.numElements; ++i) {
            this.storedOutputValue[i] = this.nodeFactory.getSAINode((VRMLNodeType)vRMLFieldData.nodeArrayValue[i]);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFNodeWrapper mFNodeWrapper = (MFNodeWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFNodeWrapper == null || !mFNodeWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFNodeWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFNodeWrapper = new MFNodeWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.nodeFactory, this.theEventAdapterFactory, true);
                    mFNodeWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFNodeWrapper.storedInputLength > 0) {
                if (n + 1 < mFNodeWrapper.storedInputLength) {
                    System.arraycopy(mFNodeWrapper.storedInputValue, n + 1, mFNodeWrapper.storedInputValue, n, mFNodeWrapper.storedInputLength - n - 1);
                }
                --mFNodeWrapper.storedInputLength;
                if (bl) {
                    this.theEventQueue.processEvent(mFNodeWrapper);
                }
            } else {
                if (bl) {
                    mFNodeWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
        if (this.storedOutputValue != null) {
            for (int i = 0; i < this.storedOutputValue.length; ++i) {
                this.storedOutputValue[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, X3DNode x3DNode) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNode);
            if (vRMLNodeType != null) {
                this.theEventQueue.postRealizeNode(vRMLNodeType);
            }
            MFNodeWrapper mFNodeWrapper = (MFNodeWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFNodeWrapper == null || !mFNodeWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFNodeWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFNodeWrapper = new MFNodeWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.nodeFactory, this.theEventAdapterFactory, true);
                    mFNodeWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFNodeWrapper.storedInputValue[n] = vRMLNodeType;
            if (bl) {
                this.theEventQueue.processEvent(mFNodeWrapper);
            }
        }
    }

    public void setValue(int n, X3DNode[] x3DNodeArray) {
        this.checkWriteAccess();
        MFNodeWrapper mFNodeWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFNodeWrapper = new MFNodeWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.nodeFactory, this.theEventAdapterFactory);
        }
        mFNodeWrapper.storedInput = true;
        if (mFNodeWrapper.storedInputValue == null || mFNodeWrapper.storedInputValue.length != n) {
            mFNodeWrapper.storedInputValue = new VRMLNodeType[n];
        }
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = this.nodeFactory.getVRMLNode(x3DNodeArray[i]);
            if (vRMLNodeType != null) {
                this.theEventQueue.postRealizeNode(vRMLNodeType);
            }
            mFNodeWrapper.storedInputValue[i] = vRMLNodeType;
        }
        mFNodeWrapper.storedInputLength = n;
        this.theEventQueue.processEvent(mFNodeWrapper);
    }

    public int getSize() {
        if (this.storedOutput) {
            return this.storedOutputValue.length;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

