/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFFloat;

class MFFloatWrapper
extends BaseFieldWrapper
implements MFFloat,
ExternalEvent,
ExternalOutputBuffer {
    private boolean isSetOneValue;
    private int storedInputLength;
    private float[] storedInputValue;
    private float[] storedOutputValue;

    MFFloatWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFFloatWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(float f) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFFloatWrapper mFFloatWrapper = (MFFloatWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFFloatWrapper == null || !mFFloatWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFFloatWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFFloatWrapper = new MFFloatWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFFloatWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFFloatWrapper.ensureArraySize(mFFloatWrapper.storedInputLength + 1);
            mFFloatWrapper.storedInputValue[mFFloatWrapper.storedInputLength++] = f;
            if (bl) {
                this.theEventQueue.processEvent(mFFloatWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new float[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputValue.length);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        float[] fArray = new float[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, fArray, 0, this.storedInputLength);
        }
        this.storedInputValue = fArray;
    }

    public float get1Value(int n) throws ArrayIndexOutOfBoundsException {
        if (this.storedOutput) {
            return this.storedOutputValue[n];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (n < 0 || n >= vRMLFieldData.numElements) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return vRMLFieldData.floatArrayValue[n];
    }

    public void getValue(float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, fArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, vRMLFieldData.numElements);
            }
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, float f) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFFloatWrapper mFFloatWrapper = (MFFloatWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFFloatWrapper == null || !mFFloatWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFFloatWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFFloatWrapper = new MFFloatWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFFloatWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFFloatWrapper.ensureArraySize(mFFloatWrapper.storedInputLength + 1);
            System.arraycopy(mFFloatWrapper.storedInputValue, n, mFFloatWrapper.storedInputValue, n + 1, mFFloatWrapper.storedInputLength - n);
            mFFloatWrapper.storedInputValue[n] = f;
            ++mFFloatWrapper.storedInputLength;
            if (bl) {
                this.theEventQueue.processEvent(mFFloatWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements) {
            this.storedInputValue = new float[vRMLFieldData.numElements];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        if (!this.isWritable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new float[vRMLFieldData.numElements];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFFloatWrapper mFFloatWrapper = (MFFloatWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFFloatWrapper == null || !mFFloatWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFFloatWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFFloatWrapper = new MFFloatWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFFloatWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFFloatWrapper.storedInputLength > 0) {
                if (n + 1 < mFFloatWrapper.storedInputLength) {
                    System.arraycopy(mFFloatWrapper.storedInputValue, n + 1, mFFloatWrapper.storedInputValue, n, mFFloatWrapper.storedInputLength - n - 1);
                }
                --mFFloatWrapper.storedInputLength;
                if (bl) {
                    this.theEventQueue.processEvent(mFFloatWrapper);
                }
            } else {
                if (bl) {
                    mFFloatWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float f) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFFloatWrapper mFFloatWrapper = (MFFloatWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFFloatWrapper == null || !mFFloatWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFFloatWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFFloatWrapper = new MFFloatWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFFloatWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFFloatWrapper.storedInputValue[n] = f;
            if (bl) {
                this.theEventQueue.processEvent(mFFloatWrapper);
            }
        }
    }

    public void setValue(int n, float[] fArray) {
        this.checkWriteAccess();
        MFFloatWrapper mFFloatWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFFloatWrapper = new MFFloatWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFFloatWrapper.storedInput = true;
        if (mFFloatWrapper.storedInputValue == null || mFFloatWrapper.storedInputValue.length != n) {
            mFFloatWrapper.storedInputValue = new float[n];
        }
        System.arraycopy(fArray, 0, mFFloatWrapper.storedInputValue, 0, n);
        mFFloatWrapper.storedInputLength = n;
        this.theEventQueue.processEvent(mFFloatWrapper);
    }

    public int getSize() {
        if (this.storedOutput) {
            return this.storedOutputValue.length;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

