/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.ArrayUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.MFColor;

class MFColorWrapper
extends BaseFieldWrapper
implements MFColor,
ExternalEvent,
ExternalOutputBuffer {
    private boolean isSetOneValue;
    private int storedInputLength;
    private float[] storedInputValue;
    private float[] storedOutputValue;

    MFColorWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    MFColorWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(float[] fArray) {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFColorWrapper mFColorWrapper = (MFColorWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFColorWrapper == null || !mFColorWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFColorWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFColorWrapper = new MFColorWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFColorWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFColorWrapper.ensureArraySize(mFColorWrapper.storedInputLength + 3);
            mFColorWrapper.storedInputValue[mFColorWrapper.storedInputLength++] = fArray[0];
            mFColorWrapper.storedInputValue[mFColorWrapper.storedInputLength++] = fArray[1];
            mFColorWrapper.storedInputValue[mFColorWrapper.storedInputLength++] = fArray[2];
            if (bl) {
                this.theEventQueue.processEvent(mFColorWrapper);
            }
        }
    }

    public void clear() {
        this.setValue(0, new float[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputLength);
        }
        finally {
            this.isSetOneValue = false;
            this.storedInput = false;
        }
    }

    protected void ensureArraySize(int n) {
        if (this.storedInputValue != null && n < this.storedInputValue.length) {
            return;
        }
        float[] fArray = new float[n];
        if (this.storedInputValue != null) {
            System.arraycopy(this.storedInputValue, 0, fArray, 0, this.storedInputLength);
        }
        this.storedInputValue = fArray;
    }

    public void get1Value(int n, float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, n * 3, fArray, 0, 3);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (n < 0 || n >= vRMLFieldData.numElements) {
                throw new ArrayIndexOutOfBoundsException();
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, n * 3, fArray, 0, 3);
        }
    }

    public void getValue(float[] fArray) {
        if (this.storedOutput) {
            System.arraycopy(this.storedOutputValue, 0, fArray, 0, this.storedOutputValue.length);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.numElements != 0) {
                System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, vRMLFieldData.numElements * 3);
            }
        }
    }

    public void getValue(float[][] fArray) {
        if (this.storedOutput) {
            ArrayUtils.raise3(this.storedOutputValue, this.storedOutputValue.length / 3, fArray);
        } else {
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            ArrayUtils.raise3(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, fArray);
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValue(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFColorWrapper mFColorWrapper = (MFColorWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFColorWrapper == null || !mFColorWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFColorWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFColorWrapper = new MFColorWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFColorWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            mFColorWrapper.ensureArraySize(this.storedInputLength + 3);
            System.arraycopy(mFColorWrapper.storedInputValue, n * 3, mFColorWrapper.storedInputValue, n * 3 + 3, mFColorWrapper.storedInputLength - n * 3 - 3);
            mFColorWrapper.storedInputValue[n * 3] = fArray[0];
            mFColorWrapper.storedInputValue[n * 3 + 1] = fArray[1];
            mFColorWrapper.storedInputValue[n * 3 + 2] = fArray[2];
            mFColorWrapper.storedInputLength += 3;
            if (bl) {
                this.theEventQueue.processEvent(mFColorWrapper);
            }
        }
    }

    public boolean isConglomerating() {
        return this.isSetOneValue;
    }

    private void loadInputValue() {
        if (!this.isReadable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length != vRMLFieldData.numElements) {
            this.storedInputValue = new float[vRMLFieldData.numElements * 3];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements * 3);
        }
        this.storedInput = true;
        this.storedInputLength = this.storedInputValue.length;
    }

    public void loadOutputValue() {
        if (!this.isWritable()) {
            return;
        }
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedOutputValue == null || this.storedOutputValue.length != vRMLFieldData.numElements) {
            this.storedOutputValue = new float[vRMLFieldData.numElements * 3];
        }
        if (vRMLFieldData.numElements != 0) {
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements * 3);
        }
        this.storedOutput = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValue(int n) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFColorWrapper mFColorWrapper = (MFColorWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFColorWrapper == null || !mFColorWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFColorWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFColorWrapper = new MFColorWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFColorWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            if (mFColorWrapper.storedInputLength > 0) {
                if (n * 3 + 3 < mFColorWrapper.storedInputLength) {
                    System.arraycopy(mFColorWrapper.storedInputValue, n * 3 + 3, mFColorWrapper.storedInputValue, n * 3, mFColorWrapper.storedInputLength - n * 3 - 3);
                }
                mFColorWrapper.storedInputLength -= 3;
                if (bl) {
                    this.theEventQueue.processEvent(mFColorWrapper);
                }
            } else {
                if (bl) {
                    mFColorWrapper.isSetOneValue = false;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float[] fArray) throws ArrayIndexOutOfBoundsException {
        this.checkReadAccess();
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            MFColorWrapper mFColorWrapper = (MFColorWrapper)this.theEventQueue.getLast(this);
            boolean bl = false;
            if (mFColorWrapper == null || !mFColorWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    mFColorWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    mFColorWrapper = new MFColorWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, true);
                    mFColorWrapper.isSetOneValue = true;
                }
                bl = true;
            }
            System.arraycopy(fArray, 0, mFColorWrapper.storedInputValue, n * 3, 3);
            if (bl) {
                this.theEventQueue.processEvent(mFColorWrapper);
            }
        }
    }

    public void setValue(int n, float[] fArray) {
        this.checkWriteAccess();
        MFColorWrapper mFColorWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFColorWrapper = new MFColorWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        mFColorWrapper.storedInput = true;
        if (mFColorWrapper.storedInputValue == null || mFColorWrapper.storedInputValue.length != n * 3) {
            mFColorWrapper.storedInputValue = new float[n * 3];
        }
        System.arraycopy(fArray, 0, mFColorWrapper.storedInputValue, 0, n * 3);
        mFColorWrapper.storedInputLength = n * 3;
        this.theEventQueue.processEvent(mFColorWrapper);
    }

    public void setValue(int n, float[][] fArray) {
        this.checkWriteAccess();
        MFColorWrapper mFColorWrapper = this;
        if (this.isSetOneValue || this.storedInput || this.storedOutput) {
            mFColorWrapper = new MFColorWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory, this.isSetOneValue);
        }
        mFColorWrapper.storedInput = true;
        if (mFColorWrapper.storedInputValue == null || mFColorWrapper.storedInputValue.length != n * 4) {
            mFColorWrapper.storedInputValue = new float[n * 3];
        }
        ArrayUtils.flatten3(fArray, n, mFColorWrapper.storedInputValue);
        mFColorWrapper.storedInputLength = n * 3;
        this.theEventQueue.processEvent(mFColorWrapper);
    }

    public int getSize() {
        if (this.storedOutput) {
            return this.storedOutputValue.length;
        }
        return this.theNode.getFieldValue((int)this.fieldIndex).numElements;
    }
}

