/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.xj3d.sai.Xj3DErrorReporter;

class ExternalErrorReporterAdapter
implements ErrorReporter {
    private Xj3DErrorReporter externalReporter;
    private ErrorReporter internalReporter;

    ExternalErrorReporterAdapter(ErrorReporter errorReporter) {
        this.setErrorReporter(errorReporter);
    }

    public void partialReport(String string) {
        try {
            if (this.externalReporter != null) {
                this.externalReporter.partialReport(string);
            } else {
                this.internalReporter.partialReport(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Error sending partial report to output");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void messageReport(String string) {
        try {
            if (this.externalReporter != null) {
                this.externalReporter.messageReport(string);
            } else {
                this.internalReporter.messageReport(string);
            }
        }
        catch (Exception exception) {
            System.out.println("Error sending message report to output");
            System.out.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void warningReport(String string, Exception exception) {
        try {
            if (this.externalReporter != null) {
                this.externalReporter.warningReport(string, exception);
            } else {
                this.internalReporter.warningReport(string, exception);
            }
        }
        catch (Exception exception2) {
            System.out.println("Error sending warning report to output");
            System.out.println(exception2.getMessage());
            exception2.printStackTrace();
        }
    }

    public void errorReport(String string, Exception exception) {
        try {
            if (this.externalReporter != null) {
                this.externalReporter.errorReport(string, exception);
            } else {
                this.internalReporter.errorReport(string, exception);
            }
        }
        catch (Exception exception2) {
            System.out.println("Error sending error report to output");
            System.out.println(exception2.getMessage());
            exception2.printStackTrace();
        }
    }

    public void fatalErrorReport(String string, Exception exception) {
        try {
            if (this.externalReporter != null) {
                this.externalReporter.fatalErrorReport(string, exception);
            } else {
                this.internalReporter.fatalErrorReport(string, exception);
            }
        }
        catch (Exception exception2) {
            System.out.println("Error sending fatal report to output");
            System.out.println(exception2.getMessage());
            exception2.printStackTrace();
        }
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.internalReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    void setErrorReporter(Xj3DErrorReporter xj3DErrorReporter) {
        this.externalReporter = xj3DErrorReporter;
    }
}

