/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.ArrayList;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.NodeObserver;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.sai.CADViewListenerMulticaster;
import org.web3d.vrml.scripting.external.sai.SAINodeFactory;
import org.web3d.x3d.sai.X3DNode;
import org.xj3d.sai.Xj3DCADView;
import org.xj3d.sai.Xj3DCADViewListener;

class CADViewAdapter
implements Xj3DCADView,
NodeObserver {
    private static final String ADD_ERROR_MSG = "Error sending CAD node addtition update: ";
    private static final String REMOVE_ERROR_MSG = "Error sending CAD node removal update: ";
    private static final String DEFAULT_ERR_MSG = "Unknown error sending CAD View listener event: ";
    private Xj3DCADViewListener viewListener;
    private ErrorReporter errorReporter;
    private BrowserCore browserCore;
    private SAINodeFactory saiNodeFactory;

    CADViewAdapter(BrowserCore browserCore, SAINodeFactory sAINodeFactory) {
        this.browserCore = browserCore;
        this.saiNodeFactory = sAINodeFactory;
    }

    public X3DNode[] getCADLayers() {
        X3DNode x3DNode;
        VRMLNodeType vRMLNodeType;
        int n;
        VRMLExecutionSpace vRMLExecutionSpace = this.browserCore.getWorldExecutionSpace();
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        ArrayList<X3DNode> arrayList = new ArrayList<X3DNode>();
        ArrayList arrayList2 = basicScene.getByPrimaryType(94);
        for (n = 0; n < arrayList2.size(); ++n) {
            vRMLNodeType = (VRMLNodeType)arrayList2.get(n);
            x3DNode = this.saiNodeFactory.getSAINode(vRMLNodeType);
            arrayList.add(x3DNode);
        }
        arrayList2 = basicScene.getBySecondaryType(94);
        for (n = 0; n < arrayList2.size(); ++n) {
            vRMLNodeType = (VRMLNodeType)arrayList2.get(n);
            x3DNode = this.saiNodeFactory.getSAINode(vRMLNodeType);
            arrayList.add(x3DNode);
        }
        if (arrayList.size() != 0) {
            return arrayList.toArray(new X3DNode[arrayList.size()]);
        }
        return null;
    }

    public X3DNode[] getCADAssemblies() {
        X3DNode x3DNode;
        VRMLNodeType vRMLNodeType;
        int n;
        VRMLExecutionSpace vRMLExecutionSpace = this.browserCore.getWorldExecutionSpace();
        BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
        ArrayList<X3DNode> arrayList = new ArrayList<X3DNode>();
        ArrayList arrayList2 = basicScene.getByPrimaryType(95);
        for (n = 0; n < arrayList2.size(); ++n) {
            vRMLNodeType = (VRMLNodeType)arrayList2.get(n);
            x3DNode = this.saiNodeFactory.getSAINode(vRMLNodeType);
            arrayList.add(x3DNode);
        }
        arrayList2 = basicScene.getBySecondaryType(95);
        for (n = 0; n < arrayList2.size(); ++n) {
            vRMLNodeType = (VRMLNodeType)arrayList2.get(n);
            x3DNode = this.saiNodeFactory.getSAINode(vRMLNodeType);
            arrayList.add(x3DNode);
        }
        if (arrayList.size() != 0) {
            return arrayList.toArray(new X3DNode[arrayList.size()]);
        }
        return null;
    }

    public void highlightPart(X3DNode x3DNode, X3DNode x3DNode2) {
    }

    public void addCADViewListener(Xj3DCADViewListener xj3DCADViewListener) {
        if (this.viewListener == null && xj3DCADViewListener != null) {
            this.browserCore.addNodeObserver(94, this);
            this.browserCore.addNodeObserver(95, this);
        }
        this.viewListener = CADViewListenerMulticaster.add(this.viewListener, xj3DCADViewListener);
    }

    public void removeCADViewListener(Xj3DCADViewListener xj3DCADViewListener) {
        this.viewListener = CADViewListenerMulticaster.remove(this.viewListener, xj3DCADViewListener);
        if (this.viewListener == null) {
            this.browserCore.removeNodeObserver(94, this);
            this.browserCore.removeNodeObserver(95, this);
        }
    }

    public void nodesAdded(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        if (this.viewListener == null) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            try {
                X3DNode x3DNode = this.saiNodeFactory.getSAINode(vRMLNodeTypeArray[i]);
                if (n == 94) {
                    this.viewListener.layerAdded(x3DNode);
                    continue;
                }
                this.viewListener.assemblyAdded(x3DNode);
                continue;
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(ADD_ERROR_MSG + this.viewListener, (Exception)throwable);
                    continue;
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public void nodesRemoved(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) {
        if (this.viewListener == null) {
            return;
        }
        for (int i = 0; i < n2; ++i) {
            try {
                X3DNode x3DNode = this.saiNodeFactory.getSAINode(vRMLNodeTypeArray[i]);
                if (n == 94) {
                    this.viewListener.layerRemoved(x3DNode);
                    continue;
                }
                this.viewListener.assemblyRemoved(x3DNode);
                continue;
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    this.errorReporter.errorReport(REMOVE_ERROR_MSG + this.viewListener, (Exception)throwable);
                    continue;
                }
                System.out.println(DEFAULT_ERR_MSG + throwable);
                throwable.printStackTrace();
            }
        }
    }

    public void clear() {
    }

    public void shutdown() {
        this.browserCore.removeNodeObserver(94, this);
        this.browserCore.removeNodeObserver(95, this);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }
}

