/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.Enumeration;
import java.util.Vector;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.BaseExternalEventAdapter;
import org.web3d.vrml.scripting.external.buffer.ExternalEventAdapter;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBufferReclaimer;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterThreadPool;
import org.web3d.vrml.scripting.external.sai.SAIFieldFactory;
import org.web3d.x3d.sai.X3DFieldEvent;
import org.web3d.x3d.sai.X3DFieldEventListener;

class BufferedSAIEventAdapter
extends BaseExternalEventAdapter
implements ExternalEventAdapter,
VRMLNodeListener,
ExternalOutputBufferReclaimer {
    SAIFieldFactory theFieldFactory;
    SAIEventAdapterThreadPool thePool;

    BufferedSAIEventAdapter(SAIFieldFactory sAIFieldFactory, VRMLNodeType vRMLNodeType, SAIEventAdapterThreadPool sAIEventAdapterThreadPool, VRMLClock vRMLClock) {
        super(vRMLNodeType, vRMLClock);
        this.theFieldFactory = sAIFieldFactory;
        this.thePool = sAIEventAdapterThreadPool;
    }

    public synchronized void generateBroadcast(int n, double d) {
        Vector vector = this.getListeners(n);
        if (vector != null) {
            Object object = null;
            try {
                object = this.parentNode.getUserData(n);
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Unexpectedly bad field ID " + n + " for " + this.parentNode + " in event broadcast.");
            }
            Enumeration enumeration = ((Vector)vector.clone()).elements();
            while (enumeration.hasMoreElements()) {
                ExternalOutputBuffer externalOutputBuffer;
                if (this.buffers[n].size() != 0) {
                    externalOutputBuffer = (ExternalOutputBuffer)this.buffers[n].removeFirst();
                    externalOutputBuffer.initialize(this.parentNode, n);
                    externalOutputBuffer.loadOutputValue();
                } else {
                    externalOutputBuffer = (ExternalOutputBuffer)this.theFieldFactory.getStoredField(this.parentNode, n, this.parentNode.getFieldDeclaration(n).getName(), false);
                }
                X3DFieldEvent x3DFieldEvent = new X3DFieldEvent((Object)externalOutputBuffer, d, object);
                X3DFieldEventListener x3DFieldEventListener = (X3DFieldEventListener)enumeration.nextElement();
                this.thePool.sendEvent(x3DFieldEventListener, x3DFieldEvent, externalOutputBuffer, n, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaimEventOutBuffer(ExternalOutputBuffer externalOutputBuffer, int n) {
        externalOutputBuffer.reset();
        BufferedSAIEventAdapter bufferedSAIEventAdapter = this;
        synchronized (bufferedSAIEventAdapter) {
            this.buffers[n].addLast(externalOutputBuffer);
        }
    }
}

