/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.util.Hashtable;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEventAdapter;
import org.web3d.vrml.scripting.external.sai.BufferedSAIEventAdapter;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterThreadPool;
import org.web3d.vrml.scripting.external.sai.SAIFieldFactory;

class BufferedMappingSAIEventAdapterFactory
implements SAIEventAdapterFactory {
    Hashtable adapterTable = new Hashtable();
    SAIFieldFactory theFieldFactory;
    SAIEventAdapterThreadPool thePool;
    VRMLClock timeClock;

    BufferedMappingSAIEventAdapterFactory(VRMLClock vRMLClock) {
        this(2, vRMLClock);
    }

    BufferedMappingSAIEventAdapterFactory(int n, VRMLClock vRMLClock) {
        this.thePool = new SAIEventAdapterThreadPool(n);
        this.timeClock = vRMLClock;
    }

    public ExternalEventAdapter getAdapter(VRMLNodeType vRMLNodeType) {
        BufferedSAIEventAdapter bufferedSAIEventAdapter = (BufferedSAIEventAdapter)this.adapterTable.get(vRMLNodeType);
        if (bufferedSAIEventAdapter == null) {
            bufferedSAIEventAdapter = new BufferedSAIEventAdapter(this.theFieldFactory, vRMLNodeType, this.thePool, this.timeClock);
            this.adapterTable.put(vRMLNodeType, bufferedSAIEventAdapter);
            vRMLNodeType.addNodeListener(bufferedSAIEventAdapter);
        }
        return bufferedSAIEventAdapter;
    }

    void setFieldFactory(SAIFieldFactory sAIFieldFactory) {
        this.theFieldFactory = sAIFieldFactory;
    }

    public void shutdown() {
        this.thePool.shutdown();
    }
}

