/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.sai.SAIFieldDefinition;
import org.web3d.x3d.sai.InvalidReadableFieldException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.X3DField;
import org.web3d.x3d.sai.X3DFieldDefinition;
import org.web3d.x3d.sai.X3DFieldEventListener;

abstract class BaseFieldWrapper
implements X3DField {
    private static final String IMPROPER_READ_FROM_INPUTONLY_FIELD = "It is improper to read from an inputOnly field.";
    private static final String IMPROPER_READ_FROM_INITIALIZEONLY_FIELD = "It is improper to read from an initializeOnly field on a realized node.";
    private static final String IMPROPER_READ_FROM_OUTPUTONLY_FIELD = "It is improper to read from an outputOnly field on a node still in setup.";
    private static final String IMPROPER_WRITE_TO_OUTPUTONLY_FIELD = "It is improper to write to an outputOnly field.";
    private static final String IMPROPER_WRITE_TO_INITIAlIZEONLY_FIELD = "It is improper to write to an initializeOnly field on a realized node.";
    private static final String IMPROPER_WRITE_TO_INPUTONLY_FIELD = "It is improper to write to an inputOnly field on a node still in setup.";
    protected boolean storedInput;
    protected boolean storedOutput;
    protected ExternalEventQueue theEventQueue;
    protected VRMLNodeType theNode;
    protected SAIEventAdapterFactory theEventAdapterFactory;
    protected int fieldIndex;
    protected SAIFieldDefinition fieldDefinition;

    protected BaseFieldWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        this.theNode = vRMLNodeType;
        this.theEventAdapterFactory = sAIEventAdapterFactory;
        this.theEventQueue = externalEventQueue;
        this.fieldIndex = n;
    }

    protected void checkReadAccess() {
        int n = this.getAccessType();
        if (this.theEventQueue.isNodeRealized(this.theNode)) {
            switch (n) {
                case 1: {
                    throw new InvalidReadableFieldException(IMPROPER_READ_FROM_INPUTONLY_FIELD);
                }
                case 2: {
                    throw new InvalidReadableFieldException(IMPROPER_READ_FROM_INITIALIZEONLY_FIELD);
                }
            }
            return;
        }
        switch (n) {
            case 1: {
                throw new InvalidReadableFieldException(IMPROPER_READ_FROM_INPUTONLY_FIELD);
            }
            case 4: {
                throw new InvalidReadableFieldException(IMPROPER_READ_FROM_OUTPUTONLY_FIELD);
            }
        }
    }

    protected void checkWriteAccess() {
        int n = this.getAccessType();
        if (this.theEventQueue.isNodeRealized(this.theNode)) {
            switch (n) {
                default: {
                    return;
                }
                case 2: {
                    throw new InvalidWritableFieldException(IMPROPER_WRITE_TO_INITIAlIZEONLY_FIELD);
                }
                case 4: 
            }
            throw new InvalidWritableFieldException(IMPROPER_WRITE_TO_OUTPUTONLY_FIELD);
        }
        switch (n) {
            default: {
                return;
            }
            case 1: {
                throw new InvalidWritableFieldException(IMPROPER_WRITE_TO_INPUTONLY_FIELD);
            }
            case 4: 
        }
        throw new InvalidWritableFieldException(IMPROPER_WRITE_TO_OUTPUTONLY_FIELD);
    }

    public boolean equals(Object object) {
        if (object instanceof BaseFieldWrapper) {
            BaseFieldWrapper baseFieldWrapper = (BaseFieldWrapper)object;
            return this.fieldIndex == baseFieldWrapper.fieldIndex && this.theNode == baseFieldWrapper.theNode;
        }
        return super.equals(object);
    }

    protected int getAccessType() {
        int n = this.theNode.getFieldDeclaration(this.fieldIndex).getAccessType();
        return n;
    }

    public X3DFieldDefinition getDefinition() {
        if (this.fieldDefinition == null) {
            this.fieldDefinition = new SAIFieldDefinition(this.theNode, this.fieldIndex);
        }
        return this.fieldDefinition;
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.fieldIndex;
    }

    public boolean isReadable() {
        int n = this.getAccessType();
        if (this.theEventQueue.isNodeRealized(this.theNode)) {
            return n == 4 || n == 3;
        }
        return n == 2 || n == 3;
    }

    public boolean isWritable() {
        int n = this.getAccessType();
        if (this.theEventQueue.isNodeRealized(this.theNode)) {
            return n == 1 || n == 3;
        }
        return n == 3 || n == 2;
    }

    public void addX3DEventListener(X3DFieldEventListener x3DFieldEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).addListener(this.fieldIndex, x3DFieldEventListener);
    }

    public void removeX3DEventListener(X3DFieldEventListener x3DFieldEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).removeListener(this.fieldIndex, x3DFieldEventListener);
    }

    public void setUserData(Object object) {
        this.theNode.setUserData(this.fieldIndex, object);
    }

    public Object getUserData() {
        return this.theNode.getUserData(this.fieldIndex);
    }
}

