/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.sav;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.GZIPInputStream;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URIUtils;
import org.ietf.uri.URL;
import org.ietf.uri.event.ProgressListener;
import org.xj3d.io.ReadProgressListener;
import org.xj3d.io.ReportableInputStream;
import org.xj3d.io.ReportableInputStreamReader;
import org.xj3d.io.ReportableReader;

public class InputSource {
    private String encoding;
    private String baseURL;
    private String realURL;
    private InputStream stream;
    private Reader reader;
    private ReadProgressListener readProgressListener;
    private ProgressListener progressListener;
    private int updateSize;
    private String contentType;

    public InputSource(String string) {
        this.realURL = string;
        if (this.realURL.startsWith("file:")) {
            this.realURL = this.realURL.replace('\\', '/');
            if (this.realURL.charAt(7) != '/') {
                this.realURL = "file:///" + this.realURL.substring(6);
            }
        }
        String string2 = null;
        try {
            String[] stringArray = URIUtils.stripFile((String)URLDecoder.decode(string, "UTF-8"));
            string2 = stringArray[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        int n = string2.lastIndexOf("/");
        this.baseURL = string2.substring(0, n + 1);
    }

    public InputSource(File file) {
        try {
            java.net.URL uRL = file.toURL();
            this.realURL = uRL.toString();
            if (this.realURL.startsWith("file:")) {
                this.realURL = this.realURL.replace('\\', '/');
                if (this.realURL.charAt(7) != '\\') {
                    this.realURL = "file:///" + this.realURL.substring(6);
                }
            }
            String string = null;
            try {
                String[] stringArray = URIUtils.stripFile((String)URLDecoder.decode(this.realURL, "UTF-8"));
                string = stringArray[0];
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            int n = string.lastIndexOf("/");
            this.baseURL = string.substring(0, n + 1);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public InputSource(java.net.URL uRL) {
        this.realURL = uRL.toExternalForm();
        if (this.realURL.startsWith("file:")) {
            this.realURL = this.realURL.replace('\\', '/');
            if (this.realURL.charAt(7) != '\\') {
                this.realURL = "file:///" + this.realURL.substring(6);
            }
        }
        String string = null;
        try {
            String[] stringArray = URIUtils.stripFile((String)URLDecoder.decode(this.realURL, "UTF-8"));
            string = stringArray[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        int n = string.lastIndexOf("/");
        this.baseURL = string.substring(0, n + 1);
    }

    public InputSource(URL uRL) {
        this.realURL = uRL.toExternalForm();
        if (this.realURL.startsWith("file:")) {
            this.realURL = this.realURL.replace('\\', '/');
            if (this.realURL.charAt(7) != '\\') {
                this.realURL = "file:///" + this.realURL.substring(6);
            }
        }
        String string = null;
        try {
            String[] stringArray = URIUtils.stripFile((String)URLDecoder.decode(this.realURL, "UTF-8"));
            string = stringArray[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        int n = string.lastIndexOf("/");
        this.baseURL = string.substring(0, n + 1);
    }

    public InputSource(String string, InputStream inputStream) {
        this(string, inputStream, null);
    }

    public InputSource(String string, InputStream inputStream, String string2) {
        this.baseURL = string;
        this.stream = inputStream;
        this.realURL = string2;
    }

    public InputSource(String string, Reader reader) {
        this(string, reader, null);
    }

    public InputSource(String string, Reader reader, String string2) {
        this.baseURL = string;
        this.reader = reader;
        this.realURL = string2;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Reader getCharacterStream() throws IOException {
        Reader reader = null;
        if (this.reader == null) {
            if (this.stream == null) {
                try {
                    URL uRL = new URL(this.realURL);
                    final ResourceConnection resourceConnection = uRL.getResource();
                    if (this.progressListener != null) {
                        resourceConnection.addProgressListener(this.progressListener);
                    }
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            resourceConnection.connect();
                            return null;
                        }
                    });
                    this.stream = resourceConnection.getInputStream();
                    this.contentType = resourceConnection.getContentType();
                    this.encoding = resourceConnection.getContentEncoding();
                    if (this.encoding != null && this.encoding.equals("x-gzip")) {
                        this.stream = new GZIPInputStream(this.stream);
                    }
                    if (this.readProgressListener != null) {
                        ReportableInputStreamReader reportableInputStreamReader = new ReportableInputStreamReader(false, this.updateSize, this.readProgressListener, this.stream);
                        reader = reportableInputStreamReader;
                    }
                    reader = new InputStreamReader(this.stream);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IOException("Unable to locate file");
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            } else {
                reader = this.readProgressListener != null ? new ReportableInputStreamReader(false, this.updateSize, this.readProgressListener, this.stream) : new InputStreamReader(this.stream);
            }
            this.reader = reader;
        } else {
            reader = !(this.reader instanceof ReportableReader) && this.readProgressListener != null ? new ReportableReader(false, this.updateSize, this.readProgressListener, this.reader) : this.reader;
        }
        return reader;
    }

    public InputStream getByteStream() throws IOException {
        block9: {
            if (this.reader != null && this.stream == null) {
                throw new IOException("Raw reader provided. Can't make stream");
            }
            if (this.stream == null) {
                try {
                    URL uRL = new URL(this.realURL);
                    final ResourceConnection resourceConnection = uRL.getResource();
                    if (this.progressListener != null) {
                        resourceConnection.addProgressListener(this.progressListener);
                    }
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws IOException {
                            resourceConnection.connect();
                            return null;
                        }
                    });
                    this.stream = resourceConnection.getInputStream();
                    this.contentType = resourceConnection.getContentType();
                    this.encoding = resourceConnection.getContentEncoding();
                    if (this.encoding != null && this.encoding.equals("x-gzip")) {
                        this.stream = new GZIPInputStream(this.stream);
                    }
                    if (this.readProgressListener != null) {
                        ReportableInputStream reportableInputStream = new ReportableInputStream(false, this.updateSize, this.readProgressListener, this.stream);
                        return reportableInputStream;
                    }
                    break block9;
                }
                catch (MalformedURLException malformedURLException) {
                    throw new IOException("Unable to locate file");
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (IOException)privilegedActionException.getException();
                }
            }
            if (!(this.stream instanceof ReportableInputStream) && this.readProgressListener != null) {
                this.stream = new ReportableInputStream(false, this.updateSize, this.readProgressListener, this.stream);
            }
        }
        return this.stream;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getURL() {
        return this.realURL;
    }

    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public void setReadProgressListener(ReadProgressListener readProgressListener, int n) {
        this.readProgressListener = readProgressListener;
        this.updateSize = n;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getContentType() {
        return this.contentType;
    }
}

