/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.sax.AttributesHolder;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.util.XMLTools;
import org.web3d.vrml.export.BaseRetainedExporter;
import org.web3d.vrml.export.compressors.NodeCompressor;
import org.web3d.vrml.lang.ComponentInfo;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.ROUTE;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.lang.VRMLNodeTemplate;
import org.web3d.vrml.nodes.ImportNodeProxy;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;
import org.web3d.vrml.nodes.SceneGraphTraverser;
import org.web3d.vrml.nodes.VRMLExternalNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGroupingNodeType;
import org.web3d.vrml.nodes.VRMLMultiExternalNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.nodes.proto.AbstractProto;
import org.web3d.vrml.nodes.proto.ExternalPrototypeDecl;
import org.web3d.vrml.nodes.proto.ProtoInstancePlaceHolder;
import org.web3d.vrml.nodes.proto.PrototypeDecl;
import org.web3d.vrml.renderer.CRExternPrototypeDecl;
import org.web3d.vrml.renderer.CRProtoInstance;
import org.web3d.vrml.renderer.common.nodes.AbstractDynamicFieldNode;
import org.web3d.vrml.sav.SAVException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class X3DRetainedSAXExporter
extends BaseRetainedExporter
implements SceneGraphTraversalSimpleObserver {
    protected static String INDENT_STRING = "   ";
    public static final int METHOD_FASTEST_PARSING = 0;
    public static final int METHOD_SMALLEST_NONLOSSY = 1;
    public static final int METHOD_SMALLEST_LOSSY = 2;
    public static final int METHOD_STRINGS = 3;
    protected static final int BYTE_ALGORITHM_ID = 32;
    protected static final int DELTA_ZLIB_INT_ARRAY_ALGORITHM_ID = 33;
    protected static final int QUANTIZED_ZLIB_FLOAT_ARRAY_ALGORITHM_ID = 34;
    private static char[] newLineChar = new char[]{'\n'};
    protected HashMap EMPTY_MAP = new HashMap();
    protected int indent = 0;
    protected String indentString;
    protected IntHashMap indentMap;
    protected HashSet usedNodes;
    protected PrintWriter p;
    protected Writer filterWriter;
    protected HashSet protoDeclSet;
    protected SceneGraphTraverser traverser;
    protected VRMLWorldRootNodeType root;
    protected boolean printDocType;
    protected boolean useNC = false;
    protected boolean ignoreData;
    protected HashMap protoMap;
    protected NodeCompressor currentCompressor;
    protected boolean compressedAttWay = false;
    protected ContentHandler handler;
    protected int compressionMethod;
    protected float quantizeParam;
    protected boolean binary;

    public X3DRetainedSAXExporter(int n, int n2, ErrorReporter errorReporter, int n3, float f) {
        super(n, n2, errorReporter, -1);
        this.compressionMethod = n3;
        this.quantizeParam = f;
        this.init();
    }

    public X3DRetainedSAXExporter(int n, int n2, ErrorReporter errorReporter, int n3, float f, int n4) {
        super(n, n2, errorReporter, n4);
        this.compressionMethod = n3;
        this.quantizeParam = f;
        this.init();
    }

    private void init() {
        this.usedNodes = new HashSet();
        this.indentString = "";
        this.indentMap = new IntHashMap();
        this.protoDeclSet = new HashSet();
        this.traverser = new SceneGraphTraverser();
        this.protoMap = new HashMap();
        this.printDocType = false;
        this.stripWhitespace = false;
        this.ignoreData = false;
    }

    protected void encodeFloatArray(float[] fArray, int n, VRMLFieldDeclaration vRMLFieldDeclaration, String string, AttributesHolder attributesHolder, int n2) {
        String string2;
        if (fArray != null && fArray.length != 0 && (string2 = this.createX3DString(vRMLFieldDeclaration, fArray, n)) != null) {
            attributesHolder.addAttribute(new QualifiedName("", "", string), string2);
        }
    }

    protected String createX3DString(VRMLFieldDeclaration vRMLFieldDeclaration, float[] fArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(fArray.length * 3);
        boolean bl = this.isMFField(vRMLFieldDeclaration);
        if (bl) {
            int n2 = n;
            if (n2 <= 0) {
                return null;
            }
            int n3 = fArray.length / n2;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    if (this.sigDigits < 0) {
                        stringBuffer.append(fArray[n4++]);
                    } else {
                        stringBuffer.append(this.floatFormat.format(fArray[n4++]));
                    }
                    if (j == n3 - 1) continue;
                    stringBuffer.append(" ");
                }
                if (i == n2 - 1) continue;
                stringBuffer.append(" ,");
            }
        } else {
            int n5 = fArray.length;
            for (int i = 0; i < n5; ++i) {
                if (this.sigDigits < 0) {
                    stringBuffer.append(fArray[i]);
                } else {
                    stringBuffer.append(this.floatFormat.format(fArray[i]));
                }
                if (i == n5 - 1) continue;
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    protected String createX3DString(VRMLFieldDeclaration vRMLFieldDeclaration, double[] dArray, int n) {
        StringBuffer stringBuffer = new StringBuffer(dArray.length * 3);
        boolean bl = this.isMFField(vRMLFieldDeclaration);
        if (bl) {
            int n2 = n;
            if (n2 <= 0) {
                return null;
            }
            int n3 = dArray.length / n2;
            int n4 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n3; ++j) {
                    stringBuffer.append(dArray[n4++]);
                    if (j == n3 - 1) continue;
                    stringBuffer.append(" ");
                }
                if (i == n2 - 1) continue;
                stringBuffer.append(" ,");
            }
        } else {
            int n5 = dArray.length;
            for (int i = 0; i < n5; ++i) {
                stringBuffer.append(dArray[i]);
                if (i == n5 - 1) continue;
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    protected String createX3DString(VRMLFieldDeclaration vRMLFieldDeclaration, int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (i == n - 1) {
                stringBuffer.append(nArray[i]);
                continue;
            }
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    protected void encodeDoubleArray(double[] dArray, int n, VRMLFieldDeclaration vRMLFieldDeclaration, String string, AttributesHolder attributesHolder, int n2) {
        if (dArray != null && dArray.length != 0) {
            StringBuffer stringBuffer = new StringBuffer(dArray.length * 4);
            boolean bl = this.isMFField(vRMLFieldDeclaration);
            if (bl) {
                int n3 = n;
                if (n3 <= 0) {
                    return;
                }
                int n4 = dArray.length / n3;
                int n5 = 0;
                for (int i = 0; i < n3; ++i) {
                    for (int j = 0; j < n4; ++j) {
                        stringBuffer.append(dArray[n5++]);
                        if (j == n4 - 1) continue;
                        stringBuffer.append(" ");
                    }
                    if (i == n3 - 1) continue;
                    stringBuffer.append(" ,");
                }
            } else {
                int n6 = dArray.length;
                for (int i = 0; i < n6; ++i) {
                    stringBuffer.append(dArray[i]);
                    if (i == n6 - 1) continue;
                    stringBuffer.append(" ");
                }
            }
            attributesHolder.addAttribute(new QualifiedName("", "", string), stringBuffer.toString());
        }
    }

    public void writeScene(VRMLScene vRMLScene) {
        List list;
        this.usedNodes.clear();
        Map map = vRMLScene.getDEFNodes();
        this.currentDefMap = new HashMap(map.size());
        this.reverseMap(map, this.currentDefMap);
        Map map2 = this.currentDefMap;
        ArrayList arrayList = vRMLScene.getNodeTemplates();
        Iterator iterator = arrayList.iterator();
        this.root = (VRMLWorldRootNodeType)vRMLScene.getRootNode();
        this.traverser.setObserver(this);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ExternalPrototypeDecl) {
                this.printExternalPrototypeDecl((CRExternPrototypeDecl)e);
                continue;
            }
            this.printPrototypeDecl((PrototypeDecl)e);
            list = ((AbstractProto)e).getAllFields();
            for (VRMLFieldDeclaration vRMLFieldDeclaration : list) {
                if (vRMLFieldDeclaration == null) continue;
                this.protoMap.put(((VRMLNodeTemplate)e).getVRMLNodeName() + "." + vRMLFieldDeclaration.getName(), vRMLFieldDeclaration);
            }
        }
        this.currentDefMap = map2;
        this.traverse(this.root, true);
        this.printImports(vRMLScene.getImports());
        list = vRMLScene.getRoutes();
        int n = ((ArrayList)list).size();
        for (int i = 0; i < n; ++i) {
            this.printROUTE((ROUTE)((ArrayList)list).get(i), this.currentDefMap);
        }
        this.printExports(vRMLScene.getExports());
        try {
            this.handler.endElement("", "", "Scene");
            this.printNewLine();
            this.handler.endElement("", "", "X3D");
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void endDocument() throws SAVException, VRMLException {
        if (!this.processingDocument) {
            return;
        }
        this.processingDocument = false;
        super.endDocument();
        this.writeScene(this.scene);
        try {
            this.handler.endDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printHeader(int n, int n2) {
        try {
            this.handler.startDocument();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        this.loadContainerProperties(n, n2);
    }

    public void printProfile(String string) {
        String string2 = this.getPublicId(this.majorVersion, this.minorVersion);
        String string3 = this.getSystemId(this.majorVersion, this.minorVersion);
        AttributesHolder attributesHolder = new AttributesHolder();
        attributesHolder.addAttribute(new QualifiedName("", "", "profile"), string);
        attributesHolder.addAttribute(new QualifiedName("", "", "version"), this.majorVersion + "." + this.minorVersion);
        try {
            this.handler.startElement("", "", "X3D", (Attributes)attributesHolder);
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printComponents(ComponentInfo[] componentInfoArray) {
        int n = componentInfoArray.length;
        try {
            this.handler.startElement("", "", "head", (Attributes)new AttributesHolder());
            this.printNewLine();
            for (int i = 0; i < n; ++i) {
                AttributesHolder attributesHolder = new AttributesHolder();
                attributesHolder.addAttribute(new QualifiedName("", "", "name"), componentInfoArray[i].getName());
                attributesHolder.addAttribute(new QualifiedName("", "", "level"), Integer.toString(componentInfoArray[i].getLevel()));
                this.handler.startElement("", "", "component", (Attributes)attributesHolder);
                this.handler.endElement("", "", "component");
                this.printNewLine();
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printMetaData(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        int n = entryArray.length;
        this.indentUp();
        try {
            for (int i = 0; i < n; ++i) {
                this.printIndent();
                AttributesHolder attributesHolder = new AttributesHolder();
                attributesHolder.addAttribute(new QualifiedName("", "", "name"), (String)entryArray[i].getKey());
                attributesHolder.addAttribute(new QualifiedName("", "", "key"), (String)entryArray[i].getValue());
                this.handler.startElement("", "", "meta", (Attributes)attributesHolder);
                this.handler.endElement("", "", "meta");
            }
            this.handler.endElement("", "", "head");
            this.printNewLine();
            this.handler.startElement("", "", "Scene", (Attributes)new AttributesHolder());
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printROUTE(ROUTE rOUTE, Map map) {
        VRMLNode vRMLNode = rOUTE.getSourceNode();
        VRMLNode vRMLNode2 = rOUTE.getDestinationNode();
        String string = (String)map.get(vRMLNode);
        String string2 = vRMLNode2 instanceof ImportNodeProxy ? ((ImportNodeProxy)vRMLNode2).getImportedName() : (String)map.get(vRMLNode2);
        string = vRMLNode instanceof ImportNodeProxy ? ((ImportNodeProxy)vRMLNode).getImportedName() : (String)map.get(vRMLNode);
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNode.getFieldDeclaration(rOUTE.getSourceIndex());
        VRMLFieldDeclaration vRMLFieldDeclaration2 = vRMLNode2.getFieldDeclaration(rOUTE.getDestinationIndex());
        AttributesHolder attributesHolder = new AttributesHolder();
        attributesHolder.addAttribute(new QualifiedName("", "", "fromNode"), string);
        attributesHolder.addAttribute(new QualifiedName("", "", "fromField"), vRMLFieldDeclaration.getName());
        attributesHolder.addAttribute(new QualifiedName("", "", "toNode"), string2);
        attributesHolder.addAttribute(new QualifiedName("", "", "toField"), vRMLFieldDeclaration2.getName());
        try {
            this.printIndent();
            this.handler.startElement("", "", "ROUTE", (Attributes)attributesHolder);
            this.handler.endElement("", "", "ROUTE");
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printExports(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        try {
            for (int i = 0; i < entryArray.length; ++i) {
                String string = (String)entryArray[i].getValue();
                String string2 = (String)entryArray[i].getKey();
                AttributesHolder attributesHolder = new AttributesHolder();
                attributesHolder.addAttribute(new QualifiedName("", "", "localDEF"), string);
                if (string2 != null && !string.equals(string2)) {
                    attributesHolder.addAttribute(new QualifiedName("", "", "AS"), string2);
                }
                this.printIndent();
                this.handler.startElement("", "", "EXPORT", (Attributes)attributesHolder);
                this.handler.endElement("", "", "EXPORT");
                this.printNewLine();
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printImports(Map map) {
        Map.Entry[] entryArray = new Map.Entry[map.size()];
        map.entrySet().toArray(entryArray);
        try {
            for (int i = 0; i < entryArray.length; ++i) {
                String string = (String)entryArray[i].getKey();
                Object v = entryArray[i].getValue();
                AttributesHolder attributesHolder = new AttributesHolder();
                if (v instanceof String[]) {
                    String[] stringArray = (String[])entryArray[i].getValue();
                    attributesHolder.addAttribute(new QualifiedName("", "", "inlineDEF"), stringArray[0]);
                    attributesHolder.addAttribute(new QualifiedName("", "", "exportedDEF"), stringArray[1]);
                    attributesHolder.addAttribute(new QualifiedName("", "", "AS"), string);
                    this.printIndent();
                    this.handler.startElement("", "", "IMPORT", (Attributes)attributesHolder);
                    this.handler.endElement("", "", "IMPORT");
                    this.printNewLine();
                    continue;
                }
                ImportNodeProxy importNodeProxy = (ImportNodeProxy)v;
                attributesHolder.addAttribute(new QualifiedName("", "", "inlineDEF"), importNodeProxy.getInlineDEFName());
                attributesHolder.addAttribute(new QualifiedName("", "", "exportedDEF"), importNodeProxy.getExportedName());
                attributesHolder.addAttribute(new QualifiedName("", "", "AS"), importNodeProxy.getImportedName());
                this.printIndent();
                this.handler.startElement("", "", "IMPORT", (Attributes)attributesHolder);
                this.handler.endElement("", "", "IMPORT");
                this.printNewLine();
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void traverse(VRMLNode vRMLNode, boolean bl) {
        if (vRMLNode == null) {
            return;
        }
        if (bl) {
            this.recurseSimpleSceneGraphChild((VRMLNodeType)vRMLNode, false, false);
        } else {
            this.processSimpleNode(null, -1, (VRMLNodeType)vRMLNode, null);
        }
    }

    private void processSimpleNode(VRMLNodeType vRMLNodeType, int n, VRMLNodeType vRMLNodeType2, String string) {
        String string2;
        boolean bl = this.usedNodes.contains(vRMLNodeType2);
        String string3 = null;
        String string4 = vRMLNodeType2.getVRMLNodeName();
        if (this.convertOldContent && (string2 = (String)this.oldProtos.get(string4)) != null) {
            string4 = string2;
        }
        if (!bl) {
            this.usedNodes.add(vRMLNodeType2);
        }
        this.indentUp();
        if (!(string == null || (string2 = (String)this.containerFields.get(string4)) != null && string2.equals(string))) {
            string3 = string;
        }
        if (bl) {
            string2 = (String)this.currentDefMap.get(vRMLNodeType2);
            if (string2 == null) {
                this.printDefMap(this.currentDefMap);
            }
            try {
                this.printIndent();
                AttributesHolder attributesHolder = new AttributesHolder();
                attributesHolder.addAttribute(new QualifiedName("", "", "USE"), string2);
                if (string3 != null) {
                    attributesHolder.addAttribute(new QualifiedName("", "", "containerField"), string3);
                }
                this.handler.startElement("", "", string4, (Attributes)attributesHolder);
                this.handler.endElement("", "", string4);
                this.printNewLine();
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
            this.indentDown();
        } else {
            boolean bl2 = false;
            if (this.useNC) {
                if (vRMLNodeType2.getVRMLNodeName().equals("IndexedFaceSet")) {
                    this.ignoreData = true;
                    bl2 = true;
                }
                if (vRMLNodeType2.getVRMLNodeName().equals("TriangleSet")) {
                    this.ignoreData = true;
                    bl2 = true;
                }
                if (vRMLNodeType2.getVRMLNodeName().equals("IndexedTriangleSet")) {
                    this.ignoreData = true;
                    bl2 = true;
                }
            }
            boolean bl3 = this.printStartNode(vRMLNodeType2, bl, this.currentDefMap, this.currentIsMap, string3, bl2);
            boolean bl4 = this.recurseSimpleSceneGraphChild(vRMLNodeType2, bl3, bl2);
            try {
                this.printEndNode(vRMLNodeType2, bl4, bl2, this.currentIsMap);
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
            if (bl2) {
                this.ignoreData = false;
                this.currentCompressor = null;
            }
        }
    }

    private boolean recurseSimpleSceneGraphChild(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2) {
        int[] nArray = vRMLNodeType.getNodeFieldIndices();
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = vRMLNodeType.getFieldIndex("metadata");
        boolean bl6 = bl;
        String string = null;
        for (int i = 0; i < nArray.length; ++i) {
            VRMLFieldData vRMLFieldData;
            block35: {
                VRMLFieldDeclaration vRMLFieldDeclaration;
                AttributesHolder attributesHolder;
                int n2;
                if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
                    bl3 = true;
                    bl6 = true;
                }
                if (bl) {
                    bl6 = true;
                }
                bl4 = false;
                string = null;
                if (bl6 && i == n) {
                    bl6 = false;
                }
                try {
                    vRMLFieldData = vRMLNodeType.getFieldValue(nArray[i]);
                }
                catch (InvalidFieldException invalidFieldException) {
                    continue;
                }
                if (bl3 && i == n) {
                    if (vRMLFieldData.nodeValue == null) continue;
                    bl3 = false;
                }
                if (vRMLFieldData.dataType == 13) {
                    block34: {
                        VRMLFieldDeclaration vRMLFieldDeclaration2;
                        if (vRMLFieldData.nodeArrayValue != null && vRMLFieldData.nodeArrayValue.length > 0) {
                            bl5 = true;
                        } else if (bl) continue;
                        if (bl6) {
                            vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(nArray[i]);
                            this.printIndent();
                            try {
                                if (bl3) {
                                    n2 = vRMLFieldDeclaration2.getAccessType();
                                    if (n2 == 2 || n2 == 3) {
                                        bl4 = true;
                                    }
                                    this.printDeclNoValue(vRMLFieldDeclaration2, vRMLFieldData.numElements != 0);
                                    if (vRMLFieldData.numElements == 0) {
                                        this.printIndent();
                                        this.handler.endElement("", "", "field");
                                        this.printNewLine();
                                    }
                                    break block34;
                                }
                                this.printIndent();
                                attributesHolder = new AttributesHolder();
                                attributesHolder.addAttribute(new QualifiedName("", "", "name"), vRMLFieldDeclaration2.getName());
                                this.handler.startElement("", "", "fieldValue", (Attributes)attributesHolder);
                                if (vRMLFieldData.numElements == 0) {
                                    this.printIndent();
                                    this.handler.endElement("", "", "fieldValue");
                                    this.printNewLine();
                                    break block34;
                                }
                                this.printNewLine();
                            }
                            catch (SAXException sAXException) {
                                this.handleSAXException(sAXException);
                            }
                        } else {
                            vRMLFieldDeclaration2 = vRMLNodeType.getFieldDeclaration(nArray[i]);
                            string = vRMLFieldDeclaration2.getName();
                        }
                    }
                    for (int j = 0; j < vRMLFieldData.numElements; ++j) {
                        if (vRMLFieldData.nodeArrayValue[j] == null || this.convertOldContent && vRMLFieldData.nodeArrayValue[j].getVRMLNodeName().equals("GeoOrigin") && !vRMLNodeType.getFieldDeclaration(nArray[i]).getName().equals("geoOrigin")) continue;
                        this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeArrayValue[j], string);
                    }
                    if (!bl6) continue;
                    try {
                        if (bl) {
                            if (vRMLFieldData.numElements == 0) continue;
                            this.printIndent();
                            this.handler.endElement("", "", "fieldValue");
                            this.printNewLine();
                            continue;
                        }
                        if (vRMLFieldData.numElements == 0) continue;
                        this.printIndent();
                        this.handler.endElement("", "", "field");
                        this.printNewLine();
                    }
                    catch (SAXException sAXException) {
                        this.handleSAXException(sAXException);
                    }
                    continue;
                }
                if (nArray[i] == n && bl2) continue;
                if (vRMLFieldData.nodeValue != null) {
                    bl5 = true;
                }
                if (vRMLFieldData.nodeValue == null && !bl3) continue;
                if (bl6) {
                    vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(nArray[i]);
                    this.printIndent();
                    try {
                        if (bl3) {
                            n2 = vRMLFieldDeclaration.getAccessType();
                            if (n2 == 2 || n2 == 3) {
                                bl4 = true;
                            }
                            this.printDeclNoValue(vRMLFieldDeclaration, vRMLFieldData.nodeValue != null);
                            if (vRMLFieldData.nodeValue == null) {
                                this.printIndent();
                                this.handler.endElement("", "", "field");
                                this.printNewLine();
                                continue;
                            }
                            break block35;
                        }
                        attributesHolder = new AttributesHolder();
                        attributesHolder.addAttribute(new QualifiedName("", "", "name"), vRMLFieldDeclaration.getName());
                        this.handler.startElement("", "", "fieldValue", (Attributes)attributesHolder);
                        this.printNewLine();
                    }
                    catch (SAXException sAXException) {
                        this.handleSAXException(sAXException);
                    }
                } else {
                    vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(nArray[i]);
                    string = vRMLFieldDeclaration.getName();
                }
            }
            this.processSimpleNode(vRMLNodeType, nArray[i], (VRMLNodeType)vRMLFieldData.nodeValue, string);
            if (!bl6) continue;
            try {
                if (bl) {
                    this.printIndent();
                    this.handler.endElement("", "", "fieldValue");
                    this.printNewLine();
                    continue;
                }
                this.printIndent();
                this.handler.endElement("", "", "field");
                this.printNewLine();
                continue;
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
        return bl5;
    }

    public void printStartScriptNode(AbstractDynamicFieldNode abstractDynamicFieldNode, AttributesHolder attributesHolder, boolean bl, Map map, Map map2) {
        StringBuffer stringBuffer;
        VRMLFieldData vRMLFieldData;
        int n;
        List list = abstractDynamicFieldNode.getAllFields();
        Iterator iterator = list.iterator();
        int n2 = abstractDynamicFieldNode.getFieldIndex("mustEvaluate");
        int n3 = abstractDynamicFieldNode.getFieldIndex("directOutput");
        int n4 = abstractDynamicFieldNode.getFieldIndex("url");
        int n5 = abstractDynamicFieldNode.getFieldIndex("metadata");
        while (iterator.hasNext()) {
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
            if (vRMLFieldDeclaration == null) continue;
            n = abstractDynamicFieldNode.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLFieldData = abstractDynamicFieldNode.getFieldValue(n);
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer("Can't get field: ");
                stringBuffer.append(vRMLFieldDeclaration.getName());
                stringBuffer.append(" for: ");
                stringBuffer.append(abstractDynamicFieldNode);
                stringBuffer.append(" named: ");
                stringBuffer.append(abstractDynamicFieldNode.getVRMLNodeName());
                stringBuffer.append("\nIndex: ");
                stringBuffer.append(n4);
                this.errorReporter.errorReport(stringBuffer.toString(), null);
                continue;
            }
            if (n == n5) continue;
            if (n == n2) {
                if (!vRMLFieldData.booleanValue) continue;
                this.printFieldValue((VRMLNodeType)abstractDynamicFieldNode, attributesHolder, vRMLFieldData, vRMLFieldDeclaration, false, true);
                continue;
            }
            if (n == n3) {
                if (!vRMLFieldData.booleanValue) continue;
                this.printFieldValue((VRMLNodeType)abstractDynamicFieldNode, attributesHolder, vRMLFieldData, vRMLFieldDeclaration, false, true);
                continue;
            }
            if (n != n4) continue;
        }
        try {
            this.handler.startElement("", "", "Script", (Attributes)attributesHolder);
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
        for (VRMLFieldDeclaration vRMLFieldDeclaration : list) {
            if (vRMLFieldDeclaration == null) continue;
            n = abstractDynamicFieldNode.getFieldIndex(vRMLFieldDeclaration.getName());
            try {
                vRMLFieldData = abstractDynamicFieldNode.getFieldValue(n);
            }
            catch (Exception exception) {
                stringBuffer = new StringBuffer("Can't get field: ");
                stringBuffer.append(vRMLFieldDeclaration.getName());
                stringBuffer.append(" for: ");
                stringBuffer.append(abstractDynamicFieldNode);
                stringBuffer.append(" named: ");
                stringBuffer.append(abstractDynamicFieldNode.getVRMLNodeName());
                stringBuffer.append("\nIndex: ");
                stringBuffer.append(n4);
                this.errorReporter.errorReport(stringBuffer.toString(), null);
                continue;
            }
            if (n == n5 || n == n2 || n == n3 || n == n4) continue;
            this.printScriptFieldDecl((VRMLNodeType)abstractDynamicFieldNode, vRMLFieldDeclaration, n, vRMLFieldData, map, this.currentIsMap);
        }
        this.indentDown();
    }

    public boolean printStartNode(VRMLNodeType vRMLNodeType, boolean bl, Map map, Map map2, String string, boolean bl2) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl3;
        block53: {
            String string2;
            int n;
            VRMLFieldDeclaration vRMLFieldDeclaration;
            ArrayList<String[]> arrayList;
            int n2;
            Object object5;
            String string3 = (String)map.get(vRMLNodeType);
            String string4 = vRMLNodeType.getVRMLNodeName();
            boolean bl4 = false;
            bl3 = false;
            int[] nArray = vRMLNodeType.getNodeFieldIndices();
            if (vRMLNodeType instanceof VRMLProtoInstance) {
                if (this.convertOldContent) {
                    object4 = (String)this.oldProtos.get(string4);
                    if (object4 != null) {
                        string4 = object4;
                    } else {
                        bl3 = true;
                    }
                } else {
                    bl3 = true;
                }
            }
            this.printIndent();
            object4 = new AttributesHolder();
            String string5 = null;
            if (bl3) {
                object4.addAttribute(new QualifiedName("", "", "name"), string4);
                string5 = "ProtoInstance";
            } else {
                string5 = string4;
            }
            if (string3 != null) {
                object4.addAttribute(new QualifiedName("", "", "DEF"), string3);
            }
            if (string != null) {
                object4.addAttribute(new QualifiedName("", "", "containerField"), string);
            }
            if (bl3) {
                try {
                    this.handler.startElement("", "", string5, (Attributes)object4);
                    this.printNewLine();
                    object4 = new AttributesHolder();
                }
                catch (SAXException sAXException) {
                    this.handleSAXException(sAXException);
                }
            }
            this.indentUp();
            if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
                this.printStartScriptNode((AbstractDynamicFieldNode)vRMLNodeType, (AttributesHolder)object4, bl, map, map2);
                return false;
            }
            VRMLNodeType vRMLNodeType2 = (VRMLNodeType)this.defaultNodes.get(string4);
            if (vRMLNodeType2 == null && !(vRMLNodeType instanceof CRProtoInstance) && !(vRMLNodeType instanceof ProtoInstancePlaceHolder)) {
                vRMLNodeType2 = (VRMLNodeType)this.nodeFactory.createVRMLNode(string4, false);
                if (vRMLNodeType2 == null) {
                    this.errorReporter.errorReport("Could not create node: " + string4, null);
                }
                this.defaultNodes.put(string4, vRMLNodeType2);
            }
            int n3 = vRMLNodeType.getNumFields();
            boolean bl5 = false;
            boolean bl6 = false;
            HashSet<Integer> hashSet = null;
            String string6 = null;
            if (vRMLNodeType instanceof VRMLExternalNodeType) {
                bl6 = true;
                string6 = ((VRMLExternalNodeType)((Object)vRMLNodeType)).getWorldUrl();
                hashSet = new HashSet<Integer>();
                if (vRMLNodeType instanceof VRMLSingleExternalNodeType) {
                    hashSet.add(new Integer(vRMLNodeType.getFieldIndex("url")));
                } else {
                    object5 = ((VRMLMultiExternalNodeType)((Object)vRMLNodeType)).getUrlFieldIndexes();
                    for (n2 = 0; n2 < ((Object)object5).length; ++n2) {
                        hashSet.add(new Integer((int)object5[n2]));
                    }
                }
            }
            if (this.upgrading && string4.equals("Inline")) {
                bl5 = true;
            }
            object5 = new ArrayList();
            if (vRMLNodeType instanceof AbstractProto) {
                List list = ((AbstractProto)((Object)vRMLNodeType)).getAllFields();
                arrayList = list.iterator();
                while (arrayList.hasNext()) {
                    object5.add(arrayList.next());
                }
            } else {
                for (n2 = 0; n2 < n3; ++n2) {
                    arrayList = vRMLNodeType.getFieldDeclaration(n2);
                    object5.add(arrayList);
                }
            }
            Iterator iterator = object5.iterator();
            arrayList = new ArrayList<String[]>();
            int n4 = 0;
            while (iterator.hasNext()) {
                object3 = (VRMLFieldDeclaration)iterator.next();
                vRMLFieldDeclaration = null;
                if (object3 == null || (object2 = this.findIS(vRMLNodeType, n = vRMLNodeType.getFieldIndex(string2 = ((VRMLFieldDeclaration)object3).getName()), map2)) == null) continue;
                arrayList.add(new String[]{((VRMLFieldDeclaration)object3).getName(), object2});
            }
            iterator = object5.iterator();
            if (bl2) {
                bl4 = true;
            }
            while (iterator.hasNext()) {
                int n5;
                String[] stringArray;
                int n6;
                object3 = (VRMLFieldDeclaration)iterator.next();
                vRMLFieldDeclaration = null;
                if (object3 == null) continue;
                string2 = ((VRMLFieldDeclaration)object3).getName();
                n = vRMLNodeType.getFieldIndex(string2);
                if (vRMLNodeType2 != null) {
                    n4 = vRMLNodeType2.getFieldIndex(string2);
                    vRMLFieldDeclaration = vRMLNodeType2.getFieldDeclaration(n4);
                }
                if ((object2 = this.findIS(vRMLNodeType, n, map2)) != null) continue;
                if (this.ignoreData) {
                    n6 = 0;
                    if (this.currentCompressor != null) {
                        n6 = this.currentCompressor.handleData(string4, string2) ? 1 : 0;
                    }
                    if (n6 != 0) continue;
                }
                if ((n6 = ((VRMLFieldDeclaration)object3).getAccessType()) == 1 || n6 == 4) continue;
                try {
                    object = vRMLNodeType.getFieldValue(n);
                }
                catch (Exception exception) {
                    continue;
                }
                if (((VRMLFieldData)object).dataType == 7) {
                    if (((VRMLFieldData)object).nodeValue == null) continue;
                    bl4 = true;
                    continue;
                }
                if (((VRMLFieldData)object).dataType == 13) {
                    if (((VRMLFieldData)object).nodeArrayValue == null || ((VRMLFieldData)object).nodeArrayValue.length <= 0) continue;
                    bl4 = true;
                    continue;
                }
                if (vRMLNodeType2 != null && this.isDefault(vRMLNodeType, (VRMLFieldDeclaration)object3, n4, (VRMLFieldData)object, vRMLNodeType2) || vRMLNodeType instanceof CRProtoInstance && (stringArray = (String[])vRMLNodeType).isDefaultValue(n)) continue;
                if (bl6 && hashSet.contains(new Integer(n)) && (stringArray = ((VRMLFieldData)object).stringArrayValue) != null && string6 != null) {
                    for (n5 = 0; n5 < stringArray.length; ++n5) {
                        if (stringArray[n5] == null || !stringArray[n5].startsWith(string6)) continue;
                        stringArray[n5] = stringArray[n5].substring(string6.length());
                    }
                    ((VRMLFieldData)object).stringArrayValue = stringArray;
                }
                if (bl5 && ((VRMLFieldDeclaration)object3).getName().equals("url") && (stringArray = ((VRMLFieldData)object).stringArrayValue) != null) {
                    for (n5 = 0; n5 < stringArray.length; ++n5) {
                        int n7 = stringArray[n5].indexOf(".wrl");
                        if (n7 < 0) continue;
                        stringArray[n5] = stringArray[n5].substring(0, n7);
                        stringArray[n5] = stringArray[n5] + this.encodingTo;
                    }
                    ((VRMLFieldData)object).stringArrayValue = stringArray;
                }
                this.printFieldValue(vRMLNodeType, (AttributesHolder)object4, (VRMLFieldData)object, (VRMLFieldDeclaration)object3, bl3, !bl3);
            }
            if (bl2 && this.compressedAttWay) {
                object4.addAttribute(new QualifiedName("", "", "encoder"), "1");
                object3 = this.currentCompressor.compress(vRMLNodeType);
                object4.addAttributeWithAlgorithmData(new QualifiedName("", "", "", "data"), null, 3, object3);
            }
            if (bl4 && !bl3) {
                try {
                    this.handler.startElement("", "", string5, (Attributes)object4);
                }
                catch (SAXException sAXException) {
                    this.handleSAXException(sAXException);
                }
                this.printNewLine();
                this.printISList(arrayList);
            } else if (!bl3) {
                try {
                    if (arrayList.size() > 0) {
                        this.handler.startElement("", "", string5, (Attributes)object4);
                        this.printNewLine();
                        this.printISList(arrayList);
                        this.printIndent();
                        this.handler.endElement("", "", string5);
                        this.printNewLine();
                        break block53;
                    }
                    this.handler.startElement("", "", string5, (Attributes)object4);
                    this.handler.endElement("", "", string5);
                    this.printNewLine();
                }
                catch (SAXException sAXException) {
                    this.handleSAXException(sAXException);
                }
            } else {
                this.printISList(arrayList);
            }
        }
        if (bl2 && !this.compressedAttWay) {
            try {
                this.printIndent();
                object4 = new AttributesHolder();
                object4.addAttribute(new QualifiedName("", "", "name"), ".x3db");
                this.handler.startElement("", "", "MetadataSet", (Attributes)object4);
                this.printNewLine();
                this.indentUp();
                object3 = null;
                int n = vRMLNodeType.getFieldIndex("metadata");
                object2 = vRMLNodeType.getFieldValue(n);
                if (((VRMLFieldData)object2).nodeValue != null) {
                    this.ignoreData = false;
                    this.processSimpleNode(null, -1, (VRMLNodeType)((VRMLFieldData)object2).nodeValue, "metadata");
                    this.ignoreData = true;
                }
                this.printIndent();
                object4 = new AttributesHolder();
                object4.addAttribute(new QualifiedName("", "", "encoding"), "1");
                this.handler.startElement("", "", "MetadataInteger", (Attributes)object4);
                this.handler.endElement("", "", "MetadataInteger");
                this.printNewLine();
                int[] nArray = this.currentCompressor.compress(vRMLNodeType);
                this.printIndent();
                object4 = new AttributesHolder();
                object4.addAttribute(new QualifiedName("", "", "name"), "payload");
                object4.addAttributeWithAlgorithmData(new QualifiedName("", "", "", "value"), null, 3, (Object)nArray);
                this.handler.startElement("", "", "MetadataInteger", (Attributes)object4);
                this.handler.endElement("", "", "MetadataInteger");
                this.printNewLine();
                object = this.currentCompressor.getEncoderMetadata();
                if (object != null) {
                    this.errorReporter.warningReport("***XML String version of encoded Metadata not supported", null);
                    object4 = new AttributesHolder();
                    object4.addAttribute(new QualifiedName("", "", "name"), "Encoder Metadata");
                    this.handler.startElement("", "", "MetadataSet", (Attributes)object4);
                    this.handler.endElement("", "", "MetadataSet");
                }
                this.indentDown();
                this.printIndent();
                this.handler.endElement("", "", "MetadataSet");
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
        this.indentDown();
        return bl3;
    }

    public void printEndNode(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2, Map map) throws SAXException {
        Object object;
        Object object2 = vRMLNodeType.getVRMLNodeName();
        boolean bl3 = false;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            if (this.convertOldContent) {
                object = (String)this.oldProtos.get(object2);
                if (object != null) {
                    object2 = object;
                } else {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
        }
        if (vRMLNodeType instanceof AbstractDynamicFieldNode) {
            Object[] objectArray;
            Object object3;
            object = ((AbstractDynamicFieldNode)vRMLNodeType).getAllFields();
            Iterator iterator = object.iterator();
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (iterator.hasNext()) {
                int n;
                VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)iterator.next();
                if (vRMLFieldDeclaration == null || (object3 = this.findIS(vRMLNodeType, n = vRMLNodeType.getFieldIndex(vRMLFieldDeclaration.getName()), map)) == null || object3 == null) continue;
                arrayList.add(new String[]{vRMLFieldDeclaration.getName(), object3});
            }
            this.printISList(arrayList);
            this.indentUp();
            int n = vRMLNodeType.getFieldIndex("url");
            VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
            object3 = null;
            try {
                object3 = vRMLNodeType.getFieldValue(n);
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Can't get field: ");
                stringBuffer.append(vRMLFieldDeclaration.getName());
                stringBuffer.append(" for: ");
                stringBuffer.append(vRMLNodeType);
                stringBuffer.append(" named: ");
                stringBuffer.append(vRMLNodeType.getVRMLNodeName());
                stringBuffer.append("\nIndex: ");
                stringBuffer.append(n);
                this.errorReporter.errorReport(stringBuffer.toString(), null);
            }
            if (this.upgrading) {
                objectArray = new String[((VRMLFieldData)object3).stringArrayValue.length];
                boolean bl4 = false;
                int n2 = objectArray.length;
                for (int i = 0; i < n2; ++i) {
                    objectArray[i] = ((VRMLFieldData)object3).stringArrayValue[i];
                    if (!bl4 && (objectArray[i].startsWith("javascript:") || objectArray[i].startsWith("vrmlscript:"))) {
                        objectArray[i] = "ecmascript:" + objectArray[i].substring(11);
                        bl4 = true;
                    }
                    int n3 = this.scriptPatterns.length;
                    for (int j = 0; j < n3; ++j) {
                        objectArray[i] = this.scriptPatterns[j].matcher(objectArray[i]).replaceAll(this.scriptReplacements[j]);
                    }
                }
                ((VRMLFieldData)object3).stringArrayValue = objectArray;
            }
            this.printIndent();
            if (!this.binary) {
                objectArray = "<![CDATA[".toCharArray();
                this.handler.characters((char[])objectArray, 0, objectArray.length);
            }
            this.indentUp();
            for (int i = 0; i < ((VRMLFieldData)object3).stringArrayValue.length; ++i) {
                if (i != 0) {
                    this.printIndent();
                }
                this.handler.characters(((VRMLFieldData)object3).stringArrayValue[i].toCharArray(), 0, ((VRMLFieldData)object3).stringArrayValue[i].length());
            }
            this.indentDown();
            if (!this.binary) {
                objectArray = "]]>".toCharArray();
                this.handler.characters((char[])objectArray, 0, objectArray.length);
            }
            this.printNewLine();
            this.printIndent();
            this.handler.endElement("", "", (String)object2);
            this.printNewLine();
            this.indentDown();
            return;
        }
        if (bl3) {
            this.printIndent();
            this.handler.endElement("", "", "ProtoInstance");
            this.printNewLine();
        } else if (bl) {
            this.printIndent();
            this.handler.endElement("", "", (String)object2);
            this.printNewLine();
        }
        this.indentDown();
    }

    public void observedNode(VRMLNodeType vRMLNodeType, VRMLNodeType vRMLNodeType2, int n, boolean bl) {
        VRMLNodeTemplate vRMLNodeTemplate;
        if (vRMLNodeType2 instanceof ProtoInstancePlaceHolder && !((vRMLNodeTemplate = ((ProtoInstancePlaceHolder)vRMLNodeType2).getProtoDefinition()) instanceof CRExternPrototypeDecl)) {
            this.protoDeclSet.add(vRMLNodeTemplate);
        }
    }

    public void printPrototypeDecl(PrototypeDecl prototypeDecl) {
        this.currentDefMap = new HashMap();
        Map map = this.currentDefMap;
        this.reverseMap(prototypeDecl.getDEFMap(), this.currentDefMap);
        this.currentIsMap = prototypeDecl.getISMaps();
        this.currentPrototypeDecl = prototypeDecl;
        VRMLGroupingNodeType vRMLGroupingNodeType = prototypeDecl.getBodyGroup();
        VRMLNodeType[] vRMLNodeTypeArray = vRMLGroupingNodeType.getChildren();
        String string = prototypeDecl.getVRMLNodeName();
        VRMLNode vRMLNode = this.protoCreator.newInstance((VRMLNodeTemplate)prototypeDecl, (VRMLExecutionSpace)this.root, this.majorVersion, this.minorVersion, false);
        this.defaultNodes.put(prototypeDecl.getVRMLNodeName(), vRMLNode);
        if (this.convertOldContent && this.oldProtos.get(string) != null) {
            return;
        }
        try {
            int n;
            this.printIndent();
            AttributesHolder attributesHolder = new AttributesHolder();
            attributesHolder.addAttribute(new QualifiedName("", "", "name"), string);
            this.handler.startElement("", "", "ProtoDeclare", (Attributes)attributesHolder);
            this.printNewLine();
            this.indentUp();
            this.printIndent();
            attributesHolder = new AttributesHolder();
            this.handler.startElement("", "", "ProtoInterface", (Attributes)attributesHolder);
            this.printNewLine();
            this.indentUp();
            List list = prototypeDecl.getAllFields();
            for (VRMLFieldDeclaration vRMLFieldDeclaration : list) {
                boolean bl;
                int n2 = prototypeDecl.getFieldIndex(vRMLFieldDeclaration.getName());
                VRMLFieldData vRMLFieldData = null;
                int n3 = vRMLFieldDeclaration.getAccessType();
                if (n3 != 1 && n3 != 4) {
                    vRMLFieldData = prototypeDecl.getFieldValue(n2);
                    bl = true;
                } else {
                    bl = false;
                }
                if (vRMLFieldDeclaration.getName().equals("metadata") && (vRMLFieldData == null || vRMLFieldData.nodeValue == null)) continue;
                this.printProtoFieldDecl(vRMLFieldDeclaration, n2, vRMLFieldData, this.currentDefMap, this.currentIsMap, bl);
            }
            this.indentDown();
            this.printIndent();
            this.handler.endElement("", "", "ProtoInterface");
            this.printNewLine();
            this.printIndent();
            attributesHolder = new AttributesHolder();
            this.handler.startElement("", "", "ProtoBody", (Attributes)attributesHolder);
            this.printNewLine();
            this.protoDeclSet.clear();
            for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                this.traverser.reset();
                this.traverser.traverseGraph(vRMLNodeTypeArray[i]);
            }
            PrototypeDecl[] prototypeDeclArray = new PrototypeDecl[this.protoDeclSet.size()];
            this.protoDeclSet.toArray(prototypeDeclArray);
            for (n = 0; n < prototypeDeclArray.length; ++n) {
                this.printPrototypeDecl(prototypeDeclArray[n]);
            }
            this.currentDefMap = map;
            this.currentIsMap = prototypeDecl.getISMaps();
            this.currentPrototypeDecl = prototypeDecl;
            for (n = 0; n < vRMLNodeTypeArray.length; ++n) {
                this.traverse(vRMLNodeTypeArray[n], false);
            }
            this.printImports(prototypeDecl.getImportDecls());
            Set set = prototypeDecl.getRouteDecls();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.printROUTE((ROUTE)iterator.next(), this.currentDefMap);
            }
            this.printIndent();
            this.handler.endElement("", "", "ProtoBody");
            this.printNewLine();
            this.indentDown();
            this.printIndent();
            this.handler.endElement("", "", "ProtoDeclare");
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    public void printExternalPrototypeDecl(CRExternPrototypeDecl cRExternPrototypeDecl) {
        String string;
        int n;
        this.currentDefMap = new HashMap();
        String string2 = cRExternPrototypeDecl.getVRMLNodeName();
        if (this.convertOldContent && this.oldProtos.get(string2) != null) {
            return;
        }
        this.printIndent();
        AttributesHolder attributesHolder = new AttributesHolder();
        attributesHolder.addAttribute(new QualifiedName("", "", "name"), string2);
        String[] stringArray = (String[])this.epToUrl.get(cRExternPrototypeDecl.getVRMLNodeName());
        int n2 = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append("\"");
            if (this.upgrading) {
                int n3 = stringArray[i].indexOf(".wrl");
                n = stringArray[i].indexOf("#");
                if (n3 >= 0) {
                    Object object = stringArray[i];
                    stringArray[i] = stringArray[i].substring(0, n3);
                    stringArray[i] = stringArray[i] + this.encodingTo;
                    if (n > 0) {
                        string = ((String)object).substring(n);
                        stringArray[i] = stringArray[i] + string;
                    }
                }
            }
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("\"");
            if (i == n2 - 1) continue;
            stringBuffer.append("\n");
        }
        attributesHolder.addAttribute(new QualifiedName("", "", "url"), stringBuffer.toString());
        try {
            this.handler.startElement("", "", "ExternProtoDeclare", (Attributes)attributesHolder);
            this.indentUp();
            List list = cRExternPrototypeDecl.getAllFields();
            for (Object object : list) {
                n = cRExternPrototypeDecl.getFieldIndex(((VRMLFieldDeclaration)object).getName());
                string = null;
                if (((VRMLFieldDeclaration)object).getName().equals("metadata")) continue;
                this.printProtoFieldDecl((VRMLFieldDeclaration)object, n, null, this.currentDefMap, this.currentIsMap, false);
            }
            this.indentDown();
            this.printIndent();
            this.handler.endElement("", "", "ExternProtoDeclare");
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    private boolean isMFField(VRMLFieldDeclaration vRMLFieldDeclaration) {
        int n = vRMLFieldDeclaration.getFieldType();
        return n % 2 == 0;
    }

    private void indentUp() {
        ++this.indent;
        if (this.stripWhitespace) {
            return;
        }
        this.indentString = (String)this.indentMap.get(this.indent);
        if (this.indentString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.indent * INDENT_STRING.length());
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(INDENT_STRING);
            }
            this.indentString = stringBuffer.toString();
            this.indentMap.put(this.indent, this.indentString);
        }
    }

    private void indentDown() {
        --this.indent;
        if (this.stripWhitespace) {
            return;
        }
        this.indentString = (String)this.indentMap.get(this.indent);
        if (this.indentString == null) {
            StringBuffer stringBuffer = new StringBuffer(this.indent * INDENT_STRING.length());
            for (int i = 0; i < this.indent; ++i) {
                stringBuffer.append(INDENT_STRING);
            }
            this.indentString = stringBuffer.toString();
        }
    }

    private void printProtoFieldDecl(VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, Map map, Map map2, boolean bl) {
        this.printIndent();
        int n2 = vRMLFieldDeclaration.getAccessType();
        String string = "Unknown";
        switch (n2) {
            case 2: {
                string = "initializeOnly";
                break;
            }
            case 3: {
                string = "inputOutput";
                break;
            }
            case 1: {
                string = "inputOnly";
                break;
            }
            case 4: {
                string = "outputOnly";
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type in X3DClassicExporter: " + n2, null);
            }
        }
        AttributesHolder attributesHolder = new AttributesHolder();
        attributesHolder.addAttribute(new QualifiedName("", "", "accessType"), string);
        attributesHolder.addAttribute(new QualifiedName("", "", "type"), vRMLFieldDeclaration.getFieldTypeString());
        attributesHolder.addAttribute(new QualifiedName("", "", "name"), vRMLFieldDeclaration.getName());
        try {
            if (vRMLFieldData != null) {
                switch (vRMLFieldData.dataType) {
                    case 7: {
                        VRMLNode vRMLNode = vRMLFieldData.nodeValue;
                        if (vRMLNode == null) {
                            this.handler.startElement("", "", "field", (Attributes)attributesHolder);
                            this.handler.endElement("", "", "field");
                            this.printNewLine();
                            break;
                        }
                        this.handler.startElement("", "", "field", (Attributes)attributesHolder);
                        this.printNewLine();
                        this.traverse(vRMLNode, false);
                        this.printIndent();
                        this.handler.endElement("", "", "field");
                        this.printNewLine();
                        break;
                    }
                    case 13: {
                        this.handler.startElement("", "", "field", (Attributes)attributesHolder);
                        VRMLNode[] vRMLNodeArray = vRMLFieldData.nodeArrayValue;
                        int n3 = vRMLNodeArray.length;
                        if (n3 > 0) {
                            this.printNewLine();
                        }
                        this.indentUp();
                        for (int i = 0; i < n3; ++i) {
                            this.printIndent();
                            this.traverse(vRMLNodeArray[i], false);
                        }
                        this.indentDown();
                        this.printIndent();
                        this.handler.endElement("", "", "field");
                        this.printNewLine();
                        break;
                    }
                    default: {
                        this.printFieldValue(null, attributesHolder, vRMLFieldData, vRMLFieldDeclaration, false, false);
                        this.handler.startElement("", "", "field", (Attributes)attributesHolder);
                        this.handler.endElement("", "", "field");
                        this.printNewLine();
                        break;
                    }
                }
            } else {
                if (bl) {
                    this.printFieldValue(null, attributesHolder, vRMLFieldData, vRMLFieldDeclaration, false, false);
                }
                this.handler.startElement("", "", "field", (Attributes)attributesHolder);
                this.handler.endElement("", "", "field");
                this.printNewLine();
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    private void printDeclNoValue(VRMLFieldDeclaration vRMLFieldDeclaration, boolean bl) {
        int n = vRMLFieldDeclaration.getAccessType();
        String string = "Unknown";
        switch (n) {
            case 2: {
                string = "initializeOnly";
                break;
            }
            case 3: {
                string = "inputOutput";
                break;
            }
            case 1: {
                string = "inputOnly";
                break;
            }
            case 4: {
                string = "outputOnly";
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown field type in X3DClassicExporter: " + n, null);
            }
        }
        AttributesHolder attributesHolder = new AttributesHolder();
        attributesHolder.addAttribute(new QualifiedName("", "", "accessType"), string);
        attributesHolder.addAttribute(new QualifiedName("", "", "type"), vRMLFieldDeclaration.getFieldTypeString());
        attributesHolder.addAttribute(new QualifiedName("", "", "name"), vRMLFieldDeclaration.getName());
        try {
            this.handler.startElement("", "", "field", (Attributes)attributesHolder);
            if (bl) {
                this.printNewLine();
            }
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    private void printScriptFieldDecl(VRMLNodeType vRMLNodeType, VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, Map map, Map map2) {
        String string = this.findIS(vRMLNodeType, n, map2);
        if (vRMLFieldData != null && (vRMLFieldData.dataType == 7 || vRMLFieldData.dataType == 13)) {
            return;
        }
        this.printIndent();
        int n2 = vRMLFieldDeclaration.getAccessType();
        this.printDeclNoValue(vRMLFieldDeclaration, n2 != 1 && n2 != 4);
        if (n2 == 1 || n2 == 4) {
            try {
                this.printIndent();
                this.handler.endElement("", "", "field");
                this.printNewLine();
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
            return;
        }
        if (vRMLFieldData != null) {
            switch (vRMLFieldData.dataType) {
                case 7: {
                    break;
                }
                case 13: {
                    break;
                }
                default: {
                    this.printFieldValue(vRMLNodeType, new AttributesHolder(), vRMLFieldData, vRMLFieldDeclaration, false, false);
                    try {
                        this.printIndent();
                        this.handler.endElement("", "", "field");
                        this.printNewLine();
                        break;
                    }
                    catch (SAXException sAXException) {
                        this.handleSAXException(sAXException);
                    }
                }
            }
        }
    }

    private boolean isDefault(VRMLNodeType vRMLNodeType, VRMLFieldDeclaration vRMLFieldDeclaration, int n, VRMLFieldData vRMLFieldData, VRMLNodeType vRMLNodeType2) {
        VRMLFieldData vRMLFieldData2;
        try {
            vRMLFieldData2 = vRMLNodeType2.getFieldValue(n);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Can't get field: ");
            stringBuffer.append(vRMLFieldDeclaration.getName());
            stringBuffer.append(" for: ");
            stringBuffer.append(vRMLNodeType);
            stringBuffer.append(" named: ");
            stringBuffer.append(vRMLNodeType.getVRMLNodeName());
            stringBuffer.append("\nIndex: ");
            stringBuffer.append(n);
            this.errorReporter.errorReport(stringBuffer.toString(), null);
            return false;
        }
        if (vRMLFieldData == null) {
            return true;
        }
        boolean bl = true;
        block1 : switch (vRMLFieldData.dataType) {
            case 1: {
                if (vRMLFieldData2.booleanValue == vRMLFieldData.booleanValue) break;
                bl = false;
                break;
            }
            case 2: {
                if (vRMLFieldData2.intValue == vRMLFieldData.intValue) break;
                bl = false;
                break;
            }
            case 3: {
                if (vRMLFieldData2.longValue == vRMLFieldData.longValue) break;
                bl = false;
                break;
            }
            case 4: {
                if (vRMLFieldData2.floatValue == vRMLFieldData.floatValue) break;
                bl = false;
                break;
            }
            case 5: {
                if (vRMLFieldData2.doubleValue == vRMLFieldData.doubleValue) break;
                bl = false;
                break;
            }
            case 6: {
                if (vRMLFieldData2.stringValue == vRMLFieldData.stringValue) break;
                bl = false;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (vRMLFieldData2.booleanArrayValue == null && vRMLFieldData.booleanArrayValue == null) break;
                if (vRMLFieldData2.booleanArrayValue == null || vRMLFieldData.booleanArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.booleanArrayValue.length != vRMLFieldData.booleanArrayValue.length) {
                    bl = false;
                    break;
                }
                int n2 = vRMLFieldData2.booleanArrayValue.length;
                for (int i = 0; i < n2; ++i) {
                    if (vRMLFieldData2.booleanArrayValue[i] == vRMLFieldData.booleanArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 9: {
                if (vRMLFieldData2.intArrayValue == null && vRMLFieldData.intArrayValue == null) break;
                if (vRMLFieldData2.intArrayValue == null || vRMLFieldData.intArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.intArrayValue.length != vRMLFieldData.intArrayValue.length) {
                    bl = false;
                    break;
                }
                int n3 = vRMLFieldData2.intArrayValue.length;
                for (int i = 0; i < n3; ++i) {
                    if (vRMLFieldData2.intArrayValue[i] == vRMLFieldData.intArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 10: {
                if (vRMLFieldData2.longArrayValue == null && vRMLFieldData.longArrayValue == null) break;
                if (vRMLFieldData2.longArrayValue == null || vRMLFieldData.longArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.longArrayValue.length != vRMLFieldData.longArrayValue.length) {
                    bl = false;
                    break;
                }
                int n4 = vRMLFieldData2.longArrayValue.length;
                for (int i = 0; i < n4; ++i) {
                    if (vRMLFieldData2.longArrayValue[i] == vRMLFieldData.longArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 11: {
                if (vRMLFieldData2.floatArrayValue == null && vRMLFieldData.floatArrayValue == null) break;
                if (vRMLFieldData2.floatArrayValue == null || vRMLFieldData.floatArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.floatArrayValue.length != vRMLFieldData.floatArrayValue.length) {
                    bl = false;
                    break;
                }
                int n5 = vRMLFieldData2.floatArrayValue.length;
                for (int i = 0; i < n5; ++i) {
                    if (vRMLFieldData2.floatArrayValue[i] == vRMLFieldData.floatArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 12: {
                if (vRMLFieldData2.doubleArrayValue == null && vRMLFieldData.doubleArrayValue == null) break;
                if (vRMLFieldData2.doubleArrayValue == null || vRMLFieldData.doubleArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.doubleArrayValue.length != vRMLFieldData.doubleArrayValue.length) {
                    bl = false;
                    break;
                }
                int n6 = vRMLFieldData2.doubleArrayValue.length;
                for (int i = 0; i < n6; ++i) {
                    if (vRMLFieldData2.doubleArrayValue[i] == vRMLFieldData.doubleArrayValue[i]) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                if (vRMLFieldData2.stringArrayValue == null && vRMLFieldData.stringArrayValue == null) break;
                if (vRMLFieldData2.stringArrayValue == null || vRMLFieldData.stringArrayValue == null) {
                    bl = false;
                    break;
                }
                if (vRMLFieldData2.stringArrayValue.length != vRMLFieldData.stringArrayValue.length) {
                    bl = false;
                    break;
                }
                int n7 = vRMLFieldData2.stringArrayValue.length;
                for (int i = 0; i < n7; ++i) {
                    if (vRMLFieldData2.stringArrayValue[i] == null && vRMLFieldData.stringArrayValue[i] == null) continue;
                    if (vRMLFieldData2.stringArrayValue[i] == null || vRMLFieldData.stringArrayValue[i] == null) {
                        bl = false;
                        break block1;
                    }
                    if (vRMLFieldData2.stringArrayValue[i].equals(vRMLFieldData.stringArrayValue[i])) continue;
                    bl = false;
                    break block1;
                }
                break;
            }
        }
        return bl;
    }

    private void printFieldValue(VRMLNodeType vRMLNodeType, AttributesHolder attributesHolder, VRMLFieldData vRMLFieldData, VRMLFieldDeclaration vRMLFieldDeclaration, boolean bl, boolean bl2) {
        int n;
        String string;
        Comparable<Integer> comparable;
        if (vRMLFieldData == null) {
            int n2 = vRMLFieldDeclaration.getFieldType();
            if (n2 == 27) {
                String string2 = "value";
            }
            return;
        }
        if (this.convertOldContent && vRMLNodeType != null && (comparable = (Integer)this.fieldRemap.get(string = vRMLNodeType.getVRMLNodeName() + "." + vRMLFieldDeclaration.getName())) != null) {
            n = (Integer)comparable;
            this.convertFieldData(n, vRMLFieldData, vRMLFieldDeclaration);
        }
        if (bl) {
            attributesHolder.addAttribute(new QualifiedName("", "", "name"), vRMLFieldDeclaration.getName());
        }
        if (vRMLFieldData.dataType == 13 || vRMLFieldData.dataType == 7) {
            System.out.println("*** pfv, Not sure if this case is handled");
            this.p.print(" >");
            return;
        }
        String string3 = bl ? "value" : (bl2 ? vRMLFieldDeclaration.getName() : "value");
        switch (vRMLFieldData.dataType) {
            case 1: {
                string = vRMLFieldData.booleanValue ? "true" : "false";
                attributesHolder.addAttribute(new QualifiedName("", "", string3), string);
                break;
            }
            case 2: {
                string = Integer.toString(vRMLFieldData.intValue);
                attributesHolder.addAttribute(new QualifiedName("", "", string3), string);
                break;
            }
            case 3: {
                string = Long.toString(vRMLFieldData.longValue);
                attributesHolder.addAttribute(new QualifiedName("", "", string3), string);
                break;
            }
            case 4: {
                string = Float.toString(vRMLFieldData.floatValue);
                attributesHolder.addAttribute(new QualifiedName("", "", string3), string);
                break;
            }
            case 5: {
                string = Double.toString(vRMLFieldData.doubleValue);
                attributesHolder.addAttribute(new QualifiedName("", "", string3), string);
                break;
            }
            case 6: {
                if (vRMLFieldData.stringValue == null) break;
                attributesHolder.addAttribute(new QualifiedName("", "", string3), XMLTools.XML.escape(vRMLFieldData.stringValue));
                break;
            }
            case 8: {
                if (vRMLFieldData.booleanArrayValue == null) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string3), null, 5, (Object)vRMLFieldData.booleanArrayValue);
                break;
            }
            case 9: {
                if (vRMLFieldData.intArrayValue == null) break;
                if (vRMLFieldData.numElements != vRMLFieldData.intArrayValue.length) {
                    this.errorReporter.warningReport("Unhandled resizing in exporter, int", null);
                }
                if (this.compressionMethod == 3) {
                    string = this.createX3DString(vRMLFieldDeclaration, vRMLFieldData.intArrayValue, vRMLFieldData.numElements);
                    attributesHolder.addAttribute(new QualifiedName("", "", string3), string);
                    break;
                }
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string3), "encoder://web3d.org/DeltazlibIntArrayEncoder", 33, (Object)vRMLFieldData.intArrayValue);
                break;
            }
            case 10: {
                if (vRMLFieldData.longArrayValue == null) break;
                if (vRMLFieldData.numElements != vRMLFieldData.longArrayValue.length) {
                    this.errorReporter.warningReport("Unhandled resizing in exporter, long", null);
                }
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string3), null, 4, (Object)vRMLFieldData.longArrayValue);
                break;
            }
            case 11: {
                if (vRMLFieldData.floatArrayValue == null) break;
                this.encodeFloatArray(vRMLFieldData.floatArrayValue, vRMLFieldData.numElements, vRMLFieldDeclaration, string3, attributesHolder, 6);
                break;
            }
            case 12: {
                if (vRMLFieldData.doubleArrayValue == null) break;
                this.encodeDoubleArray(vRMLFieldData.doubleArrayValue, vRMLFieldData.numElements, vRMLFieldDeclaration, string3, attributesHolder, 6);
                break;
            }
            case 14: {
                if (vRMLFieldData.stringArrayValue == null) break;
                comparable = new StringBuffer();
                int n3 = vRMLFieldData.numElements;
                for (n = 0; n < n3; ++n) {
                    if (n == n3 - 1) {
                        ((StringBuffer)comparable).append("\"");
                        ((StringBuffer)comparable).append(XMLTools.XML.escape(vRMLFieldData.stringArrayValue[n]));
                        ((StringBuffer)comparable).append("\"");
                        continue;
                    }
                    ((StringBuffer)comparable).append("\"");
                    ((StringBuffer)comparable).append(XMLTools.XML.escape(vRMLFieldData.stringArrayValue[n]));
                    ((StringBuffer)comparable).append("\",");
                }
                attributesHolder.addAttribute(new QualifiedName("", "", string3), ((StringBuffer)comparable).toString());
            }
        }
        if (bl) {
            try {
                this.printIndent();
                this.handler.startElement("", "", "fieldValue", (Attributes)attributesHolder);
                this.handler.endElement("", "", "fieldValue");
                this.printNewLine();
                attributesHolder.clear();
            }
            catch (SAXException sAXException) {
                this.handleSAXException(sAXException);
            }
        }
    }

    private void printISList(List list) {
        if (list.size() == 0) {
            return;
        }
        try {
            Iterator iterator = list.iterator();
            this.printIndent();
            AttributesHolder attributesHolder = new AttributesHolder();
            this.handler.startElement("", "", "IS", (Attributes)attributesHolder);
            this.printNewLine();
            this.indentUp();
            while (iterator.hasNext()) {
                String[] stringArray = (String[])iterator.next();
                this.printIndent();
                attributesHolder = new AttributesHolder();
                attributesHolder.addAttribute(new QualifiedName("", "", "nodeField"), stringArray[0]);
                attributesHolder.addAttribute(new QualifiedName("", "", "protoField"), stringArray[1]);
                this.handler.startElement("", "", "connect", (Attributes)attributesHolder);
                this.handler.endElement("", "", "connect");
                this.printNewLine();
            }
            this.indentDown();
            this.printIndent();
            this.handler.endElement("", "", "IS");
            this.printNewLine();
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    private void handleSAXException(SAXException sAXException) {
        this.errorReporter.errorReport("SAXException: " + sAXException.getMessage(), sAXException);
    }

    private void printIndent() {
        if (this.stripWhitespace) {
            return;
        }
        try {
            this.handler.characters(this.indentString.toCharArray(), 0, this.indentString.length());
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }

    private void printNewLine() {
        if (this.stripWhitespace) {
            return;
        }
        try {
            this.handler.characters(newLineChar, 0, 1);
        }
        catch (SAXException sAXException) {
            this.handleSAXException(sAXException);
        }
    }
}

