/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.fastinfoset.sax.AttributesHolder;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import com.sun.xml.fastinfoset.vocab.SerializerVocabulary;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.web3d.parser.x3d.ByteEncodingAlgorithm;
import org.web3d.parser.x3d.DeltazlibIntArrayAlgorithm;
import org.web3d.parser.x3d.QuantizedzlibFloatArrayAlgorithm;
import org.web3d.parser.x3d.X3DBinaryVocabulary;
import org.web3d.parser.x3d.X3DFieldReader;
import org.web3d.util.SimpleStack;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.SceneMetaData;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.lang.WriteableSceneMetaData;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.renderer.CRProtoCreator;
import org.web3d.vrml.renderer.CRVRMLScene;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.norender.NRProtoCreator;
import org.web3d.x3d.jaxp.X3DEntityResolver;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class X3DBinarySerializer {
    public static final int METHOD_FASTEST_PARSING = 0;
    public static final int METHOD_SMALLEST_NONLOSSY = 1;
    public static final int METHOD_SMALLEST_LOSSY = 2;
    public static final int METHOD_STRINGS = 3;
    private static final float FLOAT_EPS = 9.0E-7f;
    private static float PARAM_FLOAT_LOSSY = 0.001f;
    private static final String USAGE = "Usage:  X3DSerializer [options] <input> <output>\noptions:  -method [fastest, smallest, lossy]\n          -quantizeParam n\n          -savedefaults";
    protected static final int BYTE_ALGORITHM_ID = 32;
    protected static final int DELTA_ZLIB_INT_ARRAY_ALGORITHM_ID = 33;
    protected static final int QUANTIZED_ZLIB_FLOAT_ARRAY_ALGORITHM_ID = 34;
    protected static final String EXTERNAL_VOCABULARY_URI_STRING = "urn:external-vocabulary";
    private Transformer _transformer;
    private DocumentBuilder _docBuilder;
    private Source _source = null;
    private SAXResult _result = null;
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String LOAD_DTD_ID = "http://apache.org/xml/features/nonvalidating/load-dtd-grammar";
    private VRMLNodeFactory nodeFactory;
    private HashMap nodeCache;
    private X3DFieldReader fieldParser;
    private int[] fieldTypeStats;
    private int[] fieldTypeOrigSize;
    private int[] fieldTypeNewSize;
    private HashMap fieldTypeMap;
    private boolean collectStats = true;
    private int method;
    private boolean removeDefaults;
    private int defaults;
    private Map protoMap;
    protected CRProtoCreator protoCreator;
    private int majorVersion;
    private int minorVersion;
    protected VRMLWorldRootNodeType root;
    private SimpleStack elementStack;

    public X3DBinarySerializer(int n, boolean bl, float f) {
        this.method = n;
        this.removeDefaults = bl;
        PARAM_FLOAT_LOSSY = f;
        this.elementStack = new SimpleStack();
        this.elementStack.push("WorldRoot");
        try {
            this._transformer = TransformerFactory.newInstance().newTransformer();
            this._docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.majorVersion = 3;
        this.minorVersion = 1;
        this.nodeFactory = DefaultNodeFactory.newInstance((String)"null");
        this.nodeFactory.setSpecVersion(this.majorVersion, this.minorVersion);
        this.nodeFactory.setProfile("Immersive");
        this.nodeCache = new HashMap();
        this.fieldParser = new X3DFieldReader();
        this.fieldParser.setCaseSensitive(false);
        this.fieldTypeStats = new int[43];
        this.fieldTypeOrigSize = new int[43];
        this.fieldTypeNewSize = new int[43];
        this.fieldTypeMap = new HashMap();
        this.fieldTypeMap.put(new Integer(3), "SFInt32    ");
        this.fieldTypeMap.put(new Integer(4), "MFInt32    ");
        this.fieldTypeMap.put(new Integer(5), "SFFloat    ");
        this.fieldTypeMap.put(new Integer(6), "MFFloat    ");
        this.fieldTypeMap.put(new Integer(7), "SFDouble   ");
        this.fieldTypeMap.put(new Integer(8), "MFDouble   ");
        this.fieldTypeMap.put(new Integer(31), "SFLong     ");
        this.fieldTypeMap.put(new Integer(32), "MFLong     ");
        this.fieldTypeMap.put(new Integer(1), "SFBool     ");
        this.fieldTypeMap.put(new Integer(2), "MFBool     ");
        this.fieldTypeMap.put(new Integer(13), "SFVec2f    ");
        this.fieldTypeMap.put(new Integer(14), "MFVec2f    ");
        this.fieldTypeMap.put(new Integer(29), "SFVec2d    ");
        this.fieldTypeMap.put(new Integer(30), "MFVec2d    ");
        this.fieldTypeMap.put(new Integer(15), "SFVec3f    ");
        this.fieldTypeMap.put(new Integer(16), "MFVec3f    ");
        this.fieldTypeMap.put(new Integer(17), "SFVec3d    ");
        this.fieldTypeMap.put(new Integer(18), "MFVec3d    ");
        this.fieldTypeMap.put(new Integer(33), "SFVec4f    ");
        this.fieldTypeMap.put(new Integer(34), "MFVec4f    ");
        this.fieldTypeMap.put(new Integer(35), "SFVec4d    ");
        this.fieldTypeMap.put(new Integer(36), "MFVec4d    ");
        this.fieldTypeMap.put(new Integer(25), "SFImage    ");
        this.fieldTypeMap.put(new Integer(26), "MFImage    ");
        this.fieldTypeMap.put(new Integer(9), "SFTime     ");
        this.fieldTypeMap.put(new Integer(10), "MFTime     ");
        this.fieldTypeMap.put(new Integer(11), "SFNode     ");
        this.fieldTypeMap.put(new Integer(12), "MFNode     ");
        this.fieldTypeMap.put(new Integer(27), "SFString   ");
        this.fieldTypeMap.put(new Integer(28), "MFString   ");
        this.fieldTypeMap.put(new Integer(19), "SFRotation ");
        this.fieldTypeMap.put(new Integer(20), "MFRotation ");
        this.fieldTypeMap.put(new Integer(21), "SFColor    ");
        this.fieldTypeMap.put(new Integer(22), "MFColor    ");
        this.fieldTypeMap.put(new Integer(23), "SFColorRGBA");
        this.fieldTypeMap.put(new Integer(24), "MFColorRGBA");
        this.fieldTypeMap.put(new Integer(37), "SFMatrix3f ");
        this.fieldTypeMap.put(new Integer(38), "MFMatrix3f ");
        this.fieldTypeMap.put(new Integer(41), "SFMatrix3d ");
        this.fieldTypeMap.put(new Integer(42), "MFMatrix3d ");
        this.fieldTypeMap.put(new Integer(39), "SFMatrix4f ");
        this.fieldTypeMap.put(new Integer(40), "MFMatrix4f ");
        this.fieldTypeMap.put(new Integer(43), "SFMatrix4d ");
        this.fieldTypeMap.put(new Integer(44), "MFMatrix4d ");
        this.protoMap = new HashMap();
    }

    public void setProtoMap(Map map) {
        this.protoMap = map;
        this.protoCreator = new NRProtoCreator(this.nodeFactory, "", this.majorVersion, this.minorVersion);
        this.root = (VRMLWorldRootNodeType)this.nodeFactory.createVRMLNode("WorldRoot", false);
        CRVRMLScene cRVRMLScene = new CRVRMLScene(this.majorVersion, this.minorVersion);
        cRVRMLScene.setNodeFactory(this.nodeFactory);
        WriteableSceneMetaData writeableSceneMetaData = new WriteableSceneMetaData("3.0", true, 4);
        cRVRMLScene.setMetaData((SceneMetaData)writeableSceneMetaData);
        this.root.setContainedScene((BasicScene)cRVRMLScene);
    }

    public void writeFiltered(InputStream inputStream, OutputStream outputStream) {
        try {
            OutputStream outputStream2 = outputStream;
            SAXDocumentSerializer sAXDocumentSerializer = new SAXDocumentSerializer();
            sAXDocumentSerializer.setAttributeValueSizeLimit(32);
            sAXDocumentSerializer.setOutputStream(outputStream2);
            SerializerVocabulary serializerVocabulary = new SerializerVocabulary();
            serializerVocabulary.setExternalVocabulary(EXTERNAL_VOCABULARY_URI_STRING, X3DBinaryVocabulary.serializerVoc, false);
            sAXDocumentSerializer.setVocabulary(serializerVocabulary);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("http://www.web3d.org/binary/BYTE", new ByteEncodingAlgorithm());
            hashMap.put("encoder://web3d.org/DeltazlibIntArrayEncoder", new DeltazlibIntArrayAlgorithm());
            if (this.method == 2) {
                hashMap.put("encoder://web3d.org/QuantizedzlibFloatArrayEncoder", new QuantizedzlibFloatArrayAlgorithm(PARAM_FLOAT_LOSSY));
            } else {
                hashMap.put("encoder://web3d.org/QuantizedzlibFloatArrayEncoder", new QuantizedzlibFloatArrayAlgorithm());
            }
            sAXDocumentSerializer.setRegisteredEncodingAlgorithms(hashMap);
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setFeature(VALIDATION_FEATURE_ID, false);
            X3DEntityResolver x3DEntityResolver = new X3DEntityResolver();
            xMLReader.setEntityResolver((EntityResolver)x3DEntityResolver);
            X3DFilter x3DFilter = new X3DFilter((ContentHandler)sAXDocumentSerializer);
            xMLReader.setContentHandler(x3DFilter);
            InputSource inputSource = new InputSource(inputStream);
            xMLReader.parse(inputSource);
            outputStream2.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void encodeField(int n, String string, String string2, String string3, AttributesHolder attributesHolder, VRMLFieldData vRMLFieldData) {
        int n2 = n;
        this.fieldTypeStats[n2] = this.fieldTypeStats[n2] + 1;
        int n3 = n;
        this.fieldTypeOrigSize[n3] = this.fieldTypeOrigSize[n3] + string3.length();
        block0 : switch (n) {
            case 3: {
                int n4;
                if (this.removeDefaults && vRMLFieldData != null && (n4 = this.fieldParser.SFInt32(string3)) == vRMLFieldData.intValue) {
                    ++this.defaults;
                    break;
                }
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 9: {
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 31: {
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 7: {
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 1: {
                boolean bl;
                if (this.removeDefaults && vRMLFieldData != null && (bl = this.fieldParser.SFBool(string3)) == vRMLFieldData.booleanValue) {
                    ++this.defaults;
                    break;
                }
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 5: {
                float f;
                if (this.removeDefaults && vRMLFieldData != null && Math.abs((f = this.fieldParser.SFFloat(string3)) - vRMLFieldData.floatValue) <= 9.0E-7f) {
                    ++this.defaults;
                    break;
                }
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 27: {
                if (this.removeDefaults && vRMLFieldData != null && string3.equals(vRMLFieldData.stringValue)) {
                    ++this.defaults;
                    break;
                }
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 28: {
                attributesHolder.addAttribute(new QualifiedName("", "", string, string2), string3);
                break;
            }
            case 19: {
                float[] fArray = this.fieldParser.SFRotation(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                if (fArray == null || fArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                if (!this.collectStats) break;
                int n5 = BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.getOctetLengthFromPrimitiveLength(fArray.length);
                this.fieldTypeNewSize[19] = this.fieldTypeNewSize[19] + n5;
                break;
            }
            case 20: {
                float[] fArray = this.fieldParser.MFRotation(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 23: {
                float[] fArray = this.fieldParser.SFColorRGBA(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                if (fArray == null || fArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                break;
            }
            case 24: {
                float[] fArray = this.fieldParser.MFColorRGBA(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 21: {
                float[] fArray = this.fieldParser.SFColor(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                if (fArray == null || fArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                break;
            }
            case 22: {
                float[] fArray = this.fieldParser.MFColor(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 29: {
                double[] dArray = this.fieldParser.SFVec2d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 30: {
                double[] dArray = this.fieldParser.MFVec2d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 17: {
                double[] dArray = this.fieldParser.SFVec3d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 18: {
                double[] dArray = this.fieldParser.MFVec3d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 13: {
                float[] fArray = this.fieldParser.SFVec2f(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                if (fArray == null || fArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                break;
            }
            case 14: {
                float[] fArray = this.fieldParser.MFVec2f(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 15: {
                float[] fArray = this.fieldParser.SFVec3f(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                if (fArray == null || fArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                if (!this.collectStats) break;
                int n6 = BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.getOctetLengthFromPrimitiveLength(fArray.length);
                this.fieldTypeNewSize[15] = this.fieldTypeNewSize[15] + n6;
                break;
            }
            case 16: {
                float[] fArray = this.fieldParser.MFVec3f(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 33: {
                float[] fArray = this.fieldParser.SFVec4f(string3);
                if (fArray == null || fArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                break;
            }
            case 34: {
                float[] fArray = this.fieldParser.MFVec4f(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 6: {
                float[] fArray = this.fieldParser.MFFloat(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, 6);
                break;
            }
            case 8: {
                double[] dArray = this.fieldParser.MFDouble(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 37: {
                float[] fArray = this.fieldParser.SFMatrix3f(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                if (fArray == null || fArray.length == 0) break;
                switch (this.method) {
                    case 2: {
                        attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), "encoder://web3d.org/QuantizedzlibFloatArrayEncoder", 34, (Object)fArray);
                        break block0;
                    }
                }
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 6, (Object)fArray);
                break;
            }
            case 38: {
                float[] fArray = this.fieldParser.MFMatrix3f(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 39: {
                float[] fArray = this.fieldParser.SFMatrix4f(string3);
                if (this.removeDefaults && vRMLFieldData != null && fArray.length == vRMLFieldData.floatArrayValue.length) {
                    boolean bl = true;
                    for (int i = 0; i < fArray.length; ++i) {
                        if (!(Math.abs(fArray[i] - vRMLFieldData.floatArrayValue[i]) > 9.0E-7f)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        ++this.defaults;
                        break;
                    }
                }
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 40: {
                float[] fArray = this.fieldParser.MFMatrix4f(string3);
                this.encodeFloatArray(string3, fArray, string, string2, attributesHolder, n);
                break;
            }
            case 41: {
                double[] dArray = this.fieldParser.SFMatrix3d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 10: {
                double[] dArray = this.fieldParser.MFTime(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 42: {
                double[] dArray = this.fieldParser.MFMatrix3d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 43: {
                double[] dArray = this.fieldParser.SFMatrix4d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 44: {
                double[] dArray = this.fieldParser.MFMatrix4d(string3);
                if (dArray == null || dArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 7, (Object)dArray);
                break;
            }
            case 25: {
                int[] nArray = this.fieldParser.SFImage(string3);
                if (nArray == null || nArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 3, (Object)nArray);
                break;
            }
            case 26: {
                int[] nArray = this.fieldParser.MFImage(string3);
                if (nArray == null || nArray.length == 0) break;
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), null, 3, (Object)nArray);
                break;
            }
            case 4: {
                int[] nArray = this.fieldParser.MFInt32(string3);
                attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string, string2), "encoder://web3d.org/DeltazlibIntArrayEncoder", 33, (Object)nArray);
                break;
            }
            default: {
                System.out.println("Unhandled field: " + string);
            }
        }
    }

    private void encodeFloatArray(String string, float[] fArray, String string2, String string3, AttributesHolder attributesHolder, int n) {
        if (fArray != null && fArray.length != 0) {
            switch (this.method) {
                case 2: {
                    attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string2, string3), "encoder://web3d.org/QuantizedzlibFloatArrayEncoder", 34, (Object)fArray);
                    break;
                }
                case 1: {
                    attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string2, string3), "encoder://web3d.org/QuantizedzlibFloatArrayEncoder", 34, (Object)fArray);
                    break;
                }
                default: {
                    int n2 = BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.getOctetLengthFromPrimitiveLength(fArray.length);
                    if (n2 <= string.length()) {
                        attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string2, string3), null, 6, (Object)fArray);
                        if (!this.collectStats) break;
                        int n3 = n;
                        this.fieldTypeNewSize[n3] = this.fieldTypeNewSize[n3] + n2;
                        break;
                    }
                    attributesHolder.addAttribute(new QualifiedName("", "", string2, string3), string);
                    if (!this.collectStats) break;
                    int n4 = n;
                    this.fieldTypeNewSize[n4] = this.fieldTypeNewSize[n4] + string.length();
                }
            }
        }
    }

    public class X3DFilter
    implements ContentHandler {
        private ContentHandler parent;
        int chars = 0;

        public X3DFilter(ContentHandler contentHandler) {
            this.parent = contentHandler;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            int n = attributes.getLength();
            if (attributes.getLength() > 0) {
                if (string2.equals("fieldValue")) {
                    AttributesHolder attributesHolder = new AttributesHolder();
                    String string4 = attributes.getValue("name");
                    attributesHolder.addAttribute(new QualifiedName("", "", "name", "name"), string4);
                    VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)X3DBinarySerializer.this.protoMap.get((String)X3DBinarySerializer.this.elementStack.peek() + "." + string4);
                    if (vRMLFieldDeclaration != null) {
                        X3DBinarySerializer.this.encodeField(vRMLFieldDeclaration.getFieldType(), "value", "value", attributes.getValue("value"), attributesHolder, null);
                    } else {
                        attributesHolder.addAttribute(new QualifiedName("", "", "value", "value"), attributes.getValue("value"));
                    }
                    this.parent.startElement(string, string2, string3, (Attributes)attributesHolder);
                    X3DBinarySerializer.this.elementStack.push("fieldValue");
                    return;
                }
                try {
                    VRMLNodeType vRMLNodeType = (VRMLNodeType)X3DBinarySerializer.this.nodeCache.get(string2);
                    if (string2.equals("ProtoInstance")) {
                        this.parent.startElement(string, string2, string3, attributes);
                        X3DBinarySerializer.this.elementStack.push(attributes.getValue("name"));
                        return;
                    }
                    if (vRMLNodeType == null) {
                        vRMLNodeType = (VRMLNodeType)X3DBinarySerializer.this.nodeFactory.createVRMLNode(string2, false);
                        X3DBinarySerializer.this.nodeCache.put(string2, vRMLNodeType);
                    }
                    AttributesHolder attributesHolder = new AttributesHolder();
                    VRMLFieldDeclaration vRMLFieldDeclaration = null;
                    boolean bl = string2.equals("MetadataInteger");
                    for (int i = 0; i < n; ++i) {
                        Object object;
                        String string5 = attributes.getLocalName(i);
                        int n2 = vRMLNodeType.getFieldIndex(string5);
                        if (bl && string5.equals("value") && attributes.getValue("name").equals("payload")) {
                            vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "MFInt32", "value");
                            n2 = 0;
                            object = X3DBinarySerializer.this.fieldParser.MFInt32(attributes.getValue(i));
                            attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", attributes.getLocalName(i), attributes.getQName(i)), null, 3, object);
                            continue;
                        }
                        if (n2 > -1) {
                            vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n2);
                        } else if (string5.equals("encoder")) {
                            vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "SFInt32", "encoder");
                            n2 = 0;
                        } else if (string5.equals("data")) {
                            vRMLFieldDeclaration = new VRMLFieldDeclaration(2, "MFInt32", "data");
                            n2 = 0;
                            object = X3DBinarySerializer.this.fieldParser.MFInt32(attributes.getValue(i));
                            attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", attributes.getLocalName(i), attributes.getQName(i)), null, 3, object);
                            continue;
                        }
                        object = null;
                        if (n2 != -1) {
                            int n3 = vRMLFieldDeclaration.getAccessType();
                            if (n3 == 1 || n3 == 4) continue;
                            object = vRMLNodeType.getFieldValue(n2);
                        }
                        if (n2 > -1 && X3DBinarySerializer.this.method != 3) {
                            X3DBinarySerializer.this.encodeField(vRMLFieldDeclaration.getFieldType(), attributes.getLocalName(i), attributes.getQName(i), attributes.getValue(i), attributesHolder, (VRMLFieldData)object);
                            continue;
                        }
                        attributesHolder.addAttribute(new QualifiedName("", "", attributes.getLocalName(i), attributes.getQName(i)), attributes.getValue(i));
                    }
                    this.parent.startElement(string, string2, string3, (Attributes)attributesHolder);
                }
                catch (UnsupportedNodeException unsupportedNodeException) {
                    this.parent.startElement(string, string2, string3, attributes);
                }
                catch (Exception exception) {
                    System.out.println("***Unhandled element: " + string2);
                    exception.printStackTrace();
                }
            } else {
                this.parent.startElement(string, string2, string3, attributes);
            }
            X3DBinarySerializer.this.elementStack.push(string2);
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.parent.endElement(string, string2, string3);
            X3DBinarySerializer.this.elementStack.pop();
        }

        public void startDocument() throws SAXException {
            this.parent.startDocument();
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.parent.startPrefixMapping(string, string2);
        }

        public void endPrefixMapping(String string) throws SAXException {
            this.parent.endPrefixMapping(string);
        }

        public void setDocumentLocator(Locator locator) {
            this.parent.setDocumentLocator(locator);
        }

        public void endDocument() throws SAXException {
            this.parent.endDocument();
            if (X3DBinarySerializer.this.removeDefaults) {
                System.out.println(X3DBinarySerializer.this.defaults + " default fields removed");
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.chars += n2;
            this.parent.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.parent.ignorableWhitespace(cArray, n, n2);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
            this.parent.processingInstruction(string, string2);
        }

        public void skippedEntity(String string) throws SAXException {
            this.parent.skippedEntity(string);
        }
    }
}

