/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.export;

import com.sun.xml.fastinfoset.QualifiedName;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithmFactory;
import com.sun.xml.fastinfoset.sax.AttributesHolder;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import com.sun.xml.fastinfoset.vocab.SerializerVocabulary;
import java.io.OutputStream;
import java.util.HashMap;
import org.web3d.parser.x3d.ByteEncodingAlgorithm;
import org.web3d.parser.x3d.DeltazlibIntArrayAlgorithm;
import org.web3d.parser.x3d.QuantizedzlibFloatArrayAlgorithm;
import org.web3d.parser.x3d.X3DBinaryVocabulary;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.export.X3DRetainedSAXExporter;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.SceneGraphTraversalSimpleObserver;

public class X3DBinaryRetainedDirectExporter
extends X3DRetainedSAXExporter
implements SceneGraphTraversalSimpleObserver {
    private static final float FLOAT_EPS = 9.0E-7f;
    private static float PARAM_FLOAT_LOSSY = 0.001f;
    protected static final int BYTE_ALGORITHM_ID = 32;
    protected static final int DELTA_ZLIB_INT_ARRAY_ALGORITHM_ID = 33;
    protected static final int QUANTIZED_ZLIB_FLOAT_ARRAY_ALGORITHM_ID = 34;
    protected static final String EXTERNAL_VOCABULARY_URI_STRING = "urn:external-vocabulary";
    private OutputStream os;

    public X3DBinaryRetainedDirectExporter(OutputStream outputStream, int n, int n2, ErrorReporter errorReporter, int n3, float f) {
        super(n, n2, errorReporter, n3, f);
        this.os = outputStream;
        this.binary = true;
        this.encodingTo = ".x3db";
        this.printDocType = false;
        this.stripWhitespace = false;
        SAXDocumentSerializer sAXDocumentSerializer = new SAXDocumentSerializer();
        sAXDocumentSerializer.setAttributeValueSizeLimit(32);
        sAXDocumentSerializer.setOutputStream(outputStream);
        SerializerVocabulary serializerVocabulary = new SerializerVocabulary();
        serializerVocabulary.setExternalVocabulary(EXTERNAL_VOCABULARY_URI_STRING, X3DBinaryVocabulary.serializerVoc, false);
        sAXDocumentSerializer.setVocabulary(serializerVocabulary);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("http://www.web3d.org/binary/BYTE", new ByteEncodingAlgorithm());
        hashMap.put("encoder://web3d.org/DeltazlibIntArrayEncoder", new DeltazlibIntArrayAlgorithm());
        if (n3 == 2) {
            hashMap.put("encoder://web3d.org/QuantizedzlibFloatArrayEncoder", new QuantizedzlibFloatArrayAlgorithm(PARAM_FLOAT_LOSSY));
        } else {
            hashMap.put("encoder://web3d.org/QuantizedzlibFloatArrayEncoder", new QuantizedzlibFloatArrayAlgorithm());
        }
        sAXDocumentSerializer.setRegisteredEncodingAlgorithms(hashMap);
        this.handler = sAXDocumentSerializer;
    }

    protected void encodeDoubleArray(double[] dArray, int n, VRMLFieldDeclaration vRMLFieldDeclaration, String string, AttributesHolder attributesHolder, int n2) {
        if (dArray != null && dArray.length != 0) {
            switch (this.compressionMethod) {
                case 3: {
                    String string2 = this.createX3DString(vRMLFieldDeclaration, dArray, n);
                    attributesHolder.addAttribute(new QualifiedName("", "", string), string2);
                    break;
                }
                default: {
                    int n3 = BuiltInEncodingAlgorithmFactory.doubleEncodingAlgorithm.getOctetLengthFromPrimitiveLength(dArray.length);
                    String string3 = this.createX3DString(vRMLFieldDeclaration, dArray, n);
                    if (n3 <= string3.length()) {
                        attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string), null, 7, (Object)dArray);
                        break;
                    }
                    attributesHolder.addAttribute(new QualifiedName("", "", string), string3);
                }
            }
        }
    }

    protected void encodeFloatArray(float[] fArray, int n, VRMLFieldDeclaration vRMLFieldDeclaration, String string, AttributesHolder attributesHolder, int n2) {
        if (fArray != null && fArray.length != 0) {
            switch (this.compressionMethod) {
                case 2: {
                    attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string), "encoder://web3d.org/QuantizedzlibFloatArrayEncoder", 34, (Object)fArray);
                    break;
                }
                case 1: {
                    attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string), "encoder://web3d.org/QuantizedzlibFloatArrayEncoder", 34, (Object)fArray);
                    break;
                }
                case 3: {
                    String string2 = this.createX3DString(vRMLFieldDeclaration, fArray, n);
                    attributesHolder.addAttribute(new QualifiedName("", "", string), string2);
                    break;
                }
                default: {
                    int n3 = BuiltInEncodingAlgorithmFactory.floatEncodingAlgorithm.getOctetLengthFromPrimitiveLength(fArray.length);
                    String string3 = this.createX3DString(vRMLFieldDeclaration, fArray, n);
                    if (n3 <= string3.length()) {
                        attributesHolder.addAttributeWithAlgorithmData(new QualifiedName("", "", string), null, 6, (Object)fArray);
                        break;
                    }
                    attributesHolder.addAttribute(new QualifiedName("", "", string), string3);
                }
            }
        }
    }
}

