/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.content.image;

public class ImageDecoder {
    private static final int MAX_THREADS = 2000;
    private static boolean[] threadInUse;
    private static Object mutex;

    public int acquireThreadId() {
        int n;
        block5: {
            n = -1;
            Object object = mutex;
            synchronized (object) {
                while (true) {
                    for (int i = 0; i < 2000; ++i) {
                        if (threadInUse[i]) continue;
                        ImageDecoder.threadInUse[i] = true;
                        n = i;
                        break block5;
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
        return n;
    }

    public void releaseThreadId(int n) {
        if (n < 0 || n >= 2000) {
            throw new IllegalArgumentException("Invalid thread ID");
        }
        if (!threadInUse[n]) {
            throw new IllegalArgumentException("ID was not in use");
        }
    }

    private static native void initialize(int var0) throws InternalError;

    public static native String[] getFileFormats();

    native void initDecoder(int var1, String var2, boolean var3) throws InternalError;

    native void sendData(int var1, byte[] var2, int var3);

    native void startDecoding(int var1) throws InternalError;

    native int getImageWidth(int var1) throws InternalError;

    native int getImageHeight(int var1) throws InternalError;

    native int getNumColorComponents(int var1) throws InternalError;

    native void getNextImageRow(int var1, int[] var2) throws InternalError;

    native void finishDecoding(int var1);

    static {
        mutex = new Object();
        System.loadLibrary("image_decode");
        threadInUse = new boolean[2000];
        try {
            for (int i = 0; i < 2000; ++i) {
                ImageDecoder.threadInUse[i] = false;
            }
            ImageDecoder.initialize(2000);
        }
        catch (InternalError internalError) {
            System.err.println("Error initialising library: " + internalError.getMessage());
        }
    }
}

