/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.content.image;

import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import vlc.image.ByteBufferImage;
import vlc.net.content.image.BufferFiller;
import vlc.net.content.image.ImageBuffer;
import vlc.net.content.image.ImageDecoder;

public class ImageBuilder {
    public static final int IMAGE_REQD = 1;
    public static final int IMAGEPRODUCER_REQD = 2;
    public static final int RASTER_REQD = 3;
    public static final int WRITABLE_RASTER_REQD = 4;
    public static final int BYTEBUFFERIMAGE_REQD = 5;
    private static final boolean jdk1_1;
    private static final boolean hasNativeThreads;
    private static final String[] validTypes;
    private String imageType;
    private Object finishLock;
    private ThreadGroup threadGroup;
    private int threadCount;

    public ImageBuilder(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No image type given");
        }
        this.finishLock = new Object();
        this.threadGroup = new ThreadGroup("VLC Image Loading");
        this.imageType = string;
        this.threadCount = 0;
        boolean bl = false;
        for (int i = 0; i < validTypes.length; ++i) {
            if (!string.equalsIgnoreCase(validTypes[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("Unsupported image type " + string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(InputStream inputStream, int n) throws IOException {
        int n2;
        int[] nArray;
        int n3;
        int n4;
        int n5;
        Object object;
        ByteBuffer byteBuffer;
        ImageBuffer imageBuffer;
        block52: {
            ImageDecoder imageDecoder = new ImageDecoder();
            int n6 = imageDecoder.acquireThreadId();
            imageBuffer = null;
            BufferFiller bufferFiller = null;
            byteBuffer = null;
            try {
                int n7;
                imageDecoder.initDecoder(n6, this.imageType, !hasNativeThreads);
                bufferFiller = new BufferFiller(n6, inputStream, imageDecoder, this.finishLock);
                if (hasNativeThreads) {
                    object = new Thread(this.threadGroup, bufferFiller, "Imageloader filler thread " + this.threadCount++);
                    ((Thread)object).start();
                } else {
                    bufferFiller.run();
                }
                imageDecoder.startDecoding(n6);
                n5 = imageDecoder.getImageWidth(n6);
                n4 = imageDecoder.getImageHeight(n6);
                n3 = imageDecoder.getNumColorComponents(n6);
                if (jdk1_1 || n == 2) {
                    imageBuffer = new ImageBuffer(n5, n4, n3);
                }
                nArray = this.createIntArray(n5 * n4);
                object = new int[n5];
                if (jdk1_1 || n == 2) {
                    for (n7 = 0; n7 < n4; ++n7) {
                        imageDecoder.getNextImageRow(n6, (int[])object);
                        imageBuffer.setImageRow(n7, (int[])object);
                    }
                    break block52;
                }
                if (n == 5) {
                    byteBuffer = ByteBuffer.allocateDirect(n5 * n4 * n3);
                    byteBuffer.order(ByteOrder.nativeOrder());
                    switch (n3) {
                        case 4: {
                            Object object2;
                            int n8;
                            int n9;
                            int n10 = n4 - 1;
                            for (n9 = 0; n9 < n4; ++n9) {
                                imageDecoder.getNextImageRow(n6, (int[])object);
                                n8 = n10 * n5 * n3;
                                for (n2 = 0; n2 < n5; ++n2) {
                                    object2 = object[n2];
                                    byteBuffer.put(n8++, (byte)(object2 >> 16));
                                    byteBuffer.put(n8++, (byte)(object2 >> 8));
                                    byteBuffer.put(n8++, (byte)object2);
                                    byteBuffer.put(n8++, (byte)(object2 >> 24));
                                }
                                --n10;
                            }
                            break block52;
                        }
                        case 3: {
                            Object object2;
                            int n8;
                            int n9;
                            int n10 = n4 - 1;
                            for (n9 = 0; n9 < n4; ++n9) {
                                imageDecoder.getNextImageRow(n6, (int[])object);
                                n8 = n10 * n5 * n3;
                                for (n2 = 0; n2 < n5; ++n2) {
                                    object2 = object[n2];
                                    byteBuffer.put(n8++, (byte)(object2 >> 16));
                                    byteBuffer.put(n8++, (byte)(object2 >> 8));
                                    byteBuffer.put(n8++, (byte)object2);
                                }
                                --n10;
                            }
                            break block52;
                        }
                        case 2: {
                            Object object2;
                            int n8;
                            int n9;
                            int n10 = n4 - 1;
                            for (n9 = 0; n9 < n4; ++n9) {
                                imageDecoder.getNextImageRow(n6, (int[])object);
                                n8 = n10 * n5 * n3;
                                for (n2 = 0; n2 < n5; ++n2) {
                                    object2 = object[n2];
                                    byteBuffer.put(n8++, (byte)object2);
                                    byteBuffer.put(n8++, (byte)(object2 >> 8));
                                }
                                --n10;
                            }
                            break block52;
                        }
                        case 1: {
                            Object object2;
                            int n8;
                            int n9;
                            int n10 = n4 - 1;
                            for (n9 = 0; n9 < n4; ++n9) {
                                imageDecoder.getNextImageRow(n6, (int[])object);
                                n8 = n10 * n5;
                                for (n2 = 0; n2 < n5; ++n2) {
                                    object2 = object[n2];
                                    byteBuffer.put(n8++, (byte)object2);
                                }
                                --n10;
                            }
                            break;
                        }
                    }
                    break block52;
                }
                for (n7 = 0; n7 < n4; ++n7) {
                    imageDecoder.getNextImageRow(n6, (int[])object);
                    System.arraycopy(object, 0, nArray, n7 * n5, n5);
                }
            }
            catch (InternalError internalError) {
                bufferFiller.die();
                internalError.printStackTrace();
                throw new IOException(internalError.getMessage() + " on thread: " + n6);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                bufferFiller.die();
                outOfMemoryError.printStackTrace();
                throw new IOException("Not enough memory");
            }
            finally {
                bufferFiller.die();
                while (bufferFiller.stillSending()) {
                    Object object3 = this.finishLock;
                    synchronized (object3) {
                        try {
                            this.finishLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    }
                }
                imageDecoder.finishDecoding(n6);
                imageDecoder.releaseThreadId(n6);
            }
        }
        object = null;
        if (n == 2) {
            object = imageBuffer;
        } else if (jdk1_1) {
            object = Toolkit.getDefaultToolkit().createImage(imageBuffer);
        } else if (n == 5) {
            object = new ByteBufferImage(n5, n4, n3, byteBuffer);
        } else {
            DataBuffer dataBuffer;
            ColorModel colorModel = this.getColorModel(n3);
            SampleModel sampleModel = colorModel.createCompatibleSampleModel(n5, n4);
            if (n3 == 1) {
                n2 = nArray.length;
                byte[] byArray = new byte[n2];
                for (int i = 0; i < n2; ++i) {
                    byArray[i] = (byte)(nArray[i] & 0xFF);
                }
                dataBuffer = new DataBufferByte(byArray, n5 * n4);
            } else {
                dataBuffer = new DataBufferInt(nArray, n5 * n4);
            }
            switch (n) {
                case 1: {
                    WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, dataBuffer, null);
                    object = new BufferedImage(colorModel, writableRaster, false, null);
                    break;
                }
                case 3: {
                    object = Raster.createRaster(sampleModel, dataBuffer, null);
                    break;
                }
                case 4: {
                    object = Raster.createWritableRaster(sampleModel, dataBuffer, null);
                }
            }
        }
        return object;
    }

    private int[] createIntArray(int n) {
        Runtime runtime = null;
        for (int i = 0; i < 10; ++i) {
            try {
                return new int[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                long l;
                if (runtime == null) {
                    runtime = Runtime.getRuntime();
                }
                runtime.runFinalization();
                long l2 = runtime.freeMemory();
                int n2 = 0;
                do {
                    l = l2;
                    runtime.gc();
                } while ((l2 = runtime.freeMemory()) > l && ++n2 <= 20);
                continue;
            }
        }
        return new int[n];
    }

    private ColorModel getColorModel(int n) {
        ColorModel colorModel = null;
        switch (n) {
            case 1: {
                ColorSpace colorSpace = ColorSpace.getInstance(1003);
                int n2 = 0;
                int[] nArray = new int[]{8};
                colorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, n2);
                break;
            }
            case 2: {
                colorModel = new DirectColorModel(ColorSpace.getInstance(1000), 16, 255, 255, 255, 65280, false, 3);
                break;
            }
            case 3: {
                colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
                break;
            }
            case 4: {
                colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            }
        }
        return colorModel;
    }

    static {
        validTypes = ImageDecoder.getFileFormats();
        String string = System.getProperty("java.vm.info", "");
        String string2 = System.getProperty("java.version");
        jdk1_1 = string2.startsWith("1.1");
        hasNativeThreads = string.indexOf("green") == -1;
    }
}

