/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.content.image;

import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;

class ImageBuffer
implements ImageProducer {
    private static final int MEM_LIMIT = 3000000;
    private static final int MAX_CONSUMERS = 20;
    private ColorModel colorModel;
    private ImageConsumer[] consumers;
    private int count;
    private int[][] data;
    private int[] rowsForChunk;
    private int width = 0;
    private int height = 0;
    private ColorModel model = null;

    ImageBuffer(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                this.colorModel = new DirectColorModel(8, 0, 0, 255, 0);
                break;
            }
            case 2: {
                this.colorModel = new DirectColorModel(16, 0, 65280, 255, 0);
                break;
            }
            case 3: {
                this.colorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
                break;
            }
            case 4: {
                this.colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            }
        }
        this.width = n;
        this.height = n2;
        this.consumers = new ImageConsumer[20];
        this.count = 0;
        this.allocateBuffer();
    }

    void setImageRow(int n, int[] nArray) {
        if (n < 0 || n > this.height) {
            throw new IllegalArgumentException("ImageBuffer.setImageRow(): invalid row: " + n);
        }
        if (nArray.length < this.width) {
            throw new IllegalArgumentException("ImageBuffer.setImageRow(): not enough data");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        do {
            if (n >= (n4 = n5) && n < (n5 += this.rowsForChunk[n2])) {
                bl = true;
                n3 = (n - n4) * this.width;
                continue;
            }
            ++n2;
        } while (!bl);
        System.arraycopy(nArray, 0, this.data[n2], n3, this.width);
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        if (this.isConsumer(imageConsumer)) {
            return;
        }
        if (this.count >= this.consumers.length - 1) {
            ImageConsumer[] imageConsumerArray = new ImageConsumer[this.count + 20];
            for (int i = 0; i < this.count; ++i) {
                imageConsumerArray[i] = this.consumers[i];
            }
            this.consumers = imageConsumerArray;
        }
        this.consumers[this.count++] = imageConsumer;
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        for (int i = 0; i < this.count; ++i) {
            if (this.consumers[i] != imageConsumer) continue;
            return true;
        }
        return false;
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        int n = 0;
        for (n = 0; n < this.count; ++n) {
            if (this.consumers[n] != imageConsumer) continue;
            this.consumers[n] = null;
            break;
        }
        for (int i = n; i < this.count - 1; ++i) {
            this.consumers[n] = this.consumers[n + 1];
        }
        --this.count;
    }

    public void startProduction(ImageConsumer imageConsumer) {
        int n;
        this.addConsumer(imageConsumer);
        for (n = 0; n < this.count; ++n) {
            this.consumers[n].setDimensions(this.width, this.height);
        }
        for (n = 0; n < this.count; ++n) {
            this.consumers[n].setColorModel(this.colorModel);
        }
        for (n = 0; n < this.count; ++n) {
            this.consumers[n].setHints(16);
        }
        int n2 = 0;
        int n3 = this.rowsForChunk.length;
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < this.count; ++i) {
                this.consumers[i].setPixels(0, n2, this.width, this.rowsForChunk[n], this.colorModel, this.data[n], 0, this.width);
            }
            n2 += this.rowsForChunk[n];
        }
        for (n = 0; n < this.count; ++n) {
            this.consumers[n].imageComplete(2);
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.width, this.height);
        imageConsumer.setColorModel(this.colorModel);
        imageConsumer.setHints(2);
        int n = 0;
        int n2 = this.rowsForChunk.length;
        for (int i = 0; i < n2; ++i) {
            imageConsumer.setPixels(0, n, this.width, this.rowsForChunk[i], this.colorModel, this.data[i], 0, this.width);
            n += this.rowsForChunk[i];
        }
        imageConsumer.imageComplete(2);
    }

    private void allocateBuffer() {
        int n;
        int[][] nArrayArray = new int[100][];
        int n2 = 100;
        int n3 = this.height;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = null;
        do {
            boolean bl;
            n = this.width * n3;
            int n6 = 3000000;
            do {
                bl = false;
                try {
                    if (n > n6) {
                        n5 = n6 / this.width;
                        nArray = new int[n5 * this.width];
                        continue;
                    }
                    n5 = n3;
                    nArray = new int[n];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    bl = true;
                    n6 = n6 * 2 / 3;
                }
            } while (bl);
            nArrayArray[n4++] = nArray;
            n3 -= n5;
            if (n4 < n2) continue;
            int[][] nArrayArray2 = new int[n2 += 100][];
            for (int i = 0; i < n4; ++i) {
                nArrayArray2[i] = nArrayArray[i];
            }
            nArrayArray = nArrayArray2;
        } while (n3 > 0);
        this.data = new int[n4][];
        for (n = 0; n < n4; ++n) {
            this.data[n] = nArrayArray[n];
        }
        this.rowsForChunk = new int[n4];
        for (n = 0; n < n4; ++n) {
            this.rowsForChunk[n] = this.data[n].length / this.width;
        }
    }
}

