/*
 * Decompiled with CFR 0.152.
 */
package vlc.net.content;

import java.net.ContentHandler;
import java.net.ContentHandlerFactory;
import vlc.net.content.image.bmp;
import vlc.net.content.image.gif;
import vlc.net.content.image.jpeg;
import vlc.net.content.image.png;
import vlc.net.content.image.targa;
import vlc.net.content.image.tiff;
import vlc.net.content.image.x_portable_graymap;
import vlc.net.content.image.x_portable_pixmap;

public class ImageContentHandlerFactory
implements ContentHandlerFactory {
    private ContentHandlerFactory prevFactory;

    public ImageContentHandlerFactory() {
        this.prevFactory = null;
    }

    public ImageContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        this.prevFactory = contentHandlerFactory;
    }

    public ContentHandler createContentHandler(String string) {
        ContentHandler contentHandler = null;
        if (string.equalsIgnoreCase("image/png")) {
            contentHandler = new png();
        } else if (string.equalsIgnoreCase("image/bmp")) {
            contentHandler = new bmp();
        } else if (string.equalsIgnoreCase("image/jpeg")) {
            contentHandler = new jpeg();
        } else if (string.equalsIgnoreCase("image/gif")) {
            contentHandler = new gif();
        } else if (string.equalsIgnoreCase("image/targa")) {
            contentHandler = new targa();
        } else if (string.equalsIgnoreCase("image/x-portable-pixmap")) {
            contentHandler = new x_portable_pixmap();
        } else if (string.equalsIgnoreCase("image/x-portable-graymap")) {
            contentHandler = new x_portable_graymap();
        } else if (string.equalsIgnoreCase("image/tiff")) {
            contentHandler = new tiff();
        }
        if (contentHandler == null && this.prevFactory != null) {
            contentHandler = this.prevFactory.createContentHandler(string);
        }
        return contentHandler;
    }
}

