/*
 * Decompiled with CFR 0.152.
 */
package vlc.image;

import java.nio.ByteBuffer;

public class ImageScaleFilterDriver {
    private static final int MAX_THREADS = 10;
    private static boolean[] threadInUse;
    private static Object mutex;

    public int acquireThreadId() {
        int n;
        block5: {
            n = -1;
            Object object = mutex;
            synchronized (object) {
                while (true) {
                    for (int i = 0; i < 10; ++i) {
                        if (threadInUse[i]) continue;
                        ImageScaleFilterDriver.threadInUse[i] = true;
                        n = i;
                        break block5;
                    }
                    Thread.currentThread();
                    Thread.yield();
                }
            }
        }
        return n;
    }

    public void releaseThreadId(int n) {
        if (n < 0 || n >= 10) {
            throw new IllegalArgumentException("Invalid thread ID");
        }
        if (!threadInUse[n]) {
            throw new IllegalArgumentException("ID was not in use");
        }
        ImageScaleFilterDriver.threadInUse[n] = false;
    }

    public static native String[] getScaleFilterTypes();

    private static native void initialize(int var0) throws InternalError;

    native void initScaleFilter(int var1, String var2) throws InternalError;

    native void scaleImage(int var1, int var2, int var3, int var4, ByteBuffer var5, int var6, int var7, ByteBuffer var8);

    static {
        mutex = new Object();
        System.loadLibrary("image_decode");
        threadInUse = new boolean[10];
        try {
            for (int i = 0; i < 10; ++i) {
                ImageScaleFilterDriver.threadInUse[i] = false;
            }
            ImageScaleFilterDriver.initialize(10);
        }
        catch (InternalError internalError) {
            System.err.println("Error initialising library: " + internalError.getMessage());
        }
    }
}

