/*
 * Decompiled with CFR 0.152.
 */
package vlc.image;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import vlc.image.ByteBufferImage;
import vlc.image.ImageScaleFilterDriver;

public class ImageScaleFilter {
    private static final String[] validTypes = ImageScaleFilterDriver.getScaleFilterTypes();
    private String filterType;

    public ImageScaleFilter(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Unsupported scale filter type " + string);
        }
        this.filterType = string;
        boolean bl = false;
        for (int i = 0; i < validTypes.length; ++i) {
            if (!string.equalsIgnoreCase(validTypes[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new IllegalArgumentException("Unsupported scale filter type " + string);
        }
    }

    public ByteBufferImage getScaledImage(ByteBufferImage byteBufferImage, int n, int n2) {
        ImageScaleFilterDriver imageScaleFilterDriver = new ImageScaleFilterDriver();
        int n3 = imageScaleFilterDriver.acquireThreadId();
        ByteBufferImage byteBufferImage2 = null;
        try {
            imageScaleFilterDriver.initScaleFilter(n3, this.filterType);
            int n4 = byteBufferImage.getWidth();
            int n5 = byteBufferImage.getHeight();
            int n6 = byteBufferImage.getType();
            ByteBuffer byteBuffer = byteBufferImage.getBuffer();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n * n2 * n6);
            byteBuffer2.order(ByteOrder.nativeOrder());
            imageScaleFilterDriver.scaleImage(n3, n4, n5, n6, byteBuffer, n, n2, byteBuffer2);
            byteBufferImage2 = new ByteBufferImage(n, n2, n6, byteBufferImage.isGrayScale(), byteBuffer2);
        }
        catch (InternalError internalError) {
            throw new IllegalArgumentException(internalError.getMessage());
        }
        finally {
            imageScaleFilterDriver.releaseThreadId(n3);
        }
        return byteBufferImage2;
    }

    public ByteBuffer getScaledImage(int n, int n2, int n3, ByteBuffer byteBuffer, int n4, int n5) {
        ImageScaleFilterDriver imageScaleFilterDriver = new ImageScaleFilterDriver();
        int n6 = imageScaleFilterDriver.acquireThreadId();
        ByteBuffer byteBuffer2 = null;
        try {
            imageScaleFilterDriver.initScaleFilter(n6, this.filterType);
            byteBuffer2 = ByteBuffer.allocateDirect(n4 * n5 * n3);
            byteBuffer2.order(ByteOrder.nativeOrder());
            imageScaleFilterDriver.scaleImage(n6, n, n2, n3, byteBuffer, n4, n5, byteBuffer2);
        }
        catch (InternalError internalError) {
            throw new IllegalArgumentException(internalError.getMessage());
        }
        finally {
            imageScaleFilterDriver.releaseThreadId(n6);
        }
        return byteBuffer2;
    }
}

