/*
 * Decompiled with CFR 0.152.
 */
package vlc.image;

import java.nio.ByteBuffer;

public class ByteBufferImage {
    public static final int INTENSITY = 1;
    public static final int INTENSITY_ALPHA = 2;
    public static final int RGB = 3;
    public static final int RGBA = 4;
    private static final String INVALID_WIDTH_PARAMETER = "image width must be a positive integer";
    private static final String INVALID_HEIGHT_PARAMETER = "image height must be a positive integer";
    private static final String INVALID_TYPE_PARAMETER = "image type unknown";
    private static final String BUFFER_IS_NULL = "image buffer must be non-null";
    private static final String BUFFER_INSUFFICIENT = "image buffer must be sufficiently sized to contain image";
    private int width;
    private int height;
    private int type;
    private ByteBuffer[] buffer;
    private boolean isGrayScale;

    public ByteBufferImage(int n, int n2, int n3) {
        this(n, n2, n3, n3 == 1 | n3 == 2, ByteBuffer.allocateDirect(n * n2 * n3));
    }

    public ByteBufferImage(int n, int n2, int n3, ByteBuffer byteBuffer) {
        this(n, n2, n3, n3 == 1 | n3 == 2, byteBuffer);
    }

    public ByteBufferImage(int n, int n2, int n3, boolean bl, ByteBuffer byteBuffer) {
        if (n < 1) {
            throw new IllegalArgumentException(INVALID_WIDTH_PARAMETER);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_HEIGHT_PARAMETER);
        }
        if (n3 < 1 || n3 > 4) {
            throw new IllegalArgumentException(INVALID_TYPE_PARAMETER);
        }
        if (byteBuffer == null) {
            throw new NullPointerException(BUFFER_IS_NULL);
        }
        if (byteBuffer.limit() < n * n2 * n3) {
            throw new IllegalArgumentException(BUFFER_INSUFFICIENT);
        }
        this.width = n;
        this.height = n2;
        this.type = n3;
        this.isGrayScale = bl;
        this.buffer = new ByteBuffer[]{byteBuffer};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getType() {
        return this.type;
    }

    public boolean isGrayScale() {
        return this.isGrayScale;
    }

    public int getLevels() {
        return this.buffer.length;
    }

    public ByteBuffer getBuffer() {
        this.buffer[0].rewind();
        return this.buffer[0];
    }

    public ByteBuffer[] getBuffer(ByteBuffer[] byteBufferArray) {
        int n = this.buffer.length;
        if (byteBufferArray == null || byteBufferArray.length < n) {
            byteBufferArray = new ByteBuffer[n];
        }
        for (int i = 0; i < n; ++i) {
            this.buffer[i].rewind();
            byteBufferArray[i] = this.buffer[i];
        }
        return byteBufferArray;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException(BUFFER_IS_NULL);
        }
        if (byteBuffer.limit() < this.width * this.height * this.type) {
            throw new IllegalArgumentException(BUFFER_INSUFFICIENT);
        }
        this.buffer = new ByteBuffer[]{byteBuffer};
    }

    public void setBuffer(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new NullPointerException(BUFFER_IS_NULL);
        }
        if (byteBufferArray[0].limit() != this.width * this.height * this.type) {
            throw new IllegalArgumentException(BUFFER_INSUFFICIENT);
        }
        int n = byteBufferArray.length;
        this.buffer = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = byteBufferArray[i];
        }
    }

    public String toString() {
        return "ByteBufferImage: type = " + this.getTypeDescription() + ", width = " + this.width + ", height = " + this.height;
    }

    private String getTypeDescription() {
        switch (this.type) {
            case 1: {
                return "INTENSITY";
            }
            case 2: {
                return "INTENSITY_ALPHA";
            }
            case 3: {
                return "RGB";
            }
            case 4: {
                return "RGBA";
            }
        }
        return "UNKNOWN";
    }
}

