/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.browser;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.web3d.browser.BrowserCore;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.AbstractScene;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLException;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.sav.ContentHandler;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.sav.ProtoHandler;
import org.web3d.vrml.sav.RouteHandler;
import org.web3d.vrml.sav.ScriptHandler;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.browser.CommonBrowser;
import org.web3d.vrml.scripting.browser.SceneUpdateTraverser;
import org.web3d.x3d.jaxp.X3DEntityResolver;
import org.web3d.x3d.jaxp.X3DErrorHandler;
import org.web3d.x3d.jaxp.X3DSAVAdapter;
import org.web3d.x3d.sai.NotSupportedException;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.SceneBuilder;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;

public class X3DCommonBrowser
extends CommonBrowser {
    private X3DErrorHandler domErrorHandler;
    private Transformer transformer;
    private SceneBuilder sceneBuilder;
    private SAXResult saxOutput;
    private X3DEntityResolver xmlResolver;
    private ViewpointManager viewpointManager;

    public X3DCommonBrowser(BrowserCore browserCore, ViewpointManager viewpointManager, RouteManager routeManager, FrameStateManager frameStateManager, WorldLoaderManager worldLoaderManager) {
        super(browserCore, routeManager, frameStateManager, worldLoaderManager);
        this.viewpointManager = viewpointManager;
    }

    public ViewpointManager getViewpointManager() {
        return this.viewpointManager;
    }

    public void replaceWorld(VRMLScene vRMLScene) {
        SceneUpdateTraverser.updateScene((AbstractScene)((Object)vRMLScene));
        this.core.setScene(vRMLScene, null);
    }

    public VRMLScene createX3DFromStream(InputStream inputStream) throws VRMLException, VRMLParseException, IOException {
        BasicScene basicScene;
        InputSource inputSource = new InputSource(this.core.getWorldURL(), inputStream);
        WorldLoader worldLoader = this.loaderManager.fetchLoader();
        int n = 0;
        int n2 = 0;
        VRMLExecutionSpace vRMLExecutionSpace = this.core.getWorldExecutionSpace();
        if (vRMLExecutionSpace != null) {
            basicScene = vRMLExecutionSpace.getContainedScene();
            n = basicScene.getSpecificationMajorVersion();
            n2 = basicScene.getSpecificationMinorVersion();
        }
        basicScene = worldLoader.loadNow(this.core, inputSource, true, n, n2);
        this.loaderManager.releaseLoader(worldLoader);
        return basicScene;
    }

    public VRMLScene createX3DFromString(String string) throws VRMLException, VRMLParseException, IOException {
        BasicScene basicScene;
        StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string);
        InputSource inputSource = new InputSource(this.core.getWorldURL(), stringBufferInputStream);
        WorldLoader worldLoader = this.loaderManager.fetchLoader();
        int n = 0;
        int n2 = 0;
        VRMLExecutionSpace vRMLExecutionSpace = this.core.getWorldExecutionSpace();
        if (vRMLExecutionSpace != null) {
            basicScene = vRMLExecutionSpace.getContainedScene();
            n = basicScene.getSpecificationMajorVersion();
            n2 = basicScene.getSpecificationMinorVersion();
        }
        basicScene = worldLoader.loadNow(this.core, inputSource, true, n, n2);
        this.loaderManager.releaseLoader(worldLoader);
        return basicScene;
    }

    public VRMLScene createX3DFromURL(String[] stringArray) {
        VRMLScene vRMLScene = null;
        WorldLoader worldLoader = this.loaderManager.fetchLoader();
        stringArray = this.completeUrl(stringArray);
        int n = 0;
        int n2 = 0;
        VRMLExecutionSpace vRMLExecutionSpace = this.core.getWorldExecutionSpace();
        if (vRMLExecutionSpace != null) {
            BasicScene basicScene = vRMLExecutionSpace.getContainedScene();
            n = basicScene.getSpecificationMajorVersion();
            n2 = basicScene.getSpecificationMinorVersion();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            InputSource inputSource = new InputSource(stringArray[i]);
            try {
                vRMLScene = worldLoader.loadNow(this.core, inputSource, false, n, n2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (VRMLParseException vRMLParseException) {
                this.errorReporter.errorReport("Processing URL: " + stringArray[i] + " " + vRMLParseException.getMessage(), vRMLParseException);
            }
            if (vRMLScene != null) break;
        }
        this.loaderManager.releaseLoader(worldLoader);
        return vRMLScene;
    }

    public VRMLScene importDocument(Node node) throws NotSupportedException {
        Object object;
        if (!(node instanceof Document)) {
            throw new NotSupportedException("Xj3D does not support importing anything other than a Document yet");
        }
        DOMSource dOMSource = new DOMSource(node);
        if (this.domErrorHandler == null) {
            object = this.loaderManager.getBuilderFactory(this.core.getRendererType());
            this.sceneBuilder = object.createBuilder();
            this.sceneBuilder.setFrameStateManager(this.stateManager);
            this.sceneBuilder.setErrorReporter(this.errorReporter);
            this.domErrorHandler = new X3DErrorHandler();
            this.domErrorHandler.setErrorReporter(this.errorReporter);
            X3DSAVAdapter x3DSAVAdapter = new X3DSAVAdapter();
            x3DSAVAdapter.setContentHandler((ContentHandler)this.sceneBuilder);
            x3DSAVAdapter.setProtoHandler((ProtoHandler)this.sceneBuilder);
            x3DSAVAdapter.setRouteHandler((RouteHandler)this.sceneBuilder);
            x3DSAVAdapter.setScriptHandler((ScriptHandler)this.sceneBuilder);
            String string = System.getProperty("user.dir");
            string = "file://" + string.substring(3);
            x3DSAVAdapter.setLoadState(string, "DOM", true);
            this.xmlResolver = new X3DEntityResolver();
            try {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                this.transformer = transformerFactory.newTransformer();
            }
            catch (TransformerException transformerException) {
                this.errorReporter.warningReport("Error creating transformer: ", transformerException);
            }
            this.saxOutput = new SAXResult((org.xml.sax.ContentHandler)x3DSAVAdapter);
        }
        object = null;
        try {
            this.sceneBuilder.reset();
            this.transformer.transform(dOMSource, this.saxOutput);
            object = this.sceneBuilder.getScene();
            this.sceneBuilder.releaseScene();
        }
        catch (TransformerException transformerException) {
            this.errorReporter.warningReport("Error importing document", transformerException);
        }
        return object;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        if (this.domErrorHandler != null) {
            this.domErrorHandler.setErrorReporter(this.errorReporter);
        }
    }

    public void nextViewpoint() {
        this.viewpointManager.nextViewpoint();
    }

    public void nextViewpoint(int n) {
        this.viewpointManager.nextViewpoint(n);
    }

    public void previousViewpoint() {
        this.viewpointManager.previousViewpoint();
    }

    public void previousViewpoint(int n) {
        this.viewpointManager.previousViewpoint(n);
    }

    public void firstViewpoint() {
        this.viewpointManager.firstViewpoint();
    }

    public void firstViewpoint(int n) {
        this.viewpointManager.firstViewpoint(n);
    }

    public void lastViewpoint() {
        this.viewpointManager.lastViewpoint();
    }

    public void lastViewpoint(int n) {
        this.viewpointManager.lastViewpoint(n);
    }
}

