/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.web3d.xmsf.dis.AcknowledgePdu;
import org.web3d.xmsf.dis.AcknowledgePduType;
import org.web3d.xmsf.dis.CollisionPdu;
import org.web3d.xmsf.dis.CollisionPduType;
import org.web3d.xmsf.dis.CreateEntityPdu;
import org.web3d.xmsf.dis.CreateEntityPduType;
import org.web3d.xmsf.dis.DetonationPdu;
import org.web3d.xmsf.dis.DetonationPduType;
import org.web3d.xmsf.dis.EntityStatePdu;
import org.web3d.xmsf.dis.FirePdu;
import org.web3d.xmsf.dis.FirePduType;
import org.web3d.xmsf.dis.RemoveEntityPdu;
import org.web3d.xmsf.dis.RemoveEntityPduType;
import org.web3d.xmsf.dis.StartResumePdu;
import org.web3d.xmsf.dis.StartResumePduType;
import org.web3d.xmsf.dis.StopFreezePdu;
import org.web3d.xmsf.dis.StopFreezePduType;
import org.web3d.xmsf.disutil.DisMarshaller;
import org.web3d.xmsf.disutil.PduFactory;

public class TestDisUnmarshaller
extends TestCase {
    static /* synthetic */ Class class$org$web3d$xmsf$disutil$TestDisUnmarshaller;

    public static Test suite() {
        return new TestSuite(class$org$web3d$xmsf$disutil$TestDisUnmarshaller == null ? (class$org$web3d$xmsf$disutil$TestDisUnmarshaller = TestDisUnmarshaller.class$("org.web3d.xmsf.disutil.TestDisUnmarshaller")) : class$org$web3d$xmsf$disutil$TestDisUnmarshaller);
    }

    public void testUnmarshallEntityStatePdu() {
        PduFactory pduFactory = new PduFactory();
        byte[] byArray = new byte[]{6, 0, 1, 1, 0, 0, 0, 0, 0, -112, 0, 0, 0, 0, 0, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, -16, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 64, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        EntityStatePdu entityStatePdu = (EntityStatePdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getPduHeader().getLength() == 144 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getEntityLocation().getX() == 1.0 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getEntityLocation().getY() == 2.0 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getEntityLocation().getZ() == 3.0 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getEntityID().getSite() == 0 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getEntityID().getApplication() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((entityStatePdu.getEntityID().getEntity() == 2 ? 1 : 0) != 0);
    }

    public void testUnmarshallFirePdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        FirePduType firePduType = pduFactory.getFirePdu();
        firePduType.getPduHeader().setLength(96);
        firePduType.getFiringEntityID().setSite(1);
        firePduType.getFiringEntityID().setApplication(2);
        firePduType.getFiringEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallFirePdu(firePduType);
        FirePdu firePdu = (FirePdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((firePdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((firePdu.getPduHeader().getLength() == 96 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((firePdu.getFiringEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((firePdu.getFiringEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((firePdu.getFiringEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallDetonationPdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        DetonationPduType detonationPduType = pduFactory.getDetonationPdu();
        detonationPduType.getPduHeader().setLength(104);
        detonationPduType.getFiringEntityID().setSite(1);
        detonationPduType.getFiringEntityID().setApplication(2);
        detonationPduType.getFiringEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallDetonationPdu(detonationPduType);
        DetonationPdu detonationPdu = (DetonationPdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((detonationPdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((detonationPdu.getPduHeader().getLength() == 104 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((detonationPdu.getFiringEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((detonationPdu.getFiringEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((detonationPdu.getFiringEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallCollisionPdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        CollisionPduType collisionPduType = pduFactory.getCollisionPdu();
        collisionPduType.getPduHeader().setLength(60);
        collisionPduType.getIssuingEntityID().setSite(1);
        collisionPduType.getIssuingEntityID().setApplication(2);
        collisionPduType.getIssuingEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallCollisionPdu(collisionPduType);
        CollisionPdu collisionPdu = (CollisionPdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((collisionPdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((collisionPdu.getPduHeader().getLength() == 60 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((collisionPdu.getIssuingEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((collisionPdu.getIssuingEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((collisionPdu.getIssuingEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallCreateEntityPdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        CreateEntityPduType createEntityPduType = pduFactory.getCreateEntityPdu();
        createEntityPduType.getPduHeader().setLength(28);
        createEntityPduType.getOriginatingEntityID().setSite(1);
        createEntityPduType.getOriginatingEntityID().setApplication(2);
        createEntityPduType.getOriginatingEntityID().setEntity(3);
        createEntityPduType.getReceivingEntityID().setSite(1);
        createEntityPduType.getReceivingEntityID().setApplication(2);
        createEntityPduType.getReceivingEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallCreateEntityPdu(createEntityPduType);
        CreateEntityPdu createEntityPdu = (CreateEntityPdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((createEntityPdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((createEntityPdu.getPduHeader().getLength() == 28 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((createEntityPdu.getOriginatingEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((createEntityPdu.getOriginatingEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((createEntityPdu.getOriginatingEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallRemoveEntityPdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        RemoveEntityPduType removeEntityPduType = pduFactory.getRemoveEntityPdu();
        removeEntityPduType.getPduHeader().setLength(28);
        removeEntityPduType.getOriginatingEntityID().setSite(1);
        removeEntityPduType.getOriginatingEntityID().setApplication(2);
        removeEntityPduType.getOriginatingEntityID().setEntity(3);
        removeEntityPduType.getReceivingEntityID().setSite(1);
        removeEntityPduType.getReceivingEntityID().setApplication(2);
        removeEntityPduType.getReceivingEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallRemoveEntityPdu(removeEntityPduType);
        RemoveEntityPdu removeEntityPdu = (RemoveEntityPdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((removeEntityPdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((removeEntityPdu.getPduHeader().getLength() == 28 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((removeEntityPdu.getOriginatingEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((removeEntityPdu.getOriginatingEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((removeEntityPdu.getOriginatingEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallStartResumePdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        StartResumePduType startResumePduType = pduFactory.getStartResumePdu();
        startResumePduType.getPduHeader().setLength(44);
        startResumePduType.getOriginatingEntityID().setSite(1);
        startResumePduType.getOriginatingEntityID().setApplication(2);
        startResumePduType.getOriginatingEntityID().setEntity(3);
        startResumePduType.getReceivingEntityID().setSite(1);
        startResumePduType.getReceivingEntityID().setApplication(2);
        startResumePduType.getReceivingEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallStartResumePdu(startResumePduType);
        StartResumePdu startResumePdu = (StartResumePdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((startResumePdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((startResumePdu.getPduHeader().getLength() == 44 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((startResumePdu.getOriginatingEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((startResumePdu.getOriginatingEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((startResumePdu.getOriginatingEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallStopFreezePdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        StopFreezePduType stopFreezePduType = pduFactory.getStopFreezePdu();
        stopFreezePduType.getPduHeader().setLength(40);
        stopFreezePduType.getOriginatingEntityID().setSite(1);
        stopFreezePduType.getOriginatingEntityID().setApplication(2);
        stopFreezePduType.getOriginatingEntityID().setEntity(3);
        stopFreezePduType.getReceivingEntityID().setSite(1);
        stopFreezePduType.getReceivingEntityID().setApplication(2);
        stopFreezePduType.getReceivingEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallStopFreezePdu(stopFreezePduType);
        StopFreezePdu stopFreezePdu = (StopFreezePdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((stopFreezePdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((stopFreezePdu.getPduHeader().getLength() == 40 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((stopFreezePdu.getOriginatingEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((stopFreezePdu.getOriginatingEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((stopFreezePdu.getOriginatingEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    public void testUnmarshallAcknowledgePdu() {
        PduFactory pduFactory = new PduFactory();
        DisMarshaller disMarshaller = new DisMarshaller();
        AcknowledgePduType acknowledgePduType = pduFactory.getAcknowledgePdu();
        acknowledgePduType.getPduHeader().setLength(32);
        acknowledgePduType.getOriginatingEntityID().setSite(1);
        acknowledgePduType.getOriginatingEntityID().setApplication(2);
        acknowledgePduType.getOriginatingEntityID().setEntity(3);
        acknowledgePduType.getReceivingEntityID().setSite(1);
        acknowledgePduType.getReceivingEntityID().setApplication(2);
        acknowledgePduType.getReceivingEntityID().setEntity(3);
        byte[] byArray = disMarshaller.marshallAcknowledgePdu(acknowledgePduType);
        AcknowledgePdu acknowledgePdu = (AcknowledgePdu)pduFactory.getPdu(byArray);
        TestDisUnmarshaller.assertTrue((acknowledgePdu.getPduHeader().getProtocolVersion() == 6 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((acknowledgePdu.getPduHeader().getLength() == 32 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((acknowledgePdu.getOriginatingEntityID().getSite() == 1 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((acknowledgePdu.getOriginatingEntityID().getApplication() == 2 ? 1 : 0) != 0);
        TestDisUnmarshaller.assertTrue((acknowledgePdu.getOriginatingEntityID().getEntity() == 3 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

