/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.web3d.xmsf.dis.AcknowledgePdu;
import org.web3d.xmsf.dis.AcknowledgePduType;
import org.web3d.xmsf.dis.BurstDescriptorType;
import org.web3d.xmsf.dis.ClockType;
import org.web3d.xmsf.dis.CollisionPdu;
import org.web3d.xmsf.dis.CollisionPduType;
import org.web3d.xmsf.dis.CreateEntityPdu;
import org.web3d.xmsf.dis.CreateEntityPduType;
import org.web3d.xmsf.dis.DIS;
import org.web3d.xmsf.dis.DISType;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.DetonationPdu;
import org.web3d.xmsf.dis.DetonationPduType;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityMarking;
import org.web3d.xmsf.dis.EntityStatePdu;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EntityType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.EventIDType;
import org.web3d.xmsf.dis.FirePdu;
import org.web3d.xmsf.dis.FirePduType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.ObjectFactory;
import org.web3d.xmsf.dis.RemoveEntityPdu;
import org.web3d.xmsf.dis.RemoveEntityPduType;
import org.web3d.xmsf.dis.StartResumePdu;
import org.web3d.xmsf.dis.StartResumePduType;
import org.web3d.xmsf.dis.StopFreezePdu;
import org.web3d.xmsf.dis.StopFreezePduType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.disutil.DisUnmarshaller;
import org.web3d.xmsf.disutil.DisUnmarshaller1995;

public class PduFactory {
    private ObjectFactory objectFactory = new ObjectFactory();
    private boolean fastEspdus = false;
    DisUnmarshaller disUnmarshaller = new DisUnmarshaller();
    DisUnmarshaller1995 disUnmarshaller1995 = new DisUnmarshaller1995();

    public void setFastEspdus(boolean bl) {
        this.fastEspdus = bl;
        this.disUnmarshaller.setFastEspdus(bl);
    }

    public DISType getDIS() {
        DIS dIS = null;
        try {
            dIS = this.objectFactory.createDIS();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return dIS;
    }

    public Object getPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        HeaderType headerType = this.deserializePduHeader(dataInputStream);
        switch (headerType.getProtocolVersion()) {
            case 5: 
            case 6: {
                switch (headerType.getPduType()) {
                    case 1: {
                        if (this.fastEspdus) {
                            return this.disUnmarshaller.unmarshallEntityStatePduFast(byArray);
                        }
                        return this.disUnmarshaller.unmarshallEntityStatePdu(byArray);
                    }
                    case 2: {
                        return this.disUnmarshaller.unmarshallFirePdu(byArray);
                    }
                    case 3: {
                        return this.disUnmarshaller.unmarshallDetonationPdu(byArray);
                    }
                    case 4: {
                        return this.disUnmarshaller.unmarshallCollisionPdu(byArray);
                    }
                    case 5: {
                        return this.disUnmarshaller.unmarshallCreateEntityPdu(byArray);
                    }
                    case 6: {
                        return this.disUnmarshaller.unmarshallRemoveEntityPdu(byArray);
                    }
                    case 7: {
                        return this.disUnmarshaller.unmarshallStartResumePdu(byArray);
                    }
                    case 8: {
                        return this.disUnmarshaller.unmarshallStopFreezePdu(byArray);
                    }
                    case 9: {
                        return this.disUnmarshaller.unmarshallAcknowledgePdu(byArray);
                    }
                }
                System.out.println("Unrecognized PDU type, " + headerType.getPduType());
                return null;
            }
        }
        System.out.println("Unrecognized protocol version for diS packet, got " + headerType.getProtocolVersion() + " when expecting 6 for DIS-1998 or 5 for DIS-1995");
        return null;
    }

    private HeaderType deserializePduHeader(DataInputStream dataInputStream) {
        HeaderType headerType = null;
        try {
            headerType = this.objectFactory.createHeaderType();
            byte by = dataInputStream.readByte();
            if (by == -128) {
                for (int i = 0; i < 11; ++i) {
                    dataInputStream.readByte();
                }
                by = dataInputStream.readByte();
            }
            headerType.setProtocolVersion(by);
            headerType.setExerciseID(dataInputStream.readByte());
            headerType.setPduType(dataInputStream.readByte());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return headerType;
    }

    private HeaderType getPduHeader() {
        HeaderType headerType = null;
        try {
            headerType = this.objectFactory.createHeaderType();
            headerType.setTimestamp(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
        return headerType;
    }

    public EntityStatePduType getEntityStatePdu() {
        EntityStatePdu entityStatePdu = null;
        try {
            entityStatePdu = this.objectFactory.createEntityStatePdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)1);
            headerType.setProtocolFamily((byte)1);
            entityStatePdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            entityStatePdu.setEntityID(entityIDType);
            entityStatePdu.setForceID((byte)0);
            entityStatePdu.setNumberOfArticulationParameters((byte)0);
            EntityType entityType = this.objectFactory.createEntityType();
            entityStatePdu.setEntity(entityType);
            entityType = this.objectFactory.createEntityType();
            entityStatePdu.setAlternativeEntity(entityType);
            Vector3Float vector3Float = this.objectFactory.createVector3Float();
            entityStatePdu.setEntityLinearVelocity(vector3Float);
            Vector3Double vector3Double = this.objectFactory.createVector3Double();
            entityStatePdu.setEntityLocation(vector3Double);
            EulerAnglesType eulerAnglesType = this.objectFactory.createEulerAnglesType();
            entityStatePdu.setEntityOrientation(eulerAnglesType);
            entityStatePdu.setEntityAppearance(0);
            DeadReckoningParametersType deadReckoningParametersType = this.objectFactory.createDeadReckoningParametersType();
            deadReckoningParametersType.setEntityLinearAcceleration(this.objectFactory.createVector3Float());
            deadReckoningParametersType.setEntityAngularVelocity(this.objectFactory.createVector3Float());
            byte[] byArray = new byte[15];
            deadReckoningParametersType.setOtherParameters(byArray);
            entityStatePdu.setDeadReckoningParameters(deadReckoningParametersType);
            EntityMarking entityMarking = this.objectFactory.createEntityMarking();
            byte[] byArray2 = new byte[11];
            entityMarking.setCharacters(byArray2);
            entityMarking.setCharacterSet((byte)0);
            entityStatePdu.setEntityMarking(entityMarking);
            entityStatePdu.setCapabilities(0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
        return entityStatePdu;
    }

    public FirePduType getFirePdu() {
        FirePdu firePdu = null;
        try {
            firePdu = this.objectFactory.createFirePdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)2);
            headerType.setProtocolFamily((byte)2);
            firePdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            firePdu.setFiringEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            firePdu.setTargetEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            firePdu.setMunitionID(entityIDType);
            EventIDType eventIDType = this.objectFactory.createEventIDType();
            firePdu.setEventID(eventIDType);
            Vector3Double vector3Double = this.objectFactory.createVector3Double();
            firePdu.setLocationInWorldCoordinates(vector3Double);
            BurstDescriptorType burstDescriptorType = this.objectFactory.createBurstDescriptorType();
            EntityType entityType = this.objectFactory.createEntityType();
            burstDescriptorType.setMunition(entityType);
            firePdu.setBurstDescriptor(burstDescriptorType);
            Vector3Float vector3Float = this.objectFactory.createVector3Float();
            firePdu.setVelocity(vector3Float);
            firePdu.setRange(0.0f);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems creating fire pdu " + exception);
        }
        return firePdu;
    }

    public DetonationPduType getDetonationPdu() {
        DetonationPdu detonationPdu = null;
        try {
            detonationPdu = this.objectFactory.createDetonationPdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)3);
            headerType.setProtocolFamily((byte)2);
            detonationPdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            detonationPdu.setFiringEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            detonationPdu.setTargetEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            detonationPdu.setMunitionID(entityIDType);
            EventIDType eventIDType = this.objectFactory.createEventIDType();
            detonationPdu.setEventID(eventIDType);
            Vector3Float vector3Float = this.objectFactory.createVector3Float();
            detonationPdu.setVelocity(vector3Float);
            Vector3Double vector3Double = this.objectFactory.createVector3Double();
            detonationPdu.setLocationInWorldCoordinates(vector3Double);
            BurstDescriptorType burstDescriptorType = this.objectFactory.createBurstDescriptorType();
            EntityType entityType = this.objectFactory.createEntityType();
            burstDescriptorType.setMunition(entityType);
            detonationPdu.setBurstDescriptor(burstDescriptorType);
            Vector3Float vector3Float2 = this.objectFactory.createVector3Float();
            detonationPdu.setLocationInEntityCoordinates(vector3Float2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems creating fire pdu " + exception);
        }
        return detonationPdu;
    }

    public CollisionPduType getCollisionPdu() {
        CollisionPdu collisionPdu = null;
        try {
            collisionPdu = this.objectFactory.createCollisionPdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)4);
            headerType.setProtocolFamily((byte)1);
            collisionPdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            collisionPdu.setIssuingEntityID(entityIDType);
            EntityIDType entityIDType2 = this.objectFactory.createEntityIDType();
            collisionPdu.setCollidingEntityID(entityIDType2);
            EventIDType eventIDType = this.objectFactory.createEventIDType();
            collisionPdu.setEventID(eventIDType);
            Vector3Float vector3Float = this.objectFactory.createVector3Float();
            collisionPdu.setVelocity(vector3Float);
            Vector3Float vector3Float2 = this.objectFactory.createVector3Float();
            collisionPdu.setLocationWithRespectToEntity(vector3Float2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem creating collision PDU");
            System.out.println(exception);
        }
        return collisionPdu;
    }

    public CreateEntityPduType getCreateEntityPdu() {
        CreateEntityPdu createEntityPdu = null;
        try {
            createEntityPdu = this.objectFactory.createCreateEntityPdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)5);
            headerType.setProtocolFamily((byte)5);
            createEntityPdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            createEntityPdu.setOriginatingEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            createEntityPdu.setReceivingEntityID(entityIDType);
            createEntityPdu.setRequestID(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems creating entity pdu " + exception);
        }
        return createEntityPdu;
    }

    public RemoveEntityPduType getRemoveEntityPdu() {
        RemoveEntityPdu removeEntityPdu = null;
        try {
            removeEntityPdu = this.objectFactory.createRemoveEntityPdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)6);
            headerType.setProtocolFamily((byte)5);
            removeEntityPdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            removeEntityPdu.setOriginatingEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            removeEntityPdu.setReceivingEntityID(entityIDType);
            removeEntityPdu.setRequestID(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems with remove entity pdu " + exception);
        }
        return removeEntityPdu;
    }

    public StartResumePduType getStartResumePdu() {
        StartResumePdu startResumePdu = null;
        try {
            startResumePdu = this.objectFactory.createStartResumePdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)7);
            headerType.setProtocolFamily((byte)5);
            startResumePdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            startResumePdu.setOriginatingEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            startResumePdu.setReceivingEntityID(entityIDType);
            ClockType clockType = this.objectFactory.createClockType();
            startResumePdu.setRealWorldTime(clockType);
            clockType = this.objectFactory.createClockType();
            startResumePdu.setSimulationTime(clockType);
            startResumePdu.setRequestID(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems with start/resume pdu " + exception);
        }
        return startResumePdu;
    }

    public StopFreezePduType getStopFreezePdu() {
        StopFreezePdu stopFreezePdu = null;
        try {
            stopFreezePdu = this.objectFactory.createStopFreezePdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)8);
            headerType.setProtocolFamily((byte)5);
            stopFreezePdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            stopFreezePdu.setOriginatingEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            stopFreezePdu.setReceivingEntityID(entityIDType);
            ClockType clockType = this.objectFactory.createClockType();
            stopFreezePdu.setRealWorldTime(clockType);
            stopFreezePdu.setReason((byte)0);
            stopFreezePdu.setFrozenBehavior((byte)0);
            stopFreezePdu.setPadding((short)0);
            stopFreezePdu.setRequestID(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems with stop/freeze pdu " + exception);
        }
        return stopFreezePdu;
    }

    public AcknowledgePduType getAcknowledgePdu() {
        AcknowledgePdu acknowledgePdu = null;
        try {
            acknowledgePdu = this.objectFactory.createAcknowledgePdu();
            HeaderType headerType = this.getPduHeader();
            headerType.setPduType((byte)9);
            headerType.setProtocolFamily((byte)5);
            acknowledgePdu.setPduHeader(headerType);
            EntityIDType entityIDType = this.objectFactory.createEntityIDType();
            acknowledgePdu.setOriginatingEntityID(entityIDType);
            entityIDType = this.objectFactory.createEntityIDType();
            acknowledgePdu.setReceivingEntityID(entityIDType);
            acknowledgePdu.setAcknowledgeFlag((short)0);
            acknowledgePdu.setResponseFlag((short)0);
            acknowledgePdu.setRequestID(0L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problems with acknowledge pdu " + exception);
        }
        return acknowledgePdu;
    }
}

