/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityMarking;
import org.web3d.xmsf.dis.EntityStatePdu;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EntityType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.disutil.PduFactory;

public class FastEspdu {
    public byte protocolVersion;
    public byte exerciseId;
    public byte pduType;
    public byte protocolFamily;
    public int timestamp;
    public short length;
    public short padding = 0;
    public short site;
    public short application;
    public short entity;
    public byte forceID;
    public byte numberOfArticulationParameters;
    public byte entityKind;
    public byte domain;
    public short country;
    public byte category;
    public byte subCategory;
    public byte specific;
    public byte extra;
    public byte altEntityKind;
    public byte altDomain;
    public short altCountry;
    public byte altCategory;
    public byte altSubCategory;
    public byte altSpecific;
    public byte altExtra;
    public float xVelocity;
    public float yVelocity;
    public float zVelocity;
    public double xLocation;
    public double yLocation;
    public double zLocation;
    public float psi;
    public float theta;
    public float phi;
    public int entityAppearance;
    public byte deadReckoningAlgorithm;
    public byte[] parameters;
    public float xAcceleration;
    public float yAcceleration;
    public float zAcceleration;
    public float xAngularVelocity;
    public float yAngularVelocity;
    public float zAngularVelocity;
    public byte characterSet;
    public byte[] marking;
    public int capabilities;

    public FastEspdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int n;
            this.protocolVersion = dataInputStream.readByte();
            this.exerciseId = dataInputStream.readByte();
            this.pduType = dataInputStream.readByte();
            this.protocolFamily = dataInputStream.readByte();
            this.timestamp = dataInputStream.readInt();
            this.length = dataInputStream.readShort();
            this.padding = dataInputStream.readShort();
            this.site = dataInputStream.readShort();
            this.application = dataInputStream.readShort();
            this.entity = dataInputStream.readShort();
            this.forceID = dataInputStream.readByte();
            this.numberOfArticulationParameters = dataInputStream.readByte();
            if (this.numberOfArticulationParameters > 0) {
                throw new Exception("FastESPDU does not handle articulation parameters");
            }
            this.entityKind = dataInputStream.readByte();
            this.domain = dataInputStream.readByte();
            this.country = dataInputStream.readShort();
            this.category = dataInputStream.readByte();
            this.subCategory = dataInputStream.readByte();
            this.specific = dataInputStream.readByte();
            this.extra = dataInputStream.readByte();
            this.altEntityKind = dataInputStream.readByte();
            this.altDomain = dataInputStream.readByte();
            this.altCountry = dataInputStream.readShort();
            this.altCategory = dataInputStream.readByte();
            this.altSubCategory = dataInputStream.readByte();
            this.altSpecific = dataInputStream.readByte();
            this.altExtra = dataInputStream.readByte();
            this.xVelocity = dataInputStream.readFloat();
            this.yVelocity = dataInputStream.readFloat();
            this.zVelocity = dataInputStream.readFloat();
            this.xLocation = dataInputStream.readDouble();
            this.yLocation = dataInputStream.readDouble();
            this.zLocation = dataInputStream.readDouble();
            this.psi = dataInputStream.readFloat();
            this.theta = dataInputStream.readFloat();
            this.phi = dataInputStream.readFloat();
            this.entityAppearance = dataInputStream.readInt();
            this.deadReckoningAlgorithm = dataInputStream.readByte();
            this.parameters = new byte[15];
            for (n = 0; n < 15; ++n) {
                this.parameters[n] = dataInputStream.readByte();
            }
            this.xAcceleration = dataInputStream.readFloat();
            this.yAcceleration = dataInputStream.readFloat();
            this.zAcceleration = dataInputStream.readFloat();
            this.xAngularVelocity = dataInputStream.readFloat();
            this.yAngularVelocity = dataInputStream.readFloat();
            this.zAngularVelocity = dataInputStream.readFloat();
            this.characterSet = dataInputStream.readByte();
            this.marking = new byte[11];
            for (n = 0; n < 11; ++n) {
                this.marking[n] = dataInputStream.readByte();
            }
            this.capabilities = dataInputStream.readInt();
        }
        catch (Exception exception) {
            System.out.println("Error reading espdu in FastEspdu. You're probably better off turning off fastEspdu.");
        }
    }

    public EntityStatePdu getEntityStatePdu() {
        PduFactory pduFactory = new PduFactory();
        EntityStatePduType entityStatePduType = pduFactory.getEntityStatePdu();
        HeaderType headerType = entityStatePduType.getPduHeader();
        headerType.setProtocolVersion(this.protocolVersion);
        headerType.setExerciseID(this.exerciseId);
        headerType.setPduType(this.pduType);
        headerType.setProtocolFamily(this.protocolFamily);
        headerType.setTimestamp(this.timestamp);
        headerType.setLength(this.length);
        headerType.setPadding((short)0);
        EntityIDType entityIDType = entityStatePduType.getEntityID();
        entityIDType.setSite(this.site);
        entityIDType.setApplication(this.application);
        entityIDType.setEntity(this.entity);
        entityStatePduType.setForceID(this.forceID);
        entityStatePduType.setNumberOfArticulationParameters(this.numberOfArticulationParameters);
        EntityType entityType = entityStatePduType.getEntity();
        entityType.setEntityKind(this.entityKind);
        entityType.setDomain(this.domain);
        entityType.setCountry(this.country);
        entityType.setCategory(this.category);
        entityType.setSubCategory(this.subCategory);
        entityType.setSpecific(this.specific);
        entityType.setExtra(this.extra);
        entityType = entityStatePduType.getAlternativeEntity();
        entityType.setEntityKind(this.altEntityKind);
        entityType.setDomain(this.altDomain);
        entityType.setCountry(this.altCountry);
        entityType.setCategory(this.altCategory);
        entityType.setSubCategory(this.altSubCategory);
        entityType.setSpecific(this.altSpecific);
        entityType.setExtra(this.altExtra);
        Vector3Float vector3Float = entityStatePduType.getEntityLinearVelocity();
        vector3Float.setX(this.xVelocity);
        vector3Float.setY(this.yVelocity);
        vector3Float.setZ(this.zVelocity);
        Vector3Double vector3Double = entityStatePduType.getEntityLocation();
        vector3Double.setX(this.xLocation);
        vector3Double.setY(this.yLocation);
        vector3Double.setZ(this.zLocation);
        EulerAnglesType eulerAnglesType = entityStatePduType.getEntityOrientation();
        eulerAnglesType.setPsi(this.psi);
        eulerAnglesType.setTheta(this.theta);
        eulerAnglesType.setPhi(this.phi);
        entityStatePduType.setEntityAppearance(this.entityAppearance);
        DeadReckoningParametersType deadReckoningParametersType = entityStatePduType.getDeadReckoningParameters();
        deadReckoningParametersType.setDeadReckoningAlgorithm(this.deadReckoningAlgorithm);
        Vector3Float vector3Float2 = deadReckoningParametersType.getEntityAngularVelocity();
        vector3Float2.setX(this.xAngularVelocity);
        vector3Float2.setY(this.yAngularVelocity);
        vector3Float2.setZ(this.zAngularVelocity);
        Vector3Float vector3Float3 = deadReckoningParametersType.getEntityLinearAcceleration();
        vector3Float3.setX(this.xAcceleration);
        vector3Float3.setY(this.yAcceleration);
        vector3Float3.setZ(this.zAcceleration);
        deadReckoningParametersType.setOtherParameters(this.parameters);
        EntityMarking entityMarking = entityStatePduType.getEntityMarking();
        entityMarking.setCharacterSet(this.characterSet);
        entityMarking.setCharacters(this.marking);
        entityStatePduType.setCapabilities(this.capabilities);
        return (EntityStatePdu)entityStatePduType;
    }
}

