/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.web3d.xmsf.dis.AcknowledgePdu;
import org.web3d.xmsf.dis.ArticulationParametersType;
import org.web3d.xmsf.dis.BurstDescriptorType;
import org.web3d.xmsf.dis.ClockType;
import org.web3d.xmsf.dis.CollisionPdu;
import org.web3d.xmsf.dis.CreateEntityPdu;
import org.web3d.xmsf.dis.DIS;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.DetonationPdu;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityMarking;
import org.web3d.xmsf.dis.EntityStatePdu;
import org.web3d.xmsf.dis.EntityType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.EventIDType;
import org.web3d.xmsf.dis.FirePdu;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.RemoveEntityPdu;
import org.web3d.xmsf.dis.StartResumePdu;
import org.web3d.xmsf.dis.StopFreezePdu;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.disutil.FastEspdu;
import org.web3d.xmsf.disutil.ObjectPool;

public class DisUnmarshaller {
    private boolean fastEspdus = false;
    private ObjectPool objectPool = ObjectPool.getObjectPool();
    static /* synthetic */ Class class$org$web3d$xmsf$dis$EntityStatePdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$FirePdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$DetonationPdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$CollisionPdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$CreateEntityPdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$RemoveEntityPdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$StartResumePdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$StopFreezePdu;
    static /* synthetic */ Class class$org$web3d$xmsf$dis$AcknowledgePdu;

    public List unmarshallFromXML(InputStream inputStream) throws IOException {
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"org.web3d.xmsf.dis");
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            DIS dIS = (DIS)unmarshaller.unmarshal(inputStream);
            return dIS.getAcknowledgePduOrActionRequestPduOrActionResponsePdu();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Unable to read XML from input stream");
        }
    }

    public List unmarshallFromXML(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            List list = this.unmarshallFromXML(fileInputStream);
            fileInputStream.close();
            return list;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException("Unable to read DIS-XML correctly from file " + string);
        }
    }

    public FastEspdu unmarshallEntityStatePduFast(byte[] byArray) {
        return new FastEspdu(byArray);
    }

    public EntityStatePdu unmarshallEntityStatePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        EntityStatePdu entityStatePdu = (EntityStatePdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$EntityStatePdu == null ? (class$org$web3d$xmsf$dis$EntityStatePdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.EntityStatePdu")) : class$org$web3d$xmsf$dis$EntityStatePdu);
        try {
            this.deserializePduHeader(entityStatePdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(entityStatePdu.getEntityID(), dataInputStream);
            entityStatePdu.setForceID(dataInputStream.readByte());
            entityStatePdu.setNumberOfArticulationParameters(dataInputStream.readByte());
            this.deserializeEntityType(entityStatePdu.getEntity(), dataInputStream);
            this.deserializeEntityType(entityStatePdu.getAlternativeEntity(), dataInputStream);
            this.deserializeVector3Float(entityStatePdu.getEntityLinearVelocity(), dataInputStream);
            this.deserializeVector3Double(entityStatePdu.getEntityLocation(), dataInputStream);
            this.deserializeEulerAnglesType(entityStatePdu.getEntityOrientation(), dataInputStream);
            entityStatePdu.setEntityAppearance(dataInputStream.readInt());
            this.deserializeDeadReckoningParameters(entityStatePdu.getDeadReckoningParameters(), dataInputStream);
            this.deserializeEntityMarking(entityStatePdu.getEntityMarking(), dataInputStream);
            entityStatePdu.setCapabilities(dataInputStream.readInt());
            this.deserializeArticulationParameters(entityStatePdu, dataInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
        return entityStatePdu;
    }

    public FirePdu unmarshallFirePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        FirePdu firePdu = (FirePdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$FirePdu == null ? (class$org$web3d$xmsf$dis$FirePdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.FirePdu")) : class$org$web3d$xmsf$dis$FirePdu);
        try {
            this.deserializePduHeader(firePdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(firePdu.getFiringEntityID(), dataInputStream);
            this.deserializeEntityID(firePdu.getTargetEntityID(), dataInputStream);
            this.deserializeEntityID(firePdu.getMunitionID(), dataInputStream);
            this.deserializeEventID(firePdu.getEventID(), dataInputStream);
            firePdu.setFireMissionIndex(dataInputStream.readInt());
            this.deserializeVector3Double(firePdu.getLocationInWorldCoordinates(), dataInputStream);
            this.deserializeBurstDescriptor(firePdu.getBurstDescriptor(), dataInputStream);
            this.deserializeVector3Float(firePdu.getVelocity(), dataInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling fire pdu " + exception);
        }
        return firePdu;
    }

    public DetonationPdu unmarshallDetonationPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        DetonationPdu detonationPdu = (DetonationPdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$DetonationPdu == null ? (class$org$web3d$xmsf$dis$DetonationPdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.DetonationPdu")) : class$org$web3d$xmsf$dis$DetonationPdu);
        try {
            this.deserializePduHeader(detonationPdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(detonationPdu.getFiringEntityID(), dataInputStream);
            this.deserializeEntityID(detonationPdu.getTargetEntityID(), dataInputStream);
            this.deserializeEntityID(detonationPdu.getMunitionID(), dataInputStream);
            this.deserializeEventID(detonationPdu.getEventID(), dataInputStream);
            this.deserializeVector3Float(detonationPdu.getVelocity(), dataInputStream);
            this.deserializeVector3Double(detonationPdu.getLocationInWorldCoordinates(), dataInputStream);
            this.deserializeBurstDescriptor(detonationPdu.getBurstDescriptor(), dataInputStream);
            this.deserializeVector3Float(detonationPdu.getLocationInEntityCoordinates(), dataInputStream);
            detonationPdu.setDetonationResult(dataInputStream.readByte());
            detonationPdu.setNumberOfArticulationParameters(dataInputStream.readByte());
            dataInputStream.readShort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling detonation pdu " + exception);
        }
        return detonationPdu;
    }

    public void setFastEspdus(boolean bl) {
        this.fastEspdus = bl;
    }

    public CollisionPdu unmarshallCollisionPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        CollisionPdu collisionPdu = (CollisionPdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$CollisionPdu == null ? (class$org$web3d$xmsf$dis$CollisionPdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.CollisionPdu")) : class$org$web3d$xmsf$dis$CollisionPdu);
        try {
            this.deserializePduHeader(collisionPdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(collisionPdu.getIssuingEntityID(), dataInputStream);
            this.deserializeEntityID(collisionPdu.getCollidingEntityID(), dataInputStream);
            this.deserializeEventID(collisionPdu.getEventID(), dataInputStream);
            collisionPdu.setCollisionType(dataInputStream.readByte());
            collisionPdu.setPadding(dataInputStream.readByte());
            this.deserializeVector3Float(collisionPdu.getVelocity(), dataInputStream);
            collisionPdu.setMass(dataInputStream.readFloat());
            this.deserializeVector3Float(collisionPdu.getLocationWithRespectToEntity(), dataInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling detonation pdu " + exception);
        }
        return collisionPdu;
    }

    public CreateEntityPdu unmarshallCreateEntityPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        CreateEntityPdu createEntityPdu = (CreateEntityPdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$CreateEntityPdu == null ? (class$org$web3d$xmsf$dis$CreateEntityPdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.CreateEntityPdu")) : class$org$web3d$xmsf$dis$CreateEntityPdu);
        try {
            this.deserializePduHeader(createEntityPdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(createEntityPdu.getOriginatingEntityID(), dataInputStream);
            this.deserializeEntityID(createEntityPdu.getReceivingEntityID(), dataInputStream);
            createEntityPdu.setRequestID(dataInputStream.readInt());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling create entity pdu " + exception);
        }
        return createEntityPdu;
    }

    public RemoveEntityPdu unmarshallRemoveEntityPdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        RemoveEntityPdu removeEntityPdu = (RemoveEntityPdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$RemoveEntityPdu == null ? (class$org$web3d$xmsf$dis$RemoveEntityPdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.RemoveEntityPdu")) : class$org$web3d$xmsf$dis$RemoveEntityPdu);
        try {
            this.deserializePduHeader(removeEntityPdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(removeEntityPdu.getOriginatingEntityID(), dataInputStream);
            this.deserializeEntityID(removeEntityPdu.getReceivingEntityID(), dataInputStream);
            removeEntityPdu.setRequestID(dataInputStream.readInt());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling remove entity pdu " + exception);
        }
        return removeEntityPdu;
    }

    public StartResumePdu unmarshallStartResumePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        StartResumePdu startResumePdu = (StartResumePdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$StartResumePdu == null ? (class$org$web3d$xmsf$dis$StartResumePdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.StartResumePdu")) : class$org$web3d$xmsf$dis$StartResumePdu);
        try {
            this.deserializePduHeader(startResumePdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(startResumePdu.getOriginatingEntityID(), dataInputStream);
            this.deserializeEntityID(startResumePdu.getReceivingEntityID(), dataInputStream);
            this.deserializeClockType(startResumePdu.getRealWorldTime(), dataInputStream);
            this.deserializeClockType(startResumePdu.getSimulationTime(), dataInputStream);
            startResumePdu.setRequestID(dataInputStream.readInt());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling start/resume pdu " + exception);
        }
        return startResumePdu;
    }

    public StopFreezePdu unmarshallStopFreezePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        StopFreezePdu stopFreezePdu = (StopFreezePdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$StopFreezePdu == null ? (class$org$web3d$xmsf$dis$StopFreezePdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.StopFreezePdu")) : class$org$web3d$xmsf$dis$StopFreezePdu);
        try {
            this.deserializePduHeader(stopFreezePdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(stopFreezePdu.getOriginatingEntityID(), dataInputStream);
            this.deserializeEntityID(stopFreezePdu.getReceivingEntityID(), dataInputStream);
            this.deserializeClockType(stopFreezePdu.getRealWorldTime(), dataInputStream);
            stopFreezePdu.setReason(dataInputStream.readByte());
            stopFreezePdu.setFrozenBehavior(dataInputStream.readByte());
            stopFreezePdu.setPadding(dataInputStream.readShort());
            stopFreezePdu.setRequestID(dataInputStream.readInt());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling stop/freeze pdu " + exception);
        }
        return stopFreezePdu;
    }

    public AcknowledgePdu unmarshallAcknowledgePdu(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        AcknowledgePdu acknowledgePdu = (AcknowledgePdu)this.objectPool.acquireInstance(class$org$web3d$xmsf$dis$AcknowledgePdu == null ? (class$org$web3d$xmsf$dis$AcknowledgePdu = DisUnmarshaller.class$("org.web3d.xmsf.dis.AcknowledgePdu")) : class$org$web3d$xmsf$dis$AcknowledgePdu);
        try {
            this.deserializePduHeader(acknowledgePdu.getPduHeader(), dataInputStream);
            this.deserializeEntityID(acknowledgePdu.getOriginatingEntityID(), dataInputStream);
            this.deserializeEntityID(acknowledgePdu.getReceivingEntityID(), dataInputStream);
            acknowledgePdu.setAcknowledgeFlag(dataInputStream.readShort());
            acknowledgePdu.setResponseFlag(dataInputStream.readShort());
            acknowledgePdu.setRequestID(dataInputStream.readInt());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem unmarshalling acknowledge pdu " + exception);
        }
        return acknowledgePdu;
    }

    private void deserializePduHeader(HeaderType headerType, DataInputStream dataInputStream) {
        try {
            headerType.setProtocolVersion(dataInputStream.readByte());
            headerType.setExerciseID(dataInputStream.readByte());
            headerType.setPduType(dataInputStream.readByte());
            headerType.setProtocolFamily(dataInputStream.readByte());
            headerType.setTimestamp(dataInputStream.readInt());
            headerType.setLength(dataInputStream.readShort());
            headerType.setPadding((short)0);
            dataInputStream.readShort();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
    }

    private void deserializeClockType(ClockType clockType, DataInputStream dataInputStream) {
        try {
            clockType.setHour(dataInputStream.readInt());
            clockType.setTimePastHour(dataInputStream.readInt());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
    }

    private void deserializeEntityID(EntityIDType entityIDType, DataInputStream dataInputStream) {
        try {
            entityIDType.setSite(dataInputStream.readShort());
            entityIDType.setApplication(dataInputStream.readShort());
            entityIDType.setEntity(dataInputStream.readShort());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
    }

    private void deserializeEventID(EventIDType eventIDType, DataInputStream dataInputStream) {
        try {
            eventIDType.setSite(dataInputStream.readShort());
            eventIDType.setApplication(dataInputStream.readShort());
            eventIDType.setEventNumber(dataInputStream.readShort());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
    }

    private void deserializeEntityType(EntityType entityType, DataInputStream dataInputStream) {
        try {
            entityType.setEntityKind(dataInputStream.readByte());
            entityType.setDomain(dataInputStream.readByte());
            entityType.setCountry(dataInputStream.readShort());
            entityType.setCategory(dataInputStream.readByte());
            entityType.setSubCategory(dataInputStream.readByte());
            entityType.setSpecific(dataInputStream.readByte());
            entityType.setExtra(dataInputStream.readByte());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
    }

    private void deserializeVector3Float(Vector3Float vector3Float, DataInputStream dataInputStream) {
        try {
            vector3Float.setX(dataInputStream.readFloat());
            vector3Float.setY(dataInputStream.readFloat());
            vector3Float.setX(dataInputStream.readFloat());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
    }

    public void deserializeEntityMarking(EntityMarking entityMarking, DataInputStream dataInputStream) {
        try {
            entityMarking.setCharacterSet(dataInputStream.readByte());
            byte[] byArray = entityMarking.getCharacters();
            for (int i = 0; i < 11; ++i) {
                byArray[i] = dataInputStream.readByte();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
    }

    private void deserializeVector3Double(Vector3Double vector3Double, DataInputStream dataInputStream) {
        try {
            vector3Double.setX(dataInputStream.readDouble());
            vector3Double.setY(dataInputStream.readDouble());
            vector3Double.setZ(dataInputStream.readDouble());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
    }

    private void deserializeArticulationParameters(EntityStatePdu entityStatePdu, DataInputStream dataInputStream) {
        try {
            int n = entityStatePdu.getNumberOfArticulationParameters();
            for (int i = 0; i < n; ++i) {
                ArticulationParametersType articulationParametersType = (ArticulationParametersType)entityStatePdu.getArticulationParameters().get(i);
                articulationParametersType.setParameterTypeDesignator(dataInputStream.readByte());
                articulationParametersType.setChange(dataInputStream.readShort());
                articulationParametersType.setIDPartAttachedTo(dataInputStream.readShort());
                articulationParametersType.setParameterType(dataInputStream.readInt());
                articulationParametersType.setParameterValue(dataInputStream.readDouble());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println(exception);
        }
    }

    private void deserializeEulerAnglesType(EulerAnglesType eulerAnglesType, DataInputStream dataInputStream) {
        try {
            eulerAnglesType.setPsi(dataInputStream.readFloat());
            eulerAnglesType.setTheta(dataInputStream.readFloat());
            eulerAnglesType.setPhi(dataInputStream.readFloat());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
    }

    private void deserializeDeadReckoningParameters(DeadReckoningParametersType deadReckoningParametersType, DataInputStream dataInputStream) {
        try {
            deadReckoningParametersType.setDeadReckoningAlgorithm(dataInputStream.readByte());
            byte[] byArray = deadReckoningParametersType.getOtherParameters();
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = dataInputStream.readByte();
            }
            this.deserializeVector3Float(deadReckoningParametersType.getEntityLinearAcceleration(), dataInputStream);
            this.deserializeVector3Float(deadReckoningParametersType.getEntityAngularVelocity(), dataInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException + " in deserializeDeadReckoningParameters");
        }
    }

    private void deserializeBurstDescriptor(BurstDescriptorType burstDescriptorType, DataInputStream dataInputStream) {
        try {
            this.deserializeEntityType(burstDescriptorType.getMunition(), dataInputStream);
            burstDescriptorType.setWarhead(dataInputStream.readShort());
            burstDescriptorType.setFuse(dataInputStream.readShort());
            burstDescriptorType.setQuantity(dataInputStream.readShort());
            burstDescriptorType.setRate(dataInputStream.readShort());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Problem reading burst description " + exception);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

