/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.xmsf.disutil;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.web3d.xmsf.dis.ArticulationParametersType;
import org.web3d.xmsf.dis.BurstDescriptorType;
import org.web3d.xmsf.dis.CollisionPdu;
import org.web3d.xmsf.dis.DISType;
import org.web3d.xmsf.dis.DeadReckoningParametersType;
import org.web3d.xmsf.dis.DetonationPdu;
import org.web3d.xmsf.dis.EntityIDType;
import org.web3d.xmsf.dis.EntityMarking;
import org.web3d.xmsf.dis.EntityStatePduType;
import org.web3d.xmsf.dis.EntityType;
import org.web3d.xmsf.dis.EulerAnglesType;
import org.web3d.xmsf.dis.EventIDType;
import org.web3d.xmsf.dis.FirePdu;
import org.web3d.xmsf.dis.HeaderType;
import org.web3d.xmsf.dis.ProtocolDataUnitType;
import org.web3d.xmsf.dis.Vector3Double;
import org.web3d.xmsf.dis.Vector3Float;
import org.web3d.xmsf.disutil.PduFactory;

public class DisMarshaller1995 {
    public static long startupTime = System.currentTimeMillis();

    public void marshallPdus(List list, OutputStream outputStream) throws IOException {
        if (!this.listElementsArePdus(list)) {
            throw new IOException("Not all elements in the list are subclasses of ProtocolDataUnitType");
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((String)"org.web3d.xmsf.dis");
            PduFactory pduFactory = new PduFactory();
            DISType dISType = pduFactory.getDIS();
            List list2 = dISType.getAcknowledgePduOrActionRequestPduOrActionResponsePdu();
            list2.addAll(list);
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)dISType, outputStream);
        }
        catch (Exception exception) {
            throw new IOException("Unable to write DIS objects to output stream in XML format");
        }
    }

    public void marshallPdus(List list, String string) throws IOException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.marshallPdus(list, fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new IOException("Unable to open file to write Java DIS objects to XML");
        }
    }

    private boolean listElementsArePdus(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ProtocolDataUnitType) continue;
            return false;
        }
        return true;
    }

    public byte[] marshallPduToSend(ProtocolDataUnitType protocolDataUnitType) {
        long l = System.currentTimeMillis();
        protocolDataUnitType.getPduHeader().setTimestamp((int)(l - startupTime));
        return this.marshallPdu(protocolDataUnitType);
    }

    public byte[] marshallPdu(ProtocolDataUnitType protocolDataUnitType) {
        switch (protocolDataUnitType.getPduHeader().getPduType()) {
            case 1: {
                return this.marshallEntityStatePdu((EntityStatePduType)protocolDataUnitType);
            }
            case 2: {
                return this.marshallFirePdu((FirePdu)protocolDataUnitType);
            }
            case 3: {
                return this.marshallDetonationPdu((DetonationPdu)protocolDataUnitType);
            }
            case 4: {
                return this.marshallCollisionPdu((CollisionPdu)protocolDataUnitType);
            }
        }
        System.out.println("Unrecognized PDU type, " + protocolDataUnitType.getPduHeader().getPduType());
        return null;
    }

    public byte[] marshallEntityStatePdu(EntityStatePduType entityStatePduType) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(entityStatePduType.getPduHeader(), dataOutputStream);
            this.serializeEntityID(entityStatePduType.getEntityID(), dataOutputStream);
            dataOutputStream.writeByte(entityStatePduType.getForceID());
            dataOutputStream.writeByte(entityStatePduType.getNumberOfArticulationParameters());
            this.serializeEntityType(entityStatePduType.getEntity(), dataOutputStream);
            this.serializeEntityType(entityStatePduType.getAlternativeEntity(), dataOutputStream);
            this.serializeVector3Float(entityStatePduType.getEntityLinearVelocity(), dataOutputStream);
            this.serializeVector3Double(entityStatePduType.getEntityLocation(), dataOutputStream);
            this.serializeEulerAnglesType(entityStatePduType.getEntityOrientation(), dataOutputStream);
            dataOutputStream.writeInt(entityStatePduType.getEntityAppearance());
            this.serializeDeadReckoningParameters(entityStatePduType.getDeadReckoningParameters(), dataOutputStream);
            this.serializeMarking(entityStatePduType.getEntityMarking(), dataOutputStream);
            dataOutputStream.writeInt(entityStatePduType.getCapabilities());
            this.serializeArticulationParameters(entityStatePduType.getArticulationParameters(), dataOutputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public byte[] marshallFirePdu(FirePdu firePdu) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(firePdu.getPduHeader(), dataOutputStream);
            this.serializeEntityID(firePdu.getFiringEntityID(), dataOutputStream);
            this.serializeEntityID(firePdu.getTargetEntityID(), dataOutputStream);
            this.serializeEntityID(firePdu.getMunitionID(), dataOutputStream);
            this.serializeEventID(firePdu.getEventID(), dataOutputStream);
            dataOutputStream.writeInt(firePdu.getFireMissionIndex());
            this.serializeVector3Double(firePdu.getLocationInWorldCoordinates(), dataOutputStream);
            this.serializeBurstDescriptor(firePdu.getBurstDescriptor(), dataOutputStream);
            this.serializeVector3Float(firePdu.getVelocity(), dataOutputStream);
            dataOutputStream.writeFloat(firePdu.getRange());
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Fire PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallDetonationPdu(DetonationPdu detonationPdu) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(detonationPdu.getPduHeader(), dataOutputStream);
            this.serializeEntityID(detonationPdu.getFiringEntityID(), dataOutputStream);
            this.serializeEntityID(detonationPdu.getTargetEntityID(), dataOutputStream);
            this.serializeEntityID(detonationPdu.getMunitionID(), dataOutputStream);
            this.serializeEventID(detonationPdu.getEventID(), dataOutputStream);
            this.serializeVector3Float(detonationPdu.getVelocity(), dataOutputStream);
            this.serializeVector3Double(detonationPdu.getLocationInWorldCoordinates(), dataOutputStream);
            this.serializeBurstDescriptor(detonationPdu.getBurstDescriptor(), dataOutputStream);
            this.serializeVector3Float(detonationPdu.getLocationInEntityCoordinates(), dataOutputStream);
            dataOutputStream.writeByte(detonationPdu.getDetonationResult());
            dataOutputStream.writeByte(detonationPdu.getNumberOfArticulationParameters());
            dataOutputStream.writeShort(0);
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Fire PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] marshallCollisionPdu(CollisionPdu collisionPdu) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            this.serializePduHeader(collisionPdu.getPduHeader(), dataOutputStream);
            this.serializeEntityID(collisionPdu.getIssuingEntityID(), dataOutputStream);
            this.serializeEntityID(collisionPdu.getCollidingEntityID(), dataOutputStream);
            this.serializeEventID(collisionPdu.getEventID(), dataOutputStream);
            dataOutputStream.writeByte(collisionPdu.getCollisionType());
            dataOutputStream.writeByte(collisionPdu.getPadding());
            this.serializeVector3Float(collisionPdu.getVelocity(), dataOutputStream);
            dataOutputStream.writeFloat(collisionPdu.getMass());
            this.serializeVector3Float(collisionPdu.getLocationWithRespectToEntity(), dataOutputStream);
        }
        catch (Exception exception) {
            System.out.println("Problem marshalling Fire PDU " + exception);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void serializePduHeader(HeaderType headerType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(headerType.getProtocolVersion());
            dataOutputStream.writeByte((byte)headerType.getExerciseID());
            dataOutputStream.writeByte(headerType.getPduType());
            dataOutputStream.writeByte(headerType.getProtocolFamily());
            dataOutputStream.writeInt((int)headerType.getTimestamp());
            dataOutputStream.writeShort(headerType.getLength());
            dataOutputStream.writeShort(headerType.getPadding());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeEntityID(EntityIDType entityIDType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeShort(entityIDType.getSite());
            dataOutputStream.writeShort(entityIDType.getApplication());
            dataOutputStream.writeShort(entityIDType.getEntity());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeEventID(EventIDType eventIDType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeShort(eventIDType.getSite());
            dataOutputStream.writeShort(eventIDType.getApplication());
            dataOutputStream.writeShort(eventIDType.getEventNumber());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void serializeEntityType(EntityType entityType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(entityType.getEntityKind());
            dataOutputStream.writeByte(entityType.getDomain());
            dataOutputStream.writeShort(entityType.getCountry());
            dataOutputStream.writeByte(entityType.getCategory());
            dataOutputStream.writeByte(entityType.getSubCategory());
            dataOutputStream.writeByte(entityType.getSpecific());
            dataOutputStream.writeByte(entityType.getExtra());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeVector3Float(Vector3Float vector3Float, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeFloat(vector3Float.getX());
            dataOutputStream.writeFloat(vector3Float.getY());
            dataOutputStream.writeFloat(vector3Float.getZ());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeVector3Double(Vector3Double vector3Double, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeDouble(vector3Double.getX());
            dataOutputStream.writeDouble(vector3Double.getY());
            dataOutputStream.writeDouble(vector3Double.getZ());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeEulerAnglesType(EulerAnglesType eulerAnglesType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeFloat(eulerAnglesType.getPsi());
            dataOutputStream.writeFloat(eulerAnglesType.getTheta());
            dataOutputStream.writeFloat(eulerAnglesType.getPhi());
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeDeadReckoningParameters(DeadReckoningParametersType deadReckoningParametersType, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(deadReckoningParametersType.getDeadReckoningAlgorithm());
            byte[] byArray = deadReckoningParametersType.getOtherParameters();
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
            this.serializeVector3Float(deadReckoningParametersType.getEntityLinearAcceleration(), dataOutputStream);
            this.serializeVector3Float(deadReckoningParametersType.getEntityAngularVelocity(), dataOutputStream);
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeMarking(EntityMarking entityMarking, DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeByte(entityMarking.getCharacterSet());
            byte[] byArray = entityMarking.getCharacters();
            for (int i = 0; i < byArray.length; ++i) {
                dataOutputStream.writeByte(byArray[i]);
            }
        }
        catch (IOException iOException) {
            System.out.println(iOException);
        }
    }

    private void serializeBurstDescriptor(BurstDescriptorType burstDescriptorType, DataOutputStream dataOutputStream) {
        try {
            this.serializeEntityType(burstDescriptorType.getMunition(), dataOutputStream);
            dataOutputStream.writeShort(burstDescriptorType.getWarhead());
            dataOutputStream.writeShort(burstDescriptorType.getFuse());
            dataOutputStream.writeShort(burstDescriptorType.getQuantity());
            dataOutputStream.writeShort(burstDescriptorType.getRate());
        }
        catch (Exception exception) {
            System.out.println("Problem writing burst description " + exception);
        }
    }

    private void serializeArticulationParameters(List list, DataOutputStream dataOutputStream) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                ArticulationParametersType articulationParametersType = (ArticulationParametersType)list.get(i);
                dataOutputStream.writeByte(articulationParametersType.getParameterTypeDesignator());
                dataOutputStream.writeShort(articulationParametersType.getChange());
                dataOutputStream.writeShort(articulationParametersType.getIDPartAttachedTo());
                dataOutputStream.writeInt(articulationParametersType.getParameterType());
                dataOutputStream.writeDouble(articulationParametersType.getParameterValue());
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

