/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.sound3d;

import java.nio.ByteBuffer;
import net.java.games.joal.AL;

public class Buffer {
    public static final int FORMAT_MONO8 = 4352;
    public static final int FORMAT_MONO16 = 4353;
    public static final int FORMAT_STEREO8 = 4354;
    public static final int FORMAT_STEREO16 = 4355;
    final int bufferID;
    private ByteBuffer data;
    private boolean isConfigured = false;
    private final AL al;

    Buffer(AL aL, int n) {
        this.bufferID = n;
        this.al = aL;
    }

    public void configure(ByteBuffer byteBuffer, int n, int n2) {
        if (!this.isConfigured) {
            this.al.alBufferData(this.bufferID, n, byteBuffer, byteBuffer.capacity(), n2);
        }
    }

    public void delete() {
        this.data = null;
        this.al.alDeleteBuffers(1, new int[]{this.bufferID}, 0);
    }

    public int getBitDepth() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8194, nArray, 0);
        return nArray[0];
    }

    public int getNumChannels() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8195, nArray, 0);
        return nArray[0];
    }

    public ByteBuffer getData() {
        return this.data;
    }

    public int getFrequency() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8193, nArray, 0);
        return nArray[0];
    }

    public int getSize() {
        int[] nArray = new int[1];
        this.al.alGetBufferi(this.bufferID, 8196, nArray, 0);
        return nArray[0];
    }
}

