/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.joal.util;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;
import net.java.games.joal.util.WAVData;
import net.java.games.joal.util.WAVLoader;

public final class ALut {
    private static ALC alc;

    private ALut() {
    }

    public static void alutInit() throws ALException {
        String string;
        alc = ALFactory.getALC();
        ALCdevice aLCdevice = alc.alcOpenDevice(string = null);
        if (aLCdevice == null) {
            throw new ALException("Error opening default OpenAL device");
        }
        ALCcontext aLCcontext = alc.alcCreateContext(aLCdevice, null);
        if (aLCcontext == null) {
            throw new ALException("Error creating OpenAL context");
        }
        alc.alcMakeContextCurrent(aLCcontext);
        if (alc.alcGetError(aLCdevice) != 0) {
            throw new ALException("Error making OpenAL context current");
        }
    }

    public static void alutLoadWAVFile(String string, int[] nArray, ByteBuffer[] byteBufferArray, int[] nArray2, int[] nArray3, int[] nArray4) throws ALException {
        try {
            WAVData wAVData = WAVLoader.loadFromFile(string);
            nArray[0] = wAVData.format;
            byteBufferArray[0] = wAVData.data;
            nArray2[0] = wAVData.size;
            nArray3[0] = wAVData.freq;
            nArray4[0] = wAVData.loop ? 1 : 0;
        }
        catch (Exception exception) {
            throw new ALException(exception);
        }
    }

    public static void alutLoadWAVFile(InputStream inputStream, int[] nArray, ByteBuffer[] byteBufferArray, int[] nArray2, int[] nArray3, int[] nArray4) throws ALException {
        try {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            WAVData wAVData = WAVLoader.loadFromStream(inputStream);
            nArray[0] = wAVData.format;
            byteBufferArray[0] = wAVData.data;
            nArray2[0] = wAVData.size;
            nArray3[0] = wAVData.freq;
            nArray4[0] = wAVData.loop ? 1 : 0;
        }
        catch (Exception exception) {
            throw new ALException(exception);
        }
    }
}

