/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gluegen.runtime;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class BufferFactory {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    public static ByteBuffer newDirectByteBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static boolean isDirect(Buffer buffer) {
        if (buffer == null) {
            return true;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).isDirect();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).isDirect();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).isDirect();
        }
        if (buffer instanceof CharBuffer) {
            return ((CharBuffer)buffer).isDirect();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).isDirect();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).isDirect();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).isDirect();
        }
        throw new RuntimeException("Unknown buffer type " + buffer.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        if (buffer instanceof ByteBuffer) {
            return buffer.position();
        }
        if (buffer instanceof FloatBuffer) {
            return buffer.position() * 4;
        }
        if (buffer instanceof IntBuffer) {
            return buffer.position() * 4;
        }
        if (buffer instanceof ShortBuffer) {
            return buffer.position() * 2;
        }
        if (buffer instanceof DoubleBuffer) {
            return buffer.position() * 8;
        }
        if (buffer instanceof LongBuffer) {
            return buffer.position() * 8;
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buffer.getClass().getName());
    }

    public static Object getArray(Buffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).array();
        }
        if (buffer instanceof FloatBuffer) {
            return ((FloatBuffer)buffer).array();
        }
        if (buffer instanceof IntBuffer) {
            return ((IntBuffer)buffer).array();
        }
        if (buffer instanceof ShortBuffer) {
            return ((ShortBuffer)buffer).array();
        }
        if (buffer instanceof DoubleBuffer) {
            return ((DoubleBuffer)buffer).array();
        }
        if (buffer instanceof LongBuffer) {
            return ((LongBuffer)buffer).array();
        }
        throw new RuntimeException("Disallowed array backing store type in buffer " + buffer.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        int n = buffer.position();
        if (buffer instanceof ByteBuffer) {
            return ((ByteBuffer)buffer).arrayOffset() + n;
        }
        if (buffer instanceof FloatBuffer) {
            return 4 * (((FloatBuffer)buffer).arrayOffset() + n);
        }
        if (buffer instanceof IntBuffer) {
            return 4 * (((IntBuffer)buffer).arrayOffset() + n);
        }
        if (buffer instanceof ShortBuffer) {
            return 2 * (((ShortBuffer)buffer).arrayOffset() + n);
        }
        if (buffer instanceof DoubleBuffer) {
            return 8 * (((DoubleBuffer)buffer).arrayOffset() + n);
        }
        if (buffer instanceof LongBuffer) {
            return 8 * (((LongBuffer)buffer).arrayOffset() + n);
        }
        throw new RuntimeException("Unknown buffer type " + buffer.getClass().getName());
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (byArray.length - n));
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (cArray.length - n));
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (sArray.length - n));
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (nArray.length - n));
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (lArray.length - n));
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (fArray.length - n));
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (dArray.length - n));
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        int n2 = buffer.remaining();
        int n3 = 0;
        if (buffer instanceof ByteBuffer) {
            n3 = n2;
        } else if (buffer instanceof FloatBuffer) {
            n3 = n2 * 4;
        } else if (buffer instanceof IntBuffer) {
            n3 = n2 * 4;
        } else if (buffer instanceof ShortBuffer) {
            n3 = n2 * 2;
        } else if (buffer instanceof DoubleBuffer) {
            n3 = n2 * 8;
        } else if (buffer instanceof LongBuffer) {
            n3 = n2 * 8;
        }
        if (n3 < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining bytes in buffer, only had " + n3);
        }
    }
}

