/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.event.VrmlEventListener;
import vrml.eai.field.EventOutSFVec2f;

class EventOutSFVec2fWrapper
extends EventOutSFVec2f
implements ExternalOutputBuffer,
EventWrapper {
    static final float[] DEFAULT_FIELD_VALUE = new float[]{0.0f, 0.0f};
    boolean isStored;
    float[] storedValue;
    EAIEventAdapterFactory theEventAdapterFactory;
    int theFieldID;
    VRMLNodeType theNode;

    EventOutSFVec2fWrapper(VRMLNodeType vRMLNodeType, int n, EAIEventAdapterFactory eAIEventAdapterFactory, boolean bl) {
        this.fieldType = 10;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theEventAdapterFactory = eAIEventAdapterFactory;
        if (bl) {
            this.loadOutputValue();
        }
    }

    public void addVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).addListener(this.theFieldID, vrmlEventListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data", invalidFieldException);
        }
    }

    public void getValue(float[] fArray) {
        if (this.isStored) {
            System.arraycopy(this.storedValue, 0, fArray, 0, 2);
        } else {
            try {
                VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
                if (vRMLFieldData.floatArrayValue == null) {
                    System.arraycopy(DEFAULT_FIELD_VALUE, 0, fArray, 0, 2);
                } else {
                    System.arraycopy(vRMLFieldData.floatArrayValue, 0, fArray, 0, 2);
                }
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Error reading field value", invalidFieldException);
            }
        }
    }

    public float[] getValue() {
        float[] fArray = new float[2];
        this.getValue(fArray);
        return fArray;
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public void loadOutputValue() {
        this.isStored = false;
        if (this.storedValue == null) {
            this.storedValue = new float[2];
        }
        this.getValue(this.storedValue);
        this.isStored = true;
    }

    public void removeVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).removeListener(this.theFieldID, vrmlEventListener);
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data", invalidFieldException);
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
    }

    public void reset() {
        this.theNode = null;
        this.theFieldID = -1;
        this.isStored = false;
    }
}

