/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.eai.EAIEventAdapterFactory;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.event.VrmlEventListener;
import vrml.eai.field.EventOutSFImage;

class EventOutSFImageWrapper
extends EventOutSFImage
implements ExternalOutputBuffer,
EventWrapper {
    boolean isStored;
    int[] storedPixels;
    int storedHeight;
    int storedWidth;
    int storedComponents;
    EAIEventAdapterFactory theEventAdapterFactory;
    int theFieldID;
    VRMLNodeType theNode;

    EventOutSFImageWrapper(VRMLNodeType vRMLNodeType, int n, EAIEventAdapterFactory eAIEventAdapterFactory, boolean bl) {
        this.fieldType = 4;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theEventAdapterFactory = eAIEventAdapterFactory;
        this.isStored = bl;
        if (this.isStored) {
            this.loadOutputValue();
        }
    }

    public void addVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).addListener(this.theFieldID, vrmlEventListener);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getComponents() {
        if (this.isStored) {
            return this.storedComponents;
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (vRMLFieldData.intArrayValue == null) {
                return 0;
            }
            return vRMLFieldData.intArrayValue[2];
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting value.", invalidFieldException);
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("NullPointerException Error getting value.", nullPointerException);
        }
    }

    public int getHeight() {
        if (this.isStored) {
            return this.storedHeight;
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (vRMLFieldData.intArrayValue == null) {
                return 0;
            }
            return vRMLFieldData.intArrayValue[1];
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting value.");
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("NullPointerException Error getting value.");
        }
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int getWidth() {
        if (this.isStored) {
            return this.storedWidth;
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (vRMLFieldData.intArrayValue == null) {
                return 0;
            }
            return vRMLFieldData.intArrayValue[0];
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting value.");
        }
        catch (NullPointerException nullPointerException) {
            throw new RuntimeException("NullPointerException Error getting value.");
        }
    }

    public void getPixels(int[] nArray) {
        if (this.isStored) {
            System.arraycopy(this.storedPixels, 0, nArray, 0, this.storedPixels.length);
        } else {
            try {
                VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
                System.arraycopy(vRMLFieldData.intArrayValue, 3, nArray, 0, vRMLFieldData.numElements - 3);
            }
            catch (InvalidFieldException invalidFieldException) {
                throw new RuntimeException("Error getting value.");
            }
        }
    }

    public int[] getPixels() {
        if (this.isStored) {
            int[] nArray = new int[this.storedPixels.length];
            System.arraycopy(this.storedPixels, 0, nArray, 0, this.storedPixels.length);
            return nArray;
        }
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (vRMLFieldData.numElements < 3) {
                return new int[0];
            }
            int[] nArray = new int[vRMLFieldData.numElements - 3];
            System.arraycopy(vRMLFieldData.intArrayValue, 3, nArray, 0, vRMLFieldData.numElements - 3);
            return nArray;
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting value.");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public void loadOutputValue() {
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            int n = vRMLFieldData.intArrayValue[0];
            int n2 = vRMLFieldData.intArrayValue[1];
            if (this.storedPixels == null || n != this.storedWidth || n2 != this.storedHeight) {
                this.storedPixels = new int[vRMLFieldData.numElements - 3];
                this.storedHeight = n2;
                this.storedWidth = n;
            }
            this.storedComponents = vRMLFieldData.intArrayValue[2];
            if (this.storedHeight != 0 & this.storedWidth != 0) {
                System.arraycopy(vRMLFieldData.intArrayValue, 3, this.storedPixels, 0, this.storedPixels.length);
            } else {
                this.storedPixels = new int[0];
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting stored field value.");
        }
    }

    public void removeVrmlEventListener(VrmlEventListener vrmlEventListener) {
        this.theEventAdapterFactory.getAdapter(this.theNode).removeListener(this.theFieldID, vrmlEventListener);
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
    }

    public void reset() {
        this.theNode = null;
        this.theFieldID = -1;
        this.isStored = false;
    }
}

