/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.field.EventInSFImage;

class EventInSFImageWrapper
extends EventInSFImage
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    int[] storedValue;
    int theFieldID;
    VRMLNodeType theNode;
    ExternalEventQueue theQueue;

    EventInSFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue) {
        this.fieldType = 4;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theQueue = externalEventQueue;
    }

    EventInSFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, int[] nArray) {
        this(vRMLNodeType, n, externalEventQueue);
        this.hasStoredValue = true;
        this.storedValue = nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, this.storedValue.length);
            }
            finally {
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return false;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(int n, int n2, int n3, int[] nArray) {
        EventInSFImageWrapper eventInSFImageWrapper;
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Invalid image size");
        }
        if (n3 < 0 || n3 > 4) {
            throw new IllegalArgumentException("Invalid number of components");
        }
        if (!this.hasStoredValue) {
            eventInSFImageWrapper = this;
            this.storeValue(n, n2, n3, nArray);
        } else {
            int[] nArray2 = new int[n * n2 + 3];
            nArray2[0] = n;
            nArray2[1] = n2;
            nArray2[2] = n3;
            System.arraycopy(nArray, 0, nArray2, 3, n2 * n);
            eventInSFImageWrapper = new EventInSFImageWrapper(this.theNode, this.theFieldID, this.theQueue, nArray2);
        }
        this.theQueue.processEvent(eventInSFImageWrapper);
    }

    private void storeValue(int n, int n2, int n3, int[] nArray) {
        this.hasStoredValue = true;
        int n4 = n2 * n;
        if (this.storedValue == null || this.storedValue.length != n4 + 3) {
            this.storedValue = new int[n4 + 3];
        }
        this.storedValue[0] = n;
        this.storedValue[1] = n2;
        this.storedValue[2] = n3;
        System.arraycopy(nArray, 0, this.storedValue, 3, n4);
    }
}

