/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.field.EventInMFTime;

class EventInMFTimeWrapper
extends EventInMFTime
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    boolean isSet1Value;
    double[] storedValue;
    VRMLNodeType theNode;
    int theFieldID;
    ExternalEventQueue theQueue;

    EventInMFTimeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue) {
        this.fieldType = 18;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theQueue = externalEventQueue;
    }

    EventInMFTimeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, double[] dArray) {
        this(vRMLNodeType, n, externalEventQueue);
        this.storeValue(dArray);
    }

    EventInMFTimeWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, int n2, double d) {
        this(vRMLNodeType, n, externalEventQueue);
        this.loadValue();
        this.store1Value(n2, d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, this.storedValue.length);
            }
            finally {
                this.isSet1Value = false;
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return this.isSet1Value;
    }

    private void loadValue() {
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (this.storedValue == null || this.storedValue.length != vRMLFieldData.numElements) {
                this.storedValue = new double[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.doubleArrayValue, 0, this.storedValue, 0, vRMLFieldData.numElements);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException Error setting EventIn value.");
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException Error setting EventIn value.");
        }
        this.hasStoredValue = true;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(double[] dArray) {
        EventInMFTimeWrapper eventInMFTimeWrapper;
        if (!this.hasStoredValue) {
            eventInMFTimeWrapper = this;
            this.storeValue(dArray);
        } else {
            eventInMFTimeWrapper = new EventInMFTimeWrapper(this.theNode, this.theFieldID, this.theQueue, dArray);
        }
        this.theQueue.processEvent(eventInMFTimeWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, double d) {
        Object object = this.theQueue.eventLock;
        synchronized (object) {
            EventInMFTimeWrapper eventInMFTimeWrapper = (EventInMFTimeWrapper)this.theQueue.getLast(this);
            if (eventInMFTimeWrapper == null || !eventInMFTimeWrapper.isSet1Value) {
                if (!this.hasStoredValue) {
                    eventInMFTimeWrapper = this;
                    this.loadValue();
                    this.store1Value(n, d);
                } else {
                    eventInMFTimeWrapper = new EventInMFTimeWrapper(this.theNode, this.theFieldID, this.theQueue, n, d);
                }
                this.theQueue.processEvent(eventInMFTimeWrapper);
            } else {
                eventInMFTimeWrapper.store1Value(n, d);
            }
        }
    }

    private void storeValue(double[] dArray) {
        this.hasStoredValue = true;
        if (dArray != null) {
            if (this.storedValue == null || this.storedValue.length != dArray.length) {
                this.storedValue = new double[dArray.length];
            }
            System.arraycopy(dArray, 0, this.storedValue, 0, dArray.length);
        } else {
            this.storedValue = null;
        }
    }

    private void store1Value(int n, double d) {
        this.isSet1Value = true;
        this.storedValue[n] = d;
    }
}

