/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.field.EventInMFInt32;

class EventInMFInt32Wrapper
extends EventInMFInt32
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    boolean isSet1Value;
    int[] storedValue;
    int theFieldID;
    VRMLNodeType theNode;
    ExternalEventQueue theQueue;

    public EventInMFInt32Wrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue) {
        this.fieldType = 14;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theQueue = externalEventQueue;
    }

    EventInMFInt32Wrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, int[] nArray) {
        this(vRMLNodeType, n, externalEventQueue);
        this.storeValue(nArray);
    }

    EventInMFInt32Wrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, int n2, int n3) {
        this(vRMLNodeType, n, externalEventQueue);
        this.loadValue();
        this.store1Value(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, this.storedValue.length);
            }
            finally {
                this.isSet1Value = false;
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return this.isSet1Value;
    }

    private void loadValue() {
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (this.storedValue == null || this.storedValue.length != vRMLFieldData.numElements) {
                this.storedValue = new int[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedValue, 0, vRMLFieldData.numElements);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException Error setting EventIn value.");
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException Error setting EventIn value.");
        }
        this.hasStoredValue = true;
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(int[] nArray) {
        EventInMFInt32Wrapper eventInMFInt32Wrapper;
        if (!this.hasStoredValue) {
            eventInMFInt32Wrapper = this;
            this.storeValue(nArray);
        } else {
            eventInMFInt32Wrapper = new EventInMFInt32Wrapper(this.theNode, this.theFieldID, this.theQueue, nArray);
        }
        this.theQueue.processEvent(eventInMFInt32Wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, int n2) throws ArrayIndexOutOfBoundsException {
        Object object = this.theQueue.eventLock;
        synchronized (object) {
            EventInMFInt32Wrapper eventInMFInt32Wrapper = (EventInMFInt32Wrapper)this.theQueue.getLast(this);
            if (eventInMFInt32Wrapper == null || !eventInMFInt32Wrapper.isSet1Value) {
                if (!this.hasStoredValue) {
                    eventInMFInt32Wrapper = this;
                    this.loadValue();
                    this.store1Value(n, n2);
                } else {
                    eventInMFInt32Wrapper = new EventInMFInt32Wrapper(this.theNode, this.theFieldID, this.theQueue, n, n2);
                }
                this.theQueue.processEvent(eventInMFInt32Wrapper);
            } else {
                eventInMFInt32Wrapper.store1Value(n, n2);
            }
        }
    }

    private void storeValue(int[] nArray) {
        this.hasStoredValue = true;
        if (this.storedValue == null || this.storedValue.length != nArray.length) {
            this.storedValue = new int[nArray.length];
        }
        System.arraycopy(nArray, 0, this.storedValue, 0, this.storedValue.length);
    }

    private void store1Value(int n, int n2) {
        this.isSet1Value = true;
        this.storedValue[n] = n2;
    }
}

