/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.eai;

import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EventWrapper;
import vrml.eai.field.EventInMFFloat;

class EventInMFFloatWrapper
extends EventInMFFloat
implements ExternalEvent,
EventWrapper {
    boolean hasStoredValue;
    boolean isSet1Value;
    float[] storedValue;
    int theFieldID;
    VRMLNodeType theNode;
    ExternalEventQueue theQueue;

    EventInMFFloatWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue) {
        this.fieldType = 13;
        this.theNode = vRMLNodeType;
        this.theFieldID = n;
        this.theQueue = externalEventQueue;
    }

    EventInMFFloatWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, float[] fArray) {
        this(vRMLNodeType, n, externalEventQueue);
        this.storeValue(fArray);
    }

    EventInMFFloatWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, int n2, float f) {
        this(vRMLNodeType, n, externalEventQueue);
        this.loadValue();
        this.store1Value(n2, f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            try {
                this.theNode.setValue(this.theFieldID, this.storedValue, this.storedValue.length);
            }
            finally {
                this.isSet1Value = false;
                this.hasStoredValue = false;
            }
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException setting EventIn value.", invalidFieldException);
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException setting EventIn value.", invalidFieldValueException);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof EventWrapper) {
            EventWrapper eventWrapper = (EventWrapper)object;
            return eventWrapper.getFieldNode() == this.theNode && eventWrapper.getFieldID() == this.theFieldID && eventWrapper.getType() == this.getType();
        }
        return super.equals(object);
    }

    public int getFieldID() {
        return this.theFieldID;
    }

    public VRMLNodeType getFieldNode() {
        return this.theNode;
    }

    public Object getUserData() {
        try {
            return this.theNode.getUserData(this.theFieldID);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error getting user data");
        }
    }

    public int hashCode() {
        return this.theNode.hashCode() + this.theFieldID;
    }

    public boolean isConglomerating() {
        return this.isSet1Value;
    }

    private void loadValue() {
        try {
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.theFieldID);
            if (this.storedValue == null || this.storedValue.length != vRMLFieldData.numElements) {
                this.storedValue = new float[vRMLFieldData.numElements];
            }
            System.arraycopy(vRMLFieldData.floatArrayValue, 0, this.storedValue, 0, vRMLFieldData.numElements);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("InvalidFieldException Error setting EventIn value.");
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            throw new RuntimeException("InvalidFieldValueException Error setting EventIn value.");
        }
        this.hasStoredValue = true;
    }

    public void setUserData(Object object) {
        try {
            this.theNode.setUserData(this.theFieldID, object);
        }
        catch (InvalidFieldException invalidFieldException) {
            throw new RuntimeException("Error setting user data");
        }
    }

    public void setValue(float[] fArray) {
        EventInMFFloatWrapper eventInMFFloatWrapper;
        if (!this.hasStoredValue) {
            eventInMFFloatWrapper = this;
            this.storeValue(fArray);
        } else {
            eventInMFFloatWrapper = new EventInMFFloatWrapper(this.theNode, this.theFieldID, this.theQueue, fArray);
        }
        this.theQueue.processEvent(eventInMFFloatWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set1Value(int n, float f) {
        Object object = this.theQueue.eventLock;
        synchronized (object) {
            EventInMFFloatWrapper eventInMFFloatWrapper = (EventInMFFloatWrapper)this.theQueue.getLast(this);
            if (eventInMFFloatWrapper == null || !eventInMFFloatWrapper.isSet1Value) {
                if (!this.hasStoredValue) {
                    eventInMFFloatWrapper = this;
                    this.loadValue();
                    this.store1Value(n, f);
                } else {
                    eventInMFFloatWrapper = new EventInMFFloatWrapper(this.theNode, this.theFieldID, this.theQueue, n, f);
                }
                this.theQueue.processEvent(eventInMFFloatWrapper);
            } else {
                eventInMFFloatWrapper.store1Value(n, f);
            }
        }
    }

    private void storeValue(float[] fArray) {
        this.hasStoredValue = true;
        if (fArray != null) {
            if (this.storedValue == null || this.storedValue.length != fArray.length) {
                this.storedValue = new float[fArray.length];
            }
            System.arraycopy(fArray, 0, this.storedValue, 0, fArray.length);
        } else {
            fArray = null;
        }
    }

    private void store1Value(int n, float f) {
        this.isSet1Value = true;
        this.storedValue[n] = f;
    }
}

