/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.buffer;

import java.util.LinkedList;
import java.util.Vector;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEventAdapter;

public abstract class BaseExternalEventAdapter
implements ExternalEventAdapter {
    protected VRMLNodeType parentNode;
    Vector[] listenerArray;
    protected LinkedList[] buffers;
    protected VRMLClock timeClock;

    public BaseExternalEventAdapter(VRMLNodeType vRMLNodeType, VRMLClock vRMLClock) {
        this.parentNode = vRMLNodeType;
        this.timeClock = vRMLClock;
    }

    public void addListener(int n, Object object) {
        Vector vector = this.checkListeners(n);
        vector.addElement(object);
    }

    synchronized Vector checkListeners(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid field ID");
        }
        if (this.listenerArray != null) {
            if (n >= this.listenerArray.length) {
                Vector[] vectorArray = new Vector[n + 1];
                LinkedList[] linkedListArray = new LinkedList[n + 1];
                System.arraycopy(this.listenerArray, 0, vectorArray, 0, this.listenerArray.length);
                System.arraycopy(this.buffers, 0, linkedListArray, 0, this.buffers.length);
                vectorArray[n] = new Vector();
                linkedListArray[n] = new LinkedList();
                this.listenerArray = vectorArray;
                this.buffers = linkedListArray;
            } else if (this.listenerArray[n] == null) {
                this.listenerArray[n] = new Vector();
                this.buffers[n] = new LinkedList();
            }
        } else {
            Vector[] vectorArray = new Vector[n + 1];
            LinkedList[] linkedListArray = new LinkedList[n + 1];
            vectorArray[n] = new Vector();
            linkedListArray[n] = new LinkedList();
            this.listenerArray = vectorArray;
            this.buffers = linkedListArray;
        }
        return this.listenerArray[n];
    }

    public void fieldChanged(int n) {
        this.generateBroadcast(n, this.timeClock.getTime());
    }

    public abstract void generateBroadcast(int var1, double var2);

    protected synchronized Vector getListeners(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid field ID");
        }
        if (this.listenerArray == null || this.listenerArray.length <= n) {
            return null;
        }
        return this.listenerArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(int n, Object object) {
        Vector vector = this.getListeners(n);
        if (vector != null) {
            vector.removeElement(object);
            if (vector.size() == 0) {
                BaseExternalEventAdapter baseExternalEventAdapter = this;
                synchronized (baseExternalEventAdapter) {
                    this.buffers[n].clear();
                }
            }
        }
    }
}

