/*
 * Decompiled with CFR 0.152.
 */
package virbot4u;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.JViewport;
import javax.swing.border.AbstractBorder;

public class NumeredBorder
extends AbstractBorder {
    private int lineHeight = 16;
    private int characterHeight = 8;
    private int characterWidth = 7;
    private Color myColor = new Color(164, 164, 164);
    private JViewport viewport;

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.viewport == null) {
            this.searchViewport(c);
        }
        Object d = null;
        Point point = this.viewport != null ? this.viewport.getViewPosition() : new Point();
        Color oldColor = g.getColor();
        g.setColor(this.myColor);
        double r = (double)height / (double)this.lineHeight;
        int rows = (int)(r + 0.5);
        String str = String.valueOf(rows);
        int maxLenght = str.length();
        int i = 0;
        if (point.y > 0) {
            i = point.y / this.lineHeight;
        }
        if (d != null) {
            r = (double)d.height / (double)this.lineHeight;
            rows = (int)(r + 0.5);
            rows += i + 1;
        }
        while (i < rows) {
            str = String.valueOf(i + 1);
            int lenght = str.length();
            lenght = maxLenght - lenght;
            int py = this.lineHeight * i + 14;
            int px = this.characterWidth * lenght + 2;
            g.drawString(str, px, py);
            ++i;
        }
        int left = this.calculateLeft(height) + 7;
        g.drawLine(left, 0, left, height);
        g.setColor(oldColor);
    }

    public Insets getBorderInsets(Component c) {
        int left = this.calculateLeft(c.getHeight()) + 10;
        return new Insets(1, left, 1, 1);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 1;
        insets.left = this.calculateLeft(c.getHeight()) + 10;
        insets.bottom = 1;
        insets.right = 1;
        return insets;
    }

    protected int calculateLeft(int height) {
        double r = (double)height / (double)this.lineHeight;
        int rows = (int)(r + 0.5);
        String str = String.valueOf(rows);
        int lenght = str.length();
        return this.characterHeight * lenght;
    }

    protected void searchViewport(Component c) {
        Container parent = c.getParent();
        if (parent instanceof JViewport) {
            this.viewport = (JViewport)parent;
        }
    }
}

