/*
 * Decompiled with CFR 0.152.
 */
package virbot4u;

import Commands.BlockContext;
import Commands.ScriptingBlockContext;
import Compiler.Interpreter;
import Compiler.ParseException;
import Componentes.RList;
import Robo.Ponto;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import virbot4u.CenaX3D;
import virbot4u.JanelaDigital;
import virbot4u.JanelaPonto;
import virbot4u.NumeredBorder;
import virbot4u.SalvaArquivo;

public class JanelaPrograma
extends JFrame
implements ActionListener,
MouseListener {
    private JButton newFile;
    private JButton openFile;
    private JButton saveFile;
    private JButton run;
    private JButton stop;
    private JButton stepNext;
    private JButton digitalWindow;
    private JButton loop;
    private JButton reset;
    private JButton home;
    private JLabel cmdTitle;
    private JList cmdList;
    private JPanel panelBottons;
    private JPanel panelProg;
    private JPanel panelCmd;
    private JPanel panelConsole;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private static JTextArea txtProg;
    private static JTextArea txtConsole;
    private RList lPontos;
    private CenaX3D cena;
    private Rectangle tamanhoJanela;
    private JanelaPonto janelaPonto;
    private SalvaArquivo salvaArquivo;
    private static String idioma;
    private BlockContext blockContext;
    private JanelaDigital jDigital;
    String[] strings_en = new String[]{"   AXIS CONTROL", "OG OpenGripper", "CG CloseGripper", "GP GoToPosition#_", "GL GoLinearToPosition#_", "GC GoCircularToPosition#_", "GS GoSmoothToPosition#_", "JA JAW...", "IL IfLimitSwitch#_...", "RP RecordPosition#_...", "SA SetAxis#_ ToZero...", "PH SetHomePosition", "SVS SetVariableToSensor...", "   PROGRAM FLOW", "WT Wait...", "JU JumpTo...", "RE Remark...", "RB RingBell", "RT ResetTimer", "SVC SetVariable...", "SVT SetVariableToTimer...", "IF IfJump...", "SS SetSubroutine...", "CS CallSubroutine...", "RS ReturnSubroutine", "LA Label...", "PS PrintToScreen&Log...", "   INPUTS & OUTPUTS", "II IfInput#_OnJump...", "OI OnInputInt#_OnJump...", "EI EnableInterrupt#_...", "DI DisableInterrupt#_...", "ON TurnOnOutput#_...", "OF TurnOffOutput#_..."};
    String[] strings_pt = new String[]{"   CONTROLE DOS EIXOS", "OG AbrirGarra", "CG FecharGarra", "GP IrParaPosicao#_", "GL IrLinearParaPosicao#_", "GC IrCircularParaPosicao#_", "GS IrSuaveParaPosicao#_", "JA Abertura...", "IL SeLimiteMudar#_...", "RP GravarPosicao#_...", "SA DefinirEixos#_ EmZero...", "PH DefinirPosicaoInicial", "SVS DefinirVarivelAoSensor...", "   FLUXO DE PROGRAMA", "WT Esperar...", "JU PularPara...", "RE Comentario...", "RB Campainha", "RT ReiniciarTempo", "SVC DefinirVariavel...", "SVT DefinirVariavelAoTempo...", "IF SePular...", "SS DefinirSubrotina...", "CS ChamarSubrotina...", "RS RetornarSubrotina", "LA Rotulo...", "PS ImprimirNaTela&Log...", "   ENTRADAS & SAIDAS", "II SeEntrada#_AtivadaPular...", "OI OnInputInt#_OnJump...", "EI AbilitarInterrupcao#_...", "DI DesabilitarInterrupcao#_...", "ON AcionarSaida#_...", "OF DesligarSaida#_..."};
    private static Ponto homePosition;
    static final int MES_EXE = 1;
    static final int MES_STOP = 2;
    static final int MES_STOPPED = 3;
    static final int MES_RESET = 4;
    static final int MES_SAVE = 5;
    static final int MES_LOAD = 6;
    static final int MES_FNF = 7;
    static final int MES_NF = 8;
    static final int MES_OF = 9;
    static final int MES_SF = 10;
    static final int MES_RUN = 11;
    static final int MES_REPEAT = 12;
    static final int MES_STP = 13;
    static final int MES_RESTART = 14;
    static final int MES_NEXT = 15;
    static final int MES_STEP = 16;
    static final int MES_HOME = 17;
    static final int MES_DW = 18;

    public JanelaPrograma(CenaX3D cena, Rectangle tamanhoJanela) {
        this.cena = cena;
        this.tamanhoJanela = tamanhoJanela;
        idioma = "Portugues";
        float h = 0.0f;
        homePosition = new Ponto("Home", Float.valueOf(h), Float.valueOf(h), Float.valueOf(h), Float.valueOf(h), Float.valueOf(h), Float.valueOf(h), Float.valueOf(h), Float.valueOf(h));
        this.jDigital = new JanelaDigital();
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle("Programa\u00e7\u00e3o");
        this.setLocation(0, this.tamanhoJanela.height - 465);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJPanelBotton(), -1, 395, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.getJPanelConsole(), GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.getJPanelProg(), -1, -1, Short.MAX_VALUE).addGap(0, 0, 0).addComponent(this.getJPanelCmd(), -2, -1, -2))).addGap(0, 0, 0)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.getJPanelBotton(), -2, -1, -2).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJPanelCmd(), -1, -1, Short.MAX_VALUE).addComponent(this.getJPanelProg(), -1, -1, Short.MAX_VALUE)).addGap(5, 5, 5).addComponent(this.getJPanelConsole(), -2, -1, -2).addContainerGap()));
        this.pack();
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("Figuras/larvao2.gif"));
        this.setAlwaysOnTop(false);
        this.setVisible(true);
    }

    private JPanel getJPanelBotton() {
        if (this.panelBottons == null) {
            this.panelBottons = new JPanel();
            this.panelBottons.setBorder(BorderFactory.createEtchedBorder());
            GroupLayout jPanel1Layout = new GroupLayout(this.panelBottons);
            this.panelBottons.setLayout(jPanel1Layout);
            jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.getJButtonNewF(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonOpenF(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonSave(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonPlay(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonLoop(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonStop(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonStep(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonReset(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtonHome(), -2, 35, -2).addGap(0, 0, 0).addComponent(this.getJButtondigitalWindow(), -2, 35, -2).addGap(73, 73, 73)));
            jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.getJButtonNewF(), -2, 35, -2).addComponent(this.getJButtonOpenF(), -2, 35, -2).addComponent(this.getJButtonSave(), -2, 35, -2).addComponent(this.getJButtonPlay(), -2, 35, -2).addComponent(this.getJButtonLoop(), -2, 35, -2).addComponent(this.getJButtonStop(), -2, 35, -2).addComponent(this.getJButtonStep(), -2, 35, -2)).addComponent(this.getJButtonReset(), -2, 35, -2).addComponent(this.getJButtonHome(), -2, 35, -2).addComponent(this.getJButtondigitalWindow(), -2, 35, -2));
        }
        return this.panelBottons;
    }

    private JPanel getJPanelProg() {
        if (this.panelProg == null) {
            this.panelProg = new JPanel();
            GroupLayout jPanel2Layout = new GroupLayout(this.panelProg);
            this.panelProg.setLayout(jPanel2Layout);
            jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.getJScrollPaneProg(), -1, 205, Short.MAX_VALUE).addContainerGap()));
            jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJScrollPaneProg(), -1, 239, Short.MAX_VALUE));
        }
        return this.panelProg;
    }

    private JPanel getJPanelCmd() {
        if (this.panelCmd == null) {
            this.panelCmd = new JPanel();
            GroupLayout jPanel3Layout = new GroupLayout(this.panelCmd);
            this.panelCmd.setLayout(jPanel3Layout);
            jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJLabelCmd(), -1, -1, Short.MAX_VALUE).addComponent(this.getJScrollPaneCmd(), -1, 180, Short.MAX_VALUE));
            jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.getJLabelCmd(), -2, 22, -2).addGap(0, 0, 0).addComponent(this.getJScrollPaneCmd(), -1, 217, Short.MAX_VALUE)));
        }
        return this.panelCmd;
    }

    private JPanel getJPanelConsole() {
        if (this.panelConsole == null) {
            this.panelConsole = new JPanel();
            GroupLayout jPanel4Layout = new GroupLayout(this.panelConsole);
            this.panelConsole.setLayout(jPanel4Layout);
            jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJScrollPaneConsole(), -1, 395, Short.MAX_VALUE));
            jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getJScrollPaneConsole(), -2, 61, -2));
        }
        return this.panelConsole;
    }

    private JButton getJButtonNewF() {
        if (this.newFile == null) {
            this.newFile = new JButton();
            this.newFile.setIcon(new ImageIcon("Figuras/new.gif"));
            this.newFile.addMouseListener(this);
            this.newFile.addActionListener(this);
        }
        return this.newFile;
    }

    private JButton getJButtonOpenF() {
        if (this.openFile == null) {
            this.openFile = new JButton();
            this.openFile.setIcon(new ImageIcon("Figuras/open.gif"));
            this.openFile.addMouseListener(this);
            this.openFile.addActionListener(this);
        }
        return this.openFile;
    }

    private JButton getJButtonSave() {
        if (this.saveFile == null) {
            this.saveFile = new JButton();
            this.saveFile.setIcon(new ImageIcon("Figuras/save.gif"));
            this.saveFile.addMouseListener(this);
            this.saveFile.addActionListener(this);
        }
        return this.saveFile;
    }

    private JButton getJButtonPlay() {
        if (this.run == null) {
            this.run = new JButton();
            this.run.setIcon(new ImageIcon("Figuras/play.gif"));
            this.run.addMouseListener(this);
            this.run.addActionListener(this);
        }
        return this.run;
    }

    private JButton getJButtonLoop() {
        if (this.loop == null) {
            this.loop = new JButton();
            this.loop.setIcon(new ImageIcon("Figuras/loop.gif"));
            this.loop.addMouseListener(this);
            this.loop.addActionListener(this);
        }
        return this.loop;
    }

    private JButton getJButtonStop() {
        if (this.stop == null) {
            this.stop = new JButton();
            this.stop.setIcon(new ImageIcon("Figuras/stop.gif"));
            this.stop.addMouseListener(this);
            this.stop.addActionListener(this);
        }
        return this.stop;
    }

    private JButton getJButtonStep() {
        if (this.stepNext == null) {
            this.stepNext = new JButton();
            this.stepNext.setIcon(new ImageIcon("Figuras/step.gif"));
            this.stepNext.addMouseListener(this);
            this.stepNext.addActionListener(this);
        }
        return this.stepNext;
    }

    private JButton getJButtondigitalWindow() {
        if (this.digitalWindow == null) {
            this.digitalWindow = new JButton();
            this.digitalWindow.setIcon(new ImageIcon("Figuras/io.gif"));
            this.digitalWindow.addMouseListener(this);
            this.digitalWindow.addActionListener(this);
        }
        return this.digitalWindow;
    }

    private JButton getJButtonReset() {
        if (this.reset == null) {
            this.reset = new JButton();
            this.reset.setIcon(new ImageIcon("Figuras/reset.gif"));
            this.reset.addMouseListener(this);
            this.reset.addActionListener(this);
        }
        return this.reset;
    }

    private JButton getJButtonHome() {
        if (this.home == null) {
            this.home = new JButton();
            this.home.setIcon(new ImageIcon("Figuras/home.gif"));
            this.home.addMouseListener(this);
            this.home.addActionListener(this);
        }
        return this.home;
    }

    private JTextArea getJTextProg() {
        if (txtProg == null) {
            txtProg = new JTextArea();
            txtProg.setColumns(20);
            txtProg.setRows(5);
            Font font = new Font("Monospaced", 0, 12);
            txtProg.setFont(font);
            txtProg.setBorder(new NumeredBorder());
        }
        return txtProg;
    }

    private JTextArea getJTextConsole() {
        if (txtConsole == null) {
            txtConsole = new JTextArea();
            txtConsole.setBackground(new Color(240, 240, 240));
            txtConsole.setColumns(7);
            txtConsole.setRows(5);
        }
        return txtConsole;
    }

    private JScrollPane getJScrollPaneProg() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getJTextProg());
        }
        return this.jScrollPane1;
    }

    private JScrollPane getJScrollPaneCmd() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getJListCmd());
        }
        return this.jScrollPane2;
    }

    private JScrollPane getJScrollPaneConsole() {
        if (this.jScrollPane3 == null) {
            this.jScrollPane3 = new JScrollPane();
            this.jScrollPane3.setViewportView(this.getJTextConsole());
        }
        return this.jScrollPane3;
    }

    private JLabel getJLabelCmd() {
        if (this.cmdTitle == null) {
            this.cmdTitle = new JLabel();
        }
        if (idioma.equals("Portugues")) {
            this.cmdTitle.setIcon(new ImageIcon("Figuras/comandos.gif"));
        } else {
            this.cmdTitle.setIcon(new ImageIcon("Figuras/commands.gif"));
        }
        return this.cmdTitle;
    }

    private JList getJListCmd() {
        if (this.cmdList == null) {
            this.cmdList = new JList();
            Font font = new Font("Courier", 1, 12);
            this.cmdList.setFont(font);
            this.cmdList.setListData(this.strings_en);
            this.cmdList.addMouseListener(this);
        }
        return this.cmdList;
    }

    public BlockContext getBlockContext() {
        return this.blockContext;
    }

    public static JTextArea getTxtProgSave() {
        return txtProg;
    }

    public static void setTxtProgSave(String texto) {
        txtProg.setText(texto);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.stepNext) {
            if (this.blockContext == null || !this.blockContext.isAlive()) {
                try {
                    if (this.blockContext == null) {
                        this.interpretProgram(new FileInputStream(this.createFileTemp()));
                    }
                    txtConsole.setText("");
                    txtProg.setEditable(false);
                    this.blockContext.executeNextInstruction();
                }
                catch (FileNotFoundException fe) {}
            } else {
                JOptionPane.showMessageDialog(null, this.getMessage(1, ""));
            }
        } else if (e.getSource() == this.newFile) {
            if (this.blockContext != null && this.blockContext.isAlive()) {
                JOptionPane.showMessageDialog(null, this.getMessage(2, ""));
            } else {
                this.blockContext = null;
                txtProg.setText("");
                txtProg.setEditable(true);
            }
        } else if (e.getSource() == this.digitalWindow) {
            this.jDigital.setLocation(this.tamanhoJanela.width - 930, this.tamanhoJanela.height - 340);
            this.jDigital.setVisible(true);
        } else if (e.getSource() == this.run) {
            if (this.blockContext == null || !this.blockContext.isAlive()) {
                try {
                    this.interpretProgram(new FileInputStream(this.createFileTemp()));
                    this.blockContext.inicializeProgram();
                    this.blockContext.start();
                }
                catch (FileNotFoundException fe) {}
            } else {
                JOptionPane.showMessageDialog(null, this.getMessage(1, ""));
            }
        } else if (e.getSource() == this.loop) {
            if (this.blockContext == null || !this.blockContext.isAlive()) {
                try {
                    this.interpretProgram(new FileInputStream(this.createFileTemp()));
                    this.blockContext.inicializeProgram();
                    this.blockContext.setExecutionLoop();
                    this.blockContext.start();
                }
                catch (FileNotFoundException fileNotFoundException) {}
            } else {
                JOptionPane.showMessageDialog(null, this.getMessage(1, ""));
            }
        } else if (e.getSource() == this.stop) {
            if (this.blockContext != null) {
                this.blockContext.inicializeProgram();
                txtConsole.setText(txtConsole.getText() + this.getMessage(3, ""));
                if (this.blockContext.isAlive()) {
                    this.blockContext.stop();
                }
            }
            this.blockContext = null;
            txtProg.setEditable(true);
        } else if (e.getSource() == this.reset) {
            if (this.blockContext != null) {
                if (!this.blockContext.isAlive()) {
                    this.blockContext.inicializeProgram();
                    txtConsole.setText(this.getMessage(4, ""));
                } else {
                    JOptionPane.showMessageDialog(null, this.getMessage(1, ""));
                }
            }
        } else if (e.getSource() == this.home) {
            if (this.blockContext == null || !this.blockContext.isAlive()) {
                this.cena.setMove(homePosition.getAngulos());
            } else {
                JOptionPane.showMessageDialog(null, this.getMessage(1, ""));
            }
        } else if (e.getSource() == this.saveFile) {
            System.out.println("Salvando Arq");
            if (this.blockContext == null || !this.blockContext.isAlive()) {
                if (this.salvaArquivo != null) {
                    if (!this.salvaArquivo.isVisible()) {
                        System.out.println("Salvando Arq1");
                        this.salvaArquivo = new SalvaArquivo(this.cena, this.tamanhoJanela, "Salvar Programas");
                        this.salvaArquivo.setIdioma(this.cena.getJanelaPrincipal().getIdioma());
                    }
                } else {
                    System.out.println("Salvando Arq2");
                    this.salvaArquivo = new SalvaArquivo(this.cena, this.tamanhoJanela, "Salvar Programas");
                    this.salvaArquivo.setIdioma(this.cena.getJanelaPrincipal().getIdioma());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Salvar Programas");
            }
        } else if (e.getSource() == this.openFile) {
            if (this.blockContext == null || !this.blockContext.isAlive()) {
                if (this.salvaArquivo != null) {
                    if (!this.salvaArquivo.isVisible()) {
                        this.salvaArquivo = new SalvaArquivo(this.cena, this.tamanhoJanela, "Carregar Programas");
                        this.salvaArquivo.setIdioma(this.cena.getJanelaPrincipal().getIdioma());
                    }
                } else {
                    this.salvaArquivo = new SalvaArquivo(this.cena, this.tamanhoJanela, "Carregar Programas");
                    this.salvaArquivo.setIdioma(this.cena.getJanelaPrincipal().getIdioma());
                }
            } else {
                JOptionPane.showMessageDialog(null, "Carregar Programas");
            }
        }
    }

    private void interpretProgram(FileInputStream file) {
        try {
            txtConsole.setText("");
            Interpreter interp = new Interpreter(file);
            this.blockContext = new ScriptingBlockContext(null, this.cena);
            interp.ParseProgram(this.blockContext);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
            System.out.println("ERRO: parser.");
        }
    }

    public String createFileTemp() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(new File("out")));
            out.println(txtProg.getText());
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, this.getMessage(7, ""));
        }
        return "out";
    }

    private int verificaPontos(String nomePonto) {
        Integer numPontos = this.lPontos.getItemCount();
        for (int i = 0; i < numPontos; ++i) {
            Ponto ponto = (Ponto)this.lPontos.getObjeto(i);
            if (!nomePonto.equals(ponto.getNomePonto())) continue;
            return i;
        }
        return -1;
    }

    public void setIdioma(String idioma) {
        JanelaPrograma.idioma = idioma;
        if (idioma.equals("Portugues")) {
            this.setTitle("Programa\u00e7\u00e3o");
            this.cmdTitle.setIcon(new ImageIcon("Figuras/comandos.gif"));
            this.cmdList.setListData(this.strings_pt);
        }
        if (idioma.equals("Ingles")) {
            this.setTitle("Programming");
            this.cmdTitle.setIcon(new ImageIcon("Figuras/commands.gif"));
            this.cmdList.setListData(this.strings_en);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            if (this.cmdList.getSelectedIndex() == 1) {
                txtProg.append("OG\n");
            } else if (this.cmdList.getSelectedIndex() == 2) {
                txtProg.append("CG\n");
            } else if (this.cmdList.getSelectedIndex() == 3) {
                txtProg.append("GP [approach] #\n");
            } else if (this.cmdList.getSelectedIndex() == 4) {
                txtProg.append("GL [approach] #\n");
            } else if (this.cmdList.getSelectedIndex() == 5) {
                txtProg.append("GC [approach] #\n");
            } else if (this.cmdList.getSelectedIndex() == 6) {
                txtProg.append("GS [approach] #\n");
            } else if (this.cmdList.getSelectedIndex() == 7) {
                txtProg.append("JA #\n");
            } else if (this.cmdList.getSelectedIndex() == 8) {
                txtProg.append("IL [#|ALL] JU #\n");
            } else if (this.cmdList.getSelectedIndex() == 9) {
                txtProg.append("RP #\n");
            } else if (this.cmdList.getSelectedIndex() == 10) {
                txtProg.append("SA #\n");
            } else if (this.cmdList.getSelectedIndex() == 11) {
                txtProg.append("PH\n");
            } else if (this.cmdList.getSelectedIndex() == 12) {
                txtProg.append("SVS #\n");
            } else if (this.cmdList.getSelectedIndex() != 13) {
                if (this.cmdList.getSelectedIndex() == 14) {
                    txtProg.append("WT #\n");
                } else if (this.cmdList.getSelectedIndex() == 15) {
                    txtProg.append("JU #\n");
                } else if (this.cmdList.getSelectedIndex() == 16) {
                    txtProg.append("RE #\n");
                } else if (this.cmdList.getSelectedIndex() == 17) {
                    txtProg.append("RB\n");
                } else if (this.cmdList.getSelectedIndex() == 18) {
                    txtProg.append("RT\n");
                } else if (this.cmdList.getSelectedIndex() == 19) {
                    txtProg.append("SVC # = #\n");
                } else if (this.cmdList.getSelectedIndex() == 20) {
                    txtProg.append("SVT #\n");
                } else if (this.cmdList.getSelectedIndex() == 21) {
                    txtProg.append("IF # JU #\n");
                } else if (this.cmdList.getSelectedIndex() == 22) {
                    txtProg.append("SS #\n");
                } else if (this.cmdList.getSelectedIndex() == 23) {
                    txtProg.append("CS #\n");
                } else if (this.cmdList.getSelectedIndex() == 24) {
                    txtProg.append("RS\n");
                } else if (this.cmdList.getSelectedIndex() == 25) {
                    txtProg.append("#:\n");
                } else if (this.cmdList.getSelectedIndex() == 26) {
                    txtProg.append("PS #\n");
                } else if (this.cmdList.getSelectedIndex() != 27) {
                    if (this.cmdList.getSelectedIndex() == 28) {
                        txtProg.append("II # [On|Off] [JU|CS] #\n");
                    } else if (this.cmdList.getSelectedIndex() == 29) {
                        txtProg.append("OI [#|ANY] [On|Off] [JU|CS] #\n");
                    } else if (this.cmdList.getSelectedIndex() == 30) {
                        txtProg.append("EI [#|ALL]\n");
                    } else if (this.cmdList.getSelectedIndex() == 31) {
                        txtProg.append("DI [#|ALL]\n");
                    } else if (this.cmdList.getSelectedIndex() == 32) {
                        txtProg.append("ON #\n");
                    } else if (this.cmdList.getSelectedIndex() == 33) {
                        txtProg.append("OF #\n");
                    }
                }
            }
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (e.getSource().equals(this.newFile)) {
            this.newFile.setToolTipText(this.getMessage(8, ""));
        } else if (e.getSource().equals(this.openFile)) {
            this.openFile.setToolTipText(this.getMessage(9, ""));
        } else if (e.getSource().equals(this.saveFile)) {
            this.saveFile.setToolTipText(this.getMessage(10, ""));
        } else if (e.getSource().equals(this.run)) {
            this.run.setToolTipText(this.getMessage(11, ""));
        } else if (e.getSource().equals(this.loop)) {
            this.loop.setToolTipText(this.getMessage(12, ""));
        } else if (e.getSource().equals(this.stop)) {
            this.stop.setToolTipText(this.getMessage(13, ""));
        } else if (e.getSource().equals(this.stepNext)) {
            this.stepNext.setToolTipText(this.getMessage(16, ""));
        } else if (e.getSource().equals(this.reset)) {
            this.reset.setToolTipText(this.getMessage(14, ""));
        } else if (e.getSource().equals(this.home)) {
            this.home.setToolTipText(this.getMessage(17, ""));
        } else if (e.getSource().equals(this.digitalWindow)) {
            this.digitalWindow.setToolTipText(this.getMessage(18, ""));
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public CenaX3D getCena() {
        return this.cena;
    }

    public static JTextArea getTxtConsole() {
        return txtConsole;
    }

    public static String getIdioma() {
        return idioma;
    }

    public String getMessage(int numberMessage, String complements) {
        String pt = "";
        String en = "";
        if (!idioma.equals("Portugues")) {
            numberMessage += 100;
        }
        switch (numberMessage) {
            case 1: {
                return pt + "Programa em execu\u00e7\u00e3o!";
            }
            case 101: {
                return en + "Executing program!";
            }
            case 2: {
                return pt + "Pressione Bot\u00e3o STOP!";
            }
            case 102: {
                return en + "Push STOP button!";
            }
            case 3: {
                return pt + "Parado!";
            }
            case 103: {
                return en + "Stopped!";
            }
            case 4: {
                return pt + "Inicio!";
            }
            case 104: {
                return en + "Reset!";
            }
            case 5: {
                return pt + "Salvar Programa!";
            }
            case 105: {
                return en + "Save Program!";
            }
            case 6: {
                return pt + "Carregar Programa!";
            }
            case 106: {
                return en + "Load Program!";
            }
            case 7: {
                return pt + "N\u00e3o foi possivel abrir o arquivo!";
            }
            case 107: {
                return en + "It was not possible to open the file!";
            }
            case 8: {
                return pt + "Novo Arquivo";
            }
            case 108: {
                return en + "New File";
            }
            case 9: {
                return pt + "Abrir Arquivo";
            }
            case 109: {
                return en + "Open File";
            }
            case 10: {
                return pt + "Salvar Arquivo";
            }
            case 110: {
                return en + "Save File";
            }
            case 11: {
                return pt + "Executar";
            }
            case 111: {
                return en + "Run";
            }
            case 12: {
                return pt + "Repetir";
            }
            case 112: {
                return en + "Repeat";
            }
            case 13: {
                return pt + "Parar";
            }
            case 113: {
                return en + "Stop";
            }
            case 14: {
                return pt + "Reiniciar";
            }
            case 114: {
                return en + "Reset";
            }
            case 16: {
                return pt + "Avan\u00e7ar Passo";
            }
            case 116: {
                return en + "Next Step";
            }
            case 17: {
                return pt + "Posi\u00e7\u00e3o Inicial";
            }
            case 117: {
                return en + "Home";
            }
            case 18: {
                return pt + "Janela Digital";
            }
            case 118: {
                return en + "Digital Window";
            }
        }
        return "";
    }

    public static void setHomePosition(Ponto hPosition) {
        homePosition = hPosition;
    }

    public void executarPrograma() {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

