/*
 * Decompiled with CFR 0.152.
 */
package virbot4u;

import Colisao.CollisionManager;
import Colisao.Obb;
import Colisao.ObbTree;
import Objetos.PartManager;
import Preensao.Pegar_Soltar;
import Robo.Angulos;
import Robo.Eixo;
import Robo.Ponto;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.web3d.vrml.lang.UnsupportedNodeException;
import org.web3d.x3d.sai.BrowserFactory;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidNodeException;
import org.web3d.x3d.sai.MFNode;
import org.web3d.x3d.sai.SFBool;
import org.web3d.x3d.sai.SFColor;
import org.web3d.x3d.sai.SFFloat;
import org.web3d.x3d.sai.SFRotation;
import org.web3d.x3d.sai.SFTime;
import org.web3d.x3d.sai.SFVec3f;
import org.web3d.x3d.sai.X3DComponent;
import org.web3d.x3d.sai.X3DFieldEvent;
import org.web3d.x3d.sai.X3DFieldEventListener;
import org.web3d.x3d.sai.X3DNode;
import org.web3d.x3d.sai.X3DScene;
import virbot4u.JanelaPonto;
import virbot4u.JanelaPrincipal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CenaX3D
implements X3DFieldEventListener {
    private static final double TAM_BRACO = 220.0;
    private static final double ALTURA = 335.0;
    private static final double DESVIO = 20.0;
    private static final double TAM_GARRA = 150.0;
    private X3DScene mainScene;
    private X3DNode root;
    public JanelaPrincipal jp;
    private SFFloat alfa;
    private SFFloat beta;
    private SFFloat gama;
    private SFFloat elevacao;
    private SFFloat rotacao;
    private SFBool abertura;
    private SFVec3f ponto;
    private SFRotation inBase;
    private SFRotation inAntebraco;
    private SFRotation inBraco;
    private SFRotation inElevacao;
    private SFRotation inRotacao;
    private SFFloat inAbertura;
    private SFBool inPosicaoInicial;
    private SFBool inEixosVisivel;
    private SFBool insensoresAtivos;
    private SFBool inPFPVisivel;
    private SFTime inExecutar;
    private MFNode inAddChildrenGarra;
    private MFNode inRemoveChildrenGarra;
    private SFRotation inAlfa;
    private SFRotation inBeta;
    private SFRotation inGama;
    private SFRotation inElev;
    private SFRotation inRota;
    private SFColor color;
    private int objCol1 = -1;
    private int objCol2 = -1;
    private float[][] listaCores = new float[][]{{0.3f, 0.3f, 0.3f}, {0.0f, 0.7f, 0.5f}, {0.0f, 0.7f, 0.5f}, {0.0f, 0.7f, 0.5f}, {0.3f, 0.3f, 0.3f}};
    private SFVec3f vBaX;
    private SFVec3f vBaY;
    private SFVec3f vBaZ;
    private SFVec3f vBaPtC;
    private SFVec3f vABX;
    private SFVec3f vABY;
    private SFVec3f vABZ;
    private SFVec3f vABPtC;
    private SFVec3f vBX;
    private SFVec3f vBY;
    private SFVec3f vBZ;
    private SFVec3f vBPtC;
    private SFVec3f vGX;
    private SFVec3f vGY;
    private SFVec3f vGZ;
    private SFVec3f vGPtC;
    private SFVec3f vGPtD1;
    private SFVec3f vGPtD2;
    private SFVec3f vGPtSup;
    private SFVec3f vGPtEixo;
    private ObbTree[] childrenGarra = new ObbTree[4];
    private ObbTree treeDedo1 = new ObbTree();
    private ObbTree treeDedo2 = new ObbTree();
    private ObbTree treeSup = new ObbTree();
    private ObbTree treeEixo = new ObbTree();
    public Obb obbBase = new Obb();
    public Obb obbCorpo = new Obb();
    public Obb obbAntBraco = new Obb();
    public Obb obbBraco = new Obb();
    public Obb obbGarra = new Obb();
    private ObbTree treeBase = new ObbTree();
    private ObbTree treeCorpo = new ObbTree();
    private ObbTree treeAntBraco = new ObbTree();
    private ObbTree treeBraco = new ObbTree();
    private ObbTree treeGarra = new ObbTree();
    public Obb obbDedo1 = new Obb();
    public Obb obbDedo2 = new Obb();
    public Obb obbSup = new Obb();
    public Obb obbEixo = new Obb();
    private ExternalBrowser x3dBrowser;
    public CollisionManager collisionManager;
    public PartManager partManager;
    public Pegar_Soltar Pegar_soltar;
    private boolean posicaoOK = true;
    X3DNode[][] filhoObj = new X3DNode[1][];
    public static Boolean pego = false;
    public int contacolisao = 0;
    int prim = 0;
    public int NManipulacoesClick = 0;
    public int NManipulacoesTeclado = 0;
    public int NPreencaoO = 0;
    public int NPreencaoOF = 0;
    public int NPreencaoOM = 0;
    public int maxFator = 180;
    public String FolgaAb = "50";
    public String FolgaGeom = "18";
    public int TestePreensao = 2;
    public int usoPreensao = 1;
    public int io = 0;
    public boolean ghostGripper = false;
    public boolean elbowOver = true;
    public int granularity = 50;
    public boolean simulateIK = false;
    private boolean stateGripper = false;
    public String ikValidationFeedback;

    public void PrintPonto(Ponto p) {
        System.out.println(p.getNomePonto() + ": " + p.getX() + ", " + p.getY() + ", " + p.getZ() + " # " + p.getAlfa() + ", " + p.getBeta() + ", " + p.getGama() + ", " + p.getElevacao() + ", " + p.getRotacao() + " # " + p.radianPitch + " " + p.radianRoll);
    }

    public CenaX3D(String x3dWorld) {
        HashMap<String, Object> requestedParameters = new HashMap<String, Object>();
        requestedParameters.put("Antialiased", Boolean.TRUE);
        requestedParameters.put("TextureQuality", "high");
        requestedParameters.put("PrimitiveQuality", "high");
        X3DComponent x3dComp = BrowserFactory.createX3DComponent(requestedParameters);
        this.jp = new JanelaPrincipal(this, (JComponent)x3dComp.getImplementation());
        this.x3dBrowser = x3dComp.getBrowser();
        try {
            this.mainScene = this.x3dBrowser.createX3DFromURL(new String[]{x3dWorld});
            this.x3dBrowser.replaceWorld(this.mainScene);
            this.carregaSensores(this);
        }
        catch (UnsupportedNodeException ex) {
            System.out.println("Erro: " + ex.getMessage());
        }
        catch (NullPointerException np) {
            System.out.println("Erro: " + np.getMessage());
            np.printStackTrace();
        }
        this.carregaVetores();
        this.montaObbs();
        this.collisionManager = new CollisionManager();
        this.partManager = new PartManager(this);
        this.Pegar_soltar = new Pegar_Soltar(this);
    }

    public void generateGhostGripper(boolean allPoints, boolean showGripper, boolean showPFP, boolean validate) {
        int length;
        for (int i = 0; i < this.mainScene.getNamedNodes().length; ++i) {
            if (!this.mainScene.getNamedNodes()[i].contains("CP_ROBOGARRA_")) continue;
            X3DNode node = this.mainScene.getNamedNode(this.mainScene.getNamedNodes()[i]);
            this.mainScene.removeRootNode(node);
            this.mainScene.removeNamedNode(this.mainScene.getNamedNodes()[i]);
            --i;
        }
        if (!showGripper && !showPFP) {
            return;
        }
        if (allPoints) {
            JanelaPonto cfr_ignored_0 = this.jp.janelaPonto;
            length = JanelaPonto.lPontos.getItemCount();
        } else {
            JanelaPonto cfr_ignored_1 = this.jp.janelaPonto;
            length = JanelaPonto.lControlPoints.getItemCount();
        }
        if (length <= 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            Ponto p;
            if (allPoints) {
                JanelaPonto cfr_ignored_2 = this.jp.janelaPonto;
                p = (Ponto)JanelaPonto.lPontos.getObjeto(i);
            } else {
                JanelaPonto cfr_ignored_3 = this.jp.janelaPonto;
                p = (Ponto)JanelaPonto.lControlPoints.getObjeto(i);
            }
            String color = "1 1 0";
            if (validate) {
                float pitch = this.toRadianos(p.getElevacao().floatValue() + p.getBeta().floatValue() + p.getGama().floatValue()) - (float)Math.PI;
                float roll = this.toRadianos(p.getRotacao().floatValue());
                this.simulateIK = true;
                this.calcularInversa(-p.getX().floatValue(), p.getZ().floatValue(), p.getY().floatValue(), pitch, roll, this.elbowOver);
                this.simulateIK = false;
                color = !this.getPosicaoOK() ? "1 0 0" : "0.3 1 0";
            }
            String xmlScene = "<X3D profile='Immersive' version='3.0' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.2.xsd'> <Scene> <Group DEF='ROBOGARRA'> <Transform DEF='FIXACAO' translation='0.0 -0.48 0.0' scale='0.075 0.075 0.075' rotation='0 1 0 #ROT_ALFA_RADIAN#'> <Shape DEF='GEO_FIXACAO' > <Appearance > <Material DEF='COR_0' diffuseColor='0.3 0.3 0.3' transparency='1'/> </Appearance> <Extrusion crossSection='1.0 0.0, 0.92 -0.38, 0.71 -0.71, 0.38 -0.92, 0.0 -1.0, -0.38 -0.92, -0.71 -0.71, -0.92 -0.38, -1.0 -0.0, -0.92 0.38, -0.71 0.71, -0.38 0.92, 0.0 1.0, 0.38 0.92, 0.71 0.71, 0.92 0.38, 1.0 0.0, ' scale='3.2 3.2, 3.2 3.2, 2.5 2.5, 2.45 2.45, 2.4 2.4, 2.35 2.35, 2.3 2.3, 2.25 2.25, 2.2 2.2, 2.15 2.15, 2.1 2.1, ' solid='false' creaseAngle='1.0' spine='0.0 0.0 0.0, 0.0 0.3 0.0, 0.0 0.301 0.0, 0.0 1.4 0.0, 0.0 1.8 0.0, 0.0 2.2 0.0, 0.0 2.6 0.0, 0.0 3.0 0.0, 0.0 3.4 0.0, 0.0 3.8 0.0, 0.0 4.2 0.0, '/> </Shape> <Transform DEF='CONJ_BASE' > <Transform DEF='BASE' scale='3.0 3.0 3.0' translation='-2.25 4.4 2.325' > <Shape DEF='GEO_BASE' > <Appearance > <Material DEF='COR_1' diffuseColor='0.0 0.7 0.5' transparency='1'/> </Appearance> <IndexedFaceSet coordIndex=' 0 1 2 3 4 5 6 7 8 9 -1 10 19 18 17 16 15 14 13 12 11 -1 0 10 11 1 -1 1 11 12 2 -1 2 12 13 3 -1 3 13 14 4 -1 4 14 15 5 -1 5 15 16 6 -1 6 16 17 7 -1 7 17 18 8 -1 8 18 19 9 -1 9 19 20 0 -1 21 22 23 24 25 26 27 28 29 30 -1 31 40 39 38 37 36 35 34 33 32 -1 21 31 32 22 -1 22 32 33 23 -1 23 33 34 24 -1 24 34 35 25 -1 25 35 36 26 -1 26 36 37 27 -1 27 37 38 28 -1 28 38 39 29 -1 29 39 40 30 -1 30 40 41 21 -1 0 21 22 1 -1 42 43 45 44 -1 0 42 44 21 -1 1 22 45 43 -1 1 22 23 2 -1 46 48 49 47 -1 2 23 49 48 -1'> <Coordinate point='0.0 0.0 0.0, 1.5 0.0 0.0, 1.5 0.9 0.0, 1.46 0.97 0.0, 1.4 1.0 0.0, 0.5 1.0 0.0, 0.4 0.95 0.0, 0.35 0.9 0.0, 0.3 0.85 0.0, 0.0 0.3 0.0, 0.0 0.0 -0.05, 1.5 0.0 -0.05, 1.5 0.9 -0.05, 1.46 0.97 -0.05, 1.4 1.0 -0.05, 0.5 1.0 -0.05, 0.4 0.95 -0.05, 0.35 0.9 -0.05, 0.3 0.85 -0.05, 0.0 0.3 -0.05, 0.0 0.0 -0.05, 0.0 0.0 -1.5, 1.5 0.0 -1.5, 1.5 0.9 -1.5, 1.46 0.97 -1.5, 1.4 1.0 -1.5, 0.5 1.0 -1.5, 0.4 0.95 -1.5, 0.35 0.9 -1.5, 0.3 0.85 -1.5, 0.0 0.3 -1.5, 0.0 0.0 -1.55, 1.5 0.0 -1.55, 1.5 0.9 -1.55, 1.46 0.97 -1.55, 1.4 1.0 -1.55, 0.5 1.0 -1.55, 0.4 0.95 -1.55, 0.35 0.9 -1.55, 0.3 0.85 -1.55, 0.0 0.3 -1.55, 0.0 0.0 -1.55, 0.0 0.05 0.0, 1.5 0.05 0.0, 0.0 0.05 -1.5, 1.5 0.05 -1.5, 1.45 0.0 0.0, 1.45 0.0 -1.5, 1.45 0.9 0.0, 1.45 0.9 -1.5, '/> </IndexedFaceSet> </Shape> <Transform DEF='CILINDRO_BASE' translation='0.2 0.2 0.0'> <Transform DEF='GEO_CILINDRO' rotation='1 0 0 1.5708' translation='0 0 -0.775'> <Shape> <Appearance> <Material diffuseColor='0.0 0.7 0.5'/> </Appearance> </Shape> <Transform translation='0 -0.775 0'> <Shape DEF='GEO_CILINDRO_BORDA'> <Appearance> <Material diffuseColor='0.3 0.3 0.3' transparency='1'/> </Appearance> <Cylinder radius='0.14' height='0.05'/> </Shape> </Transform> <Transform translation='0 0.775 0'> <Shape USE='GEO_CILINDRO_BORDA'/> </Transform> </Transform> </Transform> <Transform DEF='CONJ_ANTEBRACO' translation='0.5 0.8 0.0'> <Transform DEF='ANTEBRACO' translation='0 -0.2 -0.1' rotation='0 0 1 #ROT_BETA_RADIAN#' center='0 0.2 0'> <Shape DEF='GEO_ANTEBRACO' > <Appearance > <Material DEF='COR_2' diffuseColor='0.0 0.7 0.5' transparency='1'/> </Appearance> <IndexedFaceSet coordIndex=' 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 -1 22 43 42 41 40 39 38 37 36 35 34 33 32 31 30 29 28 27 26 25 24 23 -1 0 22 23 1 -1 1 23 24 2 -1 2 24 25 3 -1 3 25 26 4 -1 4 26 27 5 -1 5 27 28 6 -1 6 28 29 7 -1 7 29 30 8 -1 8 30 31 9 -1 9 31 32 10 -1 10 32 33 11 -1 11 33 34 12 -1 12 34 35 13 -1 13 35 36 14 -1 14 36 37 15 -1 15 37 38 16 -1 16 38 39 17 -1 17 39 40 18 -1 18 40 41 19 -1 19 41 42 20 -1 20 42 43 21 -1 21 43 44 0 -1 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 -1 67 88 87 86 85 84 83 82 81 80 79 78 77 76 75 74 73 72 71 70 69 68 -1 45 67 68 46 -1 46 68 69 47 -1 47 69 70 48 -1 48 70 71 49 -1 49 71 72 50 -1 51 72 73 52 -1 52 73 74 53 -1 53 74 75 54 -1 54 75 76 55 -1 55 76 77 56 -1 56 77 78 57 -1 57 78 79 58 -1 58 79 80 59 -1 59 81 82 60 -1 60 82 83 61 -1 61 83 84 62 -1 62 84 85 63 -1 63 85 86 64 -1 64 86 87 65 -1 65 87 88 66 -1 66 88 89 45 -1 90 93 92 91 -1 94 95 96 97 -1 91 92 96 95 -1 90 94 97 93 -1'> <Coordinate point='-0.25 0.22 0.0, -0.2 0.13 0.0, -0.15 0.07 0.0, -0.1 0.03 0.0, -0.05 0.01 0.0, 0.0 0.0 0.0, 0.05 0.01 0.0, 0.1 0.03 0.0, 0.15 0.07 0.0, 0.2 0.13 0.0, 0.25 0.22 0.0, 0.25 1.68 0.0, 0.2 1.77 0.0, 0.15 1.83 0.0, 0.1 1.87 0.0, 0.05 1.89 0.0, 0.0 1.9 0.0, -0.05 1.89 0.0, -0.1 1.87 0.0, -0.15 1.83 0.0, -0.2 1.77 0.0, -0.25 1.68 0.0, -0.25 0.22 -0.05, -0.2 0.13 -0.05, -0.15 0.07 -0.05, -0.1 0.03 -0.05, -0.05 0.01 -0.05, 0.0 0.0 -0.05, 0.05 0.01 -0.05, 0.1 0.03 -0.05, 0.15 0.07 -0.05, 0.2 0.13 -0.05, 0.25 0.22 -0.05, 0.25 1.68 -0.05, 0.2 1.77 -0.05, 0.15 1.83 -0.05, 0.1 1.87 -0.05, 0.05 1.89 -0.05, 0.0 1.9 -0.05, -0.05 1.89 -0.05, -0.1 1.87 -0.05, -0.15 1.83 -0.05, -0.2 1.77 -0.05, -0.25 1.68 -0.05, -0.25 0.22 -0.05, -0.25 0.22 -1.3, -0.2 0.13 -1.3, -0.15 0.07 -1.3, -0.1 0.03 -1.3, -0.05 0.01 -1.3, 0.0 0.0 -1.3, 0.05 0.01 -1.3, 0.1 0.03 -1.3, 0.15 0.07 -1.3, 0.2 0.13 -1.3, 0.25 0.22 -1.3, 0.25 1.68 -1.3, 0.2 1.77 -1.3, 0.15 1.83 -1.3, 0.1 1.87 -1.3, 0.05 1.89 -1.3, 0.0 1.9 -1.3, -0.05 1.89 -1.3, -0.1 1.87 -1.3, -0.15 1.83 -1.3, -0.2 1.77 -1.3, -0.25 1.68 -1.3, -0.25 0.22 -1.35, -0.2 0.13 -1.35, -0.15 0.07 -1.35, -0.1 0.03 -1.35, -0.05 0.01 -1.35, 0.0 0.0 -1.35, 0.05 0.01 -1.35, 0.1 0.03 -1.35, 0.15 0.07 -1.35, 0.2 0.13 -1.35, 0.25 0.22 -1.35, 0.25 1.68 -1.35, 0.2 1.77 -1.35, 0.15 1.83 -1.35, 0.1 1.87 -1.35, 0.05 1.89 -1.35, 0.0 1.9 -1.35, -0.05 1.89 -1.35, -0.1 1.87 -1.35, -0.15 1.83 -1.35, -0.2 1.77 -1.35, -0.25 1.68 -1.35, -0.25 0.2 -1.35, 0.25 0.7 0.0, 0.25 1.4 0.0, 0.25 1.4 -1.35, 0.25 0.7 -1.35, 0.2 0.7 0.0, 0.2 1.4 0.0, 0.2 1.4 -1.35, 0.2 0.7 -1.35, '/> </IndexedFaceSet> </Shape> <Transform DEF='CONJ_BRACO' translation='0.0 1.65 0.0'> <Transform DEF='BRACO' translation='0.0 -0.16 -0.07' rotation='0 0 1 #ROT_GAMA_RADIAN#' center='0 0.16 0'> <Shape DEF='GEO_BRACO' > <Appearance > <Material DEF='COR_3' diffuseColor='0.0 0.7 0.5' transparency='1'/> </Appearance> <IndexedFaceSet coordIndex=' 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 -1 22 43 42 41 40 39 38 37 36 35 34 33 32 31 30 29 28 27 26 25 24 23 -1 0 22 23 1 -1 1 23 24 2 -1 2 24 25 3 -1 3 25 26 4 -1 4 26 27 5 -1 5 27 28 6 -1 6 28 29 7 -1 7 29 30 8 -1 8 30 31 9 -1 9 31 32 10 -1 10 32 33 11 -1 11 33 34 12 -1 12 34 35 13 -1 13 35 36 14 -1 14 36 37 15 -1 15 37 38 16 -1 16 38 39 17 -1 17 39 40 18 -1 18 40 41 19 -1 19 41 42 20 -1 20 42 43 21 -1 21 43 44 0 -1 45 46 47 48 49 50 51 52 53 54 55 56 57 58 59 60 61 62 63 64 65 66 -1 67 88 87 86 85 84 83 82 81 80 79 78 77 76 75 74 73 72 71 70 69 68 -1 45 67 68 46 -1 46 68 69 47 -1 47 69 70 48 -1 48 70 71 49 -1 49 71 72 50 -1 51 72 73 52 -1 52 73 74 53 -1 53 74 75 54 -1 54 75 76 55 -1 55 76 77 56 -1 56 77 78 57 -1 57 78 79 58 -1 58 79 80 59 -1 59 81 82 60 -1 60 82 83 61 -1 61 83 84 62 -1 62 84 85 63 -1 63 85 86 64 -1 64 86 87 65 -1 65 87 88 66 -1 66 88 89 45 -1 90 93 92 91 -1 94 95 96 97 -1 91 92 96 95 -1 90 94 97 93 -1'> <Coordinate point='-0.25 0.22 0.0, -0.2 0.13 0.0, -0.15 0.07 0.0, -0.1 0.03 0.0, -0.05 0.01 0.0, 0.0 0.0 0.0, 0.05 0.01 0.0, 0.1 0.03 0.0, 0.15 0.07 0.0, 0.2 0.13 0.0, 0.25 0.22 0.0, 0.25 1.68 0.0, 0.2 1.77 0.0, 0.15 1.83 0.0, 0.1 1.87 0.0, 0.05 1.89 0.0, 0.0 1.9 0.0, -0.05 1.89 0.0, -0.1 1.87 0.0, -0.15 1.83 0.0, -0.2 1.77 0.0, -0.25 1.68 0.0, -0.25 0.22 -0.05, -0.2 0.13 -0.05, -0.15 0.07 -0.05, -0.1 0.03 -0.05, -0.05 0.01 -0.05, 0.0 0.0 -0.05, 0.05 0.01 -0.05, 0.1 0.03 -0.05, 0.15 0.07 -0.05, 0.2 0.13 -0.05, 0.25 0.22 -0.05, 0.25 1.68 -0.05, 0.2 1.77 -0.05, 0.15 1.83 -0.05, 0.1 1.87 -0.05, 0.05 1.89 -0.05, 0.0 1.9 -0.05, -0.05 1.89 -0.05, -0.1 1.87 -0.05, -0.15 1.83 -0.05, -0.2 1.77 -0.05, -0.25 1.68 -0.05, -0.25 0.22 -0.05, -0.25 0.22 -1.15, -0.2 0.13 -1.15, -0.15 0.07 -1.15, -0.1 0.03 -1.15, -0.05 0.01 -1.15, 0.0 0.0 -1.15, 0.05 0.01 -1.15, 0.1 0.03 -1.15, 0.15 0.07 -1.15, 0.2 0.13 -1.15, 0.25 0.22 -1.15, 0.25 1.68 -1.15, 0.2 1.77 -1.15, 0.15 1.83 -1.15, 0.1 1.87 -1.15, 0.05 1.89 -1.15, 0.0 1.9 -1.15, -0.05 1.89 -1.15, -0.1 1.87 -1.15, -0.15 1.83 -1.15, -0.2 1.77 -1.15, -0.25 1.68 -1.15, -0.25 0.22 -1.2, -0.2 0.13 -1.2, -0.15 0.07 -1.2, -0.1 0.03 -1.2, -0.05 0.01 -1.2, 0.0 0.0 -1.2, 0.05 0.01 -1.2, 0.1 0.03 -1.2, 0.15 0.07 -1.2, 0.2 0.13 -1.2, 0.25 0.22 -1.2, 0.25 1.68 -1.2, 0.2 1.77 -1.2, 0.15 1.83 -1.2, 0.1 1.87 -1.2, 0.05 1.89 -1.2, 0.0 1.9 -1.2, -0.05 1.89 -1.2, -0.1 1.87 -1.2, -0.15 1.83 -1.2, -0.2 1.77 -1.2, -0.25 1.68 -1.2, -0.25 0.2 -1.2, 0.25 0.4 0.0, 0.25 0.9 0.0, 0.25 0.9 -1.2, 0.25 0.4 -1.2, 0.2 0.4 0.0, 0.2 0.9 0.0, 0.2 0.9 -1.2, 0.2 0.4 -1.2, '/> </IndexedFaceSet> </Shape> <Transform DEF='CONJ_PUNHO' translation='0.0 1.65 0.0'> <Transform DEF='PUNHO' rotation='0 0 1 #ROT_ELEVACAO_RADIAN#'> <Transform DEF='PUNHO2' rotation='0 1 0 #ROT_ROTATION_RADIAN#' center='0.0 0 -0.6'> <Transform DEF='GEO_CILINDRO_3' rotation='1 0 0 1.5708' translation='0 0 -0.6'> <Shape> <Appearance DEF='COR_Garra' > <Material DEF='COR_4' diffuseColor='0.3 0.3 0.3' transparency='#TRANS_GRIPPER#'/> </Appearance> </Shape> </Transform> <Transform DEF='CONJ_GARRA' scale='1 0.85 1' translation='0.0 -0.2 0.0' center='0.0 0.0 -0.6'> <Transform DEF='GARRA' > <Shape DEF='GEO_EIXO_GARRA' > <Appearance USE='COR_Garra'/> <Extrusion crossSection='1.0 0.0, 0.92 -0.38, 0.71 -0.71, 0.38 -0.92, 0.0 -1.0, -0.38 -0.92, -0.71 -0.71, -0.92 -0.38, -1.0 -0.0, -0.92 0.38, -0.71 0.71, -0.38 0.92, 0.0 1.0, 0.38 0.92, 0.71 0.71, 0.92 0.38, 1.0 0.0, ' scale='0.1 0.1, 0.1 0.1, 0.07 0.07, 0.07 0.07, 0.11 0.11, 0.11 0.11, 0.12 0.12, 0.12 0.12, 0.18 0.18, 0.18 0.18, 0.15 0.15, 0.15 0.15, 0.12 0.12, 0.12 0.12, 0.14 0.14, 0.14 0.14, 0.12 0.12, 0.12 0.12, 0.14 0.14, 0.14 0.14, 0.12 0.12, 0.12 0.12, 0.15 0.15, 0.15 0.15, ' solid='false' creaseAngle='1.87' spine='0.0 -0.5 -0.6, 0.0 -0.12 -0.6, 0.0 -0.12 -0.6, 0.0 -0.08 -0.6, 0.0 -0.08 -0.6, 0.0 0.1 -0.6, 0.0 0.1 -0.6, 0.0 0.3 -0.6, 0.0 0.3 -0.6, 0.0 0.33 -0.6, 0.0 0.33 -0.6, 0.0 0.6 -0.6, 0.0 0.6 -0.6, 0.0 0.65 -0.6, 0.0 0.65 -0.6, 0.0 0.7 -0.6, 0.0 0.7 -0.6, 0.0 0.8 -0.6, 0.0 0.8 -0.6, 0.0 0.85 -0.6, 0.0 0.85 -0.6, 0.0 0.9 -0.6, 0.0 0.9 -0.6, 0.0 1.0 -0.6, '/> </Shape> <Transform DEF='PONTA' translation='0.0 -0.45 -0.6'> <Shape DEF='GEO_SUPORTE_DEDOS' > <Appearance USE='COR_Garra'/> <Box size='0.16 0.16 0.8'/> </Shape> <Transform DEF='DEDO_1' translation='0.0 -0.2 0.075'> <Shape DEF='DEDO' > <Appearance USE='COR_Garra'/> <Box size='0.16 0.6 0.16'/> </Shape> </Transform> <Transform DEF='DEDO_2' translation='0.0 -0.2 -0.075'> <Shape USE='DEDO'/> </Transform> <Transform DEF='TPFP' translation='0.0 -0.5 0.0'> <Shape DEF='PFP'> <Appearance> <Material DEF='mpfp' diffuseColor='#COLOR_PFP#' transparency='#TRANS_PFP#'/> </Appearance> <Sphere radius='0.1'/> </Shape> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Transform> </Group> </Scene> </X3D>";
            xmlScene = xmlScene.replace("#ROT_ALFA_RADIAN#", Float.toString(this.toRadianos(p.getAlfa().floatValue())));
            xmlScene = xmlScene.replace("#ROT_BETA_RADIAN#", Float.toString(this.toRadianos(p.getBeta().floatValue())));
            xmlScene = xmlScene.replace("#ROT_GAMA_RADIAN#", Float.toString(this.toRadianos(p.getGama().floatValue())));
            xmlScene = xmlScene.replace("#ROT_ELEVACAO_RADIAN#", Float.toString(this.toRadianos(p.getElevacao().floatValue()) + (float)Math.PI));
            xmlScene = xmlScene.replace("#ROT_ROTATION_RADIAN#", Float.toString(this.toRadianos(p.getRotacao().floatValue())));
            xmlScene = xmlScene.replace("#TRANS_PFP#", showPFP ? "0.5" : "1");
            xmlScene = xmlScene.replace("#TRANS_GRIPPER#", showGripper ? "0.5" : "1");
            xmlScene = xmlScene.replace("#COLOR_PFP#", color);
            X3DScene auxScene = this.getX3DBrowser().createX3DFromString(xmlScene);
            X3DNode mynode = auxScene.getNamedNode("ROBOGARRA");
            this.mainScene.addRootNode(mynode);
            this.mainScene.updateNamedNode("CP_ROBOGARRA_" + i, mynode);
        }
    }

    private Ponto catmullRomSpline(Vector<Ponto> pontos, float u, float t, int index) {
        float[][] M = new float[][]{{0.0f, 1.0f, 0.0f, 0.0f}, {-t, 0.0f, t, 0.0f}, {2.0f * t, t - 3.0f, 3.0f - 2.0f * t, -t}, {-t, 2.0f - t, t - 2.0f, t}};
        Vector<Eixo> MG = new Vector<Eixo>();
        for (int i = 0; i < 4; ++i) {
            MG.add(new Eixo(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
        }
        float[] T = new float[]{1.0f, u, u * u, u * u * u};
        Ponto p = pontos.elementAt(index);
        for (int i = 0; i < 4; ++i) {
            int c = index - 2;
            for (int j = 0; j < 4; ++j) {
                Eixo eixo = (Eixo)MG.elementAt(i);
                Float.valueOf(eixo.x.floatValue() + M[i][j] * pontos.elementAt(c).getX().floatValue());
                eixo.x = eixo.x;
                eixo = (Eixo)MG.elementAt(i);
                Float.valueOf(eixo.y.floatValue() + M[i][j] * pontos.elementAt(c).getY().floatValue());
                eixo.y = eixo.y;
                eixo = (Eixo)MG.elementAt(i);
                Float.valueOf(eixo.z.floatValue() + M[i][j] * pontos.elementAt(c).getZ().floatValue());
                eixo.z = eixo.z;
                eixo = (Eixo)MG.elementAt(i);
                Float.valueOf(eixo.e.floatValue() + M[i][j] * pontos.elementAt((int)c).radianPitch);
                eixo.e = eixo.e;
                eixo = (Eixo)MG.elementAt(i);
                Float.valueOf(eixo.r.floatValue() + M[i][j] * pontos.elementAt((int)c).radianRoll);
                eixo.r = eixo.r;
                ++c;
            }
        }
        Eixo eixo = new Eixo(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
        for (int i = 0; i < 4; ++i) {
            Eixo j = eixo;
            Float.valueOf(j.x.floatValue() + T[i] * ((Eixo)MG.elementAt((int)i)).x.floatValue());
            j.x = j.x;
            j = eixo;
            Float.valueOf(j.y.floatValue() + T[i] * ((Eixo)MG.elementAt((int)i)).y.floatValue());
            j.y = j.y;
            j = eixo;
            Float.valueOf(j.z.floatValue() + T[i] * ((Eixo)MG.elementAt((int)i)).z.floatValue());
            j.z = j.z;
            j = eixo;
            Float.valueOf(j.e.floatValue() + T[i] * ((Eixo)MG.elementAt((int)i)).e.floatValue());
            j.e = j.e;
            j = eixo;
            Float.valueOf(j.r.floatValue() + T[i] * ((Eixo)MG.elementAt((int)i)).r.floatValue());
            j.r = j.r;
        }
        Angulos angs = new Angulos(p.getAlfa(), p.getBeta(), p.getGama(), p.getElevacao(), p.getRotacao());
        Ponto _p = new Ponto("p", eixo.x, eixo.y, eixo.z, angs.getAlfa(), angs.getBeta(), angs.getGama(), angs.getElevacao(), angs.getRotacao());
        _p.radianPitch = eixo.e.floatValue();
        _p.radianRoll = eixo.r.floatValue();
        return _p;
    }

    public Vector<Ponto> getSmoothInterpolation(boolean normalize, Vector<Ponto> controlPoints) {
        Vector<Ponto> pontos = new Vector<Ponto>();
        int length = controlPoints.size();
        if (length < 4) {
            JOptionPane.showMessageDialog(null, "S\u00e3o necess\u00e1rios quatro pontos de controle no m\u00ednimo.", "Erro", 0);
            return null;
        }
        for (int i = 0; i < length; ++i) {
            float offset = 0.545f;
            Ponto p = controlPoints.elementAt(i);
            float x = p.getX().floatValue();
            float y = p.getY().floatValue();
            float z = p.getZ().floatValue();
            if (normalize) {
                float distX = Math.abs(x /= 1000.0f) - 0.02f;
                float distY = Math.abs(y /= 1000.0f) - 0.925f;
                float distZ = Math.abs(z /= 1000.0f);
                x = x < 0.0f ? (x -= offset * distX) : (x += offset * distX);
                y = y < 0.0f ? (y -= offset * distY) : (y += offset * distY);
                z = z < 0.0f ? (z -= offset * distZ) : (z += offset * distZ);
            }
            Ponto _p = new Ponto("p", new Eixo(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)), p.getAngulos());
            _p.radianPitch = this.toRadianos(p.getElevacao().floatValue() + p.getBeta().floatValue() + p.getGama().floatValue()) - (float)Math.PI;
            _p.radianRoll = this.toRadianos(p.getRotacao().floatValue());
            pontos.add(_p);
            if (i != 0 && i != length - 1) continue;
            pontos.add(_p);
        }
        Vector<Ponto> smoothPoints = new Vector<Ponto>();
        float tg = 1.0f / (float)this.granularity;
        int sleep = 500 / this.granularity;
        if (sleep < 1) {
            sleep = 1;
        }
        for (int i = 2; i < pontos.size() - 1; ++i) {
            float beginRadianPitch = ((Ponto)pontos.elementAt((int)(i - 1))).radianPitch;
            float endRadianPitch = ((Ponto)pontos.elementAt((int)i)).radianPitch;
            float currentRadianPitch = beginRadianPitch;
            float linearStep = (endRadianPitch - beginRadianPitch) / (float)this.granularity;
            for (float t = 0.0f; t <= 1.0f; t += tg) {
                Ponto p = this.catmullRomSpline(pontos, t, 0.5f, i);
                smoothPoints.add(p);
            }
        }
        smoothPoints.add((Ponto)pontos.lastElement());
        return smoothPoints;
    }

    private void removeNearDuplicatedPoints(Vector<Ponto> points) {
        for (int i = 0; i < points.size() - 1; ++i) {
            Ponto actual = points.elementAt(i);
            Ponto next = points.elementAt(i + 1);
            if (!((double)Math.abs(actual.getX().floatValue() - next.getX().floatValue()) <= 0.01)) continue;
            points.remove(i);
            --i;
        }
    }

    public void clearTrajectory() {
        try {
            X3DNode node = this.mainScene.getNamedNode("CURVE");
            this.mainScene.removeRootNode(node);
            this.mainScene.removeNamedNode("CURVE");
        }
        catch (InvalidNodeException invalidNodeException) {
            // empty catch block
        }
    }

    public void generateTrajectory() {
        int i;
        this.clearTrajectory();
        Vector<Ponto> controlPoints = new Vector<Ponto>();
        int i2 = 0;
        while (true) {
            JanelaPonto cfr_ignored_0 = this.jp.janelaPonto;
            if (i2 >= JanelaPonto.lControlPoints.getItemCount()) break;
            JanelaPonto cfr_ignored_1 = this.jp.janelaPonto;
            controlPoints.add((Ponto)JanelaPonto.lControlPoints.getObjeto(i2));
            ++i2;
        }
        int auxGranularity = this.granularity;
        if (this.granularity > 20) {
            this.granularity = 20;
        }
        Vector<Ponto> pontos = this.getSmoothInterpolation(true, controlPoints);
        this.granularity = auxGranularity;
        if (pontos == null) {
            return;
        }
        String xml = "<Transform DEF='CURVE'><Shape><Appearance  DEF='WHITE' ><Material emissiveColor='1.0 1.0 0.5'/><LineProperties applied='true' linetype='1' linewidthScaleFactor='1.5' containerField='lineProperties' /></Appearance><IndexedLineSet  coordIndex='";
        for (i = 0; i < pontos.size(); ++i) {
            xml = xml + Integer.toString(i) + " ";
        }
        xml = xml + "-1'><Coordinate  point='";
        for (i = 0; i < pontos.size(); ++i) {
            xml = xml + pontos.elementAt(i).getX() + " " + pontos.elementAt(i).getY() + " " + pontos.elementAt(i).getZ() + ", ";
        }
        xml = xml + "'/></IndexedLineSet></Shape></Transform>";
        String xmlScene = "<X3D profile='Immersive' version='3.0' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.2.xsd'> <Scene>" + xml + "</Scene> </X3D>";
        X3DScene auxScene = this.getX3DBrowser().createX3DFromString(xmlScene);
        X3DNode mynode = auxScene.getNamedNode("CURVE");
        this.mainScene.addRootNode(mynode);
        this.mainScene.updateNamedNode("CURVE", mynode);
    }

    private Vector<Ponto> normalizePoints(Vector<Ponto> pontos) {
        float offset = 0.545f;
        Vector<Ponto> normalPoints = new Vector<Ponto>();
        for (int i = 0; i < pontos.size(); ++i) {
            Ponto p = pontos.elementAt(i);
            float x = p.getX().floatValue();
            float y = p.getY().floatValue();
            float z = p.getZ().floatValue();
            float distX = Math.abs(x /= 1000.0f) - 0.02f;
            float distY = Math.abs(y /= 1000.0f) - 0.925f;
            float distZ = Math.abs(z /= 1000.0f);
            x = x < 0.0f ? (x -= offset * distX) : (x += offset * distX);
            y = y < 0.0f ? (y -= offset * distY) : (y += offset * distY);
            z = z < 0.0f ? (z -= offset * distZ) : (z += offset * distZ);
            Ponto _p = new Ponto("p", new Eixo(Float.valueOf(x), Float.valueOf(y), Float.valueOf(z)), p.getAngulos());
            normalPoints.add(_p);
        }
        return normalPoints;
    }

    public void generateCustomTrajectory(Vector<Ponto> points) {
        int i;
        if (points == null) {
            return;
        }
        if (points.size() < 2) {
            return;
        }
        Vector<Ponto> pontos = this.normalizePoints(points);
        String xml = "<Transform DEF='CURVE'><Shape><Appearance  DEF='WHITE' ><Material emissiveColor='1.0 1.0 0.5'/><LineProperties applied='true' linetype='1' linewidthScaleFactor='1.5' containerField='lineProperties' /></Appearance><IndexedLineSet  coordIndex='";
        for (i = 0; i < pontos.size(); ++i) {
            xml = xml + Integer.toString(i) + " ";
        }
        xml = xml + "-1'><Coordinate  point='";
        for (i = 0; i < pontos.size(); ++i) {
            xml = xml + pontos.elementAt(i).getX() + " " + pontos.elementAt(i).getY() + " " + pontos.elementAt(i).getZ() + ", ";
        }
        xml = xml + "'/></IndexedLineSet></Shape></Transform>";
        String xmlScene = "<X3D profile='Immersive' version='3.0' xmlns:xsd='http://www.w3.org/2001/XMLSchema-instance' xsd:noNamespaceSchemaLocation='http://www.web3d.org/specifications/x3d-3.2.xsd'> <Scene>" + xml + "</Scene> </X3D>";
        X3DScene auxScene = this.getX3DBrowser().createX3DFromString(xmlScene);
        X3DNode mynode = auxScene.getNamedNode("CURVE");
        this.mainScene.addRootNode(mynode);
        this.mainScene.updateNamedNode("CURVE", mynode);
    }

    public String atualizaObbsRobo() {
        boolean escolha;
        float[] vBaXValues = new float[3];
        float[] vBaYValues = new float[3];
        float[] vBaZValues = new float[3];
        float[] vBaPtCValues = new float[3];
        float[] vABXValues = new float[3];
        float[] vABYValues = new float[3];
        float[] vABZValues = new float[3];
        float[] vABPtCValues = new float[3];
        float[] vBXValues = new float[3];
        float[] vBYValues = new float[3];
        float[] vBZValues = new float[3];
        float[] vBPtCValues = new float[3];
        float[] vGXValues = new float[3];
        float[] vGYValues = new float[3];
        float[] vGZValues = new float[3];
        float[] vGPtCValues = new float[3];
        float[] vGPtD1Values = new float[3];
        float[] vGPtD2Values = new float[3];
        float[] vGPtSupValues = new float[3];
        float[] vGPtEixoValues = new float[3];
        this.vBaX.getValue(vBaXValues);
        this.vBaY.getValue(vBaYValues);
        this.vBaZ.getValue(vBaZValues);
        this.vBaPtC.getValue(vBaPtCValues);
        this.vABX.getValue(vABXValues);
        this.vABY.getValue(vABYValues);
        this.vABZ.getValue(vABZValues);
        this.vABPtC.getValue(vABPtCValues);
        this.vBX.getValue(vBXValues);
        this.vBY.getValue(vBYValues);
        this.vBZ.getValue(vBZValues);
        this.vBPtC.getValue(vBPtCValues);
        this.vGX.getValue(vGXValues);
        this.vGY.getValue(vGYValues);
        this.vGZ.getValue(vGZValues);
        this.vGPtC.getValue(vGPtCValues);
        this.vGPtD1.getValue(vGPtD1Values);
        this.vGPtD2.getValue(vGPtD2Values);
        this.vGPtSup.getValue(vGPtSupValues);
        this.vGPtEixo.getValue(vGPtEixoValues);
        this.obbCorpo.setEixoX(vBaXValues[0], vBaXValues[1], vBaXValues[2]);
        this.obbCorpo.setEixoY(vBaYValues[0], vBaYValues[1], vBaYValues[2]);
        this.obbCorpo.setEixoZ(vBaZValues[0], vBaZValues[1], vBaZValues[2]);
        this.obbCorpo.setCentro(0.0, 280.0, 0.0);
        this.obbBraco.setEixoX(vABXValues[0], vABXValues[1], vABXValues[2]);
        this.obbBraco.setEixoY(vABYValues[0], vABYValues[1], vABYValues[2]);
        this.obbBraco.setEixoZ(vABZValues[0], vABZValues[1], vABZValues[2]);
        this.obbBraco.setCentro(vABPtCValues[0] - 40.0f, vABPtCValues[1] + 100.0f, vABPtCValues[2]);
        System.out.println("\nBra\u00e7o x: " + (double)vABPtCValues[0] * 1.2 + " y: " + (double)vABPtCValues[1] * 1.05 + " z: " + vABPtCValues[2]);
        this.obbAntBraco.setEixoX(vBXValues[0], vBXValues[1], vBXValues[2]);
        this.obbAntBraco.setEixoY(vBYValues[0], vBYValues[1], vBYValues[2]);
        this.obbAntBraco.setEixoZ(vBZValues[0], vBZValues[1], vBZValues[2]);
        this.obbAntBraco.setCentro((double)vBPtCValues[0] * 1.2, (double)vBPtCValues[1] * 1.05, vBPtCValues[2]);
        System.out.println("AnteBra\u00e7o x: " + (vBPtCValues[0] - 40.0f) + " y: " + (vBPtCValues[1] + 100.0f) + " z: " + vBPtCValues[2]);
        this.obbGarra.setEixoX(vGXValues[0], vGXValues[1], vGXValues[2]);
        this.obbGarra.setEixoY(vGYValues[0], vGYValues[1], vGYValues[2]);
        this.obbGarra.setEixoZ(vGZValues[0], vGZValues[1], vGZValues[2]);
        this.obbDedo1.setEixoX(vGXValues[0], vGXValues[1], vGXValues[2]);
        this.obbDedo1.setEixoY(vGYValues[0], vGYValues[1], vGYValues[2]);
        this.obbDedo1.setEixoZ(vGZValues[0], vGZValues[1], vGZValues[2]);
        this.obbDedo2.setEixoX(vGXValues[0], vGXValues[1], vGXValues[2]);
        this.obbDedo2.setEixoY(vGYValues[0], vGYValues[1], vGYValues[2]);
        this.obbDedo2.setEixoZ(vGZValues[0], vGZValues[1], vGZValues[2]);
        this.obbSup.setEixoX(vGXValues[0], vGXValues[1], vGXValues[2]);
        this.obbSup.setEixoY(vGYValues[0], vGYValues[1], vGYValues[2]);
        this.obbSup.setEixoZ(vGZValues[0], vGZValues[1], vGZValues[2]);
        this.obbEixo.setEixoX(vGXValues[0], vGXValues[1], vGXValues[2]);
        this.obbEixo.setEixoY(vGYValues[0], vGYValues[1], vGYValues[2]);
        this.obbEixo.setEixoZ(vGZValues[0], vGZValues[1], vGZValues[2]);
        this.obbGarra.setCentro(vGPtCValues[0], vGPtCValues[1], vGPtCValues[2]);
        this.obbDedo1.setCentro(vGPtD1Values[0], vGPtD1Values[1], vGPtD1Values[2]);
        this.obbDedo2.setCentro(vGPtD2Values[0], vGPtD2Values[1], vGPtD2Values[2]);
        this.obbSup.setCentro(vGPtSupValues[0], vGPtSupValues[1], vGPtSupValues[2]);
        this.obbEixo.setCentro(vGPtEixoValues[0], vGPtEixoValues[1], vGPtEixoValues[2]);
        if (this.prim == 0) {
            this.abrirFecharGarra(5.0f);
            ++this.prim;
        }
        if (!(escolha = this.jp.getJanelaParam() == null ? true : this.jp.getJanelaParam().cbMostrarColisao.isSelected())) {
            this.partManager.retiraColisao();
            this.retiraColisao();
        }
        this.Pegar_soltar.TestaPreensao(1);
        if (escolha && !this.Pegar_soltar.mensagem.equals("Nao houve Colisao")) {
            ++this.contacolisao;
        }
        if (pego.booleanValue()) {
            this.partManager.getObbTreeObjPego().getRoot().setCentro(this.getPontoX().floatValue(), this.getPontoY().floatValue(), this.getPontoZ().floatValue());
            this.partManager.getObbTreeObjPego().getRoot().setAnguloX(this.getBeta().floatValue() + this.getGama().floatValue() + this.getElevacao().floatValue());
            this.partManager.getObbTreeObjPego().getRoot().setAnguloY(this.getAlfa().floatValue() + this.getRotacao().floatValue());
        }
        return " ";
    }

    private void montaObbs() {
        this.obbBase.setXExtensao(200.0);
        this.obbBase.setYExtensao(200.0);
        this.obbBase.setZExtensao(200.0);
        this.obbBase.setEixoX(1.0, 0.0, 0.0);
        this.obbBase.setEixoY(0.0, 1.0, 0.0);
        this.obbBase.setEixoZ(0.0, 0.0, 1.0);
        this.obbBase.setCentro(0.0, 100.0, 0.0);
        this.treeBase.setRoot(this.obbBase);
        this.obbCorpo.setXExtensao(200.0);
        this.obbCorpo.setYExtensao(135.0);
        this.obbCorpo.setZExtensao(200.0);
        this.treeCorpo.setRoot(this.obbCorpo);
        this.obbAntBraco.setXExtensao(40.0);
        this.obbAntBraco.setYExtensao(220.0);
        this.obbAntBraco.setZExtensao(190.0);
        this.treeAntBraco.setRoot(this.obbAntBraco);
        this.obbBraco.setXExtensao(40.0);
        this.obbBraco.setYExtensao(220.0);
        this.obbBraco.setZExtensao(190.0);
        this.treeBraco.setRoot(this.obbBraco);
        this.obbGarra.setXExtensao(60.0);
        this.obbGarra.setZExtensao(120.0);
        this.obbGarra.setYExtensao(400.0);
        this.treeGarra.setRoot(this.obbGarra);
        this.obbDedo1.setXExtensao(20.0);
        this.obbDedo1.setZExtensao(20.0);
        this.obbDedo1.setYExtensao(100.0);
        this.treeDedo1.setRoot(this.obbDedo1);
        this.obbDedo2.setXExtensao(20.0);
        this.obbDedo2.setZExtensao(20.0);
        this.obbDedo2.setYExtensao(100.0);
        this.treeDedo2.setRoot(this.obbDedo2);
        this.obbSup.setXExtensao(20.0);
        this.obbSup.setZExtensao(120.0);
        this.obbSup.setYExtensao(20.0);
        this.treeSup.setRoot(this.obbSup);
        this.obbEixo.setXExtensao(40.0);
        this.obbEixo.setZExtensao(40.0);
        this.obbEixo.setYExtensao(180.0);
        this.treeEixo.setRoot(this.obbEixo);
        this.childrenGarra[0] = this.treeDedo1;
        this.childrenGarra[1] = this.treeDedo2;
        this.childrenGarra[3] = this.treeSup;
        this.childrenGarra[2] = this.treeEixo;
        this.treeGarra.setChildren(this.childrenGarra);
        this.treeGarra.setNumChildren(4);
    }

    public JanelaPrincipal getJanelaPrincipal() {
        return this.jp;
    }

    public ExternalBrowser getX3DBrowser() {
        return this.x3dBrowser;
    }

    public X3DScene getMainScene() {
        return this.mainScene;
    }

    public PartManager getPartManager() {
        return this.partManager;
    }

    public void replaceWorld() {
        this.x3dBrowser.replaceWorld(this.mainScene);
    }

    public void setTxtFeedback(String feedback) {
        this.jp.setTxtFeedback(feedback);
    }

    public void carregaSensores(X3DFieldEventListener x3dListener) {
        try {
            this.root = this.mainScene.getNamedNode("ROBO");
            this.alfa = (SFFloat)this.root.getField("alfa");
            this.beta = (SFFloat)this.root.getField("beta");
            this.gama = (SFFloat)this.root.getField("gama");
            this.elevacao = (SFFloat)this.root.getField("elevacao");
            this.rotacao = (SFFloat)this.root.getField("rotacao");
            this.abertura = (SFBool)this.root.getField("abertura");
            this.ponto = (SFVec3f)this.root.getField("ponto");
            this.alfa.addX3DEventListener((X3DFieldEventListener)this);
            this.beta.addX3DEventListener((X3DFieldEventListener)this);
            this.gama.addX3DEventListener((X3DFieldEventListener)this);
            this.elevacao.addX3DEventListener((X3DFieldEventListener)this);
            this.rotacao.addX3DEventListener((X3DFieldEventListener)this);
            this.abertura.addX3DEventListener((X3DFieldEventListener)this);
            this.ponto.addX3DEventListener((X3DFieldEventListener)this);
            this.inBase = (SFRotation)this.root.getField("inBaseJava");
            this.inAntebraco = (SFRotation)this.root.getField("inAntebracoJava");
            this.inBraco = (SFRotation)this.root.getField("inBracoJava");
            this.inRotacao = (SFRotation)this.root.getField("inRotacaoJava");
            this.inElevacao = (SFRotation)this.root.getField("inElevacaoJava");
            this.inAbertura = (SFFloat)this.root.getField("inAberturaJava");
            this.inPosicaoInicial = (SFBool)this.root.getField("inPosicaoInicial");
            this.inEixosVisivel = (SFBool)this.root.getField("inEixosVisivel");
            this.insensoresAtivos = (SFBool)this.root.getField("insensoresAtivos");
            this.inPFPVisivel = (SFBool)this.root.getField("inPFPVisivel2");
            this.inAlfa = (SFRotation)this.root.getField("inAlfa");
            this.inBeta = (SFRotation)this.root.getField("inBeta");
            this.inGama = (SFRotation)this.root.getField("inGama");
            this.inElev = (SFRotation)this.root.getField("inElevacao");
            this.inRota = (SFRotation)this.root.getField("inRotacao");
            this.inExecutar = (SFTime)this.root.getField("inExecutar");
            this.inAddChildrenGarra = (MFNode)this.root.getField("inAddChildrenGarra");
            this.inRemoveChildrenGarra = (MFNode)this.root.getField("inRemoveChildrenGarra");
        }
        catch (InvalidNodeException nex) {
            if (this.jp.getIdioma().equals("Ingles")) {
                this.jp.setTxtFeedback("Failed to load sensors!");
            }
            if (this.jp.getIdioma().equals("Portugues")) {
                this.jp.setTxtFeedback("Falha no carregamento dos sensores!");
            }
        }
        catch (InvalidFieldException fex) {
            this.jp.setTxtFeedback(fex.getLocalizedMessage());
        }
        if (this.jp.getIdioma().equals("Ingles")) {
            this.jp.setTxtFeedback("Robot Initialized Successfully!");
        }
        if (this.jp.getIdioma().equals("Portugues")) {
            this.jp.setTxtFeedback("Rob\u00f4 Inicializado com Sucesso!");
        }
    }

    public void carregaVetores() {
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException ex) {
            Logger.getLogger(CenaX3D.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            this.vBaX = (SFVec3f)this.root.getField("vBaX");
            this.vBaX.addX3DEventListener((X3DFieldEventListener)this);
            this.vBaY = (SFVec3f)this.root.getField("vBaY");
            this.vBaY.addX3DEventListener((X3DFieldEventListener)this);
            this.vBaZ = (SFVec3f)this.root.getField("vBaZ");
            this.vBaZ.addX3DEventListener((X3DFieldEventListener)this);
            this.vBaPtC = (SFVec3f)this.root.getField("vBaPtC");
            this.vBaPtC.addX3DEventListener((X3DFieldEventListener)this);
            this.vABX = (SFVec3f)this.root.getField("vABX");
            this.vABX.addX3DEventListener((X3DFieldEventListener)this);
            this.vABY = (SFVec3f)this.root.getField("vABY");
            this.vABY.addX3DEventListener((X3DFieldEventListener)this);
            this.vABZ = (SFVec3f)this.root.getField("vABZ");
            this.vABZ.addX3DEventListener((X3DFieldEventListener)this);
            this.vABPtC = (SFVec3f)this.root.getField("vABPtC");
            this.vABPtC.addX3DEventListener((X3DFieldEventListener)this);
            this.vBX = (SFVec3f)this.root.getField("vBX");
            this.vBX.addX3DEventListener((X3DFieldEventListener)this);
            this.vBY = (SFVec3f)this.root.getField("vBY");
            this.vBY.addX3DEventListener((X3DFieldEventListener)this);
            this.vBZ = (SFVec3f)this.root.getField("vBZ");
            this.vBZ.addX3DEventListener((X3DFieldEventListener)this);
            this.vBPtC = (SFVec3f)this.root.getField("vBPtC");
            this.vBPtC.addX3DEventListener((X3DFieldEventListener)this);
            this.vGX = (SFVec3f)this.root.getField("vGX");
            this.vGX.addX3DEventListener((X3DFieldEventListener)this);
            this.vGY = (SFVec3f)this.root.getField("vGY");
            this.vGY.addX3DEventListener((X3DFieldEventListener)this);
            this.vGZ = (SFVec3f)this.root.getField("vGZ");
            this.vGZ.addX3DEventListener((X3DFieldEventListener)this);
            this.vGPtC = (SFVec3f)this.root.getField("vGPtC");
            this.vGPtC.addX3DEventListener((X3DFieldEventListener)this);
            this.vGPtD1 = (SFVec3f)this.root.getField("vGPtD1");
            this.vGPtD1.addX3DEventListener((X3DFieldEventListener)this);
            this.vGPtD2 = (SFVec3f)this.root.getField("vGPtD2");
            this.vGPtD2.addX3DEventListener((X3DFieldEventListener)this);
            this.vGPtSup = (SFVec3f)this.root.getField("vGPtSup");
            this.vGPtSup.addX3DEventListener((X3DFieldEventListener)this);
            this.vGPtEixo = (SFVec3f)this.root.getField("vGPtEixo");
            this.vGPtEixo.addX3DEventListener((X3DFieldEventListener)this);
        }
        catch (InvalidNodeException nex) {
            System.out.println("Falha no carregamento dos sensores!");
        }
        catch (InvalidFieldException fex) {
            System.out.println(fex.getLocalizedMessage());
        }
    }

    public void setEixosVisivel(boolean visivel) {
        this.inEixosVisivel.setValue(visivel);
    }

    public void setSensoresAtivos(boolean visivel) {
        this.insensoresAtivos.setValue(visivel);
    }

    public void setPFPVisivel(boolean visivel) {
        this.inPFPVisivel.setValue(visivel);
    }

    public void setPosInicial() {
        this.inPosicaoInicial.setValue(true);
    }

    public void setAlfa(float angulo) {
        this.inBase.setValue(new float[]{0.0f, 1.0f, 0.0f, this.toRadianos(angulo)});
    }

    public void setBeta(float angulo) {
        this.inAntebraco.setValue(new float[]{0.0f, 0.0f, 1.0f, this.toRadianos(angulo)});
    }

    public void setGama(float angulo) {
        this.inBraco.setValue(new float[]{0.0f, 0.0f, 1.0f, this.toRadianos(angulo)});
    }

    public void setElevacao(float angulo) {
        this.inElevacao.setValue(new float[]{0.0f, 0.0f, 1.0f, this.toRadianos(angulo)});
    }

    public void setRotacao(float angulo) {
        this.inRotacao.setValue(new float[]{0.0f, 1.0f, 0.0f, this.toRadianos(angulo)});
    }

    public void abrirFecharGarra(float abrir) {
        if (abrir == 4.0f) {
            this.inAbertura.setValue(0.3f);
            this.Pegar_soltar.SoltaObjeto();
        }
        if (abrir == 5.0f) {
            this.Pegar_soltar.TestaPreensao(0);
            this.inAbertura.setValue(0.075f);
        }
        if (abrir != 5.0f && abrir != 4.0f) {
            this.inAbertura.setValue((float)((double)abrir + 0.065));
        }
    }

    public void addAlfa(float angulo) {
        this.inBase.setValue(new float[]{0.0f, 1.0f, 0.0f, this.alfa.getValue() + this.toRadianos(angulo)});
    }

    public void addBeta(float angulo) {
        this.inAntebraco.setValue(new float[]{0.0f, 0.0f, 1.0f, this.beta.getValue() + this.toRadianos(angulo)});
    }

    public void addGama(float angulo) {
        this.inBraco.setValue(new float[]{0.0f, 0.0f, 1.0f, this.gama.getValue() + this.toRadianos(angulo)});
    }

    public void addElevacao(float angulo) {
        this.inElevacao.setValue(new float[]{0.0f, 0.0f, 1.0f, this.elevacao.getValue() + this.toRadianos(angulo)});
    }

    public void addRotacao(float angulo) {
        this.inRotacao.setValue(new float[]{0.0f, 1.0f, 0.0f, this.rotacao.getValue() + this.toRadianos(angulo)});
    }

    public void setAngulos(Angulos ang) {
        this.setAlfa(ang.getAlfa().floatValue());
        this.setBeta(ang.getBeta().floatValue());
        this.setGama(ang.getGama().floatValue());
        this.setElevacao(ang.getElevacao().floatValue());
        this.setRotacao(ang.getRotacao().floatValue());
    }

    public Angulos getAngulos() {
        return new Angulos(this.getAlfa(), this.getBeta(), this.getGama(), this.getElevacao(), this.getRotacao());
    }

    public Eixo getEixo() {
        return new Eixo(this.getPontoX(), this.getPontoY(), this.getPontoZ());
    }

    public Float getAlfa() {
        return new Float(this.toGraus(this.alfa.getValue()));
    }

    public Float getBeta() {
        return new Float(this.toGraus(this.beta.getValue()));
    }

    public Float getGama() {
        return new Float(this.toGraus(this.gama.getValue()));
    }

    public Float getElevacao() {
        return new Float(this.toGraus(this.elevacao.getValue()));
    }

    public Float getRotacao() {
        return new Float(this.toGraus(this.rotacao.getValue()));
    }

    public Boolean getAbertura() {
        return this.abertura.getValue();
    }

    public Float getPontoX() {
        float[] data = new float[3];
        this.vGPtC.getValue(data);
        return Float.valueOf(data[0]);
    }

    public Float getPontoY() {
        float[] data = new float[3];
        this.vGPtC.getValue(data);
        return Float.valueOf(data[1]);
    }

    public Float getPontoZ() {
        float[] data = new float[3];
        this.vGPtC.getValue(data);
        return Float.valueOf(data[2]);
    }

    public boolean getStateGripper() {
        return this.stateGripper;
    }

    public float toRadianos(float graus) {
        return (float)((double)graus * Math.PI / 180.0);
    }

    public float toGraus(float radianos) {
        return (float)((double)radianos * 180.0 / Math.PI);
    }

    public void setMove(Angulos angulos) {
        float[][] temp = angulos.toArray();
        System.out.println("temp[0] = " + temp[0].toString());
        System.out.println("LENGHT = " + temp.length);
        for (int aux = 0; aux < temp.length; ++aux) {
            temp[aux][3] = this.toRadianos(temp[aux][3]);
            System.out.println("Temp [" + aux + "] = " + temp[aux][0] + temp[aux][1] + temp[aux][2] + temp[aux][3]);
        }
        this.inAlfa.setValue(temp[0]);
        this.inBeta.setValue(temp[1]);
        this.inGama.setValue(temp[2]);
        this.inElev.setValue(temp[3]);
        this.inRota.setValue(temp[4]);
        this.inExecutar.setValue((double)new Date().getTime() / 1000.0);
    }

    public void calcularInversa(float posX, float posY, float posZ, float pitch, float roll, boolean cotovelo) {
        float angBase = (float)Math.atan2(posY, posX);
        float k1 = (float)((double)posX * Math.cos(angBase) + (double)posY * Math.sin(angBase) - 20.0 + 150.0 * Math.sin(pitch));
        float k2 = (float)((double)(-posZ) + 335.0 - 150.0 * Math.cos(pitch));
        float angBraco = (float)((double)(cotovelo ? 1 : -1) * Math.acos((Math.pow(k1, 2.0) + Math.pow(k2, 2.0) - Math.pow(220.0, 2.0) - Math.pow(220.0, 2.0)) / 96800.0));
        float c2 = (float)(((double)k1 * (220.0 + 220.0 * Math.cos(angBraco)) + (double)k2 * 220.0 * Math.sin(angBraco)) / (2.0 * Math.pow(220.0, 2.0) + 96800.0 * Math.cos(angBraco)));
        float s2 = (float)(((double)(-k1) * 220.0 * Math.sin(angBraco) + (double)k2 * (220.0 + 220.0 * Math.cos(angBraco))) / (2.0 * Math.pow(220.0, 2.0) + 96800.0 * Math.cos(angBraco)));
        float angAntebraco = (float)(Math.atan2(s2, c2) + 1.5707963267948966);
        float angElevacao = (float)((double)(pitch - angBraco - angAntebraco) + Math.PI);
        if (angBase < 0.0f) {
            angBase = (float)((double)angBase + Math.PI * 2);
        }
        if (this.toGraus(angBase) >= 0.0f && this.toGraus(angBase) < 310.0f && this.toGraus(angAntebraco) > -35.0f && this.toGraus(angAntebraco) < 130.0f && this.toGraus(angAntebraco) != 0.0f && this.toGraus(angBraco) > -130.0f && this.toGraus(angBraco) < 130.0f && this.toGraus(angBraco) != 0.0f && this.toGraus(angElevacao) > -130.0f && this.toGraus(angElevacao) < 130.0f && this.toGraus(angElevacao) != 0.0f) {
            this.inBase.setValue(new float[]{0.0f, 1.0f, 0.0f, angBase});
            this.inAntebraco.setValue(new float[]{0.0f, 0.0f, 1.0f, angAntebraco});
            this.inBraco.setValue(new float[]{0.0f, 0.0f, 1.0f, angBraco});
            this.inElevacao.setValue(new float[]{0.0f, 0.0f, 1.0f, angElevacao});
            this.inRotacao.setValue(new float[]{0.0f, 1.0f, 0.0f, roll});
            if (this.jp.getIdioma().equals("Portugues")) {
                this.setTxtFeedback("Posi\u00e7\u00e3o alcan\u00e7ada com sucesso!");
            }
            if (this.jp.getIdioma().equals("Ingles")) {
                this.setTxtFeedback("Position achieved successfully!");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex2) {
                // empty catch block
            }
            this.Pegar_soltar.TestaPreensao(1);
            this.posicaoOK = true;
        } else {
            if (this.jp.getIdioma().equals("Portugues")) {
                this.setTxtFeedback("Posi\u00e7\u00e3o desejada n\u00e3o pode ser alcan\u00e7ada com esta configura\u00e7\u00e3o ou est\u00e1 fora do envelopede trabalho do rob\u00f4!");
            }
            if (this.jp.getIdioma().equals("ingles")) {
                this.setTxtFeedback("Desired position can not be achieved with this configuration or is outside the working envelope of robot!");
            }
            this.posicaoOK = false;
        }
        this.atualizaObbsRobo();
    }

    public ArrayList calcularInversaPontos(float posX, float posY, float posZ, float pitch, float roll, boolean cotovelo) {
        float angBase = (float)Math.atan2(posY, posX);
        float k1 = (float)((double)posX * Math.cos(angBase) + (double)posY * Math.sin(angBase) - 20.0 + 150.0 * Math.sin(pitch));
        float k2 = (float)((double)(-posZ) + 335.0 - 150.0 * Math.cos(pitch));
        float angBraco = (float)((double)(cotovelo ? 1 : -1) * Math.acos((Math.pow(k1, 2.0) + Math.pow(k2, 2.0) - Math.pow(220.0, 2.0) - Math.pow(220.0, 2.0)) / 96800.0));
        float c2 = (float)(((double)k1 * (220.0 + 220.0 * Math.cos(angBraco)) + (double)k2 * 220.0 * Math.sin(angBraco)) / (2.0 * Math.pow(220.0, 2.0) + 96800.0 * Math.cos(angBraco)));
        float s2 = (float)(((double)(-k1) * 220.0 * Math.sin(angBraco) + (double)k2 * (220.0 + 220.0 * Math.cos(angBraco))) / (2.0 * Math.pow(220.0, 2.0) + 96800.0 * Math.cos(angBraco)));
        float angAntebraco = (float)(Math.atan2(s2, c2) + 1.5707963267948966);
        float angElevacao = (float)((double)(pitch - angBraco - angAntebraco) + Math.PI);
        if (angBase < 0.0f) {
            angBase = (float)((double)angBase + Math.PI * 2);
        }
        if (this.toGraus(angBase) >= 0.0f && this.toGraus(angBase) < 310.0f && this.toGraus(angAntebraco) > -35.0f && this.toGraus(angAntebraco) < 130.0f && this.toGraus(angAntebraco) != 0.0f && this.toGraus(angBraco) > -130.0f && this.toGraus(angBraco) < 130.0f && this.toGraus(angBraco) != 0.0f && this.toGraus(angElevacao) > -130.0f && this.toGraus(angElevacao) < 130.0f && this.toGraus(angElevacao) != 0.0f) {
            ArrayList<Float> ang = new ArrayList<Float>();
            ang.add(Float.valueOf(angBase));
            ang.add(Float.valueOf(angAntebraco));
            ang.add(Float.valueOf(angBraco));
            ang.add(Float.valueOf(angElevacao));
            ang.add(Float.valueOf(roll));
            return ang;
        }
        return null;
    }

    public boolean getPosicaoOK() {
        return this.posicaoOK;
    }

    public boolean getPego() {
        return pego;
    }

    public void setPego(boolean p) {
        pego = p;
    }

    public ObbTree getObbTreeAntBraco() {
        return this.treeAntBraco;
    }

    public ObbTree getObbTreeBase() {
        return this.treeBase;
    }

    public ObbTree getObbTreeBraco() {
        return this.treeBraco;
    }

    public ObbTree getObbTreeCorpo() {
        return this.treeCorpo;
    }

    public ObbTree getObbTreeGarra() {
        return this.treeGarra;
    }

    public void inAddChildrenGarra(String ChildrenGarra) {
        float A = this.getAlfa().floatValue();
        float B = this.getBeta().floatValue();
        float G = this.getGama().floatValue();
        float E = this.getElevacao().floatValue();
        float R = this.getRotacao().floatValue();
        this.addAlfa(-this.getAlfa().floatValue());
        this.addBeta(-this.getBeta().floatValue());
        this.addGama(-this.getGama().floatValue());
        this.addElevacao(-this.getElevacao().floatValue());
        this.addRotacao(-this.getRotacao().floatValue());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException ex3) {
            // empty catch block
        }
        this.filhoObj[0] = this.getX3DBrowser().createX3DFromString("<X3D profile='Immersive' version='3.2' ><Scene>" + ChildrenGarra + "</Scene></X3D>").getRootNodes();
        this.inAddChildrenGarra.setValue(1, this.filhoObj[0]);
        this.addAlfa(A);
        this.addBeta(B);
        this.addGama(G);
        this.addElevacao(E);
        this.addRotacao(R);
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException ex3) {
            // empty catch block
        }
    }

    public void inRemoveChildrenGarra() {
        this.inRemoveChildrenGarra.setValue(1, this.filhoObj[0]);
    }

    public void indicaColisao1(int id) {
        float[] colisionColor = new float[]{1.0f, 0.0f, 0.0f};
        this.color = (SFColor)this.mainScene.getNamedNode("ROBO").getField("COLOR" + id);
        this.color.setValue(colisionColor);
        this.objCol1 = id;
    }

    public void indicaColisao2(int id) {
        float[] colisionColor = new float[]{1.0f, 0.0f, 0.0f};
        this.color = (SFColor)this.mainScene.getNamedNode("ROBO").getField("COLOR" + id);
        this.color.setValue(colisionColor);
        this.objCol2 = id;
    }

    public void retiraColisao() {
        if (this.objCol1 > -1) {
            this.color = (SFColor)this.mainScene.getNamedNode("ROBO").getField("COLOR" + this.objCol1);
            this.color.setValue(this.listaCores[this.objCol1]);
            this.objCol1 = -1;
        }
        if (this.objCol2 > -1) {
            this.color = (SFColor)this.mainScene.getNamedNode("ROBO").getField("COLOR" + this.objCol2);
            this.color.setValue(this.listaCores[this.objCol2]);
            this.objCol2 = -1;
        }
    }

    public void readableFieldChanged(X3DFieldEvent evt) {
    }

    public void keyPressed(KeyEvent evt) {
    }

    public void keyReleased(KeyEvent arg0) {
    }

    public void NMClick() {
        ++this.NManipulacoesClick;
    }

    public void NMTeclado() {
        ++this.NManipulacoesTeclado;
    }

    public void NPreencaoO() {
        ++this.NPreencaoO;
    }

    public void NPreencaoO(int num) {
        if (num == 0) {
            ++this.NPreencaoOM;
        }
        if (num == 1) {
            ++this.NPreencaoOF;
        }
    }

    public void NPreencaoOSub(int num) {
        if (num == 0) {
            --this.NPreencaoOM;
        }
        if (num == 1) {
            --this.NPreencaoOF;
        }
    }
}

