/*
 * Decompiled with CFR 0.152.
 */
package Preensao;

import Objetos.Cilindro;
import Objetos.Esfera;
import Objetos.ListaQuadrante;
import Objetos.Paralelepipedo;
import Preensao.Garra;

public class TrataPreensao {
    public static final int APROVADO = 1;
    public static final int ERRO_BOUNDING_BOX_TRABALHO = -1;
    public static final int ERRO_FATIA_TRASEIRA = -2;
    public static final int ERRO_TAMANHO_OBJETO_GARRA = -3;
    public static final int ERRO_PROXIMIDADE = -4;
    public static final int ERRO_ABORDAGEM = -5;
    public static final int ERRO_FG_Z = -6;
    public static final int ERRO_FG_X = -7;
    public static final int ERRO_FG_Y = -8;

    public static int preensao(ListaQuadrante lista, int id, Garra g, double deltaAb, double piDeltaGe) {
        char obj = lista.tipoComponente(id).startsWith("class Objetos.E") ? (char)'E' : (lista.tipoComponente(id).startsWith("class Objetos.C") ? (char)'C' : 'P');
        int ret = TrataPreensao.exclusao(lista, id, obj, g);
        if (ret < 0) {
            return ret;
        }
        return TrataPreensao.confirmacao(lista, id, obj, g, deltaAb, piDeltaGe);
    }

    private static int exclusao(ListaQuadrante lista, int id, char obj, Garra g) {
        if (!TrataPreensao.boundingBoxTrabalho(lista, id)) {
            return -1;
        }
        if (!TrataPreensao.fatiaTraseira(lista, id)) {
            return -2;
        }
        if (!TrataPreensao.tamanhoObjetoGarra(lista, id, g)) {
            return -3;
        }
        if (!TrataPreensao.proximidade(lista, id, obj, g)) {
            return -4;
        }
        return 1;
    }

    private static boolean boundingBoxTrabalho(ListaQuadrante lista, int id) {
        if (lista.getObbTreePos(id).getRoot().getCentro()[0] < -0.9524999999999999 || lista.getObbTreePos(id).getRoot().getCentro()[0] > 0.9524999999999999) {
            return false;
        }
        return !(lista.getObbTreePos(id).getRoot().getCentro()[2] < -0.9524999999999999) && !(lista.getObbTreePos(id).getRoot().getCentro()[2] > 0.9524999999999999);
    }

    private static boolean fatiaTraseira(ListaQuadrante lista, int id) {
        double angulo = Math.atan2(lista.getObbTreePos(id).getRoot().getCentro()[2], -lista.getObbTreePos(id).getRoot().getCentro()[0]);
        if (angulo < 0.0) {
            angulo = Math.PI * 2 + angulo;
        }
        return !(angulo > 5.410520681182422);
    }

    private static boolean tamanhoObjetoGarra(ListaQuadrante lista, int id, Garra g) {
        return !(Math.min(lista.getObbTreePos(id).getRoot().getExtensao()[0], Math.min(lista.getObbTreePos(id).getRoot().getExtensao()[1], lista.getObbTreePos(id).getRoot().getExtensao()[2])) > 0.1125);
    }

    private static boolean proximidade(ListaQuadrante lista, int id, char obj, Garra g) {
        double R;
        double dist;
        if (obj == 'E') {
            Esfera e = lista.getComponenteEsfera(id);
            dist = TrataPreensao.distanciaPontoPonto(e.getObbTree().getRoot().getCentro(), g.getPFP());
            R = e.getRaioEsferaEnv() * e.getRaioEsferaEnv();
        } else if (obj == 'C') {
            Cilindro c = lista.getComponenteCilindro(id);
            dist = TrataPreensao.distanciaPontoPonto(c.getObbTree().getRoot().getCentro(), g.getPFP());
            R = c.getRaioEsferaEnv() * c.getRaioEsferaEnv();
        } else {
            Paralelepipedo p = lista.getComponenteParalelepipedo(id);
            dist = TrataPreensao.distanciaPontoPonto(p.getObbTree().getRoot().getCentro(), g.getPFP());
            R = p.getRaioEsferaEnv() * p.getRaioEsferaEnv();
        }
        return !(dist > R);
    }

    private static int confirmacao(ListaQuadrante lista, int id, char obj, Garra g, double deltaAb, double piDeltaGe) {
        int ret = TrataPreensao.folgaAbordagem(lista, id, obj, g, deltaAb);
        if (ret < 0) {
            return ret;
        }
        return TrataPreensao.folgaGeometrica(lista, id, obj, g, piDeltaGe);
    }

    private static int folgaAbordagem(ListaQuadrante lista, int id, char obj, Garra g, double deltaAb) {
        if (obj == 'C') {
            return TrataPreensao.folgaAbordagemCilindro(lista.getComponenteCilindro(id), g, deltaAb);
        }
        if (obj == 'P') {
            return TrataPreensao.folgaAbordagemParalelepipedo(lista.getComponenteParalelepipedo(id), g, deltaAb);
        }
        return 1;
    }

    private static int folgaAbordagemCilindro(Cilindro c, Garra g, double deltaAb) {
        double angulo = TrataPreensao.anguloEntreVetores(c.getObbTree().getRoot().getEixoY(), g.getApg());
        if (angulo <= deltaAb || Math.PI - angulo <= deltaAb) {
            return 1;
        }
        if (angulo >= 1.5707963267948966 - deltaAb && angulo <= 1.5707963267948966 + deltaAb) {
            angulo = TrataPreensao.anguloEntreVetores(g.getUpg(), c.getObbTree().getRoot().getEixoY());
            if (angulo <= deltaAb || Math.PI - angulo <= deltaAb) {
                return 1;
            }
            if (angulo >= 1.5707963267948966 - deltaAb && angulo <= 1.5707963267948966 + deltaAb) {
                return 1;
            }
            return -5;
        }
        angulo = TrataPreensao.anguloEntreVetores(c.getObbTree().getRoot().getEixoY(), g.getElg());
        if (angulo >= 1.5707963267948966 - deltaAb && angulo <= 1.5707963267948966 + deltaAb) {
            return 1;
        }
        return -5;
    }

    private static int folgaAbordagemParalelepipedo(Paralelepipedo p, Garra g, double deltaAb) {
        double angulo = TrataPreensao.anguloEntreVetores(p.getObbTree().getRoot().getEixoX(), g.getElg());
        if (angulo <= deltaAb || Math.PI - angulo <= deltaAb) {
            return 1;
        }
        angulo = TrataPreensao.anguloEntreVetores(p.getObbTree().getRoot().getEixoY(), g.getElg());
        if (angulo <= deltaAb || Math.PI - angulo <= deltaAb) {
            return 1;
        }
        angulo = TrataPreensao.anguloEntreVetores(p.getObbTree().getRoot().getEixoZ(), g.getElg());
        if (angulo <= deltaAb || Math.PI - angulo <= deltaAb) {
            return 1;
        }
        return -5;
    }

    private static int folgaGeometrica(ListaQuadrante lista, int id, char obj, Garra g, double piDeltaGe) {
        double[] centro;
        if (obj == 'E') {
            Esfera e = lista.getComponenteEsfera(id);
            centro = new double[]{e.getPosicao()[0], e.getPosicao()[1] + 0.48, e.getPosicao()[2]};
        } else if (obj == 'C') {
            Cilindro c = lista.getComponenteCilindro(id);
            centro = new double[]{c.getPosicao()[0], c.getPosicao()[1] + 0.48, c.getPosicao()[2]};
        } else {
            Paralelepipedo p = lista.getComponenteParalelepipedo(id);
            centro = new double[]{p.getPosicao()[0], p.getPosicao()[1] + 0.48, p.getPosicao()[2]};
        }
        return TrataPreensao.testeFolgaGeometrica(centro, g, piDeltaGe);
    }

    private static int testeFolgaGeometrica(double[] pontoCentralFolga, Garra g, double deltaGe) {
        if (Math.abs(pontoCentralFolga[0] - g.getPFP()[0]) > deltaGe && Math.abs(pontoCentralFolga[0] - g.getPFP()[0]) >= Math.abs(pontoCentralFolga[1] - g.getPFP()[1]) && Math.abs(pontoCentralFolga[0] - g.getPFP()[0]) >= Math.abs(pontoCentralFolga[2] - g.getPFP()[2])) {
            return -7;
        }
        if (Math.abs(pontoCentralFolga[1] - g.getPFP()[1]) > deltaGe && Math.abs(pontoCentralFolga[1] - g.getPFP()[1]) >= Math.abs(pontoCentralFolga[0] - g.getPFP()[0]) && Math.abs(pontoCentralFolga[1] - g.getPFP()[1]) >= Math.abs(pontoCentralFolga[2] - g.getPFP()[2])) {
            return -8;
        }
        if (Math.abs(pontoCentralFolga[2] - g.getPFP()[2]) > deltaGe && Math.abs(pontoCentralFolga[2] - g.getPFP()[2]) >= Math.abs(pontoCentralFolga[0] - g.getPFP()[0]) && Math.abs(pontoCentralFolga[2] - g.getPFP()[2]) >= Math.abs(pontoCentralFolga[1] - g.getPFP()[1])) {
            return -6;
        }
        return 1;
    }

    private static double distanciaPontoPonto(double[] a, double[] b) {
        return Math.pow(a[0] - b[0], 2.0) + Math.pow(a[1] + 0.48 - b[1], 2.0) + Math.pow(a[2] - b[2], 2.0);
    }

    private static double anguloEntreVetores(double[] v1, double[] v2) {
        return Math.acos((v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2]) / (Math.sqrt(v1[0] * v1[0] + v1[1] * v1[1] + v1[2] * v1[2]) * Math.sqrt(v2[0] * v2[0] + v2[1] * v2[1] + v2[2] * v2[2])));
    }
}

