/*
 * Decompiled with CFR 0.152.
 */
package Objetos;

import Colisao.Obb;
import Colisao.ObbTree;

public class Cilindro {
    private double raio = 0.0;
    private double altura = 0.0;
    private double anguloX = 0.0;
    private double anguloY = 0.0;
    private String nome = new String();
    private boolean emPe = true;
    private double[] posicao = new double[3];
    private float[] cor = new float[3];
    private Obb obbCil = new Obb();
    private double r;
    private ObbTree obbTree = new ObbTree();

    public Cilindro(double rai, double alt, String nom) {
        this.raio = rai;
        this.altura = alt;
        this.r = Math.sqrt(this.raio * this.raio + Math.pow(this.altura / 2.0, 2.0));
        this.obbCil.setEixoX(1.0, 0.0, 0.0);
        this.obbCil.setEixoY(0.0, 1.0, 0.0);
        this.obbCil.setEixoZ(0.0, 0.0, 1.0);
        this.obbCil.setYExtensao(alt);
        this.obbCil.setXExtensao(rai * 2.0);
        this.obbCil.setZExtensao(rai * 2.0);
        this.nome = nom;
        this.obbTree.setRoot(this.obbCil);
    }

    public void setCor(float[] cores) {
        this.cor[0] = cores[0];
        this.cor[1] = cores[1];
        this.cor[2] = cores[2];
    }

    public void setPosicao(double x, double y, double z) {
        this.posicao[0] = x;
        this.posicao[1] = y;
        this.posicao[2] = z;
        this.obbCil.setCentro(x, y, z);
    }

    public void setAnguloY(double ang) {
        this.anguloY = ang;
        this.obbCil.setAnguloY(this.anguloY);
    }

    public void setAnguloX(double ang) {
        this.anguloX = ang;
        this.obbCil.setAnguloY(ang);
    }

    public void setAnguloEixoX(double ang) {
        this.anguloX = ang;
        this.emPe = false;
        this.obbCil.setXExtensao(this.getAltura());
        this.obbCil.setYExtensao(this.getRaio() * 2.0);
        this.obbCil.setAnguloX(this.anguloX);
    }

    public double getRaio() {
        return this.raio;
    }

    public double[] getPosicao() {
        return this.posicao;
    }

    public double getAltura() {
        return this.altura;
    }

    public boolean getStatus() {
        return this.emPe;
    }

    public double getAnguloX() {
        return this.anguloX;
    }

    public double getAnguloY() {
        return this.anguloY;
    }

    public String getNome() {
        return this.nome;
    }

    public float[] getCor() {
        return this.cor;
    }

    public double getRaioEsferaEnv() {
        return this.r;
    }

    public ObbTree getObbTree() {
        return this.obbTree;
    }

    public Obb getObb() {
        return this.obbCil;
    }
}

