/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import Commands.AbstractBlockContext;
import Commands.AbstractInstruction;
import Commands.BlockContext;
import Commands.InstrLabel;
import Commands.Instruction;
import java.util.HashMap;
import virbot4u.CenaX3D;
import virbot4u.JanelaPrograma;

public class ScriptingBlockContext
extends AbstractBlockContext {
    Instruction firstInstr;
    Instruction lastInstr;
    Instruction currentInstr;

    public ScriptingBlockContext(BlockContext parent, CenaX3D scene) {
        super(parent, new HashMap<String, InstrLabel>(), new HashMap<String, BlockContext>(), new HashMap<String, Float>(), scene);
        this.lastInstr = this.firstInstr = new FirstInstruction();
        this.currentInstr = this.firstInstr;
    }

    protected void addInstr(Instruction instr) {
        this.lastInstr.setNext(instr);
        this.lastInstr = instr;
    }

    public void run() {
        if (this.loop) {
            this.executeBlockInstructionsLoop();
            this.loop = false;
        } else {
            this.executeBlockInstructions();
        }
    }

    public void executeBlockInstructions() {
        for (Instruction currentInstr = this.firstInstr; currentInstr != null; currentInstr = currentInstr.execute(this)) {
            if (this.upDown) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                currentInstr = this.interruptInstr;
                this.upDown = false;
            }
            this.writeFeedbackLine(currentInstr.getLine());
        }
        if (this.parent == null) {
            this.writeFeedback(1, "");
            this.writeFeedback(2, "");
            this.inicializeProgram();
        }
    }

    private void executeBlockInstructionsLoop() {
        while (true) {
            JanelaPrograma.getTxtConsole().setText("");
            this.executeBlockInstructions();
        }
    }

    public void executeNextInstruction() {
        if (this.currentInstr == null) {
            this.currentInstr = this.firstInstr;
        }
        String[] s = JanelaPrograma.getTxtProgSave().getText().split("\n", 1000);
        JanelaPrograma.getTxtProgSave().setText("");
        for (int i = 1; i <= s.length; ++i) {
            if (i == this.currentInstr.getLine()) {
                if (s[this.currentInstr.getLine() - 1].charAt(0) == '#') {
                    JanelaPrograma.getTxtProgSave().append(s[this.currentInstr.getLine() - 1] + "\n");
                    continue;
                }
                JanelaPrograma.getTxtProgSave().append("#" + s[this.currentInstr.getLine() - 1] + "\n");
                continue;
            }
            if (i == s.length) {
                JanelaPrograma.getTxtProgSave().append(s[i - 1].replace("#", ""));
                continue;
            }
            JanelaPrograma.getTxtProgSave().append(s[i - 1].replace("#", "") + "\n");
        }
        this.writeFeedbackLine(this.currentInstr.getLine());
        this.currentInstr = this.currentInstr.execute(this);
    }

    public void inicializeProgram() {
        JanelaPrograma.getTxtProgSave().setText(JanelaPrograma.getTxtProgSave().getText().replace("#", ""));
        this.currentInstr = this.firstInstr;
    }

    private static class FirstInstruction
    extends AbstractInstruction {
        private FirstInstruction() {
        }

        public Instruction execute(BlockContext inThisContext) {
            return this.nextInstruction;
        }
    }
}

